// globals

function prepareLabel (labelname) {
	quoted = (getValue (labelname + "isquote") == "1");
	label = getValue (labelname);
	if (label == "") {
		label = getValue ("default_" + labelname);
		quoted = true;
	}
	if ((label != "") && (quoted)) label = "\"" + strtr (label, array ('"' ,  '\\"')) + "\"";
	if (label != "") label = ", " + labelname + "=" + label;

	return label;
}


function calculate () {
	if (getValue ("grid_enable") == "true") {
		echo (getValue ("grid_options.code.printout"));
	}
}

function printout () {
	log; xaxt; yaxt; xlim; ylim; xlab; ylab; main; sub;

	xvars = split ("\n", getValue ("xvar"));
	if (count (xvars) > 1) {
		xvar = "c (" + join (", ", xvars) + ")";
	} else {
		xvar = xvars[0];
	}
	yvars = getValue ("yvar");
	if (count (yvars) > 1) {
		yvar = "c (" + join (", ", yvars) + ")";
	} else {
		yvar = yvars[0];
	}

	if (yvar == "") {
		yvar = "1:length (" + xvar +")";
	} else if (xvar == "") {	
		xvar = "1:length (" + yvar +")";
	}

	
	xaxt = getValue ("xaxt");
	if (xaxt != "") {
		xaxt = ", xaxt=\"" + xaxt + "\"";
	}
	log += getValue ("xlog");

	xlab = prepareLabel ("xlab");
	xminvalue = getValue ("xminvalue");
	xmaxvalue = getValue ("xmaxvalue");
	if ((xminvalue != "") || (xmaxvalue != "")) {
		xlim = ", xlim=c (";
		if ((xminvalue == "") && (xvar != "")) xlim += "min (" + xvar + ")";
		else xlim += xminvalue;
		xlim += ", ";
		if ((xmaxvalue == "") && (xvar != "")) xlim += "max (" + xvar + ")";
		else xlim += xmaxvalue;
		xlim += ")";
	}


	
	yaxt = getValue ("yaxt");
	if (yaxt != ""){
		yaxt = ", yaxt=\"" + yaxt + "\"";
	}
	log += getValue ("ylog");

	ylab = prepareLabel ("ylab");
	yminvalue = getValue ("yminvalue");
	ymaxvalue = getValue ("ymaxvalue");
	if ((yminvalue != "") || (ymaxvalue != "")) {
		ylim = ", ylim=c (";
		if ((yminvalue == "") && (yvar != "")) ylim += "min (" + yvar + ")";
		else ylim += yminvalue;
		ylim += ", ";
		if ((ymaxvalue == "") && (yvar != "")) ylim += "max (" + yvar + ")";
		else ylim += ymaxvalue;
		ylim += ")";
	}


	
	if (log != "") log = ", log=\"" + log + "\"";

	type = getValue ("pointtype");
	if (empty (type)) type = getValue ("default_pointtype");
	if (!empty (type)) type = ", type=\"" + type + "\"";

	
	col = getValue ("pointcolor.code.printout");

	
	main = prepareLabel ("main");
	sub = prepareLabel ("sub");

	
	asp = getValue ("asp");
	if (asp != 0) asp = ", asp=" + asp;
	else asp = "";

	
	options = type + col + xaxt + yaxt + log + xlim + ylim + xlab + ylab + main + sub + asp;

	echo (options);
}

