#ifndef H_DATA
#define H_DATA

#include <sys/time.h>
#include <sys/types.h>
#include <sys/resource.h>

#include <config.h>

#include "bytecode.h"
#include "rlinetd.h"

#ifdef HAVE_CAPABILITIES
#include <sys/capability.h>
#endif

struct numlist {
	long num;
	struct numlist *next;
};

struct service {
	struct stringlist *port;
	struct stringlist *interface;
	char *name;
	int family;
	int socktype;
	int proto;
	char *protoname;
	int backlog;
	int limit;
	struct rlimit r;
	char *rpcname;
	long rpcnum;
	struct numlist *rpcvers;
#ifdef HAVE_CAPABILITIES
	cap_t caps;
#endif

	rl_opcode_t iname;	/* stringtab for service name */
	rl_opcode_t exec;	/* stringtab for program to exec */
	rl_opcode_t parent;	/* oplist for parent to exec post-fork */
	rl_opcode_t iuser;	/* stringtab for username */
	
	uid_t setuid;		/* user id */
	gid_t supgid;		/* supplementary groupid for initgroups */
	gid_t setgid;		/* primary group */
	int sgid;		/* true if an OP_SGID is in the opstream */
	
	int disabled;		/* if parse error in service declaration */
	int internal;		/* if internal service */

	rl_opcode_t run;	/* opstream to hook onto listening socket */
	rl_opcode_t onexit;	/* opstream to run when child exits */
#ifdef HAVE_NET_BPF_H
	void *filter;									/* LSF program to attach to sockets */
	int filterlen;								/* length of above LSF program */
#endif	
};

void numlist_add(struct numlist **, long);
void numlist_copy(struct numlist **, struct numlist *);
void numlist_free(struct numlist *);

struct stringlist {
	char *str;
	struct stringlist *next;
};

void stringlist_add(struct stringlist **, char *);
void stringlist_copy(struct stringlist **, struct stringlist *);
void stringlist_free(struct stringlist *);

struct userdata {
	uid_t uid;
	gid_t gid;
	char *name;
};

void builduserdata(struct userdata **, char *);
void clearuserdata(struct userdata **);
void newuserdata(struct userdata **); 
void userdata_copy(struct userdata **, struct userdata *);

#endif /* !H_DATA */

/* vim: set ts=2: */
