//RLPlot.h, Copyright (c) 2000, 2001, 2002, 2003, 2004 R.Lackner
//
//    This file is part of RLPlot.
//
//    RLPlot is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    RLPlot is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with RLPlot; if not, write to the Free Software
//    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
#define NUM_UNITS  3
#define TMP_TXT_SIZE 4096

#include <stdio.h>
#include "Version.h"

#define Swap(a,b) {a^=b;b^=a;a^=b;}
inline int iround(double a) {return a < 0.0 ?(int)(a-0.499) : (int)(a+0.499);}
inline int WriteFloatToBuff(char *buff, double val) {return sprintf(buff, " %g", val);}

#ifdef _WINDOWS
#include <windows.h>

#else
#define DWORD unsigned long

typedef struct tagPOINT { // pt 
    long x; 
    long y; 
} POINT; 

typedef struct _RECT {    // rc 
    long left; 
    long top; 
    long right; 
    long bottom; 
} RECT; 

#endif	//_WINDOWS

enum {SIZE_MINE, SIZE_SYMBOL, SIZE_SYM_LINE, SIZE_DATA_LINE, SIZE_TEXT,
	SIZE_GRECT_TOP, SIZE_GRECT_BOTTOM, SIZE_GRECT_LEFT, SIZE_GRECT_RIGHT,
	SIZE_DRECT_LEFT, SIZE_DRECT_RIGHT, SIZE_DRECT_TOP, SIZE_DRECT_BOTTOM,
	SIZE_DATA_LINE_PAT, SIZE_XPOS, SIZE_XPOS_LAST = SIZE_XPOS+200, 
	SIZE_YPOS, SIZE_YPOS_LAST = SIZE_YPOS+200, SIZE_ZPOS, 
	SIZE_ZPOS_LAST = SIZE_ZPOS+200, SIZE_BOUNDS_XMIN,
	SIZE_BOUNDS_XMAX, SIZE_BOUNDS_YMIN, SIZE_BOUNDS_YMAX, SIZE_BOUNDS_ZMIN,
	SIZE_BOUNDS_ZMAX, SIZE_BOUNDS_LEFT, SIZE_BAR_BASE,
	SIZE_BOUNDS_RIGHT, SIZE_BOUNDS_TOP, SIZE_BOUNDS_BOTTOM, SIZE_XAXISY,
	SIZE_YAXISX, SIZE_AXIS_LINE, SIZE_PATLENGTH, SIZE_BAR_DEPTH,
	SIZE_AXIS_TICKS, SIZE_TICK_LABELS, SIZE_ERRBAR, SIZE_ERRBAR_LINE, 
	SIZE_BAR_LINE, SIZE_BAR, SIZE_XBASE, SIZE_YBASE, SIZE_ZBASE, SIZE_BUBBLE_LINE,
	SIZE_BUBBLE_HATCH_LINE, SIZE_BARMINX, SIZE_BARMINY, SIZE_ARROW_LINE,
	SIZE_ARROW_CAPWIDTH, SIZE_ARROW_CAPLENGTH, SIZE_HAIRLINE, SIZE_WHISKER,
	SIZE_WHISKER_LINE, SIZE_BOX_LINE, SIZE_BOXMINX, SIZE_BOXMINY, SIZE_BOX,
	SIZE_RADIUS1, SIZE_RADIUS2, SIZE_SEGLINE, SIZE_LB_XPOS, SIZE_LB_YPOS,
	SIZE_LB_XDIST, SIZE_LB_YDIST, SIZE_TLB_XDIST, SIZE_TLB_YDIST, SIZE_ANGLE1,
	SIZE_ANGLE2, SIZE_XCENTER, SIZE_YCENTER, SIZE_ZCENTER, SIZE_CELLWIDTH, SIZE_CELLTEXT,
	SIZE_A, SIZE_B, SIZE_MX, SIZE_MY, SIZE_MIN_Z, SIZE_MAX_Z, SIZE_MIN_X, SIZE_MAX_X,
	SIZE_MIN_Y, SIZE_MAX_Y, SIZE_TICK_ANGLE, SIZE_RRECT_RAD, SIZE_XCENT, SIZE_YCENT,
	SIZE_ZCENT, SIZE_DRADIUS, SIZE_CURSORPOS, SIZE_CURSOR_XMIN, SIZE_CURSOR_YMIN,
	SIZE_CURSOR_XMAX, SIZE_CURSOR_YMAX, SIZE_XSTEP};
enum {COL_SYM_LINE, COL_SYM_FILL, COL_DATA_LINE, COL_TEXT, COL_BG,
	COL_AXIS, COL_BAR_LINE, COL_BAR_FILL, COL_ERROR_LINE, COL_BUBBLE_LINE, 
	COL_BUBBLE_FILLLINE, COL_BUBBLE_FILL, COL_ARROW, COL_WHISKER, COL_BOX_LINE,
	COL_DRECT, COL_GRECT, COL_GRECTLINE, COL_POLYLINE, COL_POLYGON};
enum {MRK_NONE, MRK_INVERT, MRK_GODRAW, MRK_SSB_DRAW};
enum {CMD_NONE, CMD_ADDCHAR, CMD_SETFOCUS, CMD_KILLFOCUS, CMD_DELETE,
	CMD_BACKSP, CMD_CURRLEFT, CMD_CURRIGHT, CMD_CURRUP, CMD_CURRDOWN,
	CMD_SHIFTLEFT, CMD_SHIFTRIGHT, CMD_SHIFTUP, CMD_SHIFTDOWN,
	CMD_NEWGRAPH, CMD_DELGRAPH, CMD_DELOBJ, CMD_DROP_PLOT, CMD_DROP_GRAPH, CMD_OPEN,
	CMD_SAVEDATAAS, CMD_ADDROWCOL, CMD_MOUSE_EVENT, CMD_REDRAW, CMD_DOPLOT,
	CMD_LBUP, CMD_ENDDIALOG, CMD_RADIOBUTT, CMD_ADDCHILD, CMD_BAR_TYPE,
	CMD_BAR_FILL, CMD_SET_AXDEF, CMD_SET_DATAOBJ, CMD_SETTEXT, CMD_GETTEXT,
	CMD_SETTEXTDEF, CMD_GETTEXTDEF, CMD_ADDPLOT, CMD_SYM_TYPE, CMD_SYMTEXT, 
	CMD_SYMTEXTDEF, CMD_RANGETEXT, CMD_SYM_RANGETEXT, CMD_FOCTXT, CMD_CONTINUE,
	CMD_ERR_TYPE, CMD_ARROW_ORG, CMD_ARROW_TYPE, CMD_FLUSH, CMD_BOX_FILL,
	CMD_TABDLG, CMD_NOTABDLG, CMD_TAB, CMD_SHTAB, CMD_BOX_TYPE, CMD_BUBBLE_TYPE,
	CMD_BUBBLE_ATTRIB, CMD_BUBBLE_FILL, CMD_BUBBLE_LINE, CMD_DL_LINE, 
	CMD_DL_TYPE, CMD_SEG_FILL, CMD_SEG_LINE, CMD_SELECT, CMD_MOVE, CMD_CUT,
	CMD_SETSCROLL, CMD_SETHPOS, CMD_SETVPOS, CMD_PG_FILL, CMD_BOUNDS,
	CMD_SHIFT_OUT, CMD_CAN_DELETE, CMD_REG_GO, CMD_RESET_LINE, CMD_SET_TICKSTYLE,
	CMD_GET_GRIDLINE, CMD_SET_GRIDLINE, CMD_SET_GRIDTYPE, CMD_TLB_TXTDEF,
	CMD_DROP_LABEL, CMD_DROP_OBJECT, CMD_PAGEUP, CMD_PAGEDOWN, CMD_AUTOSCALE,
	CMD_MRK_DIRTY, CMD_SETNAME, CMD_TOOLMODE, CMD_DROPFILE, CMD_AXIS, CMD_INIT,
	CMD_GET_CELLDIMS, CMD_SET_CELLDIMS, CMD_TEXTSIZE, CMD_PASTE_TSV, CMD_PASTE_XML,
	CMD_PASTE_CSV, CMD_COPY_TSV, CMD_COPY_XML, CMD_COPY_SYLK, CMD_QUERY_COPY,
	CMD_MOUSECURSOR, CMD_NEWPAGE, CMD_MINRC, CMD_MAXRC,CMD_SETCHILD, CMD_SYM_FILL,
	CMD_LINEUP, CMD_LINEDOWN, CMD_CONFIG, CMD_FINDTEXT, CMD_MOVE_TOP, CMD_MOVE_UP,
	CMD_MOVE_DOWN, CMD_MOVE_BOTTOM, CMD_UPDATE, CMD_POS_FIRST, CMD_POS_LAST,
	CMD_ADDAXIS, CMD_REG_AXISPLOT, CMD_USEAXIS, CMD_SET_GO3D, CMD_UNDO, CMD_DELOBJ_CONT,
	CMD_RMU, CMD_REPL_GO, CMD_UNDO_MOVE, CMD_SAVEPOS, CMD_WHISKER_STYLE, CMD_TICK_TYPE,
	CMD_ZOOM, CMD_CLIP, CMD_STARTLINE, CMD_ADDTOLINE, CMD_DRAW_LATER, CMD_SEG_MOVEABLE,
	CMD_ARROW_ORG3D, CMD_MUTATE, CMD_PRINT, CMD_UPDHISTORY, CMD_ALLTEXT, CMD_SET_LINE,
	CMD_SAVE_SYMBOLS, CMD_SAVE_TICKS, CMD_SAVE_BARS, CMD_SAVE_BARS_CONT, CMD_SAVE_ERRS,
	CMD_SAVE_ARROWS, CMD_SAVE_DROPLINES, CMD_UNLOCK, CMD_SYMTEXT_UNDO, CMD_FILLRANGE, 
	CMD_BUSY, CMD_ERROR, CMD_CLEAR_ERROR, CMD_SETPARAM, CMD_SETFUNC, CMD_HIDE_MARK,
	CMD_LEGEND, CMD_FILENAME, CMD_LAYERS, CMD_OBJTREE, CMD_TEXTDEF};
enum {SYM_CIRCLE, SYM_CIRCLEF, SYM_RECT, SYM_RECTF, SYM_TRIAU, SYM_TRIAUF,
	SYM_TRIAD, SYM_TRIADF, SYM_DIAMOND, SYM_DIAMONDF, SYM_PLUS, SYM_CROSS,
	SYM_STAR, SYM_HLINE, SYM_VLINE, SYM_TEXT, SYM_POS_PARENT = 0x1000};
//types of graphic objects: stored in Id and used for proper destruction of objects
//  and retrieving information.
enum {GO_UNKNOWN, GO_AXIS, GO_TICK, GO_GRIDLINE, GO_SYMBOL, GO_BUBBLE, GO_BAR, 
	GO_ERRBAR, GO_ARROW, GO_BOX, GO_LABEL, GO_MLABEL, GO_WHISKER, GO_DROPLINE, 
	GO_DATALINE, GO_DATAPOLYGON, GO_REGLINE, GO_SDELLIPSE, GO_SEGMENT, 
	GO_POLYLINE, GO_POLYGON, GO_RECTANGLE, GO_ELLIPSE, GO_ROUNDREC,
	GO_DRAGHANDLE, GO_DRAGRECT, GO_DRAG3D, GO_FRAMERECT, GO_SPHERE, GO_SVGOPTIONS,
	GO_PLANE, GO_BRICK, GO_LINESEG, GO_LINE3D, GO_GRIDLINE3D, GO_GRIDRADIAL,
	GO_SPHSCANL, GO_DROPL3D, GO_ARROW3D, GO_PLANE3D, GO_LEGITEM, GO_LEGEND,
	GO_OBJTREE,
	GO_PLOT = 0x100, GO_PLOTSCATT, GO_REGRESSION, GO_BARCHART, GO_BUBBLEPLOT, 
	GO_BOXPLOT, GO_DENSDISP, GO_STACKBAR, GO_STACKPG, GO_WATERFALL, GO_POLARPLOT,
	GO_PIECHART, GO_RINGCHART, GO_GROUP, GO_STARCHART, GO_SCATT3D, GO_PLOT3D,
	GO_RIBBON, GO_LIMITS, GO_FUNCTION, GO_FITFUNC,
	GO_GRAPH = 0x200, GO_PAGE, GO_SPREADDATA = 0x300, GO_DEFRW};
enum {FILL_NONE, FILL_HLINES, FILL_VLINES, FILL_HVCROSS, FILL_DLINEU, FILL_DLINED,
	FILL_DCROSS, FILL_STIPPLE1, FILL_STIPPLE2, FILL_STIPPLE3, FILL_STIPPLE4, 
	FILL_STIPPLE5, FILL_ZIGZAG, FILL_COMBS, FILL_BRICKH, FILL_BRICKV, FILL_BRICKDU, 
	FILL_BRICKDD, FILL_TEXTURE1, FILL_TEXTURE2, FILL_WAVES1, FILL_SCALES, FILL_SHINGLES, 
	FILL_WAVES2, FILL_HERRING, FILL_CIRCLES, FILL_GRASS, FILL_FOAM, FILL_RECS,
	NUM_FILLS, FILL_LIGHT3D = 0x100};
enum {ERRBAR_VSYM, ERRBAR_VUP, ERRBAR_VDOWN, ERRBAR_HSYM, ERRBAR_HLEFT,
	ERRBAR_HRIGHT};
enum {BAR_NONE, BAR_VERTB, BAR_VERTT, BAR_VERTU, BAR_HORL, BAR_HORR, BAR_HORU, 
	BAR_RELWIDTH = 0x100, BAR_CENTERED = 0x200, BAR_WIDTHDATA = 0x400};
enum {TM_STANDARD, TM_DRAW, TM_POLYLINE, TM_POLYGON, TM_RECTANGLE, TM_ELLIPSE,
	TM_ROUNDREC, TM_ARROW, TM_TEXT, TM_MARK, TM_ZOOMIN, TM_MOVE = 0x100};
enum {MC_LAST, MC_ARROW, MC_CROSS, MC_TEXT, MC_WAIT, MC_MOVE, MC_NORTH,
	MC_NE, MC_EAST, MC_SE, MC_SALL, MC_ZOOM};
enum {FILE_ERROR, FILE_READ, FILE_WRITE, INIT_VARS, SAVE_VARS};
enum {ARROW_NOCAP, ARROW_LINE, ARROW_TRIANGLE, ARROW_UNITS = 0x100};
enum {MENU_NONE, MENU_SPREAD, MENU_GRAPH, MENU_PAGE};
enum {GT_UNKNOWN, GT_STANDARD, GT_CIRCCHART, GT_POLARPLOT, GT_3D};
enum {ICO_NONE, ICO_INFO, ICO_ERROR, ICO_RLPLOT, ICO_QT};
enum {FF_UNKNOWN, FF_CSV, FF_TSV, FF_XML, FF_SYLK, FF_RLP, FF_SVG, FF_EPS,
	FF_WMF};
enum {LB_X_DATA = 0x01, LB_X_PARENT = 0x02, LB_Y_DATA = 0x10, LB_Y_PARENT = 0x20};
enum {BUBBLE_CIRCLE = 0x000, BUBBLE_SQUARE = 0x001, BUBBLE_UPTRIA = 0x002,
	BUBBLE_DOWNTRIA = 0x003, BUBBLE_UNITS = 0x000, BUBBLE_XAXIS = 0x010,
	BUBBLE_YAXIS = 0x020, BUBBLE_DIAMET = 0x000, BUBBLE_CIRCUM = 0x100,
	BUBBLE_AREA = 0x200};
enum {DH_UNKNOWN, DH_12, DH_22, DH_19, DH_29, DH_39, DH_49, DH_59, DH_69, DH_79,
	DH_89, DH_99, DH_18, DH_28, DH_38, DH_48, DH_58, DH_68, DH_78, DH_88, DH_DATA};

//drop line styles
#define DL_LEFT          0x001
#define DL_RIGHT         0x002
#define DL_YAXIS         0x004
#define DL_TOP           0x010
#define DL_BOTTOM        0x020
#define DL_XAXIS         0x040
#define DL_CIRCULAR      0x100

typedef struct {
	int num;
	char* display;
	float convert;			//multiply to get mm
	}tag_Units;

typedef struct {
	int x, y, z;
	}POINT3D;

typedef struct {
	double Xmin;
	double Ymax;
	double Xmax;
	double Ymin;
	}fRECT;

typedef struct {
	double fx;
	double fy;
	double fz;
	}fPOINT3D;

typedef struct {
	double fx;
	double fy;
	}lfPOINT;

typedef struct {
	double finc, fp;
	}RunLinePat;				//used for line patterns

typedef struct {
	double width, patlength;
	DWORD color, pattern;
	}LineDEF;

typedef struct {
	int type;					//pattern
	DWORD color;
	double scale;
	LineDEF *hatch;
	DWORD color2;
	}FillDEF;

typedef struct {
	lfPOINT org;				//zoom origin
	double scale;				//zoom factor
	}ZoomDEF;

// Axis definitions are stored in the following structure
// not to be confused with the Axis class grapic object
// bits stored in flags havethe following meaning
#define AXIS_NOTICKS      0x0			// no ticks at all
#define AXIS_POSTICKS     0x1			// positive direction of ticks
#define AXIS_NEGTICKS     0x2			// negative direction 
#define AXIS_SYMTICKS     0x3			// ticks are symmetrical
#define AXIS_GRIDLINE     0x4			// ticks control a gridline
#define AXIS_MINORTICK    0x8			// its a small tick only
#define AXIS_USER         0x00			// axis placement by user
#define AXIS_LEFT         0x10			// left of plot
#define AXIS_RIGHT        0x20			// right  -"-
#define AXIS_TOP          0x30			// top    -"-
#define AXIS_BOTTOM       0x40			// bottom -"-
#define AXIS_AUTOSCALE    0x80			// rescale upon editing
#define AXIS_INVERT       0x100			// axis top->bottom, right to left
#define AXIS_AUTOTICK     0x200			// select tick s automatically
#define AXIS_DEFRECT      0x400			// use axis to define drawing rectangle
#define AXIS_LINEAR       0x0000		// transforms ...
#define AXIS_LOG          0x1000
#define AXIS_RECI         0x2000
#define AXIS_SQR          0x3000
#define AXIS_X_DATA       0x10000		// loc.x is data coordinates
#define AXIS_Y_DATA       0x20000       // loc.y is data coordinates
#define AXIS_Z_DATA       0x40000       // loc.z is data coordinates
#define AXIS_ANGULAR      0x100000      // angular (circular) axis
#define AXIS_RADIAL       0x200000		// radial axis
#define AXIS_3D           0x400000		// three dimensional axis

typedef struct {
	void *owner;				//owners are usually graph, output or axis classes
	DWORD flags;
	double min, max;
	fPOINT3D loc[2];			//placement of axis coordinates
	double Start, Step;			//used for linear axis
	lfPOINT Center;				//of polar plot
	double Radius;				//   -"-
	int nBreaks;				//axis break ...
	lfPOINT *breaks;
	}AxisDEF;

//Attributes for text properties
//Text fonts
enum {FONT_HELVETICA, FONT_TIMES, FONT_COURIER};
//Text styles
#define TXA_VTOP        0
#define TXA_VCENTER     4
#define TXA_VBOTTOM     8
#define TXA_HLEFT       0
#define TXA_HCENTER     1
#define TXA_HRIGHT      2
#define TXM_OPAQUE      0
#define TXM_TRANSPARENT 1
#define TXS_NORMAL      0
#define TXS_ITALIC      1
#define TXS_BOLD        2
#define TXS_UNDERLINE   4
typedef struct {
	DWORD ColTxt, ColBg;				//colors ..
	double fSize;						//Text size in units
	double RotBL, RotCHAR;				//Rotation in degrees
	int iSize;							//Text size is given in iSize as pix
	int Align, Mode, Style;				//Text Alignement 0   1   2
										//                4   5   6
										//                8   9  10
										//Mode 0 = opaque, 1 = transparent
	int Font;
	char *text;
	}TextDEF;

// Store mouse events in the following structure
// Action defines the type of event:
enum {MOUSE_LBDOWN, MOUSE_LBUP, MOUSE_LBDOUBLECLICK, MOUSE_MBDOWN, MOUSE_MBUP, 
	MOUSE_MBDOUBLECLICK, MOUSE_RBDOWN, MOUSE_RBUP, MOUSE_RBDOUBLECLICK,
	MOUSE_MOVE};
typedef struct {
	unsigned short StateFlags;	//  1 Mouse left button down
								//  2       middle button down
								//  4       right button down
								//  8       shift pressed
								// 16       control pressed
	unsigned short Action;
	int x, y;
	} MouseEvent;

//the AccRange class allows to access data objects with a 'a1:b1' style
class AccRange{
public:
	AccRange(char *asc);
	~AccRange();
	int CountItems();
	bool GetFirst(int *x, int *y);
	bool GetNext(int *x, int *y);
	bool IsInRange(int x, int y);
	bool BoundRec(RECT *rec);

private:
	char *txt;
	int x1, y1, x2, y2, cx, cy, curridx;

	bool Reset();
	bool Parse(int start);
};

class anyOutput{
public:
	int units;							//use units mm, inch ...
	int MrkMode;						//existing mark on screen
	void *MrkRect;						//pointer to e.g. the marked rectangle
	fRECT Box1;							//User drawing rectangle
	lfPOINT Box1z;						// add 3D to Box1
	RECT DeskRect;						//this is maximum size Rectangle
	double ddx, ddy, ddz;				//convert to device coordinates
	double hres, vres;					//resolution in dpi
	double LineWidth;					//line width in units
	int iLine;							//current width of line in pixels
	DWORD dLineCol;						//current color of line;
	DWORD dBgCol;						//color of background
	DWORD dFillCol, dFillCol2;
	DWORD dPattern;						//current line bit-pattern
	TextDEF TxtSet;						//store current text settings here
	RunLinePat RLP;						//continuous setings of pattern line
	AxisDEF xAxis, yAxis, zAxis;		//axis and transform definitions
	lfPOINT VPorg;						//zoom origin
	double VPscale;						//zoom factor
	int MenuHeight;						//ofset due to pull down menus
	int cCursor;						//mouse coursor identifier
	double rotM[3][3];					//rotation matrix for 3D
	fPOINT3D rotC;						//rotation center
	bool hasHistMenu;					//File History List
	int HistMenuSize;					//     -"-
	lfPOINT light_source;				//angles for shading
	double light_vec[3][3];				//     -"-

	anyOutput();
	void SetRect(fRECT rec, int units, AxisDEF *x_ax, AxisDEF *y_ax);
	void SetSpace(fPOINT3D*,fPOINT3D*,int,double*,fPOINT3D*,AxisDEF*,AxisDEF*,AxisDEF*);
	void LightSource(double x, double y);
	DWORD VecColor(double *plane_vec, DWORD col1, DWORD col2);
	bool GetSize(RECT *rc);
	virtual bool ActualSize(RECT *rc) {return GetSize(rc);};
	double fx2fix(double x);
	int fx2ix(double x){return (int)(0.5 + fx2fix(x));};
	double fy2fiy(double y);
	int fy2iy(double y){return (int)(0.5 + fy2fiy(y));};
	bool fp2fip(lfPOINT *fdp, lfPOINT *fip);
	bool fvec2ivec(fPOINT3D *v, fPOINT3D *iv);
	bool cvec2ivec(fPOINT3D *v, fPOINT3D *iv);
	bool uvec2ivec(fPOINT3D *v, fPOINT3D *iv);
	double un2fix(double x);
	int un2ix(double x) {return (int)(0.5 + un2fix(x));};
	int co2ix(double x) {return un2ix(x) + iround(VPorg.fx);};
	double co2fix(double x) {return un2fix(x) + VPorg.fx;};
	double un2fiy(double y);
	int un2iy(double y) {return (int)(0.5 + un2fiy(y));};
	int co2iy(double y) {return un2iy(y) + iround(VPorg.fy);};
	double co2fiy(double y) {return un2fiy(y) + VPorg.fy;};
	double un2fiz(double z);
	double fz2fiz(double z);
	double fix2un(double fix);
	double fiy2un(double fiy);
	virtual bool SetLine(LineDEF *lDef){return false;};
	bool GetLine(LineDEF *lDef);
	virtual void Caption(char *txt){return;};
	virtual void MouseCursor(int cid, bool force){return;};
	virtual bool SetScroll(bool, int, int, int, int){return false;};
	virtual bool SetFill(FillDEF *fill){return false;};
	virtual bool SetTextSpec(TextDEF *set);
	virtual bool Erase(DWORD Color){return false;};
	virtual bool StartPage(){return false;};
	virtual bool EndPage(){return false;};
	virtual bool Eject() {return false;};		//printers only
	virtual bool UpdateRect(RECT *rc, bool invert){return false;};
	virtual bool CopyBitmap(int x, int y, anyOutput* src, int sx, int sy,
		int sw, int sh, bool invert){return false;};
	virtual void ShowBitmap(int x, int y, anyOutput* src){return;};
	bool ShowMark(void *rc, int Mode);
	bool HideMark();
	int CalcCursorPos(char *txt, POINT p, POINT *fit);
	bool TextCursor(char *txt, POINT p, POINT *fit, int *pos);
	bool PatLine(POINT p1, POINT p2);
	virtual void ShowLine(POINT * pts, int cp, DWORD color) {return;};
	virtual void ShowEllipse(POINT p1, POINT p2, DWORD color){return;}; 
	virtual bool SetMenu(int type){return false;};
	virtual void CheckMenu(int mid, bool check){return;};
	virtual void FileHistory(){return;};
	virtual bool oGetPix(int x, int y, DWORD *col){return false;};
	virtual bool oDrawIcon(int type, int x, int y) {return false;};
	virtual bool oGetTextExtent(char *text, int cb, int *width, int *height);
	virtual bool oCircle(int x1, int y1, int x2, int y2, char *nam = 0L){return false;};
	virtual bool oSphere(int cx, int cy, int r, POINT *pts, int cp, char *nam = 0L);
	virtual bool oPolyline(POINT * pts, int cp, char *nam = 0L){return false;};
	virtual bool oRectangle(int x1, int y1, int x2, int y2, char *nam = 0L){return false;};
	virtual bool oSolidLine(POINT *p){return false;};
	virtual bool oTextOut(int x, int y, char *txt, int cb){return false;};
	virtual bool oPolygon(POINT *pts, int cp, char *nam = 0L){return false;};
	virtual bool oArc(int x1, int y1, int x2, int y2, int quads){return false;};
};

class EditText {
public:
	char *text;
	int Align, type;
	void *parent;				//points to a data object: defined below
	enum {ET_UNKNOWN, ET_VALUE, ET_TEXT, ET_FORMULA, ET_BUSY=0x100};

	EditText(void *par, POINT where, POINT right, char *msg);
	EditText(void *par, char *msg);
	~EditText();
	bool AddChar(int c, anyOutput *Out);
	void Update(int select, anyOutput *Out, POINT *MousePos);
	bool Redraw(anyOutput *Out, bool display);
	void Mark(anyOutput *Out, int mark);
	bool Command(int cmd, anyOutput *Out, void *data_obj);
	bool GetValue(double *v);
	bool GetText(char *t, int size);
	bool SetValue(double v);
	bool SetText(char *t);
	bool GetItem(char *text, int size);
	void SetRec(RECT *rc);
	int GetX() {return loc.x;};
	int GetY() {return loc.y;};
	bool isValue(){return (type == ET_VALUE || type == ET_FORMULA);};
	bool isFormula(){return (type == ET_FORMULA);};
	bool isInRect(POINT *p) {return (p->x>loc.x && p->x<crb.x && p->y>loc.y && p->y<rb.y);};

private:
	LineDEF *bgLine;
	FillDEF *bgFill;
	int length, CursorPos, m1, m2, mx1, mx2;
	POINT loc, rb, crb;
	DWORD TextCol;
	double Value;

	void FindType();
};

class DataObj{
public:
	int cRows, cCols;
	EditText ***etRows;

	DataObj();
	~DataObj();
	virtual bool Init(int nRows, int nCols);
	virtual bool SetValue(int row, int col, double val);
	virtual bool SetText(int row, int col, char *txt);
	virtual bool GetValue(int row, int col, double *v);
	virtual bool GetText(int row, int col, char *txt, int len);
	virtual bool GetSize(int *width, int *height);
	virtual bool Select(POINT *p){return false;};
	virtual bool WriteData(char *FileName) {return false;};
	virtual bool AddCols(int nCols){return false;};
	virtual bool AddRows(int nRows){return false;};
	virtual bool ChangeSize(int nCols, int nRows){return false;};
	virtual bool Command(int cmd, void *tmpl, anyOutput *o){return false;};
	virtual bool ReadData(char *, unsigned char *, int){return false;};
	virtual void FlushData();
};

class HatchOut:public anyOutput {
public:
	HatchOut(anyOutput *Parent);
	~HatchOut();
	bool SetFill(FillDEF *fill);
	bool StartPage();
	bool oCircle(int x1, int y1, int x2, int y2, char *nam = 0L);
	bool oSphere(int cx, int cy, int r, POINT *pts, int cp, char *nam = 0L);
	bool oRectangle(int x1, int y1, int x2, int y2, char *nam = 0L);
	bool oPolygon(POINT *pts, int cp, char *nam = 0L);

private:
	anyOutput *out;
	double xbase, ybase;
	LineDEF ParLineDef, MyLineDef;
	bool ParInit;
	int ho, ht;
	DWORD ParLinPat;
	RECT UseRect;
	struct {
		int cx, cy, r;
		}circ_grad;

	bool PrepareParent(bool Restore);
	bool DoHatch();
	bool MkPolyLine(POINT *p, anyOutput *o);
	bool HatchLine(POINT p1, POINT p2);
	bool HatchArc(int x, int y, int r, int qad, bool start);
	bool IsInside(POINT p);
	void Lines000();
	void Lines090();
	void Lines045();
	void Lines315();
	void Stipple(int type);
	void Zigzag();
	void Combs();
	void BricksH();
	void BricksV();
	void Bricks045();
	void Bricks315();
	void Texture1();
	void Texture2();
	void Arcs(int type);
	void Waves2();
	void Herringbone();
	void Circles();
	void Grass();
	void Foam();
	void Recs();
	void CircGrad();
};

class GraphObj {
public:
	unsigned long Id;			//accepts an identifier during read from file
								//  it is set to an object identifier after
								//  construction
	GraphObj *parent;
	DataObj *data;
	int type, moveable;
	RECT rDims;
	char *name;

	GraphObj(GraphObj *par, DataObj *d);
	virtual ~GraphObj();
	virtual double GetSize(int select);
	virtual bool SetSize(int select, double value){return false;};
	virtual DWORD GetColor(int select);
	virtual bool SetColor(int select, DWORD col) {return false;};
	virtual void DoPlot(anyOutput *target){return;};
	virtual void DoMark(anyOutput *target, bool mark){return;};
	virtual bool Command(int cmd, void *tmpl, anyOutput *o){return false;};
	virtual bool PropertyDlg(){return false;};
	virtual bool FileIO(int rw) {return false;};
	virtual void * ObjThere(int x, int y);
	virtual void Track(POINT *p, anyOutput *o);
};

class ssButton:public GraphObj {
public:

	ssButton(GraphObj *par, int x, int y, int w, int h);
	~ssButton();
	void DoPlot(anyOutput *o);
	void DoMark(anyOutput *target, bool mark);
	bool Command(int cmd, void *tmpl, anyOutput *o);

private:
	bool bLBdown;
	TextDEF TextDef;
	LineDEF Line;
	FillDEF Fill;
};

class dragHandle:public GraphObj {
public:

	dragHandle(GraphObj *par, int type);
	~dragHandle();
	void DoPlot(anyOutput *o);
	bool Command(int cmd, void *tmpl, anyOutput *o);
	void * ObjThere(int x, int y);
	void Track(POINT *p, anyOutput *o);

private:
	RECT upd, drec, *minRC, *maxRC;
	LineDEF LineDef;
	FillDEF FillDef;
};

class dragRect:public GraphObj {
public:

	dragRect(GraphObj *par, int type);
	~dragRect();
	double GetSize(int select){return parent->GetSize(select);};
	DWORD GetColor(int select){return parent->GetColor(select);};
	void DoPlot(anyOutput *o);
	bool Command(int cmd, void*tmpl, anyOutput *o);
	void * ObjThere(int x, int y);

private:
	dragHandle **handles;
};

class Drag3D:public GraphObj {
public:
	Drag3D(GraphObj *par);
	~Drag3D();
	double GetSize(int select){return parent->GetSize(select);};
	void DoPlot(anyOutput *o);
	void * ObjThere(int x, int y);

private:
	dragHandle **handles;
};

class FrmRect:public GraphObj {
public:

	FrmRect(GraphObj *par, fRECT *limRC, fRECT *cRC, fRECT *chld);
	~FrmRect();
	double GetSize(int select);
	bool SetSize(int select, double value);
	bool SetColor(int select, DWORD col);
	void DoMark(anyOutput *o, bool mark);
	void DoPlot(anyOutput *o);
	bool Command(int cmd, void *tmpl, anyOutput *o);
	bool PropertyDlg(){return parent ? parent->Command(CMD_CONFIG, 0L, 0L) : false;};
	void * ObjThere(int x, int y);
	void Track(POINT *p, anyOutput *o);

private:
	RECT *minRC, *maxRC;
	anyOutput *mo;
	RECT mrc;
	dragRect *drag;
	bool swapX, swapY;
	fRECT *limRC, *cRC, *chldRC, CurrRect;
	LineDEF Line, FillLine;
	FillDEF Fill;
};

class svgOptions:public GraphObj{
public:
	svgOptions(int src);
	~svgOptions();
	bool FileIO(int rw);

private:
	char *script, *svgattr;
};

class Symbol:public GraphObj{
public:
	int idx;

	Symbol(GraphObj *par, DataObj *d, double x, double y, int which, 
		int xc = -1, int xr = -1, int yc = -1, int yr = -1);
	Symbol(int src);
	~Symbol();
	double GetSize(int select);
	bool SetSize(int select, double value);
	DWORD GetColor(int select);
	bool SetColor(int select, DWORD col);
	void DoPlot(anyOutput *target);
	bool Command(int cmd, void *tmpl, anyOutput *o);
	bool PropertyDlg();
	bool FileIO(int rw);

private:
	lfPOINT fPos;
	POINT *ssRef;
	long cssRef;
	double size;
	LineDEF SymLine;
	FillDEF SymFill;
	TextDEF *SymTxt;
};

class Bubble:public GraphObj{
public:
	Bubble(GraphObj *par, DataObj *d, double x, double y, double s, 
		int which, FillDEF *fill, LineDEF *outline, int xc = -1, 
		int xr = -1, int yc = -1, int yr = -1, int sc = -1, int sr = -1);
	Bubble(int src);
	~Bubble();
	void DoPlot(anyOutput *o);
	void DoMark(anyOutput *o, bool mark);
	bool Command(int cmd, void *tmpl, anyOutput *o);
	bool PropertyDlg();
	bool FileIO(int rw);

private:
	lfPOINT fPos;
	double fs;
	LineDEF BubbleLine, BubbleFillLine;
	FillDEF BubbleFill;
	POINT pts[5];
	POINT *ssRef;
	long cssRef;
};

class Bar:public GraphObj {
public:
	Bar(GraphObj *par, DataObj *d, double x, double y, int which, 
		int xc = -1, int xr = -1, int yc = -1, int yr = -1);
	Bar(int src);
	~Bar();
	double GetSize(int select);
	bool SetSize(int select, double value);
	bool SetColor(int select, DWORD col);
	void DoPlot(anyOutput *target);
	bool Command(int cmd, void *tmpl, anyOutput *o);
	bool PropertyDlg();
	bool FileIO(int rw);

private:
	double size;
	LineDEF BarLine, HatchLine;
	FillDEF BarFill;
	lfPOINT fPos, BarBase;
	POINT *ssRef;
	long cssRef;
};

class DataLine:public GraphObj{
public:
	bool isPolygon, dirty;
	lfPOINT *Values;
	lfPOINT min, max;
	LineDEF LineDef;
	long nPnt, nPntSet, cp;
	DWORD BgColor;
	POINT *pts;
	char *ssXref, *ssYref;
	anyOutput *mo;
	RECT mrc;

	DataLine(GraphObj *par, DataObj *d, char *xrange=0L, char *yrange=0L);
	DataLine(GraphObj *par, DataObj *d, lfPOINT *val, long nval);
	DataLine(int src);
	~DataLine();
	bool SetColor(int select, DWORD col);
	virtual void DoPlot(anyOutput *target);
	virtual void DoMark(anyOutput *o, bool mark);
	virtual bool Command(int cmd, void *tmpl, anyOutput *o);
	virtual bool PropertyDlg();
	virtual bool FileIO(int rw);

	void FileValues(char *name, int type, double start, double step);
	void SetValues();
	void LineData(lfPOINT *val, long nval);
};

class DataPolygon:public DataLine{
public:
	DataPolygon(GraphObj *par, DataObj *d, char *xrange=0L, char *yrange=0L);
	DataPolygon(int src);
	~DataPolygon();
	void DoPlot(anyOutput *target);
	void DoMark(anyOutput *o, bool mark);
	bool Command(int cmd, void *tmpl, anyOutput *o);
	bool PropertyDlg();
	bool FileIO(int rw);

private:
	FillDEF pgFill;
	LineDEF pgFillLine;
};

class RegLine:public GraphObj{
public:
	RegLine(GraphObj *par, DataObj *d, lfPOINT *values, long n, int type);
	RegLine(int src);
	~RegLine();
	double GetSize(int select);
	void DoPlot(anyOutput *o);
	void DoMark(anyOutput *o, bool mark);
	bool Command(int cmd, void *tmpl, anyOutput *o);
	bool PropertyDlg();
	bool FileIO(int rw);

	void Recalc(lfPOINT *values, long n);
	LineDEF *GetLine(){return &LineDef;};

private:
	long nPoints, cp;
	double mx, my;
	LineDEF LineDef;
	fRECT lim, uclip;
	lfPOINT l1, l2, l3, l4, l5;
	DWORD BgColor;
	POINT *pts;
};

class SDellipse:public GraphObj{
public:
	SDellipse(GraphObj *par, DataObj *d, lfPOINT *values, long n, int sel);
	SDellipse(int src);
	~SDellipse();
	void DoPlot(anyOutput *o);
	void DoMark(anyOutput *o, bool mark);
	bool Command(int cmd, void *tmpl, anyOutput *o);
	bool PropertyDlg();
	bool FileIO(int rw);

	void Recalc(lfPOINT *values, long n);

private:
	long nPoints, cp;
	double sd1, sd2, mx, my;
	POINT *pts;
	LineDEF LineDef;
	fRECT lim;
	lfPOINT *val;
	RegLine *rl;
};

class ErrorBar:public GraphObj{
public:
	ErrorBar(GraphObj *par, DataObj *d, double x, double y, double err, int type,
		int xc=-1, int xr=-1, int yc=-1, int yr=-1, int ec=-1, int er=-1);
	ErrorBar(int src);
	~ErrorBar();
	bool SetSize(int select, double value);
	bool SetColor(int select, DWORD col);
	void DoPlot(anyOutput *target);
	void DoMark(anyOutput *o, bool mark);
	bool Command(int cmd, void *tmpl, anyOutput *o);
	bool PropertyDlg();
	bool FileIO(int rw);

private:
	lfPOINT fPos;
	double ferr, SizeBar;
	POINT ebpts[6];
	LineDEF ErrLine;
	POINT *ssRef;
	long cssRef;
};

class Arrow:public GraphObj {
public:
	Arrow(GraphObj *par, DataObj *d, lfPOINT fp1, lfPOINT fp2, int which = 0,
		int xc1=-1, int xr1=-1, int yc1=-1, int yr1=-1, int xc2=-1, int xr2=-1,
		int yc2=-1, int yr2=-1);
	Arrow(int src);
	~Arrow();
	double GetSize(int select);
	bool SetSize(int select, double value);
	DWORD GetColor(int select){return LineDef.color;};
	bool SetColor(int select, DWORD col);
	void DoPlot(anyOutput *o);
	void DoMark(anyOutput *o, bool mark);
	bool Command(int cmd, void *tmpl, anyOutput *o);
	bool PropertyDlg();
	bool FileIO(int rw);
	void * ObjThere(int x, int y);
	void Track(POINT *p, anyOutput *o);

private:
	dragHandle *dh1, *dh2;
	POINT pts[5];
	lfPOINT pos1, pos2;
	double cw, cl;
	LineDEF LineDef;
	POINT *ssRef;
	long cssRef;
	bool bModified;

	void Redraw(anyOutput *o);
};

class Box:public GraphObj {
public:
	Box(GraphObj *par, DataObj *d, lfPOINT fp1, lfPOINT fp2, int which, 
		int xc1=-1, int xr1=-1, int yc1=-1, int yr1=-1, int xc2=-1, int xr2=-1,
		int yc2=-1, int yr2=-1);
	Box(int src);
	~Box();
	double GetSize(int select);
	bool SetSize(int select, double value);
	bool SetColor(int select, DWORD col);
	void DoPlot(anyOutput *o);
	void DoMark(anyOutput *o, bool mark);
	bool Command(int cmd, void *tmpl, anyOutput *o);
	bool PropertyDlg();
	bool FileIO(int rw);

private:
	double size;
	lfPOINT pos1, pos2;
	POINT pts[5];
	LineDEF Outline, Hatchline;
	FillDEF Fill;
	POINT *ssRef;
	long cssRef;
};

class Whisker:public GraphObj {
public:
	Whisker(GraphObj *par, DataObj *d, lfPOINT fp1, lfPOINT fp2, int which,
		int xc1=-1, int xr1=-1, int yc1=-1, int yr1=-1, int xc2=-1, int xr2=-1,
		int yc2=-1, int yr2=-1);
	Whisker(int src);
	bool SetSize(int select, double value);
	bool SetColor(int select, DWORD col);
	void DoPlot(anyOutput *o);
	void DoMark(anyOutput *o, bool mark);
	bool Command(int cmd, void *tmpl, anyOutput *o);
	bool PropertyDlg();
	bool FileIO(int rw);

private:
	double size;
	POINT pts[6];
	lfPOINT pos1, pos2;
	LineDEF LineDef;
	POINT *ssRef;
	long cssRef;
};

class DropLine:public GraphObj{
public:
	DropLine(GraphObj *par, DataObj *d, double x, double y, int which, int xc = -1, 
		int xr = -1, int yc = -1, int yr = -1);
	DropLine(int src);
	~DropLine();
	void DoPlot(anyOutput *o);
	void DoMark(anyOutput *o, bool mark);
	bool Command(int cmd, void *tmpl, anyOutput *o);
	bool PropertyDlg();
	bool FileIO(int rw);

private:
	lfPOINT fPos;
	POINT pts[4];
	LineDEF LineDef;
	POINT *ssRef;
	long cssRef;
	bool bModified;
};

class line_segment:public GraphObj{
public:
	line_segment(GraphObj *par, DataObj *d, LineDEF *ld, POINT3D *p1, POINT3D *p2);
	~line_segment();
	double GetSize(int select);
	void DoPlot(anyOutput *o);
	bool Command(int cmd, void *tmpl, anyOutput *o);
	void * ObjThere(int x, int y);

private:
	LineDEF Line;
	POINT3D **ldata;
	fPOINT3D fmin, fmax;
	int *nldata, nli, ndf_go;
	double prop;
	bool bDrawDone;
	GraphObj *co, **df_go;

	void DoClip(GraphObj *co);
};

class sph_scanline:public GraphObj{
public:
	int rad;
	bool vert;

	sph_scanline(POINT3D *center, int radius, bool bVert);
	bool Command(int cmd, void *tmpl, anyOutput *o);

	void DoClip(GraphObj *co);
	bool GetPoint(POINT *p, int sel);

private:
	POINT3D p1, p2, cent;
	bool bValid1, bValid2;
};

class Sphere:public GraphObj{
public:
	Sphere(GraphObj *par, DataObj *d, int sel, double x, double y, double z, double r,
		int xc = -1, int xr = -1, int yc = -1, int yr = -1, int zc = -1, int zr = -1,
		int rc = -1, int rr = -1);
	Sphere(int src);
	~Sphere();
	double GetSize(int select);
	bool SetSize(int select, double value);
	bool SetColor(int select, DWORD col);
	void DoPlot(anyOutput *o);
	bool Command(int cmd, void *tmpl, anyOutput *o);
	bool PropertyDlg();
	bool FileIO(int rw);

private:
	int ix, iy, rx, ry, nscl;
	LineDEF Line;
	FillDEF Fill;
	fPOINT3D fPos, fip;
	double size;
	POINT *ssRef;
	long cssRef;
	GraphObj *co;
	bool bModified, bDrawDone;
	sph_scanline **scl;

	void DoClip(GraphObj *co);
	void DrawPG(anyOutput *o, int start);
};

class plane:public GraphObj{
public:
	plane(GraphObj *par, DataObj *d, fPOINT3D *pts, int nPts, LineDEF *line, 
		FillDEF *fill);
	~plane();
	double GetSize(int select);
	void DoPlot(anyOutput *o);
	void DoMark(anyOutput *o, bool mark);
	bool Command(int cmd, void *tmpl, anyOutput *o);
	void * ObjThere(int x, int y);

	bool GetPolygon(POINT3D **pla, int *npt, int sel);
	double *GetVec() {return PlaneVec;};

private:
	LineDEF Line;
	FillDEF Fill;
	double *PlaneVec;
	POINT3D **ldata;
	int *nldata, nli, n_ipts, n_lines;
	POINT *ipts;
	lfPOINT xBounds, yBounds, zBounds;
	bool bDrawDone;
	GraphObj *co;
	line_segment **lines;
	long totalArea;

	void DoClip(GraphObj *co);
	bool IsValidPG(POINT3D *pg, int npg);
};

class Plane3D:public GraphObj {
public:
	Plane3D(GraphObj *par, DataObj *da, fPOINT3D *pt, long npt);
	Plane3D(int src);
	~Plane3D();
	bool SetSize(int select, double value);
	bool SetColor(int select, DWORD col);
	void DoPlot(anyOutput *o);
	void DoMark(anyOutput *o, bool mark);
	bool Command(int cmd, void *tmpl, anyOutput *o);
	bool PropertyDlg();
	bool FileIO(int rw);

private:
	plane *ipl;
	fPOINT3D *dt, *pts;
	long ndt;
	LineDEF Line;
	FillDEF Fill;
};

class Brick:public GraphObj{
public:
	Brick(GraphObj *par, DataObj *da, double x, double y, double z, 
		double d, double w, double h, DWORD flags, int xc = -1,
		int xr = -1, int yc = -1, int yr = -1, int zc = -1, int zr = -1,
		int dc = -1, int dr = -1, int wc = -1, int wr = -1, int hc = -1,
		int hr = -1);
	Brick(int src);
	~Brick();
	bool SetSize(int select, double value);
	bool SetColor(int select, DWORD col);
	void DoPlot(anyOutput *o);
	void DoMark(anyOutput *o, bool mark);
	bool Command(int cmd, void *tmpl, anyOutput *o);
	bool PropertyDlg();
	bool FileIO(int rw);

private:
	LineDEF Line;
	FillDEF Fill;
	fPOINT3D fPos;
	double depth, width, height;
	DWORD flags;
	POINT *ssRef;
	long cssRef;
	plane **faces;
	anyOutput *mo;
	RECT mrc;
	bool bModified;
};

class DropLine3D:public GraphObj{
public:
	DropLine3D(GraphObj *par, DataObj *d, fPOINT3D *p1, int xc = -1,
		int xr = -1, int yc = -1, int yr = -1, int zc = -1, int zr = -1);
	DropLine3D(int src);
	~DropLine3D();
	void DoPlot(anyOutput *o);
	void DoMark(anyOutput *o, bool mark);
	bool Command(int cmd, void *tmpl, anyOutput *o);
	bool PropertyDlg();
	bool FileIO(int rw);

private:
	line_segment *ls[6];
	POINT mpts[6][2];
	LineDEF Line;
	fPOINT3D fPos;
	POINT *ssRef;
	long cssRef;
	bool bModified;
	anyOutput *mo;
	RECT mrc;
};

class Arrow3D:public GraphObj{
public:
	Arrow3D(GraphObj *par, DataObj *d, fPOINT3D *p1, fPOINT3D *p2, int xc1 = -1,
		int xr1 = -1, int yc1 = -1, int yr1 = -1, int zc1 = -1, int zr1 = -1, 
		int xc2 = -1, int xr2 = -1, int yc2 = -1, int yr2 = -1, int zc2 = -1, 
		int zr2 = -1);
	Arrow3D(int src);
	~Arrow3D();
	bool SetSize(int select, double value);
	bool SetColor(int select, DWORD col);
	void DoPlot(anyOutput *o);
	void DoMark(anyOutput *o, bool mark);
	bool Command(int cmd, void *tmpl, anyOutput *o);
	bool PropertyDlg();
	bool FileIO(int rw);

private:
	line_segment *ls[3];
	plane *cap;
	double cw, cl;
	POINT mpts[3][2];
	LineDEF Line;
	fPOINT3D fPos1, fPos2;
	POINT *ssRef;
	long cssRef;
	bool bModified;
};

class Line3D:public GraphObj{
public:
	Line3D(GraphObj *par, DataObj *d, char *rx, char *ry, char *rz);
	Line3D(int src);
	~Line3D();
	void DoPlot(anyOutput *o);
	void DoMark(anyOutput *o, bool mark);
	bool Command(int cmd, void *tmpl, anyOutput *o);
	bool PropertyDlg();
	bool FileIO(int rw);

private:
	LineDEF Line;
	line_segment **ls;
	fPOINT3D *values, min, max;
	POINT *pts;
	char *x_range, *y_range, *z_range;
	long nPts, npts;
	bool bModified;
	anyOutput *mo;
	RECT mrc;

	void DoUpdate();
};

class Label:public GraphObj{
public:
	Label(GraphObj *par, DataObj *d, double x, double y, TextDEF *td, DWORD flg,
		int xc = -1, int xr = -1, int yc = -1, int yr = -1, int tc = -1, int tr = -1);
	Label(int src);
	~Label();
	double GetSize(int select);
	bool SetSize(int select, double value);
	bool SetColor(int select, DWORD col);
	void DoPlot(anyOutput *o);
	void DoMark(anyOutput *o, bool mark);
	bool Command(int cmd, void *tmpl, anyOutput *o);
	bool PropertyDlg();
	bool FileIO(int rw);
	void * ObjThere(int x, int y);
	void Track(POINT *p, anyOutput *o);

	bool CalcRect(anyOutput *o);
	void RedrawEdit(anyOutput *o);
	void ShowCursor(anyOutput *o);
	bool AddChar(int ci, anyOutput *o);
	void CalcCursorPos(int x, int y, anyOutput *o);
	void SetModified();
	TextDEF *GetTextDef(){return &TextDef;};

private:
	lfPOINT fPos, fDist;
	double si, csi;
	DWORD flags, bgcolor;
	TextDEF TextDef;
	LineDEF bgLine;
	int ix, iy, CursorPos;
	RECT Cursor;
	POINT pts[5];
	POINT *ssRef;
	long cssRef;
	anyOutput *defDisp;
	bool bModified, bBGvalid;
};

class mLabel:public GraphObj{
public:
	mLabel(GraphObj *, DataObj *, double, double, TextDEF *, char *, int, DWORD);
	mLabel(GraphObj *, DataObj *, double, double, TextDEF *, char *);
	mLabel(int src);
	~mLabel();
	double GetSize(int select);
	bool SetSize(int select, double value);
	void DoPlot(anyOutput *o);
	bool Command(int cmd, void *tmpl, anyOutput *o);
	bool FileIO(int rw);
	void Track(POINT *p, anyOutput *o);

private:
	lfPOINT fPos, fDist, cPos, cPos1, dist;
	double si, csi;
	DWORD flags, undo_flags;
	TextDEF TextDef;
	long nLines;
	int cli;
	Label **Lines;
};

class segment:public GraphObj{
public:
	segment(GraphObj *par, DataObj *d, lfPOINT *c, double r1, double r2, double a1, double a2);
	segment(int src);
	~segment();
	bool SetSize(int select, double value);
	void DoPlot(anyOutput *o);
	void DoMark(anyOutput *o, bool mark);
	bool Command(int cmd, void *tmpl, anyOutput *o);
	bool PropertyDlg();
	bool FileIO(int rw);
	void * ObjThere(int x, int y);
	void Track(POINT *p, anyOutput *o);

private:
	lfPOINT fCent;
	long nPts;
	double radius1, radius2, angle1, angle2, shift;
	LineDEF segLine, segFillLine;
	FillDEF segFill;
	POINT *pts;
	bool bModified;
};

class polyline:public GraphObj {
public:
	lfPOINT *Values;
	long nPoints, nPts;
	POINT *pts;
	LineDEF pgLine, pgFillLine;
	FillDEF pgFill;
	bool bModified;

	polyline(GraphObj *par, DataObj *d, lfPOINT *fpts, int cpts);
	polyline(int src);
	~polyline();
	double GetSize(int select);
	bool SetSize(int select, double value);
	DWORD GetColor(int select);
	void DoPlot(anyOutput *o);
	void DoMark(anyOutput *o, bool mark);
	bool Command(int cmd, void *tmpl, anyOutput *o);
	virtual bool PropertyDlg();
	bool FileIO(int rw);
	void * ObjThere(int x, int y);
	void Track(POINT *p, anyOutput *o);

private:
	dragHandle **pHandles;

	void ShowPoints(anyOutput *o);
};

class polygon:public polyline {
public:
	polygon(GraphObj *par, DataObj *d, lfPOINT *fpts, int cpts);
	polygon(int src):polyline(src){};
	bool PropertyDlg();
};

class rectangle:public GraphObj {
public:
	lfPOINT fp1, fp2;
	LineDEF Line, FillLine;
	FillDEF Fill;
	double rad;
	bool bModified;

	rectangle(GraphObj *par, DataObj *d, lfPOINT *p1, lfPOINT *p2);
	rectangle(int src);
	~rectangle();
	double GetSize(int select);
	bool SetSize(int select, double value);
	DWORD GetColor(int select){return Line.color;};
	void DoMark(anyOutput *o, bool mark);
	void DoPlot(anyOutput *o);
	bool Command(int cmd, void *tmpl, anyOutput *o);
	bool PropertyDlg();
	bool FileIO(int rw);
	void * ObjThere(int x, int y);
	void Track(POINT *p, anyOutput *o);

private:
	POINT *pts;
	long nPts;
	dragRect *drc;
	void PlotRoundRect(anyOutput *o);
};

class ellipse:public rectangle {
public:
	ellipse(GraphObj *par, DataObj *d, lfPOINT *p1, lfPOINT *p2);
	ellipse(int src);
};

class roundrec:public rectangle {
public:
	roundrec(GraphObj *par, DataObj *d, lfPOINT *p1, lfPOINT *p2);
	roundrec(int src);
};

class LegItem:public GraphObj{
public:
	LegItem(GraphObj *par, DataObj *d, LineDEF *ld, LineDEF *lf, FillDEF *fill);
	LegItem(GraphObj *par, DataObj *d, LineDEF *ld, Symbol *sy);
	LegItem(int src);
	~LegItem();
	double GetSize(int select);
	void DoPlot(anyOutput *o);
	void DoMark(anyOutput *o, bool mark);
	bool Command(int cmd, void *tmpl, anyOutput *o);
	bool FileIO(int rw);
	void Track(POINT *p, anyOutput *o);

	bool HasFill(LineDEF *ld, FillDEF *fd);
	bool HasSym(LineDEF *ld, Symbol *sy);

private:
	LineDEF DataLine, OutLine, HatchLine;
	FillDEF Fill;
	Symbol *Sym;
	Label *Desc;
	DWORD flags;
	RECT hcr;

	void DefDesc(char *txt);
};

class Legend:public GraphObj{
public:
	Legend(GraphObj *par, DataObj *d);
	Legend(int src);
	~Legend();
	double GetSize(int select);
	bool SetSize(int select, double value);
	void DoPlot(anyOutput *o);
	void DoMark(anyOutput *o, bool mark);
	bool Command(int cmd, void *tmpl, anyOutput *o);
	bool FileIO(int rw);
	void Track(POINT *p, anyOutput *o);

	bool HasFill(LineDEF *ld, FillDEF *fd);
	bool HasSym(LineDEF *ld, Symbol *sy);

private:
	lfPOINT pos, lb_pos;
	RECT trc;
	anyOutput *to;
	fRECT B_Rect, C_Rect, D_Rect, E_Rect, F_Rect;
	long nItems;
	LegItem **Items;
};

class Plot:public GraphObj{
public:
	fRECT Bounds;					//contains minima and maxima for x and y
	bool dirty;						//rescale before redraw;
	int use_xaxis, use_yaxis;		//this plot uses its own axes
	lfPOINT xBounds, yBounds, zBounds;	//like Bounds but in 3D space
	int hidden;						//plot (layer) is not visible

	Plot(GraphObj *par, DataObj *d);
	virtual double GetSize(int select);
	virtual bool SetSize(int select, double value){return false;};
	virtual DWORD GetColor(int select);
	virtual bool SetColor(int select, DWORD col){return false;};
	virtual void DoPlot(anyOutput *o){return;};
	virtual bool Command(int cmd, void *tmpl, anyOutput *o){return false;};
	virtual bool PropertyDlg(){return false;};

	void CheckBounds(double x, double y);
	bool UseAxis(int idx);
	void ApplyAxes(anyOutput *o);
	void CheckBounds3D(double x, double y, double z);
	bool SavVarObs(GraphObj **gol, long ngo, DWORD flags);
	DataObj *CreaCumData(char *xr, char *yr, int mode, double base);
};

class PlotScatt:public Plot{
public:
	PlotScatt(GraphObj *par, DataObj *d, DWORD presel);
	PlotScatt(GraphObj *par, DataObj *d, int cBars, Bar **bars);
	PlotScatt(GraphObj *par, DataObj *d, int nPts, Symbol **sym, DataLine *lin);
	PlotScatt(int src);
	~PlotScatt();
	double GetSize(int select);
	bool SetSize(int select, double value);
	bool SetColor(int select, DWORD col);
	void DoPlot(anyOutput *target);
	bool Command(int cmd, void *tmpl, anyOutput *o);
	virtual bool PropertyDlg();
	bool FileIO(int rw);

private:
	DWORD DefSel;
	lfPOINT BarDist;
	char *xRange, *yRange, *ErrRange, *LbRange;
	int DefSym;
	long nPoints;
	Bar **Bars;
	Symbol **Symbols;
	DataLine *TheLine;
	ErrorBar **Errors;
	Arrow **Arrows;
	DropLine **DropLines;
	Label **Labels;

	bool CreateBarChart();
	enum {FE_NONE = 0x1000, FE_PARENT, FE_PLOT, FE_FLUSH, FE_DELOBJ, FE_WRITE, 
		FE_REGGO, FE_REPLGO, FE_MUTATE};
	bool ForEach(int cmd, void *tmp, anyOutput *o);
};


class BarChart:public PlotScatt{
public:
	BarChart(GraphObj *par, DataObj *d);
};

class Regression:public Plot{
public:
	Regression(GraphObj *par, DataObj *d);
	Regression(int src);
	~Regression();
	double GetSize(int select);
	bool SetSize(int select, double value);
	bool SetColor(int select, DWORD col);
	void DoPlot(anyOutput *target);
	bool Command(int cmd, void *tmpl, anyOutput *o);
	bool PropertyDlg();
	bool FileIO(int rw);

private:
	long nPoints;
	char *xRange, *yRange;
	Symbol **Symbols;
	RegLine *rLine;
	SDellipse *sde;

	void Recalc();
};

class BubblePlot:public Plot{
public:
	BubblePlot(GraphObj *par, DataObj *d);
	BubblePlot(int src);
	~BubblePlot();
	void DoPlot(anyOutput *target);
	DWORD GetColor(int select);
	bool Command(int cmd, void *tmpl, anyOutput *o);
	bool PropertyDlg();
	bool FileIO(int rw);

private:
	long nPoints;
	LineDEF BubbleLine, BubbleFillLine;
	FillDEF BubbleFill;
	Bubble **Bubbles;
};

class PolarPlot:public Plot{
public:
	PolarPlot(GraphObj *par, DataObj *d);
	PolarPlot(int src);
	~PolarPlot();
	double GetSize(int select);
	void DoPlot(anyOutput *o);
	bool Command(int cmd, void *tmpl, anyOutput *o);
	bool PropertyDlg();
	bool FileIO(int rw);

	bool AddPlot();
	bool Config();

private:
	int nPlots, nAxes;
	double offs;
	anyOutput *CurrDisp;
	fRECT CurrRect;
	LineDEF FillLine;
	FillDEF Fill;
	Plot **Plots;
	GraphObj **Axes;			//Axis not yet defined
};

class BoxPlot:public Plot {
public:
	BoxPlot(GraphObj *par, DataObj *d);
	BoxPlot(int src);
	BoxPlot(GraphObj *par, DataObj *dt, int mode, int c1, int c2, int c3);
	~BoxPlot();
	double GetSize(int select);
	bool SetSize(int select, double value);
	bool SetColor(int select, DWORD col);
	void DoPlot(anyOutput *o);
	bool Command(int cmd, void *tmpl, anyOutput *o);
	bool PropertyDlg();
	bool FileIO(int rw);

private:
	long nPoints;
	lfPOINT BoxDist;
	Box **Boxes;
	Whisker **Whiskers;
	Symbol **Symbols;
	DataLine *TheLine;
};

class DensDisp:public Plot {
public:
	DensDisp(GraphObj *par, DataObj *d);
	DensDisp(int src);
	~DensDisp();
	bool SetSize(int select, double value);
	bool SetColor(int select, DWORD col);
	void DoPlot(anyOutput *o);
	bool Command(int cmd, void *tmpl, anyOutput *o);
	bool PropertyDlg();
	bool FileIO(int rw);

private:
	LineDEF DefLine, DefFillLine;
	FillDEF DefFill;
	long nPoints;
	char *xRange, *yRange;
	Box **Boxes;

	void DoUpdate();

};

class StackBar:public Plot{
public:
	int numPlots, numXY, numPG, numPL;
	BoxPlot **Boxes;
	PlotScatt **xyPlots;
	DataPolygon **Polygons;
	DataLine **Lines;
	lfPOINT dspm;

	StackBar(GraphObj *par, DataObj *d);
	StackBar(int src);
	~StackBar();
	bool SetSize(int select, double value);
	void DoPlot(anyOutput *o);
	bool Command(int cmd, void *tmpl, anyOutput *o);
	bool PropertyDlg();
	bool FileIO(int rw);

private:
	char *ssXrange, *ssYrange;
	double StartVal;
	int cum_data_mode;
	DataObj *CumData;
};

class StackPG:public StackBar{
public:
	StackPG(GraphObj *par, DataObj *d);
};

class GroupBars:public StackBar{
public:
	GroupBars(GraphObj *par, DataObj *d):StackBar(par, d){};
	bool PropertyDlg();
};

class Waterfall:public StackBar{
public:
	Waterfall(GraphObj *par, DataObj *d);
	bool PropertyDlg();
};

class PieChart:public Plot {
public:
	PieChart(GraphObj *par, DataObj *d);
	PieChart(int src);
	~PieChart();
	bool SetSize(int select, double value);
	void DoPlot(anyOutput *o);
	bool Command(int cmd, void *tmpl, anyOutput *o);
	bool PropertyDlg();
	bool FileIO(int rw);
	void DoUpdate();

private:
	int nPts;
	char *ssRefA, *ssRefR;
	lfPOINT CtDef;
	double FacRad;
	segment **Segments;
};

class RingChart:public PieChart {
public:
	RingChart(GraphObj *par, DataObj *d);
};

class GoGroup:public Plot {
public:
	GraphObj **Objects;
	int nObs;
	lfPOINT fPos;

	GoGroup(GraphObj *par, DataObj *d);
	GoGroup(int src);
	~GoGroup();
	double GetSize(int select);
	void DoPlot(anyOutput *o);
	bool Command(int cmd, void *tmpl, anyOutput *o);
	bool FileIO(int rw);
};

class StarChart:public GoGroup {
public:
	StarChart(GraphObj *par, DataObj *d);
	bool PropertyDlg();

private:
};

class Scatt3D:public Plot{
public:
	Scatt3D(GraphObj *par, DataObj *d, DWORD flags);
	Scatt3D(GraphObj *par, DataObj *d, Brick **cols, long nob);
	Scatt3D(GraphObj *par, DataObj *d, Sphere **ba, long nob);
	Scatt3D(int src);
	~Scatt3D();
	double GetSize(int select);
	bool SetSize(int select, double value);
	bool SetColor(int select, DWORD col);
	void DoPlot(anyOutput *o);
	bool Command(int cmd, void *tmpl, anyOutput *o);
	bool PropertyDlg();
	bool FileIO(int rw);

private:
	long nBalls, nColumns, nDropLines, nArrows;
	DWORD c_flags;
	char *ssRefX, *ssRefY, *ssRefZ;
	Line3D *Line;
	Sphere **Balls;
	Brick **Columns;
	DropLine3D **DropLines;
	Arrow3D **Arrows;
};

class Ribbon:public Plot {
public:
	Ribbon(GraphObj *par, DataObj *d, double z, double width, char *xr, char *yr);
	Ribbon(int src);
	~Ribbon();
	double GetSize(int select);
	bool SetSize(int select, double value);
	bool SetColor(int select, DWORD col);
	void DoPlot(anyOutput *o);
	bool Command(int cmd, void *tmpl, anyOutput *o);
	bool FileIO(int rw);

private:
	long nPlanes, nVal;
	double z_value, z_width, relwidth;
	char *ssRefX, *ssRefY, *ssRefZ;
	FillDEF Fill;
	LineDEF Line;
	fPOINT3D *values;
	Plane3D **planes;

	void CreateObs();
	void UpdateObs(bool bNewData);
};

class Limits:public Plot {
public:
	Limits(int src);
	~Limits();
	double GetSize(int select);
	bool Command(int cmd, void *tmpl, anyOutput *o);
	bool FileIO(int rw);
};

class Function:public Plot{
public:
	Function(GraphObj *par, DataObj *d);
	Function(int src);
	~Function();
	bool SetSize(int select, double value);
	void DoPlot(anyOutput *o);
	bool Command(int cmd, void *tmpl, anyOutput *o);
	bool PropertyDlg();
	bool FileIO(int rw);

	bool Update(anyOutput *o, DWORD flags);
	LineDEF *GetLine() {return &Line;};

private:
	double x1,x2, xstep;
	LineDEF Line;
	char *param;
	char *cmdxy;
	DataLine *dl;
};

class FitFunc:public Plot{
public:
	FitFunc(GraphObj *par, DataObj *d);
	FitFunc(int src);
	~FitFunc();
	bool SetSize(int select, double value);
	bool SetColor(int select, DWORD col);
	void DoPlot(anyOutput *o);
	bool Command(int cmd, void *tmpl, anyOutput *o);
	bool PropertyDlg();
	bool FileIO(int rw);

private:
	double x1, x2, xstep, conv;
	char *ssXref, *ssYref;
	long nPoints;
	int maxiter;
	LineDEF Line;
	Symbol **Symbols;
	char *cmdxy, *parxy;
	Function *dl;
};

class GridLine:public GraphObj{
public:
	DWORD flags;
	long ncpts;
	POINT pts[6], *cpts;
	LineDEF LineDef;
	POINT3D *gl1, *gl2, *gl3;
	line_segment **ls;
	bool bModified;
	anyOutput *mo;
	RECT mrc;

	GridLine(GraphObj *par, DataObj *d, int type, DWORD df);
	GridLine(int src);
	~GridLine();
	virtual void DoPlot(anyOutput *o);
	virtual void DoMark(anyOutput *o, bool mark);
	virtual bool Command(int cmd, void *tmpl, anyOutput *o);
	bool PropertyDlg();
	bool FileIO(int rw);
};

class GridLine3D:public GridLine {
public:
	GridLine3D(GraphObj *par, DataObj *d, int type, DWORD df);
	GridLine3D(int src);
	~GridLine3D();
	void DoPlot(anyOutput *o);
	void DoMark(anyOutput *o, bool mark);
	bool Command(int cmd, void *tmpl, anyOutput *o);
};

class GridRadial:public GridLine {
public:
	GridRadial(GraphObj *par, DataObj *d, int type, DWORD df);
	GridRadial(int src);
	~GridRadial();
	void DoPlot(anyOutput *o);
	void DoMark(anyOutput *o, bool mark);
	bool Command(int cmd, void *tmpl, anyOutput *o);
};

class Tick:public GraphObj{
public:
	Tick(GraphObj *par, DataObj *d, double val, DWORD Flags);
	Tick(int src);
	~Tick();
	double GetSize(int select);
	bool SetSize(int select, double value);
	bool SetColor(int select, DWORD col);
	void DoMark(anyOutput *o, bool mark);
	bool Command(int cmd, void *tmpl, anyOutput *o);
	bool PropertyDlg();
	bool FileIO(int rw);

	void DoPlot(double six, double csx, anyOutput *o);
	
private:
	double value, size, fix, fiy, fiz, lsi, lcsi, angle, lbx, lby;
	bool bModified;
	anyOutput *mo;
	RECT mrc;
	int gl_type;
	GridLine *Grid;
	Label *label;
	DWORD flags;
	POINT pts[2];
	line_segment *ls;
};

class Axis:public GraphObj{
public:
	AxisDEF *axis;
	LineDEF axline;

	Axis(GraphObj *par, DataObj *d, AxisDEF *ax, DWORD flags);
	Axis(int src);
	~Axis();
	double GetSize(int select);
	bool SetSize(int select, double value);
	DWORD GetColor(int select);
	bool SetColor(int select, DWORD col);
	void DoPlot(anyOutput *o);
	void DoMark(anyOutput *o, bool mark);
	bool Command(int cmd, void *tmpl, anyOutput *o);
	bool PropertyDlg();
	bool FileIO(int rw);

	AxisDEF *GetAxis() {return axis;};
	bool GetValuePos(double val, double *fix, double *fiy, double *fiz, anyOutput *o);
	void TickFile(char *name);
	void BreakSymbol(POINT3D *p1, double dsi, double dcsi, bool connect, anyOutput *o);
	void DrawBreaks(anyOutput *o);

private:
	double sizAxLine, sizAxTick, sizAxTickLabel;
	double si, csi;
	double brksymsize, brkgap, tick_angle;
	int brksym, nl_segs, gl_type, tick_type;
	bool bModified;
	DWORD colAxis;
	LineDEF GridLine;
	Tick **Ticks;
	GraphObj *axisLabel;
	long NumTicks;
	POINT pts[2];
	POINT3D pts3D[2];
	fPOINT3D flim[2];
	lfPOINT lbdist, tlbdist;
	TextDEF tlbdef;
	anyOutput *drawOut, *scaleOut;
	line_segment **l_segs;
	char *ssMATval, *ssMATlbl, *ssMITval; 
	anyOutput *mo;
	RECT mrc;

	void SetTick(long idx, double val, DWORD flags, char *txt);
	void CreateTicks();
	void ManuTicks(double sa, double st, int n, DWORD flags);
	void UpdateTicks();
	bool ssTicks();

};

class Plot3D:public Plot{
	typedef struct {
		double Zmin, Zmax;
		GraphObj *go;
		}obj_desc;
public:
	long nPlots, nAxes;
	Axis **Axes;
	GraphObj **plots;
	double *RotDef;

	Plot3D(GraphObj *par, DataObj *d, DWORD flags);
	Plot3D(int src);
	~Plot3D();
	double GetSize(int select);
	bool SetColor(int select, DWORD col);
	void DoPlot(anyOutput *o);
	void DoMark(anyOutput *o, bool mark);
	bool Command(int cmd, void *tmpl, anyOutput *o);
	bool PropertyDlg();
	bool FileIO(int rw);

	void * ObjThere(int x, int y);
	void Track(POINT *p, anyOutput *o);
	void CreateAxes();
	void DoAutoscale();
	void CalcRotation(double dx, double dy, anyOutput *o, bool accept);
	bool AcceptObj(GraphObj *go);
	void SortObj();
	bool Rotate(double dx, double dy, double dz, anyOutput *o, bool accept);

private:
	long nObs, nmaxObs;
	DWORD crea_flags;
	Drag3D *drag;
	fPOINT3D cub1, cub2, rotC, cu1, cu2, rc;
	obj_desc **dispObs;

	bool AddPlot(int family);
};

class Chart25D:public Plot3D {
public:
	Chart25D(GraphObj *par, DataObj *d, DWORD flags);
	~Chart25D();
	bool PropertyDlg();

private:
	fPOINT3D dspm;
};

class Ribbon25D:public Plot3D {
public:
	Ribbon25D(GraphObj *par, DataObj *d, DWORD flags);
	~Ribbon25D();
	bool PropertyDlg();

private:
	fPOINT3D dspm;
};

class BubblePlot3D:public Plot3D {
public:
	BubblePlot3D(GraphObj *par, DataObj *d);
	~BubblePlot3D();
	bool PropertyDlg();
};

class Graph:public GraphObj{
public:
	long NumPlots;
	int ToolMode, units, nscp;
	anyOutput *Disp, *CurrDisp;
	fRECT GRect, DRect, Bounds;
	bool OwnDisp, bModified;
	fRECT CurrRect;
	GraphObj **Plots;
	DWORD ColBG, ColAX;
	GraphObj **Sc_Plots;
	Axis **Axes;
	char *filename;

	Graph(GraphObj *par, DataObj *d, anyOutput *o);
	Graph(int src);
	~Graph();
	double GetSize(int select);
	bool SetSize(int select, double value);
	DWORD GetColor(int select);
	virtual void DoPlot(anyOutput *o);
	virtual bool Command(int cmd, void *tmpl, anyOutput *o);
	bool PropertyDlg();
	virtual bool FileIO(int rw);

private:
	int NumAxes, AxisTempl, tickstyle, zoom_level;
	RECT rcDim, rcUpd, rc_mrk;
	DWORD ColDR, ColGR, ColGRL;
	AxisDEF x_axis, y_axis;
	FrmRect *frm_g, *frm_d;
	bool dirty;
	POINT *tl_pts;
	long tl_nPts;
	ZoomDEF *zoom_def;

	bool AddPlot(int family);
	void DoAutoscale();
	void CreateAxes(int templ);
	bool ExecTool(MouseEvent *mev);
	bool Configure();
	bool AddAxis();
	bool MoveObj(int cmd, GraphObj *g); 
	bool DoZoom(char *z);
};

class Page:public Graph{
public:
	Page(GraphObj *par, DataObj *d);
	Page(int src);
	void DoPlot(anyOutput *o);
	bool Command(int cmd, void *tmpl, anyOutput *o);
	bool FileIO(int rw);

private:
	LineDEF LineDef;
	FillDEF FillDef;

	bool Configure();
};

class ObjTree:public GraphObj {
public:
	ObjTree(GraphObj *par, DataObj *d, GraphObj *root);
	~ObjTree();
	void DoPlot(anyOutput *o);
	bool Command(int cmd, void *tmpl, anyOutput *o);

	anyOutput *CreateBitmap(int *w, int *h, anyOutput *tmpl);
	int count_lines(){ return count;};
	char *get_name(int line);
	int get_vis(int line);
	bool set_vis(int line, bool vis);

private:
	GraphObj **list;
	int count, maxcount;
	TextDEF TextDef;
};

class notary{
public:
	notary();
	~notary();
	unsigned long RegisterGO(GraphObj *go);
	void AddRegGO(GraphObj *go);
	bool PushGO(unsigned long id, GraphObj *go);
	GraphObj *PopGO(unsigned long id);
	void FreeStack();

private:
	unsigned long NextPopGO, NextPushGO, NextRegGO;
	GraphObj ***gObs;
	GraphObj ***goStack;
};

class Default{
public:
	int dUnits, cUnits;
	char DecPoint[2], ColSep[2];
	char *svgAttr, *svgScript, *currPath, *IniFile;
	char *File1, *File2, *File3, *File4, *File5, *File6;
	double min4log;
	RECT clipRC;

	Default();
	~Default();
	void SetDisp(anyOutput *o);
	double GetSize(int select);
	DWORD Color(int select);
	LineDEF *GetLine();
	void SetLine(int u, LineDEF *l, int which);
	FillDEF *GetFill();
	void SetFill(int u, FillDEF *fd);
	LineDEF *GetOutLine();
	bool PropertyDlg();
	LineDEF *plLineDEF(LineDEF *ld);
	LineDEF *pgLineDEF(LineDEF *ol);
	FillDEF *pgFillDEF(FillDEF *fd);
	double rrectRad(double rad);
	void FileHistory(char *path);

private:
	LineDEF Line_0, Line_1, Line_2, *pl, *pgl;
	FillDEF Fill_0, Fill_1, Fill_2, *pg;
	LineDEF FillLine_0, FillLine_1, FillLine_2, *pg_fl;
	LineDEF OutLine_0, OutLine_1, OutLine_2;
	double *rrect_rad;
	anyOutput *cdisp;
	DWORD axis_color;
};

class DefsRW:public GraphObj{
public:
	DefsRW():GraphObj(0, 0){Id = 0; return;};
	DefsRW(int rw):GraphObj(0,0){FileIO(rw);Id=GO_DEFRW;return;};
	~DefsRW() {return;};
	bool FileIO(int rw);
};

class ReadCache{
public:
	unsigned char last, *Cache, Line[4096];
	int iFile, idx, max;
	bool eof;

	ReadCache();
	~ReadCache();
	virtual bool Open(char *name);
	virtual void Close();
	virtual unsigned char Getc();
	virtual unsigned char *GetField();
	void ReadLine(char *dest, int size);
	bool GetInt(long *in);
	bool GetFloat(double *fn);
	unsigned char Lastc();
	bool IsEOF();
};

class MemCache:public ReadCache{
public:
	MemCache(unsigned char *ptr);
	~MemCache();
	bool Open(char *name){return false;};
	void Close(){return;};
	unsigned char Getc();
	unsigned char *GetField();
};

#define UNDO_CONTINUE 0x01
#define UNDO_STORESET 0x1000
class UndoObj {
	enum {UNDO_UNDEFINED, UNDO_DEL_GO, UNDO_GOLIST, UNDO_DROPMEM,
		UNDO_VALDWORD, UNDO_VALINT, UNDO_OBJCONF, UNDO_OBJCONF_1,
		UNDO_LFP, UNDO_MOVE, UNDO_RECT, UNDO_STRING, UNDO_ROTDEF,
		UNDO_SETGO, UNDO_LINEDEF, UNDO_FILLDEF, UNDO_AXISDEF, 
		UNDO_LFP3D, UNDO_FLOAT, UNDO_MEM, UNDO_MUTATE, UNDO_DROPGOLIST,
		UNDO_TEXTDEF, UNDO_SAVVAR};
	typedef struct _UndoInfo {
		int cmd;
		DWORD flags;
		GraphObj *owner;
		void *data;
		void **loc;
		ZoomDEF zd;
		}UndoInfo;

	typedef struct _UndoList {
		void *array;
		void **loc_arr;
		long count, size;
		long *loc_count;
		}UndoList;

	typedef struct _UndoBuff {
		int count;
		UndoInfo **buff;
		anyOutput *disp;
		}UndoBuff;


public:
	int *pcb;

	UndoObj();
	~UndoObj();
	void Flush();
	void SetDisp(anyOutput *o);
	void InvalidGO(GraphObj *go);
	void Pop();
	void Restore(bool redraw, anyOutput *o);
	void ListGOmoved(GraphObj **oldlist, GraphObj **newlist, long size);
	void DeleteGO(GraphObj **go, DWORD flags, anyOutput *o);
	void MutateGO(GraphObj **old, GraphObj *repl, DWORD flags, anyOutput *o);
	void StoreListGO(GraphObj *parent, GraphObj ***go, long *count, DWORD flags);
	void DropListGO(GraphObj *parent, GraphObj ***go, long *count, DWORD flags);
	void DropMemory(GraphObj *parent, void **mem, DWORD flags);
	void SavVarBlock(GraphObj *parent, void **mem, DWORD flags);
	void ValDword(GraphObj *parent, DWORD *val, DWORD flags);
	void ValInt(GraphObj *parent, int *val, DWORD flags);
	void ObjConf(GraphObj *go, DWORD flags);
	int SaveLFP(GraphObj *go, lfPOINT *lfp, DWORD flags);
	void MoveObj(GraphObj *go, lfPOINT *lfp, DWORD flags);
	void ValRect(GraphObj *go, fRECT *rec, DWORD flags);
	void String(GraphObj *go, char **s, DWORD flags);
	void RotDef(GraphObj *go, double **d, DWORD flags);
	void SetGO(GraphObj *parent, GraphObj **where, GraphObj *go, DWORD flags);
	void Line(GraphObj *go, LineDEF *ld, DWORD flags);
	void Fill(GraphObj *go, FillDEF *fd, DWORD flags);
	void AxisDef(GraphObj *go, AxisDEF *ad, DWORD flags);
	void TextDef(GraphObj *go, TextDEF *td, DWORD flags);
	void ValLFP3D(GraphObj *go, fPOINT3D *lfp, DWORD flags);
	void ValFloat(GraphObj *parent, double *val, DWORD flags);
	void DataMem(GraphObj *go, void **mem, int size, long *count, DWORD flags);

private:
	UndoInfo **buff;
	int stub1, ndisp;
	anyOutput *cdisp;
	UndoBuff **buffers;

	int NewItem(int cmd, DWORD flags, GraphObj *owner, void *data, void **loc);
	void FreeInfo(UndoInfo** inf);
	void RestoreConf(UndoInfo *inf);
};

//prototypes: spreadwi.cpp
int ProcMemData(GraphObj *g, unsigned char *ptr, bool dispatch);
void SpreadMain(bool show);

//prototypes: WinSpec.cpp or QT_Spec.cpp
char *SaveDataAsName(char *oldname);
char *SaveGraphAsName(char *oldname);
char *OpenGraphName(char *oldname);
char *OpenDataName(char *oldname);
void InfoBox(char *Msg);
void ErrorBox(char *Msg);
bool YesNoBox(char *Msg);
void Qt_Box();
void HideTextCursor();
void HideTextCursorObj(anyOutput *out);
void ShowTextCursor(anyOutput *out, RECT *disp, DWORD color);
void HideCopyMark();
void ShowCopyMark(anyOutput *out, RECT *mrk, int nRec);
void InitTextCursor(bool init);
void EmptyClip();
void GetDesktopSize(int *width, int *height);
void FindBrowser();
void LoopDlgWnd();
void CloseDlgWnd(void *hDlg);
void ShowDlgWnd(void *hDlg);
anyOutput *NewDispClass(GraphObj *g);
bool DelDispClass(anyOutput *w);
anyOutput *NewBitmapClass(int w, int h, double hr, double vr);
bool DelBitmapClass(anyOutput *w);

//prototypes: FileIO.cpp
bool SaveGraphAs(GraphObj *g);
char *GraphToMem(GraphObj *g, long *size);
void UpdGOfromMem(GraphObj *go, unsigned char *buff);
bool OpenGraph(GraphObj *root, char *name, unsigned char *mem);
void SavVarInit();
void *SavVarFetch();

//prototypes:TheDialog.cpp
DWORD GetNewColor(DWORD oldcol);
bool ShowLayers(GraphObj *root);
void GetNewFill(FillDEF *oldfill);
void ShowBanner(bool show);
void RLPlotInfo();
bool DoSpShSize(DataObj *dt);
bool FillSsRange(DataObj *d, char **range);
bool GetCopyRange(RECT *rc, DataObj *d);
bool GetBitmapRes(double *res, double *width, double *height, char *header);
void OD_scheme(int, void *, RECT *, anyOutput *, void *, int);
FillDEF *GetSchemeFill(int *i);
void OD_linedef(int, void *, RECT *, anyOutput *o, void *, int);
void OD_filldef(int, void *, RECT *, anyOutput *o, void *, int);
void OD_paperdef(int, void *, RECT *, anyOutput *o, void *, int);
void FindPaper(double w, double h, double tol);
bool GetPaper(double *w, double *h);
void OD_axisplot(int, void *, RECT *, anyOutput *o, void *, int);

//prototypes: Utils.cpp
anyOutput *GetRectBitmap(RECT *rc, anyOutput *src);
void RestoreRectBitmap(anyOutput **pmo, RECT *mrc, anyOutput *o);
void NiceAxis(AxisDEF *axis, int nTick);
void NiceStep(AxisDEF *axis, int nTick);
double base4log(AxisDEF *axis, int direc);
double TransformValue(AxisDEF *axis, double val, bool transform);
void SortAxisBreaks(AxisDEF *axis);
double GetAxisFac(AxisDEF *axis, double delta, int direc);
void ReshapeFormula(char **text);
void ChangeChar(char *text, char c1, char c2);
char *Int2Nat(char *Text);
char *Nat2Int(char *Text);
void WriteNatFloatToBuff(char *buff, double val);
bool Txt2Flt(char *txt, double *val);
void RmTrail(char *txt);
double NiceValue(double fv);
char *Int2ColLabel(int nr, bool uc);
char *str2xml(char *str);
char **split(char *str, char sep, int *nl);
void SetMinMaxRect(RECT *rc, int x1, int y1, int x2, int y2);
void UpdateMinMaxRect(RECT *rc, int x, int y);
void IncrementMinMaxRect(RECT *rc, int i);
bool IsInRect(RECT *rc, int x, int y);
bool IsCloseToLine(POINT *p1, POINT *p2, int x, int y);
bool IsCloseToPL(POINT p, POINT *pts, int cp);
bool IsInPolygon(POINT *p, POINT *pts, int cp);
bool OverlapRect(RECT *rc1, RECT *rc2);
void AddToPolygon(long *cp, POINT *pts, POINT *np);
POINT *MakeArc(int ix, int iy, int r, int qad, long *npts);
void InvertPolygon(POINT*, int, LineDEF*, FillDEF*, RECT*, anyOutput*, bool);
void InvertLine(POINT*, int, LineDEF*, RECT*, anyOutput*, bool);
unsigned int ColDiff(DWORD col1, DWORD col2);
DWORD IpolCol(DWORD color1, DWORD color2, double fact);
double ran2(long *idum);
unsigned long isqr(unsigned long n);
bool MatMul(double a[3][3], double b[3][3], double c[3][3]);
char *GetNumFormat(double Magn);
void DeleteGO(GraphObj *go);
bool BackupFile(char *FileName);
bool IsRlpFile(char *FileName);
bool FileExist(char *FileName);
void *memdup(void *ptr, int cb_old, int cb_new);
double sininv(double val);
double trig2deg(double si, double csi);
bool ReplaceGO(GraphObj **oldobj, GraphObj **newobj);
unsigned int HashValue(unsigned char *str);
bool cmpLineDEF(LineDEF *l1, LineDEF *l2);
bool cmpFillDEF(FillDEF *f1, FillDEF *f2);
bool cmpAxisDEF(AxisDEF *a1, AxisDEF *a2);
bool cmpTextDEF(TextDEF *t1, TextDEF *t2);
DWORD CheckNewFloat(double *loc, double old_v, double new_v, GraphObj *par, DWORD flags);
DWORD CheckNewInt(int *loc, int old_v, int new_v, GraphObj *par, DWORD flags);
DWORD CheckNewDword(DWORD *loc, DWORD old_v, DWORD new_v, GraphObj *par, DWORD flags);
DWORD CheckNewLFPoint(lfPOINT *loc, lfPOINT *old_v, lfPOINT *new_v, GraphObj *par, DWORD flags);
void clip_line_sphere(GraphObj *par, POINT3D **li, int r, int cx, int cy, int cz);
void clip_line_plane(GraphObj *par, POINT3D **li, POINT3D *pg, int np, double *vec);
void clip_sphline_sphere(GraphObj *par, POINT3D *lim1, POINT3D *lim2, POINT3D *cent, 
	int r1, int r2, int cx, int cy, int cz);
void clip_sphline_plane(GraphObj *par, POINT3D *lim1, POINT3D *lim2, POINT3D *cent, 
	int r1, POINT3D *pg, int np, double *vec);
void clip_plane_plane(GraphObj *par, POINT3D *pg1, int n1, double *v1, POINT3D *pg2, 
	int n2, double *v2, POINT *m, int nm);

//prototypes Export.cpp
void DoExportWmf(GraphObj *g, char *FileName, float res, DWORD flags);
void DoExportSvg(GraphObj *g, char *FileName, DWORD flags);
void DoExportEps(GraphObj *g, char *FileName, DWORD flags);

//prototypes Output.cpp
void DoExportTif(GraphObj *g, char *FileName, DWORD flags);

//prototypes mfcalc.cpp
bool do_xyfunc(DataObj *, double, double, double, char *, lfPOINT **, long *, char *);
bool do_formula(DataObj *, char *, double *);
bool MoveFormula(DataObj *d, char *of, char *nf, int dx, int dy);
int do_fitfunc(DataObj *d, char *rx, char *ry, char *rz, char **par, char *expr, double conv, int maxiter);

//prototypes rlp_math.cp
double **dmatrix(int nrl, int nrh, int ncl, int nch);
void free_dmatrix(double **m, int nrl, int nrh, int ncl, int);
bool mrqmin(double *, double *, double *, int, double **, int, int *, int, double **, double **, double *,
	void (*funcs)(double, double **, double *, double *, int), double *);
bool Check_MRQerror();
