//vio_stream.c:

/*
 *      Copyright (C) Philipp 'ph3-der-loewe' Schafft - 2010-2011
 *
 *  This file is part of libroar a part of RoarAudio,
 *  a cross-platform sound system for both, home and professional use.
 *  See README for details.
 *
 *  This file is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 3
 *  as published by the Free Software Foundation.
 *
 *  libroar is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 *
 *  NOTE for everyone want's to change something and send patches:
 *  read README and HACKING! There a addition information on
 *  the license of this document you need to read before you send
 *  any patches.
 *
 *  NOTE for uses of non-GPL (LGPL,...) software using libesd, libartsc
 *  or libpulse*:
 *  The libs libroaresd, libroararts and libroarpulse link this lib
 *  and are therefore GPL. Because of this it may be illigal to use
 *  them with any software that uses libesd, libartsc or libpulse*.
 */

#include "libroar.h"

static ssize_t _vio_stream_read    (struct roar_vio_calls * vio, void *buf, size_t count) {
 return roar_vio_read(roar_get_connection_vio2(vio->inst), buf, count);
}

static ssize_t _vio_stream_write   (struct roar_vio_calls * vio, void *buf, size_t count) {
 return roar_vio_write(roar_get_connection_vio2(vio->inst), buf, count);
}

static off_t   _vio_stream_lseek   (struct roar_vio_calls * vio, off_t offset, int whence) {
 return roar_vio_lseek(roar_get_connection_vio2(vio->inst), offset, whence);
}
static int     _vio_stream_nonblock(struct roar_vio_calls * vio, int state) {
 return roar_vio_nonblock(roar_get_connection_vio2(vio->inst), state);
}
static int     _vio_stream_sync    (struct roar_vio_calls * vio) {
 return roar_vio_sync(roar_get_connection_vio2(vio->inst));
}
static int     _vio_stream_ctl     (struct roar_vio_calls * vio, int cmd, void * data) {
 if (vio == NULL) {
  roar_err_set(ROAR_ERROR_FAULT);
  return -1;
 }

 if (cmd == -1) {
  roar_err_set(ROAR_ERROR_INVAL);
  return -1;
 }

 switch (cmd) {
  case ROAR_VIO_CTL_GET_NAME:
    if ( data == NULL ) {
     roar_err_set(ROAR_ERROR_FAULT);
     return -1;
    }

    *(char**)data = "stream";
    return 0;
   break;
  case ROAR_VIO_CTL_GET_NEXT:
    *(struct roar_vio_calls **)data = roar_get_connection_vio2(vio->inst);
    return 0;
   break;
  case ROAR_VIO_CTL_SET_NEXT:
    roar_err_set(ROAR_ERROR_NOTSUP);
    return -1;
   break;
 }

 return roar_vio_ctl(roar_get_connection_vio2(vio->inst), cmd, data);
}

static int     _vio_stream_close   (struct roar_vio_calls * vio) {
 roar_vio_close(roar_get_connection_vio2(vio->inst));
 roar_mm_free(vio->inst);

 return 0;
}

int     roar_vio_simple_stream (struct roar_vio_calls * calls, int rate, int channels, int bits, int codec,
                                                               const char * server, int dir, const char * name) {
 struct roar_connection * con = NULL;
 struct roar_stream       stream;
 int err;

 if ( calls == NULL ) {
  roar_err_set(ROAR_ERROR_FAULT);
  return -1;
 }

 if ( roar_stream_new(&stream, rate, channels, bits, codec) == -1 )
  return -1;

 con = roar_mm_malloc(sizeof(struct roar_connection));
 if ( con == NULL )
  return -1;

 memset(con, 0, sizeof(struct roar_connection));

 if ( roar_simple_connect(con, server, name) == -1 ) {
  err = roar_error;
  roar_mm_free(con);
  roar_error = err;
  return -1;
 }

 if ( roar_stream_connect2(con, &stream, dir, -1) == -1 ) {
  err = roar_error;
  roar_disconnect(con);
  roar_mm_free(con);
  roar_error = err;
  return -1;
 }

 if ( roar_stream_exec(con, &stream) == -1 ) {
  err = roar_error;
  roar_disconnect(con);
  roar_mm_free(con);
  roar_error = err;
  return -1;
 }

 roar_vio_clear_calls(calls);

 calls->inst       = con;
 calls->read       = _vio_stream_read;
 calls->write      = _vio_stream_write;
 calls->lseek      = _vio_stream_lseek;
 calls->nonblock   = _vio_stream_nonblock;
 calls->sync       = _vio_stream_sync;
 calls->ctl        = _vio_stream_ctl;
 calls->close      = _vio_stream_close;

 if ( dir == ROAR_DIR_PLAY ) {
  roar_vio_shutdown(calls, SHUT_RD);
 } else if ( dir == ROAR_DIR_MONITOR || dir == ROAR_DIR_RECORD ) {
  roar_vio_shutdown(calls, SHUT_WR);
 }

 return 0;
}

int     roar_vio_simple_new_stream_obj (struct roar_vio_calls * calls,
                                        struct roar_connection * con,
                                        struct roar_stream * s,
                                        int rate, int channels, int bits, int codec, int dir) {
 struct roar_stream stream;
 int fh;

 ROAR_DBG("roar_vio_simple_new_stream_obj(*) = ?");

 if ( calls == NULL ) {
  roar_err_set(ROAR_ERROR_FAULT);
  return -1;
 }

 if ( s == NULL )
  s = &stream;

 roar_libroar_nowarn();
 if ( (fh = roar_simple_new_stream_obj(con, s, rate, channels, bits, codec, dir)) == -1 ) {
  roar_libroar_warn();
  ROAR_DBG("roar_vio_simple_new_stream_obj(*) = -1");
  return -1;
 }
 roar_libroar_warn();

 ROAR_DBG("roar_vio_simple_new_stream_obj(*): fh=%i", fh);

 return roar_vio_open_fh_socket(calls, fh);
}

//ll
