//error.c:

/*
 *      Copyright (C) Philipp 'ph3-der-loewe' Schafft - 2010-2011
 *  The code (may) include prototypes and comments (and maybe
 *  other code fragements) from libpulse*. They are mostly copyrighted by:
 *  Lennart Poettering <poettering@users.sourceforge.net> and
 *  Pierre Ossman <drzeus@drzeus.cx>
 *
 *  This file is part of libroarpulse a part of RoarAudio,
 *  a cross-platform sound system for both, home and professional use.
 *  See README for details.
 *
 *  This file is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 3
 *  as published by the Free Software Foundation.
 *
 *  RoarAudio is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 *
 *  NOTE for everyone want's to change something and send patches:
 *  read README and HACKING! There a addition information on
 *  the license of this document you need to read before you send
 *  any patches.
 *
 *  NOTE for uses of non-GPL (LGPL,...) software using libesd, libartsc
 *  or libpulse*:
 *  The libs libroaresd, libroararts and libroarpulse link this libroar
 *  and are therefore GPL. Because of this it may be illigal to use
 *  them with any software that uses libesd, libartsc or libpulse*.
 */

#include <libroarpulse/libroarpulse.h>


static const struct {
 int error;
 int ra_error;
 const char * name;
} _roar_pa_errors[] = {
 {PA_OK,                       ROAR_ERROR_NONE,   "OK"                             },
 {PA_ERR_ACCESS,               ROAR_ERROR_PERM,   "Access denied"                  },
 {PA_ERR_COMMAND,              ROAR_ERROR_BADRQC, "Unknown command"                },
 {PA_ERR_INVALID,              ROAR_ERROR_INVAL,  "Invalid argument"               },
 {PA_ERR_EXIST,                ROAR_ERROR_EXIST,  "Entity exists"                  },
 {PA_ERR_NOENTITY,             ROAR_ERROR_NOENT,  "No such entity"                 },
 {PA_ERR_CONNECTIONREFUSED,    ROAR_ERROR_CONNREFUSED, "Connection refused"             },
 {PA_ERR_PROTOCOL,             ROAR_ERROR_PROTO,  "Protocol error"                 },
 {PA_ERR_TIMEOUT,              ROAR_ERROR_TIMEDOUT, "Timeout"                        },
 {PA_ERR_AUTHKEY,              ROAR_ERROR_PERM,   "No authorization key"           },
 {PA_ERR_INTERNAL,             ROAR_ERROR_UNKNOWN, "Internal error"                 },
 {PA_ERR_CONNECTIONTERMINATED, ROAR_ERROR_IO,     "Connection terminated"          },
 {PA_ERR_KILLED,               ROAR_ERROR_IO,     "Entity killed"                  },
 {PA_ERR_INVALIDSERVER,        ROAR_ERROR_INVAL,  "Invalid server"                 },
 {PA_ERR_MODINITFAILED,        ROAR_ERROR_BADLIB, "Module initalization failed"    },
 {PA_ERR_BADSTATE,             ROAR_ERROR_INVAL,  "Bad state"                      },
 {PA_ERR_NODATA,               ROAR_ERROR_NODATA, "No data"                        },
 {PA_ERR_VERSION,              ROAR_ERROR_NSVERSION, "Incompatible protocol version"  },
 {PA_ERR_TOOLARGE,             ROAR_ERROR_RANGE,  "Too large"                      },
#ifdef PA_ERR_NOTSUPPORTED
 {PA_ERR_NOTSUPPORTED,         ROAR_ERROR_NOTSUP, "Not supported"},
#endif
#ifdef PA_ERR_UNKNOWN
 {PA_ERR_UNKNOWN,              ROAR_ERROR_UNKNOWN, "Unknown error code"},
#endif
#ifdef PA_ERR_NOEXTENSION
 {PA_ERR_UNKNOWN,              ROAR_ERROR_NOENT,  "No such extension"},
#endif
#ifdef PA_ERR_OBSOLETE
 {PA_ERR_OBSOLETE,             ROAR_ERROR_NOSYS,  "Obsolete functionality"},
#endif
#ifdef PA_ERR_NOTIMPLEMENTED
 {PA_ERR_NOTIMPLEMENTED,       ROAR_ERROR_NOSYS,  "Missing implementation"},
#endif
#ifdef PA_ERR_FORKED
 {PA_ERR_FORKED,               ROAR_ERROR_INVAL,  "Client forked"},
#endif
#ifdef PA_ERR_IO
 {PA_ERR_IO,                   ROAR_ERROR_IO,     "Input/Output error"},
#endif
#ifdef PA_ERR_BUSY
 {PA_ERR_BUSY,                 ROAR_ERROR_BUSY,   "Device or resource busy"},
#endif
 {PA_ERR_MAX,                  ROAR_ERROR_UNKNOWN, "MAX"                            },
 {-1, ROAR_ERROR_UNKNOWN, NULL}
};

const char * pa_strerror(int error) {
 int i;

 for (i = 0; _roar_pa_errors[i].name != NULL; i++)
  if ( _roar_pa_errors[i].error == error )
   return _roar_pa_errors[i].name;

 return NULL;
}

int roar_pa_raerror2paerror(int error) {
 int i;

 for (i = 0; _roar_pa_errors[i].name != NULL; i++)
  if ( _roar_pa_errors[i].ra_error == error )
   return _roar_pa_errors[i].error;

 return PA_ERR_INVALID;
}

//ll
