# Common:
COMMON_V_MAJOR  = 1
COMMON_V_MINOR  = 0
COMMON_V_REV    = 9
COMMON_V_MM     = $(COMMON_V_MAJOR).$(COMMON_V_MINOR)
COMMON_VERSION  = $(COMMON_V_MM).$(COMMON_V_REV)
COMMON_SOVERSION= 2

# libroar:
LIBROAR_V       = $(COMMON_SOVERSION)
NETLIBS         = $(lib_dnet) $(lib_wsock32) $(lib_ws2_32)
AUXLIBS         = $(lib_slp) $(lib_ssl) $(lib_gcrypt) $(lib_sendfile) $(lib_dl) $(lib_x11) $(lib_z)
LIBROAR_NS      = $(AUXLIBS) $(NETLIBS)

# libroardsp:
LIBROARDSP_V    = $(COMMON_SOVERSION)
DSP_CODECLIBS   = $(lib_celt) $(lib_celt0) $(lib_speex) $(lib_speexdsp)
DSP_AUXLIBS     = $(lib_samplerate)
LIBROARDSP_NS   = $(DSP_CODECLIBS) $(DSP_AUXLIBS) $(LIBROAR) $(lib_m)

# libroarmidi:
LIBROARMIDI_V   = $(COMMON_SOVERSION)
LIBROARMIDI_NS  = $(LIBROARDSP)

# libroarlight:
LIBROARLIGHT_V  = $(COMMON_SOVERSION)
LIBROARLIGHT_NS = $(LIBROAR) $(lib_m)

# libroareio:
LIBROAREIO_V    = $(COMMON_SOVERSION)
EIO_CDRIVERLIBS = $(lib_ossaudio)
LIBROAREIO_NS   = $(EIO_CDRIVERLIBS) $(LIBROAR)

# Linker Deps:
ifeq ($(LINK_DEPS),indirect)
LIBROAR         = -lroar
LIBROARDSP      = -lroardsp
LIBROARMIDI     = -lroarmidi
LIBROARLIGHT    = -lroarlight
LIBROAREIO      = -lroareio
else #LINK_DEPS=full
LIBROAR         = -lroar $(LIBROAR_NS)
LIBROARDSP      = -lroardsp $(LIBROARDSP_NS)
LIBROARMIDI     = -lroarmidi $(LIBROARMIDI_NS)
LIBROARLIGHT    = -lroarlight $(LIBROARLIGHT_NS)
LIBROAREIO      = -lroareio $(LIBROAREIO_NS)
endif

#ll
