//dtmf.h:

/*
 *      Copyright (C) Philipp 'ph3-der-loewe' Schafft - 2012-2013
 *
 *  This file is part of libroar a part of RoarAudio,
 *  a cross-platform sound system for both, home and professional use.
 *  See README for details.
 *
 *  This file is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 3
 *  as published by the Free Software Foundation.
 *
 *  libroar is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 *
 *  NOTE for everyone want's to change something and send patches:
 *  read README and HACKING! There a addition information on
 *  the license of this document you need to read before you send
 *  any patches.
 *
 *  NOTE for uses of non-GPL (LGPL,...) software using libesd, libartsc
 *  or libpulse*:
 *  The libs libroaresd, libroararts and libroarpulse link this lib
 *  and are therefore GPL. Because of this it may be illigal to use
 *  them with any software that uses libesd, libartsc or libpulse*.
 */

#ifndef _LIBROARDSP_DTMF_H_
#define _LIBROARDSP_DTMF_H_

#include "libroardsp.h"

#define ROAR_DTMF_OPTIONS_NONE 0

#define ROAR_DTMF_CHAR_DTMF(x) (((x) & 0x00FF) + 0x0000)
#define ROAR_DTMF_CHAR_ROAR(x) (((x) & 0x00FF) + 0x0100)
#define ROAR_DTMF_CHAR_BYTE(x) (((x) & 0x00FF) + 0x0200)

#define ROAR_DTMF_CHAR_BREAK   ((uint16_t)0)
#define ROAR_DTMF_CHAR_NOOP    ROAR_DTMF_CHAR_ROAR(0)
#define ROAR_DTMF_CHAR_ESCAPE  ROAR_DTMF_CHAR_ROAR(27)

ssize_t roar_dtmf_mus2samples(const int_least32_t t, const uint32_t rate);

int roar_dtmf_break(int16_t * samples, const size_t len, const uint32_t rate, const int options);
int roar_dtmf_tone (int16_t * samples, const size_t len, const uint32_t rate, const int options, const uint16_t c);

uint16_t roar_dtmf_freqs2char(const int options, float f0, float f1);

#endif

//ll
