//proto_simple.h:

/*
 *      Copyright (C) Philipp 'ph3-der-loewe' Schafft - 2009-2010
 *
 *  This file is part of RoarAudio PlayList Daemon,
 *  a playlist management daemon for RoarAudio.
 *  See README for details.
 *
 *  This file is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 3
 *  as published by the Free Software Foundation.
 *
 *  RoarAudio is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef _RPLD_PROTO_SIMPLE_H_
#define _RPLD_PROTO_SIMPLE_H_

#define PROTO_SIMPLE_STATUS_UNKNOWN -1
#define PROTO_SIMPLE_STATUS_OK       0
#define PROTO_SIMPLE_STATUS_ERROR    1
#define PROTO_SIMPLE_STATUS_INPROC   2
#define PROTO_SIMPLE_STATUS_YES      3
#define PROTO_SIMPLE_STATUS_NO       4
#define PROTO_SIMPLE_STATUS_PROERR   5 /* protocol error */
#define PROTO_SIMPLE_STATUS_GOODBYE  6 /* on quit */
#define PROTO_SIMPLE_STATUS_NOTPERM  7 /* not permitted */

int proto_simple_client_handle(int id);
int proto_simple_parse(int client, char * line, size_t len);
int proto_simple_parse_plent(struct rpld_playlist_entry ** plent, char * txt);
int proto_simple_print_plent(int client, struct rpld_playlist_entry * plent);

struct rpld_playlist * proto_simple_parse_pli(char * txt);

int proto_simple_print_playlist (int client, struct rpld_playlist * pl);

int    proto_simple_parse_ple_bopts_noeval(int client, char * txt, int need_prev,
                                           int * try_any, struct rpld_playlist ** pl,
                                           struct rpld_playlist_search * pls);
struct rpld_playlist_entry * proto_simple_parse_ple_bopts_eval(int try_any,
                                                               struct rpld_playlist * pl,
                                                               struct rpld_playlist_search * pls);
struct rpld_playlist_entry * proto_simple_parse_ple_bopts(int client, char * txt, int need_prev);

int proto_simple_import_export (int client, char * args, int is_export);

int proto_simple_showvolume (int client);
int proto_simple_showplaying (int client);

int proto_simple_setpointer(int client, char * args);
int proto_simple_showpointer(int client, char * name, struct rpld_playlist_pointer * pointer);

#endif

//ll
