
/* -*- c-basic-offset: 4 indent-tabs-mode: nil -*- vi:set ts=8 sts=4 sw=4: */

/*
    Rosegarden
    A MIDI and audio sequencer and musical notation editor.
    Copyright 2000-2008 the Rosegarden development team.

    Other copyrights also apply to some parts of this work.  Please
    see the AUTHORS file and individual file headers for details.

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of the
    License, or (at your option) any later version.  See the file
    COPYING included with this distribution for more information.
*/

#ifndef _RG_MATRIXERASER_H_
#define _RG_MATRIXERASER_H_

#include "MatrixTool.h"
#include <qstring.h>

class QMouseEvent;


namespace Rosegarden
{

class ViewElement;
class MatrixView;
class MatrixStaff;


class MatrixEraser : public MatrixTool
{
    friend class MatrixToolBox;

public:

    virtual void handleLeftButtonPress(timeT,
                                       int height,
                                       int staffNo,
                                       QMouseEvent *event,
                                       ViewElement*);

    static const QString ToolName;

    virtual void ready();

protected:
    MatrixEraser(MatrixView*);

    void setBasicContextHelp();

    MatrixStaff* m_currentStaff;
};

}

#endif
