<?php

/*
 +-----------------------------------------------------------------------+
 | Main configuration file                                               |
 |                                                                       |
 | This file is part of the RoundCube Webmail client                     |
 | Copyright (C) 2005, RoundCube Dev. - Switzerland                      |
 | Licensed under the GNU GPL                                            |
 |                                                                       |
 +-----------------------------------------------------------------------+

*/

$rcmail_config = array();


// system error reporting: 1 = log; 2 = report (not implemented yet), 4 = show, 8 = trace
$rcmail_config['debug_level'] = 5;

// enable caching of messages and mailbox data in the local database.
// this is recommended if the IMAP server does not run on the same machine
$rcmail_config['enable_caching'] = TRUE;

// automatically create a new RoundCube user when log-in the first time.
// a new user will be created once the IMAP login succeeded.
// set to false if only registered users can use this service
$rcmail_config['auto_create_user'] = TRUE;

// the mail host chosen to perform the log-in
// leave blank to show a textbox at login, give a list of hosts
// to display a pulldown menu or set one host as string.
// To use SSL connection, enter ssl://hostname:993
$rcmail_config['default_host'] = '';

// TCP port used for IMAP connections
$rcmail_config['default_port'] = 143;

// use this host for sending mails.
// if left blank, the PHP mail() function is used
$rcmail_config['smtp_server'] = '';

// SMTP port (default is 25)
$rcmail_config['smtp_port'] = 25;

// SMTP username (if required) if you use %u as the username RoundCube
// will use the current username for login
$rcmail_config['smtp_user'] = '';

// SMTP password (if required) if you use %p as the password RoundCube
// will use the current user's password for login
$rcmail_config['smtp_pass'] = '';

// SMTP AUTH type (DIGEST-MD5, CRAM-MD5, LOGIN, PLAIN or empty to use
// best server supported one)
$rcmail_config['smtp_auth_type'] = '';

// Log sent messages
$rcmail_config['smtp_log'] = TRUE;

// these cols are shown in the message list
// available cols are: subject, from, to, cc, replyto, date, size, encoding
$rcmail_config['list_cols'] = array('subject', 'from', 'date', 'size');

// relative path to the skin folder
$rcmail_config['skin_path'] = 'skins/default/';

// use this folder to store temp files (must be writebale for apache user)
$rcmail_config['temp_dir'] = 'temp/';

// session lifetime in minutes
$rcmail_config['session_lifetime'] = 10;

// check client IP in session athorization
$rcmail_config['ip_check'] = TRUE;

// not shure what this was good for :-) 
$rcmail_config['locale_string'] = 'de_DE';

// use this format for short date display
$rcmail_config['date_short'] = 'D H:i';

// use this format for detailed date/time formatting
$rcmail_config['date_long'] = 'd.m.Y H:i';

// add this user-agent to message headers when sending
$rcmail_config['useragent'] = 'RoundCube Webmail/0.1-20051021';

// only list folders within this path
$rcmail_config['imap_root'] = '';

// store sent message is this mailbox
// leave blank if sent messages should not be stored
$rcmail_config['sent_mbox'] = 'Sent';

// move messages to this folder when deleting them
// leave blank if they should be deleted directly
$rcmail_config['trash_mbox'] = 'Trash';

// display these folders separately in the mailbox list
$rcmail_config['default_imap_folders'] = array('INBOX', 'Drafts', 'Sent', 'Junk', 'Trash');


/***** these settings can be overwritten by user's preferences *****/

// show up to X items in list view
$rcmail_config['pagesize'] = 40;

// use this timezone to display date/time
$rcmail_config['timezone'] = 1;

// prefer displaying HTML messages
$rcmail_config['prefer_html'] = TRUE;

// show pretty dates as standard
$rcmail_config['prettydate'] = TRUE;


// end of config file
?>
