/*************************************************
*     rpld - an IBM style RIPL server            *
*************************************************/

/* Copyright (c) 1999,2000,2001 James McKenzie.
 *                      All rights reserved
 * Copyright (c) 1998,2000,2001 Christopher Lightfoot.
 *                      All rights reserved
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENCE file which can be found at the top level of
 * the rpld distribution.
 *
 * IBM is a trademark of IBM corp.
 *
 */


static char rcsid[] = "$Id: llc-nit.c,v 1.8 2001/11/01 15:30:29 root Exp $";

/*
 * $Log: llc-nit.c,v $
 * Revision 1.8  2001/11/01 15:30:29  root
 * #
 *
 * Revision 1.7  2001/11/01 15:28:23  root
 * #
 *
 * Revision 1.6  2001/11/01 15:26:45  root
 * #
 *
 * Revision 1.5  2001/11/01 15:26:29  root
 * #
 *
 * Revision 1.4  2001/11/01 15:23:59  root
 * #
 *
 * Revision 1.3  2000/09/26 04:06:07  root
 * #
 *
 * Revision 1.2  2000/09/26 03:48:23  root
 * #
 *
 * Revision 1.1  2000/09/26 03:44:29  root
 * #
 *
 * Revision 1.10  2000/07/17 11:59:45  root
 * #
 *
 * Revision 1.9  2000/07/17 10:43:34  root
 * #
 *
 * Revision 1.8  2000/07/16 14:05:28  root
 * #
 *
 * Revision 1.7  2000/07/16 13:18:10  root
 * #
 *
 * Revision 1.1  2000/07/16 13:16:33  root
 * #
 *
 * Revision 1.6  1999/09/13 11:17:35  root
 * \#
 *
 * Revision 1.5  1999/09/13 11:05:27  root
 * \#
 *
 * Revision 1.4  1999/09/13 11:04:13  root
 * \#
 *
 */



#include "project.h"

#include "llc.h"
#include "nit.h"

#define LLC_HDR_LEN 3

#define LLC_UIC     0x3

/* The LLC-1 headers as it comes off the wire */
struct llchdr
{
  unsigned char h_dsap;
  unsigned char h_ssap;
  unsigned char h_flags;
};

struct llcdrv_nit
{
  LLCDRV;
  struct nit *n;
  int sap;
};

#ifdef DEBUG
static void
hexdump (char *p, unsigned char *buf, int l)
{
  int i;

  for (i = 0; i < l; ++i)
    {
      if ((i % 16) == 0)
        {
          printf ("%s: ", p);
        }
      printf ("%02x ", buf[i]);
      if ((i % 16) == 15)
        {
          printf ("\n");
        }
    }

  printf ("\n");


}

#endif

static int
llc_nit_send (struct llcdrv *llc, unsigned char *dmac, unsigned char dsap,
              unsigned char *buf, int len)
{
  struct llcdrv_nit *llc_nit = (struct llcdrv_nit *) llc;

  unsigned char mybuf[MAX_FRAME_LEN];
  struct llchdr *h = (struct llchdr *) mybuf;
  int llclen;

#ifdef DEBUG
  printf ("Got %d bytes from upper layer\n", len);
//  hexdump("write",buf,len);
#endif

/*
  bcopy (dmac, h->h_dest, ETH_ALEN);
  bcopy (nit_mac(llc_nit->n), h->h_source, ETH_ALEN);

  h->h_len = htons (len + LLC_SAP_LEN);
*/


  h->h_ssap = llc_nit->sap;
  h->h_dsap = dsap;
  h->h_flags = LLC_UIC;

  bcopy (buf, mybuf + LLC_HDR_LEN, len);

  llclen = len + LLC_HDR_LEN;
  if (nit_send (llc_nit->n, mybuf, llclen, dmac) == llclen)
    {
      return len;
    }

  return -1;
}


static int
llc_nit_recv (struct llcdrv *llc, unsigned char *buf, int blen,
              unsigned char *smac, unsigned char *ssap, struct timeval *tv)
{
  struct llcdrv_nit *llc_nit = (struct llcdrv_nit *) llc;

  unsigned char mybuf[MAX_FRAME_LEN + 20];
  unsigned char *myptr = &mybuf[20];
#define       mylen (MAX_FRAME_LEN-20)

  struct llchdr *h = (struct llchdr *) myptr;

  int llclen;
  int len;

  do
    {
      do
        {
          len = nit_recv (llc_nit->n, myptr, mylen, smac, tv);
          if (len <= 0)
            {
              return len;
            }
        }
      while ((len <= LLC_HDR_LEN) || (len > MAX_FRAME_LEN));

      llclen = len;

#ifdef DEBUG
      if (smac)
        printf ("llc-nit-recv: source: %s ", ethtoa (smac));
      printf ("len: 0x%04x ", llclen);
      printf ("dsap:%02x ssap:%02x flags:%02x \n", h->h_dsap, h->h_ssap,
              h->h_flags);
#endif

    }
  while (h->h_dsap != llc_nit->sap);
#ifdef DEBUG
  hexdump ("read", myptr, len);
#endif

  if (ssap)
    *ssap = h->h_ssap;

  llclen -= LLC_HDR_LEN;

  bcopy (myptr + LLC_HDR_LEN, buf, llclen);

#ifdef DEBUG
  printf ("Returning %d bytes to upper layer\n", llclen);
  hexdump ("read", buf, llclen);
#endif



  return llclen;

}

static int
llc_nit_add_multicast (struct llcdrv *llc, unsigned char *mac)
{
  struct llcdrv_nit *llc_nit = (struct llcdrv_nit *) llc;

  return nit_multicast (llc_nit->n, mac);
}

static unsigned char *
llc_nit_mac (struct llcdrv *llc)
{
  struct llcdrv_nit *llc_nit = (struct llcdrv_nit *) llc;
  return nit_mac (llc_nit->n);
}

static void
llc_nit_close (struct llcdrv *llc)
{
  struct llcdrv_nit *llc_nit = (struct llcdrv_nit *) llc;
  nit_close (llc_nit->n);
  free (llc_nit);
}

struct llcdrv *
llc_open (unsigned char sap, char *name)
{
  struct llcdrv_nit *llc;

  syslog (LOG_ERR, "RPLD LLC 802.2 over NIT support %s", rcsid);

  llc = malloc (sizeof (struct llcdrv_nit));
  bzero (llc, sizeof (struct llcdrv_nit));

  llc->n = nit_open (name);

  if (!llc->n)
    {
      free (llc);
      return NULL;
    }

  llc->sap = sap;

  llc->recv = llc_nit_recv;
  llc->send = llc_nit_send;
  llc->mac = llc_nit_mac;
  llc->add_multicast = llc_nit_add_multicast;
  llc->close = llc_nit_close;


  return (struct llcdrv *) llc;
}
