/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *
 *  Public API for calling R.
 *
 *  $Id: RPy.h,v 1.15 2005/07/19 20:39:43 warnes Exp $
 *
 */

#ifndef _RPY_H
#define _RPY_H

#ifdef _WIN32
#undef ERROR   /* nameclash with Rext/RS.h */
#include <windows.h>
#undef ERROR
#endif /*_WIN32*/

#include <R.h>
#include <Rdefines.h>
#include <Rinternals.h>
#include <Rversion.h>
#undef _POSIX_C_SOURCE
#include <Python.h>
#include <R_ext/Rdynload.h>
#include <R_ext/eventloop.h>

#ifdef _WIN32
#define Win32  /* needed to get definition for UIMode */
#include <Rinterface.h>
#undef Win32
#include <Graphics.h>
#else
#include <Rinterface.h>
#endif 

#include <Rdevices.h> /* must follow Graphics.h */


/* Missing definitions from Rinterface.h or RStartup.h */
# define CleanEd		Rf_CleanEd
extern void CleanEd(void);
extern int	R_CollectWarnings; 
# define PrintWarnings		Rf_PrintWarnings
extern void PrintWarnings(void);
/****/

#include <signal.h>

#include "robjobject.h"
#include "setenv.h"

#ifdef WITH_NUMERIC
#include "Numeric/arrayobject.h"
#endif

#define MAXIDSIZE 256

/* Conversion */
SEXP to_Robj(PyObject *);
PyObject *to_Pyobj(SEXP);
PyObject *to_Pyobj_table(SEXP);
PyObject *to_Pyobj_with_mode(SEXP, int);

#define NO_CONVERSION 0
#define VECTOR_CONVERSION 1
#define BASIC_CONVERSION 2
#define CLASS_CONVERSION 3
#define PROC_CONVERSION 4

#define TOP_MODE 4

/* R Evaluation */
SEXP do_eval_expr(SEXP e);
SEXP do_eval_fun(char *);
SEXP get_from_name(char *);

/* A new exception */
extern PyObject *RPyExc_Exception;

char *get_last_error_msg(void);

/* For initializing R */
extern int Rf_initEmbeddedR(int argc, char *argv[]);
extern void init_io_routines(void);

/* I/O functions */
//#ifdef _WIN32
//__declspec(dllimport) FILE *R_Outputfile;
//#else
extern FILE *R_Outputfile;
//#endif

#ifdef _WIN32
extern void RPy_WriteConsole(char *, int);
extern int  RPy_ReadConsole(char *, char *, int, int);
#endif

extern void (*ptr_R_WriteConsole)(char *, int);
extern int (*ptr_R_ReadConsole)(char *, unsigned char *, int, int);
extern int (*ptr_R_ShowFiles)(int, char **, char **, char *, int, char *);

#ifdef _WIN32
extern void R_WriteConsole(char *, int);
extern int  R_ReadConsole(char *, unsigned char *, int, int);
extern void R_ProcessEvents(void);
extern char *getDLLVersion();
extern void R_DefParams(Rstart);
extern void R_SetParams(Rstart);
extern void setup_term_ui(void);
extern char *getRHOME(void);
__declspec(dllimport) int UserBreak;
#endif

/* Setters for io functions */
PyObject *set_output(PyObject *self, PyObject *args);
PyObject *set_input(PyObject *self, PyObject *args);
PyObject *set_showfiles(PyObject *self, PyObject *args);
PyObject *get_output(PyObject *self, PyObject *args);
PyObject *get_input(PyObject *self, PyObject *args);
PyObject *get_showfiles(PyObject *self, PyObject *args);

/* Interrupt the R interpreter */
void interrupt_R(int);

/* The Python original SIGINT handler */
extern PyOS_sighandler_t python_sigint;

/* R function for jumping to toplevel context */
extern void jump_now(void);

/* Global interpreter */
extern PyInterpreterState *my_interp;

/* Signal whether R is running interactively */
extern int R_interact;

/* RPy namespace */
extern PyObject *rpy;

extern PyObject *rpy_dict;

/* Pause/continue the event loop */
void stop_events(void);
void start_events(void);


/* Translation functions */
extern int to_Pyobj_proc(SEXP robj, PyObject **obj);
extern int to_Pyobj_class(SEXP robj, PyObject **obj);
extern int to_Pyobj_basic(SEXP robj, PyObject **obj);
extern int to_Pyobj_vector(SEXP robj, PyObject **obj, int mode);



#endif /* _RPY_H */
