REM
REM batch file to generate RPy installation file using MingGW
REM
REM Usage: 
REM   buildrpy python24 rpy-0.4.2.1 rw2010 R-2.1.0
REM
REM I assume that  (%3 is the third argument, and so on)
REM   1. R is installed in c:\progra~1\R\%3 
REM   2. python is installed in c:\%1
REM   3. rpy is installed in c:\%2
REM   4. there is a folder %2\%4  (c:\rpy-0.4.2.1\R-2.1.0
REM   5. MinGW is in c:\mingw\bin, pexports is also in this
REM      directory

echo on
set OLDPATH=%PATH%

set PYTHON=%1
set RPY=%2
set RW=%3
set RV=%4
set MinGW=c:\MinGW\bin
set buildDir=c:\rpy-%python%-%RPY%-%RW%

set PATH=c:\%PYTHON%;%MinGW%;c:\progra~1\R\%RW%\bin;%OLDPATH%
set R_HOME=c:\progra~1\R\%RW%\
set RSRC=c:\%rpy%\%RV%
REM previous versions need this?
set R_SRC=c:\%rpy%\%RV%

REM remove old rpy directory and rpy module if found
if exist %buildDir% rmdir /Q /S %buildDir%
if exist %PYTHON%\lib\site-packages\rpy.py del /Q /S
PYTHON%\lib\site-packages\rpy*.*

REM copy a fresh rpy to build directory
xcopy /I /E /Q c:\%rpy%\* %buildDir%
cd %buildDir%

REM build python library
copy /Y c:\windows\system32\%python%.dll .
pexports %python%.dll > %python%.def
dlltool --dllname %python%.dll --def %python%.def --output-lib lib%python%.a
copy /Y lib%python%.a c:\%python%\libs

REM build Rdll library
copy /Y c:\progra~1\R\%RW%\bin\R.dll .
pexports R.dll > Rdll.def
dlltool --dllname R.dll --def RDll.def --output-lib Rdll.lib
copy /Y Rdll.lib c:\progra~1\R\%RW%\bin

python setup.py build --compiler=mingw32 bdist_wininst

REM collect file for python 23 or python24
if exist dist\%rpy%.win32-py2.3.exe copy /Y dist\%rpy%.win32-py2.3.exe
c:\%rpy%-win32-py2.3-%RV%.exe
if exist dist\%rpy%.win32-py2.4.exe copy /Y dist\%rpy%.win32-py2.4.exe
c:\%rpy%-win32-py2.4-%RV%.exe
set PATH=%OLDPATH%
