/*

AUTHORS

 Copyright (C) 2008 Dmitry E. Oboukhov <unera@debian.org>
 Copyright (C) 2008 Nikolaev Roman <rshadow@rambler.ru>

LICENSE

This program is free software: you can redistribute  it  and/or  modify  it
under the terms of the GNU General Public License as published by the  Free
Software Foundation, either version 3 of the License, or (at  your  option)
any later version.

This program is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even  the  implied  warranty  of  MERCHANTABILITY  or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public  License  for
more details.

You should have received a copy of the GNU  General  Public  License  along
with this program.  If not, see <http://www.gnu.org/licenses/>.

*/

/* vim: set ts=4 sw=4 et ai: */

var expanded_torrent=0;
var timer_id=0;
var expanded_data, old_expanded_data;
var list_busy=false;
var full_refresh=false;

var bimages={
    del:        skin_dir+'/img/buttons/delete_button.png',
    del_hover:  skin_dir+'/img/buttons/delete_button_hover.png',
    del_down:   skin_dir+'/img/buttons/delete_button_hover_down.png',

    start:         skin_dir+'/img/buttons/started_button.png',
    start_hover:   skin_dir+'/img/buttons/started_button_hover.png',
    start_down:    skin_dir+'/img/buttons/started_button_hover_down.png',

    stop:          skin_dir+'/img/buttons/stopped_button.png',
    stop_hover:    skin_dir+'/img/buttons/stopped_button_hover.png',
    stop_down:     skin_dir+'/img/buttons/stopped_button_hover_down.png',

    sort_up:       skin_dir+'/img/sort_up.png',
    sort_down:     skin_dir+'/img/sort_down.png'
};

var table_info=[
    {
        name:           '<gt>Actions</gt>',
        id_preffix:     'actions_',
        updater:        function(td, hash, item)
        {
            update_delete_button(td, hash, item);
            update_start_stop_button(td, hash, item);
        },
        header_class:   'cell_actions'
    },
    {
        name:           '<gt>Status</gt>',
        title:          '<gt>Status of torrent</gt>',
        id_preffix:     'status_',
        header_class:   'cell_status',
        sort:           function(a, b) {
            if (a.is_active==1 && b.is_active==0) return 1;
            if (a.is_active==0 && b.is_active==1) return -1;
            if (a.is_hash_checking==1 && b.is_hash_checking==0) return 1;
            if (a.is_hash_checking==0 && b.is_hash_checking==1) return -1;
            return 0;
        },
        updater:        function(td, hash, item)
        {
            update_status(td, hash, item);
        }
    },
    {
        name:           '<gt>Name</gt>',
        header_class:   'cell_name',
        id_preffix:     'name_',
        sortable:       true,
        field:          'name',
        updater:        function(td, hash, item)
        {
            update_name(td, hash, item);
        }
    },
    {
        name:           '<gt>P</gt>',
        header_class:   'cell_priority',
        id_preffix:     'priority_',
        title:          '<gt>Priority</gt>',
        sortable:       true,
        field:          'priority',
        updater:        function(td, hash, item)
        {
            update_priority(td, hash, item);
        }
    },
    {
        name:           '<gt>Size</gt>',
        header_class:   'cell_size',
        id_preffix:     'size_',
        sort:           function(a, b) { return compare_sizes(a,b); },
        field:          'human_size'
    },
    {
        name:           '<gt>Done</gt>',
        header_class:   'cell_done',
        id_preffix:     'done_',
        sort:           function(a, b) { return compare_dones(a,b); },
        field:          'human_done'
    },
    {
        name:           '%',
        header_class:   'cell_percent',
        title:          '<gt>Done in percents</gt>',
        id_preffix:     'done_percent_',
        field:          'percent',
        sort:           function(a, b)
        {
            var sa=a.percent; if (sa==null) sa=0; sa += '';
            var sb=b.percent; if (sb==null) sb=0; sb += '';
            sa=parseFloat(sa.replace('%', ''));
            sb=parseFloat(sb.replace('%', ''));
            if (sa>sb) return 1;
            if (sa<sb) return -1;
            return 0;
        },
        updater:        function(td, hash, item)
        {
            if (item.complete==1) update_done(td, '100%');
            else update_done(td, item.percent);
        }
    },
    {
        name:           '<gt>Up</gt>',
        header_class:   'cell_up',
        id_preffix:     'up_',
        title:          '<gt>Uploaded</gt>',
        sort:           function(a, b) { return compare_uploaded(a,b); },
        field:          'human_up_total'
    },
    {
        name:           '<gt>R</gt>',
        header_class:   'cell_ratio',
        id_preffix:     'ratio_',
        title:          '<gt>Ratio</gt>',
        field:          'ratio',
        sort:           function(a, b)
        {
            var sa=parseFloat(a.ratio);
            var sb=parseFloat(b.ratio);
            if (sa>sb) return 1;
            if (sa<sb) return -1;
            return 0;
        },
        updater:        function(td, hash, item)
        {
            update_ratio(td, hash, item);
        }
    },
    {
        name:           '<gt>Peers</gt>',
        header_class:   'cell_peers',
        title:          '<gt>Peers connected</gt>',
        field:          'peers_connected',
        sort:           function(a, b)
        {
            var sa=parseInt(a.peers_connected);
            var sb=parseInt(b.peers_connected);
            if (sa>sb) return 1;
            if (sa<sb) return -1;
            return 0;
        },
        id_preffix:     'peers_'
    },
    {
        name:           '<gt>UR</gt>',
        header_class:   'cell_up_rate',
        title:          '<gt>Up rate</gt>',
        field:          'human_up_rate',
        id_preffix:     'ur_'
    },
    {
        name:           '<gt>DR</gt>',
        header_class:   'cell_down_rate',
        title:          '<gt>Down rate</gt>',
        field:          'human_down_rate',
        id_preffix:     'dr_'
    }
];

function set_loading_indicator(loading)
{
    if (timer_id) clearTimeout(timer_id); timer_id=0;
    if (loading)
    {
        $('#logo')
            .attr('class', 'logo_loading')
            .text('<gt>RTPG [Update]</gt>');
        $('body').css('cursor', 'progress');
    }
    else
    {
        $('#logo')
            .attr('class', 'logo_static')
            .text('<gt>RTPG</gt>');
        $('body').css('cursor', '');
        update_timer();
    }
}

/*
    function creates buttons from object with parameters:

    cname       - the class name
    id          - the id
    alt         - the alt
    title       - the title

    img         - the image uri

    click       - function

    optional:

    img_hover
    img_down

*/

function create_button_img(info)
{
    var button=$('<img/>').attr('id', info.id)
        .attr('alt', info.alt)
        .attr('title', info.title)
        .val(info.title)
        .addClass(info.cname)
        .attr('src', info.img);

    button.mouseup(function()   { button.attr('src', info.img_hover); });
    button.mouseout(function()  { button.attr('src', info.img); });
    button.mouseover(function() { button.attr('src', info.img_hover); });
    button.mousedown(function() { button.attr('src', info.img_down); });
    button.click(function()     { info.click(); });
    return button;
}

function update_delete_button(td, hash, item)
{
    if ($('#delete_'+hash).length!=0) return;

    var delb=create_button_img({
        cname:      'delete_button',
        id:         'delete_'+hash,
        alt:        '<gt>[Remove]</gt>',
        title:      '<gt>Remove torrent from list</gt>',

        img:        bimages.del,
        img_hover:  bimages.del_hover,
        img_down:   bimages.del_down,

        click:      function() {
            if (confirm(
            "<gt>Are You sure that You want to remove this torrent?</gt>\n\n"+
                    '"'+item.name+'"'))
            {
                if (hash == expanded_torrent) expanded_torrent=0;
                command_rtorrent('what', 'erase', 'id', hash);
            }
        }
    });
    td.append(delb);
}

function update_ratio(td, hash, item)
{
    var span=td.find('span');
    if (!span.length) td.append( span=$('<span/>').text(item.ratio) );
    if (parseFloat(item.ratio)>1) span.attr('class', 'ratio_gt_one');
    else span.attr('class', 'ratio_lt_one');
    span.text(item.ratio);
}

function update_start_stop_button(td, hash, item)
{
    var start_button=$('#start_'+hash);
    var stop_button=$('#stop_'+hash);

    if (!start_button.length)
    {
        start_button=create_button_img({
            cname:      'start_button',
            id:         'start_'+hash,
            alt:        '<gt>[Start]</gt>',
            title:      '<gt>Start torrent</gt>',

            img:        bimages.start,
            img_hover:  bimages.start_hover,
            img_down:   bimages.start_down,
            click:      function()
            {
                command_rtorrent('what', 'start', 'id', hash)
            }
        });
        td.append(start_button);
    }
    if (!stop_button.length)
    {
        stop_button=create_button_img({
            cname:      'stop_button',
            id:         'stop_'+hash,
            alt:        '<gt>[Stop]</gt>',
            title:      '<gt>Stop torrent</gt>',

            img:        bimages.stop,
            img_hover:  bimages.stop_hover,
            img_down:   bimages.stop_down,
            click:      function()
            {
                command_rtorrent('what', 'stop', 'id', hash)
            }
        });
        td.append(stop_button);
    }

    if (item.is_active==1)
    {
        start_button.css('display', 'none');
        stop_button.css('display', '');
    }
    else
    {
        start_button.css('display', '');
        stop_button.css('display', 'none');
    }
}

function update_priority(td, hash, item)
{
    if ($('#psel_'+hash).length!=0)
    {
        $('#psel_'+hash).attr('selectedIndex', item.priority);
        return;
    }
    var sel=$('<select/>').attr('id', 'psel_'+hash);
    sel.append($('<option/>').text('<gt>off</gt>').val(0));
    sel.append($('<option/>').text('<gt>low</gt>').val(1));
    sel.append($('<option/>').text('<gt>normal</gt>').val(2));
    sel.append($('<option/>').text('<gt>high</gt>').val(3));
    sel.attr('selectedIndex', item.priority);
    td.append(sel);

    sel.change(function() {
        command_rtorrent('what', 'priority',
            'id', hash, 'priority', sel.val());
    });
}

function human_size_to_float(s)
{
    var suffix=String(s).replace(/[0-9\.]/g, '');
    var value=parseFloat(String(s).replace(/[^0-9\.]/g, ''));

    switch(suffix)
    {
        case 'E': case 'e': value *= 1024;
        case 'P': case 'p': value *= 1024;
        case 'T': case 't': value *= 1024;
        case 'G': case 'g': value *= 1024;
        case 'M': case 'm': value *= 1024;
        case 'K': case 'k': value *= 1024;
    }
    return value;
}

function compare_sizes(a, b)
{
    var sa=human_size_to_float(a.human_size);
    var sb=human_size_to_float(b.human_size);
    if (sa<sb) return -1;
    if (sa>sb) return 1;
    return 0;
}

function compare_uploaded(a, b)
{
    var sa=human_size_to_float(a.human_up_total);
    var sb=human_size_to_float(b.human_up_total);
    if (sa<sb) return -1;
    if (sa>sb) return 1;
    return 0;
}

function compare_dones(a, b)
{
    var sa=human_size_to_float(a.human_done);
    var sb=human_size_to_float(b.human_done);
    if (sa<sb) return -1;
    if (sa>sb) return 1;
    return 0;
}

function sort_list(th, index)
{
    var info=table_info[index];
    set_loading_indicator(true);

    var increase=false;
    var sort_name='sort_down';

    if (th.find('img').attr('class')=='sort_down')
    {
        increase=true;
        var sort_name='sort_up';
    }

    if (info.sort)
    {
        tlist.list=tlist.list.sort(function(a,b){
            if (increase) return info.sort(a,b);
            return info.sort(b,a);
        });
    }
    else
    {
        tlist.list=tlist.list.sort(function(a,b) { 
            var af=String(a[info.field]).toLowerCase();
            var bf=String(b[info.field]).toLowerCase();
            if (increase)
            {
                if (af<bf) return -1;
                if (af>bf) return 1;
            }
            else
            {
                if (af<bf) return 1;
                if (af>bf) return -1;
            }
            return 0;
        });
    }
    
    $('#rlist > thead > tr > th > img').remove();
    $('#rlist > tbody').empty();
    expanded_torrent=0;
    expanded_data=0;

    th.append(
        $('<img/>').attr('class', sort_name)
        .attr('src', bimages[sort_name])
        .attr('alt', '')
    );
    update_list();
}

function bind_sort_function(th, index)
{
    if (table_info[index].sortable || table_info[index].sort)
    {
        th.click(function() { sort_list(th, index); })
            .css('cursor', 'pointer');
    }
}

/* Create/update torrents list */
function update_list()
{
    /* Errors */
    if (tlist.error)
    {
        $('#rlist > tbody').empty();
        $('#rlist > thead').empty();
        $('#rlist > tfoot').empty();
        $('#rlist > thead').append(
            $('<tr/>')
                .append(
                    $('<th/>')
                        .attr('class', 'error')
                        .text('<gt>Error text</gt>')
                )
        );
        $('#rlist > tbody')
            .append($('<tr/>')
                .append(
                    $('<td/>')
                        .attr('class', 'error')
                        .text('<gt>Error get downloads list</gt>')
                )
            )
            .append($('<tr/>')
                .append(
                    $('<td/>')
                        .attr('class', 'error')
                        .text(tlist.error)
                )
            );
        set_loading_indicator(false);
        return;
    }

    /* Rtorrent/library versions */
    if (tlist.versions)
    {
        $('#client_version').text(tlist.versions.client_version);
        $('#lib_version').text(tlist.versions.library_version);
    }

    if (full_refresh)
    {
        full_refresh=false;
        $('#rlist > tbody').empty();
    }

    /* Header for list */
    if ($('#list_header').length==0)
    {
        $('#rlist > tbody').empty();
        $('#rlist > thead').empty();
        $('#rlist > tfoot').empty();
        var tr=$('<tr/>').attr('id', 'list_header');
        for (var i=0; i<table_info.length; i++)
        {
            var th;
            tr.append(
                th = $('<th/>')
                    .text(table_info[i].name+' ')
                    .addClass(table_info[i].header_class)

            );
            if (table_info[i].title)
                th.attr('title', table_info[i].title);
            
            bind_sort_function(th, i);
        }
        $('#rlist > thead').append(tr);

        $('#rlist > tfoot')
            .empty()
            .append(
                $('<tr/>').append(
                    $('<td/>')
                        .attr('colSpan', table_info.length)
                        .attr('id', 'total_torrents')
                )
            );
    }
    
    /* Removed items */
    $.each($('#rlist > tbody > tr'), function(trno, tr) {
        var id=$(tr).attr('id');
        for (var i=0; i<tlist.list.length; i++)
        {
            if (tlist.list[i].hash == id) return;
            if ('tr_message_'+tlist.list[i].hash == id) return;
            if ('tr_separator_top_'+tlist.list[i].hash == id) return;
            if ('tr_expanded_'+tlist.list[i].hash == id) return;
            if ('tr_separator_bottom_'+tlist.list[i].hash == id) return;
        }
        $(tr).remove();
    });

    collapse_expanded_torrent();

    var active_torrents=0;

    /* update torrents 
    
      If we have tlist.old_list then we compare them and
      if we have no changes in torrent then we do not update it.

    */

    var append_ary=[];

    for (i=0; i<tlist.list.length; i++)
    {
        /* caclulate active_torrents */
        if (tlist.list[i].is_active==1) active_torrents++;

        if (tlist.old_list && tlist.old_list.length>i)
        {
            if (is_eq_objects(tlist.list[i], tlist.old_list[i]))
                continue;
        }
        var lines=update_one_torrent(i);
        if (lines) append_ary[append_ary.length]=lines;
    }

    /* find done column */
    var percent_col = 0;
    for (var i=0; i<table_info.length; i++)
    {
        if (table_info[i].field == 'percent')
        {
            percent_col = i;
            break;
        }
    }

    var tbody=$('#rlist > tbody');
    for(var i=0; i<append_ary.length; i++)
    {
    	tbody.append(append_ary[i].sep_top);
    	tbody.append(append_ary[i].torrent);
    	tbody.append(append_ary[i].message);
    	tbody.append(append_ary[i].expanded);
    	tbody.append(append_ary[i].sep_bottom);

    	/* HACK: refresh progress AFTER append */
    	update_done(
    	    append_ary[i].torrent.find('td.cell_percent'),
    	    tlist.list[append_ary[i].idx].percent
    	);
    }
    

    $('#total_torrents').text(
        '<gt>torrents altogether:</gt> '+tlist.list.length+
        ', <gt>active:</gt> '+active_torrents
    );

    delete tlist.old_list;

    mark_odd_even_items();
    set_loading_indicator(false);
    update_expanded_torrent();
    tlist.updated=true;
}

/* collapse expanded torrent
if removed torrent from list then the function resets expanded_torrent */
function collapse_expanded_torrent()
{
    if (expanded_torrent)
    {
        var exp_found=0;
        for (var i=0; i<tlist.list.length; i++)
        {
            if (tlist.list[i].hash==expanded_torrent)
            {
                exp_found=1;
                break;
            }
        }
        if (!exp_found) expanded_torrent=0;
    }
}

function update_one_torrent(i)
{
    var tr_id=tlist.list[i].hash;

    var tr, tr_message, tr_expanded, tr_sep_top, tr_sep_bottom;
    var flag_created=false;

    tr=$('#'+tr_id);

    /* Add item line */
    if (tr.length==0)
    {
        tr=$('<tr/>').attr('id', tr_id);
        flag_created=true;

        tr_message=$('<tr/>')
            .attr('id', 'tr_message_'+tr_id)
            .append( 
                $('<td/>').attr('colSpan', table_info.length)
                .attr('class', 'message_torrent')
            );

        tr_sep_top=$('<tr/>')
            .attr('id', 'tr_separator_top_'+tr_id)
            .addClass('torrent_separator_top')
            .append( $('<td/>').attr('colSpan', table_info.length) );

        tr_sep_bottom=$('<tr/>')
            .attr('id', 'tr_separator_bottom_'+tr_id)
            .addClass('torrent_separator_bottom')
            .append( $('<td/>').attr('colSpan', table_info.length) );

        tr_expanded=$('<tr/>')
            .attr('id', 'tr_expanded_'+tr_id)
            .append( $('<td/>').addClass('file_list')
            .attr('colSpan', table_info.length) )
            .css('display', 'none');


        for (var j=0; j<table_info.length; j++)
        {
            tr.append( $('<td/>')
                .attr('id', table_info[j].id_preffix+tr_id)
                .addClass(table_info[j].header_class)
            );
        }
    }
    else
    {
        tr_message=$('#tr_message_'+tr_id);
        tr_expanded=$('#tr_expanded_'+tr_id);
    }

    /* Update items */
    for (var j=0; j<table_info.length; j++)
    {
        var text = '';
        if (table_info[j].field) text=tlist.list[i][table_info[j].field];
        var td=tr.find('#'+table_info[j].id_preffix+tr_id);
        if (table_info[j].updater)
        {
            table_info[j].updater(td, tr_id, tlist.list[i]);
        }
        else
        {
            if (td.text()+'' != text+'') td.text(text);
        }
    }

    update_message_bar(tr_message, tlist.list[i].message);

    if (!flag_created) return false;
    return {
        sep_top:        tr_sep_top,
        torrent:        tr,
        message:        tr_message,
        expanded:       tr_expanded,
        sep_bottom:     tr_sep_bottom,
        idx:            i
    };
}


function mark_odd_even_items()
{
    var idx=0;
    $.each($('#rlist > tbody > tr'), function(i, tr) {
        if ($(tr).attr('id').match(/^tr_separator/)) return;
        var class_name='torrent_odd';
        if ((parseInt(idx/3))%2) class_name='torrent_even';
        $(tr).attr('class', class_name);
        idx++;
    });
}

function update_message_bar(tr, message)
{
    if (message=='' || message==null)
    {
        tr.css('display', 'none');
        return;
    }
    tr.css('display', '');
    tr.find('> td').text(message);
}


function update_progress_bar(td, percent)
{
    var progress_width=$('#indicator_background').width();
    var img_uri_css='url('+$('#indicator_background').attr('src')+')';
    if (!progress_width) progress_width=500;
    if (percent.match(/%/))
    {
        switch(percent)
        {
            case '0%':
                td.css('background-image', 'none');
                break;
            case '100%':
                td.css('background-image', img_uri_css)
                    .css('background-repeat', 'repeat');
                break;
            default:
                percent=parseInt(percent.replace('%', ''));
                var offset=td.width()*percent/100-progress_width+1;
                td.css('background-image', img_uri_css)
                    .css('background-position', offset)
                    .css('background-repeat', 'repeat-y');
        }
    }
}

function update_done(td, done)
{
    if (done == null) done='0%';
    done +='';
    if (done.match(/%$/))
    {
        if (td.text() != done) td.text(done);
        update_progress_bar(td, done);
        return;
    }
    td.text('???')
      .attr('title', '<gt>Please, upgrade xmlrpc-c to 1.07 or later</gt>')
      .css('background-color', 'red')
      .css('color', 'white');
}


/* updates select for all priorities in one torrent */
function _update_psel(select, value)
{
    if (value!=-1)
    {
        select.find('option[value="-1"]').remove();
        select.val(value);
        return;
    }
    if (select.find('option[value="-1"]').length==0)
    {
        select.find('option:first').before(
            $('<option/>').text('<gt>individual</gt>').val(-1)
        );
    }
    select.val(value);
}

function update_expanded_torrent()
{
    var hide_filter='#rlist > tbody > tr[id^=tr_expanded_]';
    if (expanded_torrent)
    {
        hide_filter+='[id!=tr_expanded_'+expanded_torrent+']';
        $('#tr_expanded_'+expanded_torrent).css('display', '');
    }
    $(hide_filter).css('display', 'none');

    if (!expanded_data || !expanded_torrent) return;
    
    var td=$('#tr_expanded_'+expanded_torrent+' > td:first');
    var trclass=td.parent().attr('className');

    /* Errors when get file list */
    if (expanded_data.error)
    {
        td.empty();
        td.append(
            $('<table/>')
                .addClass('expanded_error')
                .append(
                    $('<thead/>').append(
                        $('<tr/>')
                            .append(
                                $('<th/>')
                                    .addClass('error_text')
                                    .text('<gt>Error text</gt>')
                            )
                    )
                )
                .append(
                    $('<tbody/>')
                        .append(
                            $('<tr/>').append(
                                $('<td/>')
                                    .text('<gt>Can not get file list</gt>')
                                    .attr('class', 'error')
                            )
                        )
                        .append(
                            $('<tr/>').append(
                                $('<td/>')
                                    .text(expanded_data.error)
                                    .attr('class', 'error')
                            )
                        )
                )
        );
        td.parent().css('display', '');
        return;
    }

    /* show file list */
    var tbl=td.find('table.file_list');
    
    /* finding value for psel_all */
    var psel_val;
    if (!expanded_data[0].priority) psel_val='1';
    else psel_val=expanded_data[0].priority;
    for (var i=1; i<expanded_data.length; i++)
    {
        var p0=expanded_data[0].priority; if (!p0) p0='1';
        var pi=expanded_data[i].priority; if (!pi) pi='1';
        if (pi!=p0)
        {
            psel_val='-1';
            break;
        }
    }

    var psel_all;
    /* Create table */
    if (tbl.length==0)
    {
        tbl=$('<table/>')
            .addClass('file_list')
            .attr('align', 'right')
            .append(
                $('<thead/>').append(
                    $('<tr/>').append(
                        $('<th/>')
                            .text('<gt>File name</gt>')
                            .addClass('file_list_filename')
                    ).append(
                        $('<th/>')
                            .text('<gt>Size</gt>')
                            .addClass('file_list_filesize')
                    ).append(
                        $('<th/>')
                            .text('<gt>Done</gt>')
                            .addClass('file_list_filedone')
                    ).append(
                        $('<th/>')
                            .text('<gt>Priority</gt>')
                            .addClass('file_list_filepriority')
                            .append( $('<br/>') )
                            .append(
                                psel_all=$('<select/>')
                                    .append( $('<option/>')
                                        .text('<gt>off</gt>').val(0) )
                                    .append( $('<option/>')
                                        .text('<gt>normal</gt>').val(1) )
                                    .append( $('<option/>')
                                        .text('<gt>high</gt>').val(2) )
                                    .attr('title', 
                        '<gt>to set the priority to all files at once</gt>')
                            )
                    )
                )
            ).append(
                $('<tbody/>')
            );
        _update_psel(psel_all, psel_val);
        var tbody=tbl.find('tbody');
        var done_tds=[];
        for (var i=0; i<expanded_data.length; i++)
        {
            var cname=trclass+'_file_list_odd';
            if (i%2) cname=trclass+'_file_list_even';
            var fdone, fpri;
            tbody.append(
                $('<tr/>')
                    .addClass(cname)
                    .append(
                        $('<td/>')
                            .text(expanded_data[i].path)
                            .addClass('file_list_filename')
                    )
                    .append(
                        $('<td/>')
                            .addClass('file_list_filesize')
                            .text(expanded_data[i].human_size)
                    )
                    .append(
                        fdone = $('<td/>').addClass('file_list_filedone')
                    )
                    .append(
                        fpri = $('<td/>').addClass('file_list_filepriority')
                    )
            );
            update_file_priority(fpri, 
                expanded_torrent, expanded_data[i].priority, i);
            done_tds[done_tds.length] = {
            	td: fdone, percent:
                expanded_data[i].percent
            };
            expanded_data[i].just_added = true;
        }
        td.empty().append(tbl);

        /* HACK: update progress bars AFTER append */
        for (var i=0; i<done_tds.length; i++)
            update_done(done_tds[i].td, done_tds[i].percent);


        psel_all.change(function() {
            command_file_list(
                'files_priority', expanded_torrent,
                'priority',      psel_all.val()
            );
        });
        return;
    }
    else
    {
        psel_all=tbl.find('> thead > tr > th.file_list_filepriority > select');
        _update_psel(psel_all, psel_val);
    }

    /* Update file list */
    td.parent().css('display', '');
    var tbody=tbl.find('tbody');

    /* if old_expanded_data are exists and data are not changed
        we can not update fileinfo */
    for (var i=0; i<expanded_data.length; i++)
    {
        if (old_expanded_data && 
            is_eq_objects(old_expanded_data[i],expanded_data[i]))
            continue;
        
        var tr=tbody.find('tr:eq('+i+')');
        update_file_priority(
            tr.find('td.file_list_filepriority:first'),
            expanded_torrent, expanded_data[i].priority, i
        );
        update_done(
            tr.find('td.file_list_filedone:first'),
            expanded_data[i].percent
        );
    }
}

function is_eq_objects(a, b)
{
    if (!a && !b) return true;
    if (!a || !b) return false;
    for (var item in a) if (a[item]!=b[item]) return false;
    for (var item in b) if (a[item]!=b[item]) return false;
    return true;
}

var template_fp_select;
function update_file_priority(td, hash, priority, index)
{
    if (priority == null) priority='1';
    var sel=td.find('select');
    if (sel.length==0)
    {
        if (!template_fp_select)
        {
            template_fp_select=$('<select/>')
                .append( $('<option/>').text('<gt>off</gt>').val(0) )
                .append( $('<option/>').text('<gt>normal</gt>').val(1) )
                .append( $('<option/>').text('<gt>high</gt>').val(2) )
                .attr('selectedIndex', priority)
                .change(function() {
                    var vals=$(this).attr('id').split('_', 3);
                    command_file_list(
                        'file_priority', vals[2],
                        'file_id', vals[1],
                        'priority', $(this).val()
                    );
                });
            
        }
        sel=template_fp_select.clone(true);
        sel.attr('id', 'id_'+index+'_'+hash);
        td.append(sel);
    }
    sel.attr('selectedIndex', priority);
}

function update_name(td, hash, item)
{
    var nid='name_text_'+hash;
    if ($('#'+nid).length==0)
    {
        if (td.text()+''!=item.name+'')
            td.text(item.name).attr('title', item.name);
        
        td.unbind();
        td.click(function(){
            expanded_data=0;
            if (expanded_torrent==hash)
            {
                expanded_torrent=0;
                update_expanded_torrent();
            }
            else
            {
                expanded_torrent=hash;
                command_file_list('files', hash);
            }
        });
    }
}

function update_timer()
{
    if (refresh_timeout && !timer_id)
    {
        timer_id=setTimeout(function() {
                timer_id=0;
                update_tlist();
            }, refresh_timeout
        );
    }
}

function human_size(size)
{
    var sign=1;
    size=parseInt(size);
    if (sign<0) return '>2G';
    var suffixes=['', 'K', 'M', 'G', 'T', 'P', 'E'];
    var limit=1024, div=1;
    for (var i=0; i<suffixes.length; i++)
    {
        if (size<limit || i==suffixes.length-1)
        {
            size=sign*size/div+'';
            size=size
                .replace(/(\..).*/, '$1')
                .replace(/\.0/, '');
            return size+suffixes[i];
        }
        div = limit;
        limit *= 1024;
    }
}

function human_speed_size(speed)
{
    if (speed==0) return 0;
    speed = human_size(speed)+'B/s';
    return speed;
}

function update_system_info()
{
    var limits=
    [
        1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 20, 30, 40,  50,  60,
        70, 80, 90, 100, 200, 300, 400, 500, 600, 700,  800,
        900, 1024, 2048, 3072, 4096, 5120, 6144, 7168, 8192,
        9216, 10240,  20480,  30720,  40960,  51200,  61440,
        71680, 81920, 92160, 102400
    ];
    if (tlist.error) return;
    var sel_up=$('#sel_up_sel'), sel_down=$('#sel_down_sel');

    if (!sel_up.length)
    {
        $('#sel_up')
            .append( sel_up=$('<select/>').attr('id', 'sel_up_sel') );
        $('#sel_down')
            .append( sel_down=$('<select/>').attr('id', 'sel_down_sel') );

        sel_up.append( $('<option/>').val(0).text('<gt>No limits</gt>') );
        sel_down.append( $('<option/>').val(0).text('<gt>No limits</gt>') );
        for (var i=0; i<limits.length; i++)
        {
            var speed=human_speed_size(limits[i]*1024);
            sel_up.append(
                $('<option/>')
                    .val(limits[i]*1024).text(speed)
            );
            sel_down.append(
                $('<option/>')
                    .val(limits[i]*1024).text(speed)
            );
        }
        sel_up.change(function() { change_rates('up', sel_up.val()); });
        sel_down.change(function() { change_rates('down', sel_down.val()); });
    }

    /* update system info */
    insert_option_order(sel_up, tlist.system.l_upload_rate,
        human_speed_size(tlist.system.l_upload_rate));
    insert_option_order(sel_down, tlist.system.l_download_rate,
        human_speed_size(tlist.system.l_download_rate));

    sel_up.val(tlist.system.l_upload_rate);
    sel_down.val(tlist.system.l_download_rate);

    $('#sum_up_rate').text(human_speed_size(tlist.system.upload_rate));
    $('#sum_down_rate').text(human_speed_size(tlist.system.download_rate));
}

function change_rates(what, rate)
{
    set_loading_indicator(true);
    command_rtorrent('what', 'set_rate', 'rate', rate, 'direction', what);
}

function insert_option_order(select, value, text)
{
    var ret=$(select).find('option[value='+value+']:first');
    if (ret.length) return ret;

    var opt_last=$(select).find('option:last');
    $.each($(select).find('option'), function(i, option) {
        if (parseInt(value)<parseInt($(option).val())) return;
        opt_last=$(option);
    });
    opt_last.after(
        ret=$('<option/>').text(text).val(value)
    );
    return ret;
}

function update_status(td, hash, item)
{

    if (td.find('.active_indicator').length==0)
    {
        var sto=$('#status_table_template').clone();
        sto.css('display', '').attr('id', 'status_inds_'+hash);
        td.append(sto);
    }

    if (item.is_active==1)
    {
        td.find('.active_indicator').css('display', '');
        td.find('.inactive_indicator').css('display', 'none');
    }
    else
    {
        td.find('.active_indicator').css('display', 'none');
        td.find('.inactive_indicator').css('display', '');
    }
    if (item.is_hash_checking==1)
        td.find('.hashing_indicator').css('display', '');
    else td.find('.hashing_indicator').css('display', 'none');
}


function update_tlist()
{
    if (expanded_torrent)
    {
        if ((expanded_data && !expanded_data.error)||!expanded_data)
        {
            command_rtorrent('what', 'list',
                'id', expanded_torrent, 'off_names', 1);
            return;
        }
    }
    command_rtorrent('what', 'list');
}

function set_timeout_select()
{
    insert_option_order($('#timeout_refresh'),
        refresh_timeout, refresh_timeout/1000);
    $('#timeout_refresh').val(refresh_timeout);
    $('#timeout_refresh').css('display', '');
    $('#timeout_refresh').change(function() {
        if (timer_id) clearTimeout(timer_id);
        timer_id=0;
        refresh_timeout=parseInt($('#timeout_refresh').val());
        save_cookie('refresh_timeout', refresh_timeout);
        update_timer();
        update_tlist();
    });
}

function update_skins_select()
{
    $('#skin_list').change(function() {
        save_cookie('skin', $('#skin_list').val());
        document.location.href='?';
    });
}

function update_view_select()
{
    $('#view').val(view_style).css('display', '');


    $('#view').change(function() 
    {
        $('#rlist > thead > tr > th > img').remove();
        var new_style=$('#view').val();
        save_cookie('view', new_style);
        view_style=new_style;
        full_refresh=true;
        update_tlist();
    });
}

function command_rtorrent()
{
    set_loading_indicator(true);
    var uri='?';
    for (i=0; i<arguments.length; i+=2)
    {
        if (arguments[i])
        {
            if (uri!='?') uri+='&';
            uri+=arguments[i]+'='+arguments[i+1];
        }
    }

    /* skip refresh command if AJAX doing now */
    if (list_busy && arguments[0]=='what' && arguments[1]=='list') return;
    list_busy=true;
    $.getJSON(uri, function(data) {
        if (data.expanded_torrent) 
        {
            old_expanded_data=expanded_data;
            expanded_data=data.expanded_torrent;
        }
        if (tlist.updated)
        {
            /* temporary hack: only list for update */
            var old_tlist=tlist.list;
            tlist=data;
            tlist.old_list=old_tlist;
            update_list();
        }
        else
        {
            tlist=data;
            update_list();
        }
        update_system_info();
        list_busy=false;
    });
}

function command_file_list(command, hash)
{
    set_loading_indicator(true);
    list_busy=true;
    var uri='?what='+command+'&id='+hash;
    for (i=2; i<arguments.length; i+=2)
        uri+='&'+arguments[i]+'='+arguments[i+1];

    $.getJSON(uri, function(data) {
        old_expanded_data=expanded_data;
        expanded_data=data;
        update_expanded_torrent();
        set_loading_indicator(false);
        list_busy=false;
    });
}

function update_language_select()
{
    $('#lang_sel').change(function() {
        save_cookie('lang', $('#lang_sel').val());
        document.location.href='?';
    });
}

function save_cookie(name, value)
{
    var exp=new Date();
    exp.setTime(exp.getTime() + 5*360*24*3600*1000);
    document.cookie = name+'='+escape(value) +
        '; expires='+exp.toGMTString() +
        '; path=/';
}

function update_form_select()
{
    $('#type_form').change(function() {
        if ($('#type_form').val() == 'add_torrent_file')
        {
            $('#upload_input_file').css('display', '');
            $('#upload_input').css('display', 'none');
            save_cookie('form', 'file');
        }
        else
        {
            $('#upload_input_file').css('display', 'none');
            $('#upload_input').css('display', '');
            save_cookie('form', 'url');
        }
    });
}

function set_resize_hook()
{
    $(window).resize(function() {
        set_loading_indicator(true);
        setTimeout("update_list()", 1500);
    });
}

$(document).ready(function(){
    update_form_select();
    update_list();
    update_system_info();
    set_timeout_select();
    update_timer();
    update_skins_select();
    update_view_select();
    update_language_select();
    set_resize_hook();
});
