## Basic Usage

Running `rubocop` with no arguments will check all Ruby source files
in the current directory:

```sh
$ rubocop
```

Alternatively you can pass `rubocop` a list of files and directories to check:

```sh
$ rubocop app spec lib/something.rb
```

Here's RuboCop in action. Consider the following Ruby source code:

```ruby
def badName
  if something
    test
    end
end
```

Running RuboCop on it (assuming it's in a file named `test.rb`) would produce the following report:

```
Inspecting 1 file
W

Offenses:

test.rb:1:5: C: Use snake_case for method names.
def badName
    ^^^^^^^
test.rb:2:3: C: Use a guard clause instead of wrapping the code inside a conditional expression.
  if something
  ^^
test.rb:2:3: C: Favor modifier if usage when having a single-line body. Another good alternative is the usage of control flow &&/||.
  if something
  ^^
test.rb:4:5: W: end at 4, 4 is not aligned with if at 2, 2
    end
    ^^^

1 file inspected, 4 offenses detected
```

For more details check the available command-line options:

```sh
$ rubocop -h
```

Command flag              | Description
--------------------------|------------------------------------------------------------
`-v/--version`            | Displays the current version and exits.
`-V/--verbose-version`    | Displays the current version plus the version of Parser and Ruby.
`-L/--list-target-files`  | List all files RuboCop will inspect.
`-F/--fail-fast`          | Inspects in modification time order and stops after first file with offenses.
`-C/--cache`              | Store and reuse results for faster operation.
`-d/--debug`              | Displays some extra debug output.
`-D/--display-cop-names`  | Displays cop names in offense messages.
`-E/--extra-details`      | Displays extra details in offense messages.
`-c/--config`             | Run with specified config file.
`-f/--format`             | Choose a formatter.
`-o/--out`                | Write output to a file instead of STDOUT.
`-r/--require`            | Require Ruby file (see [Loading Extensions](#loading-extensions)).
`-R/--rails`              | Run extra Rails cops.
`-l/--lint`               | Run only lint cops.
`-a/--auto-correct`       | Auto-correct certain offenses. *Note:* Experimental - use with caution.
`--only`                  | Run only the specified cop(s) and/or cops in the specified departments.
`--except`                | Run all cops enabled by configuration except the specified cop(s) and/or departments.
`--auto-gen-config`       | Generate a configuration file acting as a TODO list.
`--no-offense-counts`     | Don't show offense counts in config file generated by --auto-gen-config
`--exclude-limit`         | Limit how many individual files `--auto-gen-config` can list in `Exclude` parameters, default is 15.
`--show-cops`             | Shows available cops and their configuration.
`--fail-level`            | Minimum [severity](#severity) for exit with error code. Full severity name or upper case initial can be given. Normally, auto-corrected offenses are ignored. Use `A` or `autocorrect` if you'd like them to trigger failure.
`-s/--stdin`              | Pipe source from STDIN. This is useful for editor integration.
`--[no-]color`            | Force color output on or off.
`--parallel`              | Use available CPUs to execute inspection in parallel.

Default command-line options are loaded from `.rubocop` and `RUBOCOP_OPTS` and are combined with command-line options that are explicitly passed to `rubocop`.
Thus, the options have the following order of precedence (from highest to lowest):

1. Explicit command-line options
2. Options from `RUBOCOP_OPTS` environment variable
3. Options from `.rubocop` file.

## Exit codes

RuboCop exits with the following status codes:

- 0 if no offenses are found, or if the severity of all offenses are less than
  `--fail-level`. (By default, if you use `--auto-correct`, offenses which are
  auto-corrected do not cause RuboCop to fail.)
- 1 if one or more offenses equal or greater to `--fail-level` are found. (By
  default, this is any offense which is not auto-corrected.)
- 2 if RuboCop terminates abnormally due to invalid configuration, invalid CLI
  options, or an internal error.
