/*
*  program name: Rubrica <http://digilander.iol.it/nfragale/download.html>
*  file: callbacks.c
*  
*  Copyright (C) 2000-2001 Nicola Fragale <nicolafragale@libero.it>
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <gnome.h>
#include <gconf/gconf-client.h>

#include "browse.h"
#include "form_card.h"
#include "main.h"
#include "callbacks.h"
#include "prefer.h"
#include "prefer_int.h"
#include "search_int.h"
#include "search.h"
#include "sort.h"
#include "interface.h"
#include "dialog.h"
#include "file.h"
#include "import_int.h"
#include "import.h"
#include "export.h"
#include "preview.h"
#include "autosave.h"

#include "view.h"
#include "card.h"
#include "rubrica_type.h"
#include "rubrica.h"


void
on_new_file_activate(GtkMenuItem *menuitem, gpointer user_data)
{ 
  RubricaViewType view;

  view = rubrica_view_get_view_type();

  switch(view)
    {
    case CARD_VIEW: 
      rubrica_card_add_page_view(NULL);
      break;
      
    case ACCOUNT_VIEW:
      rubrica_dialog_will_do();
      break;

    default:
      break;
    }
}


void	
on_open_activate (GtkMenuItem *menuitem,  gpointer user_data)
{
  rubrica_file_load_file();
}


void
on_save_activate (GtkMenuItem *menuitem, gpointer user_data)
{
  Rubrica *rubrica;

  rubrica = rubrica_get_current_rubrica();
  if (!rubrica)
    {
      g_print("\nRubrica error ** Can't read current rubrica. File not saved");

      return;
    }
   
  rubrica_file_save(rubrica);
}


void
on_save_as_activate (GtkMenuItem *menuitem, gpointer user_data)
{
  Rubrica *rubrica;

  rubrica = rubrica_get_current_rubrica();
  if (!rubrica)
    {
      g_print("\nRubrica error ** Can't read current rubrica. File not saved");

      return;  	 
    }

  rubrica_file_save_as(rubrica);
}

void	
on_close_activate (GtkMenuItem *menuitem, gpointer user_data)
{
  Rubrica *rubrica;

  rubrica = rubrica_get_current_rubrica();
  if (!rubrica)
    return;

  rubrica_close_rubrica(rubrica);
}


void 
on_import_activate (GtkMenuItem *menuitem,  gpointer user_data)
{
  GtkWidget *app;
  GtkWidget *import = NULL;
  gboolean imported = FALSE; 
  gint result;
  
//  rubrica_dialog_developing();

  app = rubrica_get_app();
  import = create_import_dialog(app);
  gtk_widget_show(import);
    
  while (!imported)
    {
      result = gtk_dialog_run(GTK_DIALOG(import));
      
      switch (result)
	{
	case GTK_RESPONSE_ACCEPT:
	  imported = rubrica_import_data(app);
	  break;

	case GTK_RESPONSE_CLOSE:
	default:
	  imported = TRUE;
	  break;
	}  
    }
  
  gtk_widget_destroy(import);
}

void 
on_export_activate (GtkMenuItem *menuitem, gpointer user_data)
{
  GtkWidget *app;
  GtkWidget *export = NULL;
  gboolean exported = FALSE; 
  gint result;
  
  rubrica_dialog_developing();

  app = rubrica_get_app();
  export = create_export_dialog(app);
  gtk_widget_show(export);
    
  while (!exported)
    {
      result = gtk_dialog_run(GTK_DIALOG(export));
      
      switch (result)
	{
	case GTK_RESPONSE_ACCEPT:
	  exported = rubrica_export_export_data();
	  break;

	case GTK_RESPONSE_CLOSE:
	default:
	  exported = TRUE;
	  break;
	}  
    }
  
  gtk_widget_destroy(export);
}

void 
on_preview_activate (GtkMenuItem *menuitem, gpointer user_data)
{
  GtkWidget *RubricaPreviewFs;
 
  RubricaPreviewFs = rubrica_preview_create_preview();
  gtk_widget_show (RubricaPreviewFs);  
}

void
on_exit_activate (GtkMenuItem *menuitem, gpointer user_data)
{
  Rubrica *rubrica;

  rubrica = rubrica_get_current_rubrica();  
  exit_rubrica(rubrica);
}


void 
on_undo_activate (GtkMenuItem *menuitem, gpointer user_data)
{
  /* not yet implemented */
  rubrica_dialog_will_do();
}

void
on_redo_activate (GtkMenuItem *menuitem,  gpointer user_data)
{ 
  /* not yet implemented */
  rubrica_dialog_will_do();
}


void
on_cut_activate (GtkMenuItem *menuitem, gpointer user_data)
{   
  Rubrica *rubrica;

  rubrica = rubrica_get_current_rubrica();  
  rubrica_item_cut(rubrica);  
}


void
on_copy_activate (GtkMenuItem *menuitem, gpointer user_data)
{
  Rubrica *rubrica;

  rubrica = rubrica_get_current_rubrica();  
  rubrica_item_copy(rubrica);
}


void
on_paste_activate (GtkMenuItem *menuitem, gpointer user_data)
{
  Rubrica *rubrica;

  rubrica = rubrica_get_current_rubrica();
  rubrica_item_paste(rubrica);
}


/*   POPUP CALLBACKS
*/
void
on_pop_cut_activate (GtkMenuItem *menuitem, gpointer user_data)
{ 
  Rubrica *rubrica;

  rubrica = rubrica_get_current_rubrica();
  rubrica_item_cut(rubrica);  
}

void
on_pop_copy_activate (GtkMenuItem *menuitem, gpointer user_data)
{
  Rubrica *rubrica;

  rubrica = rubrica_get_current_rubrica();
  rubrica_item_copy(rubrica);
}

void
on_pop_paste_activate (GtkMenuItem *menuitem, gpointer user_data)
{ 
  Rubrica *rubrica;
  
  rubrica = rubrica_get_current_rubrica();
  rubrica_item_paste(rubrica);
}

void 
on_pop_add_activate(GtkMenuItem *menuitem, gpointer user_data)
{
  on_button_add_clicked (NULL, NULL);
}

void on_pop_remove_activate(GtkMenuItem *menuitem, gpointer user_data)
{
  on_button_remove_clicked (NULL, NULL);
}

void
on_pop_modify_activate (GtkMenuItem *menuitem,  gpointer user_data)

{
  on_button_modify_clicked (NULL, NULL);
}


void on_pop_check_item_clicked(GtkMenuItem *menuitem, gpointer user_data)
{
  GConfClient *client;
  gchar *key = user_data;
  gboolean bool;

  client = gconf_client_get_default();
  bool = gtk_check_menu_item_get_active(GTK_CHECK_MENU_ITEM(menuitem));
  gconf_client_set_bool(client, key, bool, NULL);
}

/*****************************************************************************
 */


/*  SORT TYPE CALLBACKS
*/
void
on_alphabetic_activate (GtkMenuItem *menuitem, gpointer user_data)
{
  rubrica_sort_set_sort_type(SORT_ALPHA);
}

void on_creation_date_activate(GtkMenuItem *menuitem, gpointer user_data)
{
  rubrica_sort_set_sort_type(SORT_CREATION_DATE);
}

void on_modification_date_activate(GtkMenuItem *menuitem, gpointer user_data)
{
  rubrica_sort_set_sort_type(SORT_MODIFICATION_DATE);
}


void
on_increasing_activate (GtkMenuItem *menuitem, gpointer user_data)
{
  rubrica_sort_set_sort_direction(SORT_ASCENDING);
}


void
on_decreasing_activate (GtkMenuItem *menuitem, gpointer user_data)
{
  rubrica_sort_set_sort_direction(SORT_DESCENDING);
}
/*****************************************************************************
 */


void
on_preferences_activate (GtkMenuItem *menuitem,  gpointer user_data)
{
  gint result;
  GtkWidget *app      = NULL;
  GtkWidget *prefer   = NULL;
  GConfClient *client = NULL;
  
  app    = rubrica_get_app();
  client = gconf_client_get_default(); 
  prefer = rubrica_preferences_get_preferencesbox();
  
  if (!prefer) 
    {
      prefer = create_preferences_dialog(app, client);
    }
  else
    {
      GtkTreePath *path;
      GtkTreeView *treeview;
      GtkTreeSelection *selection;
      GtkWidget *notebook;

      notebook  = gtk_object_get_data(GTK_OBJECT(prefer), "notebook");   
      treeview  = gtk_object_get_data(GTK_OBJECT(prefer), "treeview");
      selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(treeview));
      path      = gtk_tree_path_new_from_string("0");

      gtk_tree_selection_select_path(selection, path);
      gtk_tree_path_free(path);

      if (GTK_IS_NOTEBOOK(notebook))	 
	gtk_notebook_set_page(GTK_NOTEBOOK(notebook), 0); 
    } 
  gtk_widget_show(prefer);    

  do
    {
      result = gtk_dialog_run(GTK_DIALOG(prefer));
    }
  while(result != GTK_RESPONSE_CLOSE); 
  
  gtk_widget_hide(prefer);
}


void
on_button_new_clicked (GtkButton *button, gpointer user_data)
{ 
  RubricaViewType view;

  view = rubrica_view_get_view_type();

  switch(view)
    {
    case CARD_VIEW: 
      rubrica_card_add_page_view(NULL);
      break;
      
    case ACCOUNT_VIEW:
      rubrica_dialog_will_do();
      break;

    default:
      break;
    }
}


void
on_button_open_clicked (GtkButton *button, gpointer user_data)
{
  rubrica_file_load_file();
}


void
on_button_save_clicked (GtkButton *button, gpointer user_data)
{
  Rubrica *rubrica;
  gchar *filename;

  rubrica = rubrica_get_current_rubrica();
  filename = rubrica_get_name(rubrica);
  if (filename && (g_strcasecmp(filename, _("no name")) == 0))
    rubrica_file_save_as(rubrica);
  
  rubrica_file_save(rubrica);
}


void
on_button_close_clicked  (GtkButton *button, gpointer user_data)
{
  Rubrica *rubrica;

  rubrica = rubrica_get_current_rubrica();
  rubrica_close_rubrica(rubrica);
}


void rubrica_modify_card_item(RubricaItem *item, gint index)
{
  GtkWidget *form = NULL;
  gint response;

  if ((form = rubrica_form_card_get_form()) == NULL)
    {
      form = rubrica_form_card_new();  
    }

  rubrica_form_card_set_form_type(form, OLD_CARD);
  rubrica_form_card_clean_form(RUBRICA_CARD(form));
  rubrica_form_card_insert_item(RUBRICA_CARD(form), item);

  response = gtk_dialog_run(GTK_DIALOG(form));  
  switch(response)
    {
    case GTK_RESPONSE_OK:
      rubrica_form_card_extract_change_close(RUBRICA_CARD(form), index);
      break;

    case GTK_RESPONSE_CLOSE:
      rubrica_form_card_close (RUBRICA_CARD(form));
      break;

    default:
      break;
    }
}


void
on_button_add_clicked (GtkButton *button, gpointer data)
{
  GtkWidget *form = NULL;
  RubricaViewType view;
  gint response;

  view = rubrica_view_get_view_type();

  switch(view)
    {
    case CARD_VIEW: 
      if ((form = rubrica_form_card_get_form()) == NULL)
	{
	  form = rubrica_form_card_new();      
	}
      else
	{
	  rubrica_form_card_clean_form(RUBRICA_CARD(form));
	  rubrica_form_card_set_form_type(form, NEW_CARD);
	}
      break;
      
    case ACCOUNT_VIEW:
      rubrica_dialog_will_do();
      break;

    default:
      break;
    }
  
  response = gtk_dialog_run(GTK_DIALOG(form));  
  switch(response)
    {
    case GTK_RESPONSE_OK:
      rubrica_form_card_clicked_ok(RUBRICA_CARD(form));
      break;

    case GTK_RESPONSE_CLOSE:
      rubrica_form_card_close (RUBRICA_CARD(form));
      break;

    default:
      break;
    }
}


void
on_button_remove_clicked  (GtkButton *button, gpointer data)
{
  RubricaViewType view;
  Rubrica *rubrica;

  rubrica = rubrica_get_current_rubrica();
  view = rubrica_view_get_view_type();

  switch(view)
    {
    case CARD_VIEW:   
      rubrica_delete_selected_item(rubrica);
      break;

    case ACCOUNT_VIEW:
      rubrica_dialog_will_do();
      break;

    default:
      break;
    }      
}



/*  
    Modifica il contenuto di una scheda.
    Funzione richiamata da:
    pressione del bottone modifica sulla toolbar
    doppio click su un elemento della lista
    menu popup - voce modifica
*/
void
on_button_modify_clicked (GtkButton *button, gpointer user_data)
{
  Rubrica* rubrica;
  RubricaItem *item;
  RubricaViewType type;

  GtkTreeIter iter;
  GtkTreeView *view;
  GtkTreeModel *model;
  GtkTreePath *path;
  GtkTreeSelection *select;
  gint index;

  type = rubrica_view_get_view_type();
  rubrica = rubrica_get_current_rubrica();
  
  switch(type)
    {
    case CARD_VIEW:   
      if (rubrica_is_empty(rubrica)) 
	{ 
	  rubrica_dialog_message(_("Address book is empty. "
				   "I can't continue\n"),
				 GTK_MESSAGE_ERROR, GTK_BUTTONS_OK); 
	  return; 
	} 

      view   = GTK_TREE_VIEW(rubrica_get_view(rubrica));
      model  = gtk_tree_view_get_model (view);
      select = gtk_tree_view_get_selection(view);
      
      if (gtk_tree_selection_get_selected(select, &model, &iter))
	{
	  path = gtk_tree_model_get_path(model, &iter);
	  index = gtk_tree_path_get_indices (path)[0];
	  
	  gtk_tree_model_get(model, &iter, RUBRICA_COLUMN, &item, -1);
	  rubrica_modify_card_item(item, index); 
	}
      else
	rubrica_dialog_message(_("I can't continue if you don't "
				 "select a card"), 
			       GTK_MESSAGE_ERROR, GTK_BUTTONS_OK); 
      break;
      
    case ACCOUNT_VIEW:
      rubrica_dialog_will_do();
      break;
      
    default:
      break;
    }
}
  


void
on_button_browse_clicked (GtkButton *button, gpointer data)
{
  GtkTreeView *view;
  GtkTreeModel *model;
  GtkTreeSelection *select;
  Rubrica *rubrica;
  RubricaBrowseType browse;
  
  browse  = (RubricaBrowseType) data;
  rubrica = rubrica_get_current_rubrica();
  view    = GTK_TREE_VIEW(rubrica_get_view(rubrica));
  model   = gtk_tree_view_get_model(view);
  select  = gtk_tree_view_get_selection(view);

  switch (browse)
    {
    case RB_FIRST_CARD:
      rubrica_browse_first_card(select, GTK_TREE_MODEL(model));
      break;

    case RB_LAST_CARD:
      rubrica_browse_last_card(select, GTK_TREE_MODEL(model));
      break;

    case RB_NEXT_CARD:
      rubrica_browse_next_card(select, GTK_TREE_MODEL(model));
     break;
      
    case RB_PREV_CARD:
      rubrica_browse_prev_card(select, GTK_TREE_MODEL(model));
      break;

    case RB_NTH_CARD:
      break;

    default:
      break;
    }
}


void
on_button_find_clicked (GtkButton *button, gpointer user_data)
{
  GtkWidget *app;
  GtkWidget *search;
  GConfClient *client;
  gint response = GTK_RESPONSE_NONE;

  app    = rubrica_get_app();
  client = gconf_client_get_default();

  search = create_search_dialog(client);
  gtk_widget_show(search);

  while (response != GTK_RESPONSE_CLOSE)
    {
      response = gtk_dialog_run(GTK_DIALOG(search));
      
      if (response == GTK_RESPONSE_ACCEPT) 
	rubrica_search_perform_search(search);
    }

  gtk_widget_destroy(search);  
  g_object_unref(G_OBJECT(client));
}


void
on_button_exit_clicked  (GtkButton *button, gpointer user_data)
{
  Rubrica *rubrica;

  rubrica = rubrica_get_current_rubrica();
  exit_rubrica(rubrica);
}



void
on_button_cards_clicked(GtkButton *button, gpointer user_data)
{
  GtkNotebook *nb = user_data;

  rubrica_view_set_view_type(CARD_VIEW);

  gtk_notebook_set_page(GTK_NOTEBOOK(nb), CARD_VIEW);  
}


void
on_button_account_clicked (GtkButton *button, gpointer user_data)
{
  GtkNotebook *nb = user_data;

  rubrica_view_set_view_type(ACCOUNT_VIEW);
  gtk_notebook_set_page(GTK_NOTEBOOK(nb), ACCOUNT_VIEW);  
 
  rubrica_dialog_message(_("This feature is not yet implemented"), 
			 GTK_MESSAGE_WARNING, GTK_BUTTONS_OK);
}


void on_switch_pages_cb (GtkNotebook *notebook, GtkNotebookPage *page,
			 gint page_num,  gpointer user_data)
{
  Rubrica *rubrica;
  GtkWidget *app;
  
  rubrica_view_clean_view();
  app = rubrica_get_app();
  rubrica = rubrica_get_nth_rubrica(page_num);
  rubrica_set_current_rubrica(rubrica);

  rubrica_view_set_path(rubrica_get_path(rubrica));
  rubrica_view_set_items(rubrica_get_items(rubrica));

  if (rubrica_is_modified(rubrica)) 
    {
      gchar *tmp; 

      tmp = g_strdup_printf(_("Rubrica -- %s changed --"), 
			    rubrica_get_name(rubrica)); 

      gtk_window_set_title(GTK_WINDOW(app), tmp); 
      
      g_free(tmp); 
    } 
  else 
    gtk_window_set_title(GTK_WINDOW(app), "Rubrica"); 

  if (rubrica_get_index(rubrica) != -1)
    {
       GtkWidget *view;
       GtkTreePath *path;
       GtkTreeSelection *select;
       gchar *path_str;
       
       view   = rubrica_get_view(rubrica);
       select = gtk_tree_view_get_selection(GTK_TREE_VIEW(view));     
       
       path_str = rubrica_get_list_path(rubrica);
       if (path_str != NULL)
	 {   
	   gtk_tree_selection_unselect_all(GTK_TREE_SELECTION(select));
	   path = gtk_tree_path_new_from_string(path_str);
	   
	   gtk_tree_selection_select_path(select, path);
	   gtk_tree_view_scroll_to_cell(GTK_TREE_VIEW(view), path, NULL, 
					TRUE, 0.5, 0.0);  
	   
	   gtk_tree_path_free(path);
	 } 
    }
}


/*  supporto alle callback
*/

void exit_rubrica(Rubrica *rubrica)
{
  GtkWidget *dialog;
  GtkResponseType scelta;
  gchar *mes;
  gboolean exit;
  
  /*
    modificare la routine di uscita. Bisogna controllare che 
    tutte le le rubrica siano non modificate prima di uscire
  */
  exit = rubrica_preferences_get_exit();
  
  if (exit && !rubrica_is_modified(rubrica) && !rubrica_others_are_modified())
    {
      if (rubrica_preferences_get_autosave())
	rubrica_autosave_remove_tmp_files();
      
      gtk_main_quit();
    }
  else
    {
      if (!rubrica_is_modified(rubrica) && rubrica_others_are_modified())
	mes = g_strdup_printf(_("Warning. %s\n"				  
				"Changes not saved will be lost.\n\n"
				"Do you want continue?"), 
			      _("Some Addressbooks have changed."));
      else
	if (rubrica_is_modified(rubrica))
	  mes = g_strdup_printf(_("Warning. %s\n"
				  "Changes not saved will be lost.\n\n"
				  "Do you want continue?"), 
				_("Addressbook has changed."));
	else
	  mes = g_strdup(_("\nDo you want exit rubrica?"));
      
      dialog = rubrica_dialog_query(mes, GTK_BUTTONS_YES_NO);
      gtk_widget_show(dialog);
      g_free(mes);

      scelta = gtk_dialog_run(GTK_DIALOG(dialog));
      
      switch(scelta)
	{
	case GTK_RESPONSE_YES:	  
	  gtk_main_quit();
	  break;
	  
	case GTK_RESPONSE_NO:
	default:
	  gtk_widget_destroy(dialog);
	  break;
	}  
    }
}




