/*
*  Rubrica
*  file: file.c
*  
*  Copyright (C) 2000-2001 Nicola Fragale <nicolafragale@libero.it>
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef _RUBRICA_DICT_H
#define _RUBRICA_DICT_H

#include <gnome.h>
#include <gconf/gconf-client.h>

#include "rubrica_type.h"

void rubrica_dictionary_init(RubricaLanguageType language);

void rubrica_dictionary_get_italian(void);
void rubrica_dictionary_get_english(void);
void rubrica_dictionary_get_user_dictionary(void);
void rubrica_dictionary_compile(GConfClient *client,
				RubricaLanguageType language, 
				RubricaDictionaryCode code,
				gchar *key);
gboolean rubrica_dictionary_get(RubricaLanguageType language);


void rubrica_dictionary_display_string(GtkWidget *prefbox, 
				       GConfClient* client,
				       gchar *obj_key, gchar *gconf_key);
void rubrica_dictionary_display_dictionary(GtkWidget *prefbox, 
					   GConfClient* client);

void rubrica_dictionary_load_dictionary(gchar *dictionary);
gboolean rubrica_dictionary_load_user_dictionary(GConfClient* client);
gboolean rubrica_dictionary_real_dictionary_load(gchar *dictionary);

void rubrica_dictionary_save_dictionary(gchar *dictionary);

void rubrica_dictionary_parse_node(GConfClient* client, xmlNodePtr node);








#endif
