/*
*  Rubrica
*  file: menubar.h
*
*  
*  Copyright (C) 2000-2003 Nicola Fragale <nicolafragale@libero.it>
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/
#ifndef __RUBRICA_MENUBAR_H
#define __RUBRICA_MENUBAR_H

#include <config.h>
#include <gnome.h>

#include "prefer.h"
#include "dialog.h"
#include "callbacks.h"


static GnomeUIInfo file_menu_uiinfo[] =
{
  GNOMEUIINFO_MENU_NEW_ITEM (N_("_New"), NULL, on_new_file_activate, NULL),
  GNOMEUIINFO_MENU_OPEN_ITEM (on_open_activate, NULL),
  GNOMEUIINFO_MENU_SAVE_ITEM (on_save_activate, NULL),
  GNOMEUIINFO_MENU_SAVE_AS_ITEM (on_save_as_activate, NULL),
  GNOMEUIINFO_MENU_CLOSE_ITEM (on_close_activate, NULL),
  GNOMEUIINFO_SEPARATOR,
  {
    GNOME_APP_UI_ITEM, N_("_Import"),
    NULL,
    (gpointer) on_import_activate, NULL, NULL,
    GNOME_APP_PIXMAP_FILENAME, "rubrica/import-menu.png",
    GDK_I, (GdkModifierType) GDK_CONTROL_MASK, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("_Export"),
    NULL,
    (gpointer) on_export_activate, NULL, NULL,
    GNOME_APP_PIXMAP_FILENAME, "rubrica/export-menu.png",
    GDK_E, (GdkModifierType) GDK_CONTROL_MASK, NULL
  },
  GNOMEUIINFO_SEPARATOR,
  {
    GNOME_APP_UI_ITEM, N_("_Preview"),
    NULL,
    (gpointer) on_preview_activate, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GTK_STOCK_ZOOM_100,
    GDK_P, (GdkModifierType) GDK_CONTROL_MASK, NULL
  },
  GNOMEUIINFO_SEPARATOR,
  GNOMEUIINFO_MENU_EXIT_ITEM (on_exit_activate, NULL),
  GNOMEUIINFO_END
};

static GnomeUIInfo edit_menu_uiinfo[] =
{
  GNOMEUIINFO_MENU_CUT_ITEM (on_cut_activate, NULL),
  GNOMEUIINFO_MENU_COPY_ITEM (on_copy_activate, NULL),
  GNOMEUIINFO_MENU_PASTE_ITEM (on_paste_activate, NULL),
  GNOMEUIINFO_END
};

static GnomeUIInfo properties_menu_uiinfo[] =
{
  GNOMEUIINFO_MENU_PREFERENCES_ITEM (on_preferences_activate, NULL),
  GNOMEUIINFO_END
};

static GnomeUIInfo creation_date_uiinfo[] =
{
  {
    GNOME_APP_UI_ITEM, N_("Cr_eation date"),
    NULL,
    (gpointer) on_creation_date_activate, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, (GdkModifierType) 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("M_odification date"),
    NULL,
    (gpointer) on_modification_date_activate, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, (GdkModifierType) 0, NULL
  },
  GNOMEUIINFO_END
};

static GnomeUIInfo date_menu_uiinfo[] =
{
  {
    GNOME_APP_UI_RADIOITEMS, NULL, NULL, creation_date_uiinfo,
    NULL, NULL, GNOME_APP_PIXMAP_NONE, NULL, 0,
    (GdkModifierType) 0, NULL
  },
  GNOMEUIINFO_END
};

static GnomeUIInfo ascending_uiinfo[] =
{
  {
    GNOME_APP_UI_ITEM, N_("_Ascending"),
    NULL,
    (gpointer) on_increasing_activate, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, (GdkModifierType) 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("_Descending"),
    NULL,
    (gpointer) on_decreasing_activate, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, (GdkModifierType) 0, NULL
  },
  GNOMEUIINFO_END
};

static GnomeUIInfo view_menu_uiinfo[] =
{
  {
    GNOME_APP_UI_ITEM, N_("_Alphabetic"),
    NULL,
    (gpointer) on_alphabetic_activate, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GTK_STOCK_SELECT_FONT,
    0, (GdkModifierType) 0, NULL
  },
  {
    GNOME_APP_UI_SUBTREE, N_("Da_te"),
    NULL,
    date_menu_uiinfo, NULL, NULL,
    GNOME_APP_PIXMAP_FILENAME, "rubrica/time.png",
    0, (GdkModifierType) 0, NULL
  },
  GNOMEUIINFO_SEPARATOR,
  {
    GNOME_APP_UI_RADIOITEMS, NULL, NULL, ascending_uiinfo,
    NULL, NULL, GNOME_APP_PIXMAP_NONE, NULL, 0,
    (GdkModifierType) 0, NULL
  },
  GNOMEUIINFO_END
};

static GnomeUIInfo help_menu_uiinfo[] =
{
  GNOMEUIINFO_MENU_ABOUT_ITEM (rubrica_dialog_info, NULL),
  GNOMEUIINFO_SEPARATOR,
  {
    GNOME_APP_UI_ITEM, N_("Rubrica Home _Page"),
    NULL,
    (gpointer) rubrica_dialog_goto_homepage, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GTK_STOCK_HOME,
    0, (GdkModifierType) 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("_Bugs"),
    NULL,
    (gpointer) rubrica_dialog_notify_bugs, NULL, NULL,
    GNOME_APP_PIXMAP_FILENAME, "rubrica/sbug.png",
    0, (GdkModifierType) 0, NULL
  },
  GNOMEUIINFO_END
};

static GnomeUIInfo menubar_uiinfo[] =
{
  GNOMEUIINFO_MENU_FILE_TREE (file_menu_uiinfo),
  GNOMEUIINFO_MENU_EDIT_TREE (edit_menu_uiinfo),
  GNOMEUIINFO_MENU_SETTINGS_TREE (properties_menu_uiinfo),
  GNOMEUIINFO_MENU_VIEW_TREE (view_menu_uiinfo),
  GNOMEUIINFO_MENU_HELP_TREE (help_menu_uiinfo),
  GNOMEUIINFO_END
};


#endif
