/*
*  program name: Rubrica <http://digilander.iol.it/nfragale/download.html>
*  file: prefer_int.h
*  
*  Copyright (C) 2000-2003 Nicola Fragale <nicolafragale@libero.it>
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <gnome.h>
#include <gconf/gconf-client.h>

#include "rubrica_type.h"

#ifndef _RUBRICA_PREFERENCES_INT_H
#define _RUBRICA_PREFERENCES_INT_H

/* RP -- RubricaPreferences */

enum
  {
    RP_PIXMAP_COLUMN,
    RP_STRING_COLUMN,
    RP_HAVE_PAGE,
    RP_PAGE_COLUMN,
    RP_LAST_COLUMN
  };

enum
  {
    RP_VIEW_CHECK_COLUMN,
    RP_VIEW_LABEL_COLUMN,
    RP_VIEW_KEY_COLUMN,
    RP_VIEW_LAST_COLUMN
  };

typedef int (*RubricaFunc) (GConfClient *client, gchar *str);

typedef struct _RubricaPreferItem RubricaPreferItem;

struct _RubricaPreferItem {
  gchar *label;
  gchar *str;       /* pixmap name or configuration key */
  gboolean bool;    /* have_page or configuration default value */
  RubricaFunc func;

  RubricaPreferItem *children;
};

GtkWidget* rubrica_preferences_get_preferencesbox(void);
GtkWidget* rubrica_preferences_get_notebook(void);
GtkWidget* create_preferences_dialog (GtkWidget *app, GConfClient *client);


/* create the model for preferences index tree 
*/
GtkTreeModel *rubrica_preferences_create_tree_model(GConfClient *client);

/* create the view for preferences tree 
*/
GtkWidget *rubrica_preferences_create_new_tree_view(GtkTreeModel *model,
						    GtkWidget *notebook);

/* create a list model 
 */
GtkTreeModel *rubrica_preferences_create_list_model(GConfClient *client, 
						    RubricaTreeType type);

/* create a list view using a card or account or data model 
*/
GtkWidget *
rubrica_preferences_create_list_view_with_model(GtkTreeModel *model,
						RubricaTreeType type);
/* add the rigth columns to the list view 
*/
void rubrica_preferences_add_columns(GtkTreeView *tree, RubricaTreeType type);


/* list/tree view callbacks 
*/
void rubrica_preferences_row_selected(GtkTreeSelection *select, gpointer data);
void rubrica_preferences_manage_columns(GtkCellRendererToggle *cell, 
					gchar *path_str, gpointer data);


/*  interface creation
*/
GtkWidget* rubrica_preferences_build_notebook_list_page(GConfClient *client, 
							gchar *frame_label, 
							gchar *str, 
							RubricaTreeType type);
GtkWidget* rubrica_preferences_build_notebook_info_page(gchar *frame_label, 
							gchar *pixfile, 
							gchar *str);
int rubrica_preferences_file_info(GConfClient *client, gchar *frame_label);
int rubrica_preferences_general_info(GConfClient *client, gchar *frame_label);
int rubrica_preferences_view_info(GConfClient *client, gchar *frame_label);
int rubrica_preferences_crypto_info(GConfClient *client, gchar *frame_label);
int rubrica_preferences_trans_info(GConfClient *client, gchar *frame_label);
int rubrica_not_implemented(GConfClient *client, gchar *frame_label);

int rubrica_preferences_default(GConfClient *client, gchar *frame_label);
int rubrica_preferences_file_settings(GConfClient *client, gchar *frame_label);
int rubrica_preferences_search(GConfClient *client, gchar *frame_label);
int rubrica_preferences_misc(GConfClient *client, gchar *frame_label);
int rubrica_preferences_view_cards_columns(GConfClient *client, 
					   gchar *frame_label);
int rubrica_preferences_view_account_columns(GConfClient *client, 
					     gchar *frame_label);

int rubrica_preferences_view_personal_data(GConfClient *client, 
					   gchar *frame_label);
int rubrica_preferences_view_company_data(GConfClient *client, 
					  gchar *frame_label);
int rubrica_preferences_view_note_data(GConfClient *client, 
				       gchar *frame_label);

int rubrica_preferences_dictionary(GConfClient *client, gchar *frame_label);

GtkWidget* rubrica_preferences_do_personal_page(void);
GtkWidget* rubrica_preferences_do_address_page(void);
GtkWidget* rubrica_preferences_do_communications_page(void);
GtkWidget* rubrica_preferences_do_work_page(void);
GtkWidget* rubrica_preferences_do_note_page(void);


#endif

