#!/usr/bin/python -u

##############################################################################################
##############################################################################################
##
##	Nome: rub2html.py
##	versione: 0.2 
##	Copyright (C) 2000-2002 Nicola Fragale <nicolafragale@libero.it>
##	
##	Scopo: Questo programma applica il foglio di stile rub2html.xsl ai file 
##             generati da Rubrica (.rub) producendo file html
##
##	       This program applies the stylesheet rub2html.xsl to rubrica's 
##             (.rub) file and build an html file
##       
##	This program is free software; you can redistribute it and/or modify
##	it under the terms of the GNU General Public License as published by
##  	the Free Software Foundation; either version 2 of the License, or
##  	(at your option) any later version.
##
##  	This program is distributed in the hope that it will be useful,
##  	but WITHOUT ANY WARRANTY; without even the implied warranty of
##  	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
##  	GNU General Public License for more details.
##
##  	You should have received a copy of the GNU General Public License
##  	along with this program; if not, write to the Free Software
##  	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
##  	
#############################################################################################
#############################################################################################

import sys
import libxml2
import libxslt
from gtk import *


def confirm_exit(*args):
	dialog = GtkDialog()
	dialog.set_border_width(3)
	
	vbox = GtkVBox()
	dialog.vbox.pack_start(vbox)

	label = GtkLabel("\nSei sicuro di voler uscire?\n")
	vbox.pack_start(label)

	yes = GtkButton("Si")
	no  = GtkButton("No")
	yes.connect("clicked", mainquit)
	no.connect("clicked", dialog.destroy)

	dialog.action_area.pack_start(yes)
	dialog.action_area.pack_start(no)

	vbox.show()
	label.show()
	yes.show()	
	no.show()
	dialog.show()


def export(rubfile, htmlfile, stylefile):
	styledoc = libxml2.parseFile(stylefile)
	style    = libxslt.parseStylesheetDoc(styledoc)
	doc      = libxml2.parseFile(rubfile)
	result   = style.applyStylesheet(doc, None)

	style.saveResultToFilename(htmlfile, result, 0)
	style.freeStylesheet()
	doc.freeDoc()
	result.freeDoc()
	
	
def call_export(widget, data):
	rub   = data.get_data("rub")
	html  = data.get_data("html")
	style = data.get_data("style")
	
	rubfile   =  rub.get_text()
	htmlfile  =  html.get_text()
	stylefile =  style.get_text() 

	# verificare che i file esistono
	# altrimenti segnalare l'errore
	
	export(rubfile, htmlfile, stylefile)	


def main():
	window = GtkWindow(WINDOW_TOPLEVEL)
	window.connect("destroy", mainquit)
	window.set_border_width(10)

	vbox = GtkVBox(homogeneous=FALSE, spacing=5)
	window.add(vbox)
	window.set_usize(500,160)

	label = GtkLabel("Usage: rub2html.py file.rub file.html stylesheet.xsl\n")
	vbox.pack_start(label, TRUE, TRUE, 2)

	table = GtkTable(rows=3, cols=2, homogeneous=1)
	vbox.pack_start(table)
	table.show()

	rubfile = GtkLabel("File da esportare:")
	rubfile.show()
	table.attach(rubfile, 0, 1, 0, 1)

	rubentry = GtkEntry()
	if len(sys.argv) == 2:
		rubentry.set_text(sys.argv[1])
	rubentry.show()
	table.attach(rubentry, la=1, ra=2, ta=0, ba=1)

	htmlfile = GtkLabel("Nome del file esportato")
	table.attach(htmlfile, 0, 1, 1, 2)
	
	htmlentry = GtkEntry()
	table.attach(htmlentry, 1, 2, 1, 2)

	style = GtkLabel("Foglio di stile da applicare:")
	table.attach(style, 0, 1, 2, 3)
	
	styleentry = GtkEntry()
	styleentry.set_text("/usr/share/rubrica/stylesheet/rub2html.xsl")
	table.attach(styleentry, 1, 2, 2, 3)

	sep = GtkHSeparator()
	sep.show()
	vbox.pack_start(sep)
	
	hbox = GtkHBox(TRUE, 2)
	hbox.show()
	vbox.pack_start(hbox)
	
	export_bt = GtkButton("Esporta")
	export_bt.set_data("rub", rubentry)
	export_bt.set_data("html", htmlentry)
	export_bt.set_data("style", styleentry)

	export_bt.connect("clicked", call_export, export_bt)
	hbox.pack_start(export_bt, TRUE, TRUE, 2)

	esci = GtkButton("Esci")
	esci.connect("clicked", confirm_exit)
	hbox.pack_start(esci, TRUE, TRUE, 2)

	window.show_all()
	mainloop()

if len(sys.argv) > 3:	
	export(sys.argv[1], sys.argv[2], sys.argv[3])

else:
	if __name__ == '__main__':
		main()
	

