<?xml version="1.0" ?>

<!-- 	 
##################################################################################### 
##################################################################################### 
##
##	Nome: rub2html.xsl
##	versione: 0.1 
##	Copyright (C) 2000-2002 Nicola Fragale <nicolafragale@libero.it>
##	
##	Scopo: Questo foglio di stile traduce i file generati da Rubrica (.rub) in html
##	       This stylesheet translate rubrica's (.rub) file in html
##       
##	This program is free software; you can redistribute it and/or modify
##	it under the terms of the GNU General Public License as published by
## 	the Free Software Foundation; either version 2 of the License, or
##  	(at your option) any later version.
##
## 	This program is distributed in the hope that it will be useful,
##  	but WITHOUT ANY WARRANTY; without even the implied warranty of
##  	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
##  	GNU General Public License for more details.
##
##  	You should have received a copy of the GNU General Public License
##  	along with this program; if not, write to the Free Software
##  	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
##  	
####################################################################################
####################################################################################
-->
	
	<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">	
	
		<xsl:template match="Rubrica">
			<html>
				<head>
					<title>Rubrica</title>
				</head>
				
				<body>
					<h1>Rubrica's Addressbook</h1>
					
					<hr/>
					<h2>Cards in addressbook</h2>
					<xsl:apply-templates select="Card" mode="toc"/>
					<br/><hr/><br/>
						
					<xsl:apply-templates/>

					<p><hr/></p>
					generated by rub2html (ver 0.1) <br/>
					<a href="http://digilander.iol.it/nfragale">Rubrica</a>
					&#169; 2000-2002 
					<a href="mailto:nicolafragale@libero.it">Nicola Fragale</a>
					<br/>This program is released under terms of GPL 2.0
					<br/><br/>
					
				</body>
			</html>			
		</xsl:template>
		
		<!--				Generatore dell'indice
						Index (toc) generator
		-->
		<xsl:template match="Card" mode="toc">
			<br/><a href="#{./@name}"><xsl:value-of select="@name"/></a>
		</xsl:template>
		
		
		<!--				Card/Scheda
		-->
		<xsl:template match="Card">
			<br/>
			<h2>
				<a name="{./@name}"></a>
				Card: <xsl:value-of select="@name"/>
			</h2>
						
			<xsl:apply-templates select="Data"/> <br/>
			<xsl:apply-templates select="Address"/> <br/>
			<xsl:apply-templates select="WebAddresses"/> <br/>
			<xsl:apply-templates select="EmailAddresses"/> <br/>
         <xsl:apply-templates select="TelephoneNumbers"/> <br/>		
			<xsl:apply-templates select="Company"/> <br/>
			<xsl:apply-templates select="Work"/>  <br/>
			<xsl:apply-templates select="Notes"/> <br/>

		</xsl:template>
		
		
		<!--			Personal infos/Dati Personali
		-->
		<xsl:template match="Data"> 			
			<b>Personal Data</b> <br/>
			
			<xsl:value-of select="FirstName"/> &#160;
			<xsl:value-of select="MiddleName"/> &#160;
			<xsl:value-of select="LastName"/> &#160;
			
			<xsl:if test="NamePrefix!=''">
				<br/>Name Prefix:
				<xsl:value-of select="NamePrefix"/>
			</xsl:if>
			
			<xsl:if test="Title!=''">
				<br/>Title:
				<xsl:value-of select="Title"/>
			</xsl:if>
			
			<xsl:if test="FirstName/@know_birthday='true'">
				<br/>Birthday: <xsl:value-of select="FirstName/@birthday"/>
			</xsl:if>
			
			<xsl:if test="Profession!=''">
				<br/>Profession:
				<xsl:value-of select="Profession"/>
			</xsl:if>
		</xsl:template>		 

		
		<!--			Address/Indirizzo
		-->
		<xsl:template match="Address">
			<br/><b>Address</b> <br/>
			
			<xsl:if test="Street!=''">
				Street <xsl:value-of select="Street"/> &#160;
				<xsl:value-of select="StreetNumber"/>
			</xsl:if>
			
			<br/>
			<xsl:if test="ZipCode!=''">
				<xsl:value-of select="ZipCode"/> &#160;
			</xsl:if>
			
			<xsl:if test="City!=''">
				<xsl:value-of select="City"/> &#160;
			</xsl:if>
			
			<xsl:if test="Province!=''">
				<xsl:value-of select="Province"/> &#160;
			</xsl:if>
			
			<xsl:if test="State!=''">	
				<xsl:value-of select="State"/> &#160;
			</xsl:if>
				
			<xsl:if test="Country!=''">
				<xsl:value-of select="Country"/> &#160;
			</xsl:if>
		</xsl:template>
		
		
		<!-- 			Web 
		-->
		<xsl:template match="WebAddresses">			
			<br/><b>Web Pages</b>: <br/>
			<xsl:apply-templates select="Web"/>
		</xsl:template>		
	
		<xsl:template match="Web">
			<a href="{.}"><xsl:value-of select="."/></a> <br/>
		</xsl:template>			
	
		<!-- 			Email 
		-->
		<xsl:template match="EmailAddresses">			
			<b>Emails</b>: <br/>
			<xsl:apply-templates select="Email"/>			
		</xsl:template>
		
		<xsl:template match="Email">
			<a href="mailto:{.}"><xsl:value-of select="."/></a> <br/>
		</xsl:template>
		

		<!-- 			Telephone/Telefono 
		-->
		<xsl:template match="TelephoneNumbers">			
			<b>Telephone Numbers</b> <br/>
			<xsl:apply-templates select="Telephone"/>			
		</xsl:template>		
		
		<xsl:template match="Telephone">
			Telephone <xsl:value-of select="@type"/>: 
			<xsl:value-of select="."/> <br/>
		</xsl:template>
				
				
		<!--			Company/Azienda
		-->
		<xsl:template match="Company">
			<b>Company Infos</b>
			<xsl:if test="CompanyName!=''">
				<br/><xsl:value-of select="CompanyName"/> <br/>
			
				<xsl:if test="Street!=''">
					Street: 					
					<xsl:value-of select="Street"/>  &#160;
					<xsl:value-of select="StreetNumber"/> &#160;
					<xsl:value-of select="ZipCode"/> &#160;
					<xsl:value-of select="City"/> &#160;
					<xsl:value-of select="Province"/> &#160;
					<xsl:value-of select="Country"/> &#160;
				</xsl:if>
		
				<xsl:if test="Web!='' or Email!=''">
					<br/>Net:<br/>
					web page: <a href="{Web}">
						<xsl:value-of select="Web"/></a> <br/>
					email: <a href="mailto:{Email}">
						<xsl:value-of select="Email"/></a> <br/>
				</xsl:if>
			
				<xsl:if test="Operator!='' or Fax!='' or Green!='' or CustomerCare!=''">
					Telephone: <br/>
					Operator: <xsl:value-of select="Operator"/> <br/>
					Fax: <xsl:value-of select="Fax"/> <br/>
					Green: <xsl:value-of select="Green"/> <br/>
					Customer Care: <xsl:value-of select="CustomerCare"/> <br/>
				</xsl:if>

				<xsl:if test="Notes!=''">
					Notes: <br/>
					<xsl:value-of select="Notes"/>
				</xsl:if>			
			</xsl:if>			
		</xsl:template>
		

		<!--			Assigment/Impiego
		-->		
		<xsl:template match="Work">
			<br/><b>Contact Assigment</b>  <br/>
			<xsl:if test="Assigment!=''">
				Impiego:
				<xsl:value-of select="Assigment"/> <br/>
			</xsl:if>						

			<xsl:if test="Organization!=''">
				Organization:     
				<xsl:value-of select="Organization"/> <br/>
			</xsl:if>

			<xsl:if test="Department!=''">
				Department:	     
				<xsl:value-of select="Department"/> <br/>
			</xsl:if>

			<xsl:if test="SubDepartment!=''">
				Sub Department: 
				<xsl:value-of select="SubDepartment"/> <br/>
			</xsl:if>

			<xsl:if test="SecretaryName!=''">
				Secretary:	     
				<xsl:value-of select="SecretaryName"/> <br/>
			</xsl:if>

			<xsl:if test="SecretaryPhone!=''">
				Secretary Phone: 
				<xsl:value-of select="SecretaryPhone"/>  <br/>
			</xsl:if>
		</xsl:template>		


		<!--			Notes/Note
		-->
		<xsl:template match="Notes">			
			<b>Notes</b> <br/>

			<xsl:if test="@married='true'">
				Is married <br/>
				Spouse Name: <xsl:value-of select="SpouseName"/> <br/>
				Spouse Birthday: <xsl:value-of select="SpouseName/@birthday"/> <br/>
				Anniversary: <xsl:value-of select="SpouseName/@anniversary"/> <br/>
			</xsl:if>

			<xsl:if test="@married='false'">
				Is not married <br/>
			</xsl:if>			

			<xsl:if test="@children='true'">
				Has children <br/>
				Children:  <xsl:value-of select="Child"/> <br/>
			</xsl:if>

			<xsl:if test="@children='false'">
				Hasn't children <br/>
			</xsl:if>
			
			<xsl:if test="Hobbies!=''">
				Hobbies:
				<xsl:value-of select="Hobbies"/> <br/>
			</xsl:if>
			
			<xsl:if test="OtherNotes!=''">
				Notes:
				<xsl:value-of select="OtherNotes"/> <br/>
			</xsl:if>
			
			<xsl:if test="PublicKey!=''">
				Public key:
				<xsl:value-of select="PublicKey"/> <br/>
			</xsl:if>
			
		
		</xsl:template>		

	</xsl:stylesheet>

		<!-- 	end of file
		-->
