/*
*  Rubrica
*  file: sort.h
*  
*  Copyright (C) 2000-2003 Nicola Fragale <nicolafragale@libero.it>
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef _RUBRICA_SORT_H
#define _RUBRICA_SORT_H_

#include <gnome.h>
#include <gconf/gconf-client.h>
#include "rubrica_type.h"

void rubrica_sort_init(void);

RubricaSortType rubrica_sort_get_sort_type(void);
RubricaSortDirectionType rubrica_sort_get_sort_direction(void);

void rubrica_sort_set_sort_type(RubricaSortType type);
void rubrica_sort_set_sort_direction(RubricaSortDirectionType direction);

void 
rubrica_sort_notify_sort_type_changes(GConfClient *client, guint cnxn_id, 
				      GConfEntry *entry, gpointer data);
void 
rubrica_sort_notify_sort_direction_changes(GConfClient *client,	guint cnxn_id, 
					   GConfEntry *entry, gpointer data);

gint rubrica_sort_alfa(GtkTreeModel *model, GtkTreeIter *a, 
		       GtkTreeIter *b, gpointer data);
gint rubrica_sort_date(GtkTreeModel *model, GtkTreeIter *a, 
		       GtkTreeIter *b, gpointer data);

#endif











