/*
*  Rubrica
*  file: vcard.h
*  
*  Copyright (C) Nicola Fragale <nicolafragale@libero.it>
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef _RUBRICA_VCARD_H
#define _RUBRICA_VCARD_H

#include <stdio.h>
#include <glib.h>
#include <glib-object.h>

#define RUBRICA_VCARD_TYPE            (rubrica_vcard_get_type())
#define RUBRICA_VCARD(obj)            (G_TYPE_CHECK_INSTANCE_CAST((obj),      \
                                       RUBRICA_VCARD_TYPE, RubricaVCard))
#define RUBRICA_VCARD_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass),       \
                                       RUBRICA_VCARD_TYPE, RubricaVCardClass))
#define IS_RUBRICA_VCARD(obj)         (G_TYPE_CHECK_INSTANCE_TYPE((obj),      \
                                       RUBRICA_VCARD_TYPE))
#define IS_RUBRICA_VCARD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass),       \
                                       RUBRICA_VCARD_TYPE))
#define RUBRICA_VCARD_GET_CLASS(obj)  (G_TYPE_CHECK_INSTANCE_GET_CLASS((obj), \
                                       RUBRICA_VCARD_TYPE, RubricaVCardClass))


typedef struct _RubricaVCard          RubricaVCard;
typedef struct _RubricaVCardClass     RubricaVCardClass;
typedef struct _RubricaVCardPrivate   RubricaVCardPrivate;
typedef struct _RubricaVCardData      RubricaVCardData;
typedef struct _RubricaVCardAddress   RubricaVCardAddress;
typedef struct _RubricaVCardTelephone RubricaVCardTelephone;
typedef struct _RubricaVCardType      RubricaVCardType;

#undef VERSION

/* error code returned by rubrica_vcard_open_file 
*/
enum {
  RUBRICA_VCARD_FILE_OPEN_SUCCESS,
  RUBRICA_VCARD_FILE_OPEN_FAIL,
  RUBRICA_VCARD_FILE_IMPORT_SUCCESS
};


typedef enum {
  EVOLUTION_EXT = 0,
  KADDRBOOK_EXT,
  RUBRICA_EXT,
  VCARD_EXT,
  BAD_EXT
} RubricaVCardExt;


struct _RubricaVCardAddress {
  gchar* pbox;           /* post offix box   */
  gchar* extadd;         /* extended address */
  gchar* str;            /* street address   */
  gchar* loc;            /* locality (city)  */
  gchar* reg;            /* region (state/province) */
  gchar* code;           /* postal code  */
  gchar* count;          /* country name */
  gchar* type;           /* address type */
};


struct _RubricaVCardTelephone {
  gchar* num;
  gchar* type;
};


struct _RubricaVCard 
{
  GObject parent;
  
  FILE* fp;               /* vcard file */

  /* private */
  RubricaVCardPrivate* private;
};

struct _RubricaVCardClass
{
  GObjectClass parent;
  
  /* signals */
  void (*vcard_file_opened)  (RubricaVCard*);
  void (*vcard_decoded_item) (RubricaVCard*);
  void (*vcard_decoded)      (RubricaVCard*);
};

/*
  signal string:
  vcard_file_open              -- emitted when a vcard file has been opened
                                  (whith error code on error or success)
  vcard_decode_card            -- emitted when a card has been read
  vcard_decode_addressbook     -- emitted when vcard addressbook has been read
*/

typedef enum {
  N = 1, 
  FN, 
  TZ, 
  END, 
  ADR, 
  TEL, 
  GEO, 
  ORG, 
  REV, 
  UID, 
  URL, 
  KEY, 
  BDAY, 
  ROLE, 
  LOGO, 
  NOTE, 
  BEGIN,
  PHOTO, 
  LABEL,
  EMAIL, 
  TITLE, 
  AGENT, 
  PROID, 
  SOUND, 
  CLASS,
  MAILER, 
  VERSION,
  NICKNAME, 
  CATEGORIES,                  // last vcard token

  KDE_EXT_Profession,          // KDE extensions
  KDE_EXT_Department,
  KDE_EXT_ManagersName,
  KDE_EXT_AssistantsName,
  KDE_EXT_Office,
  KDE_EXT_SpousesName,
  KDE_EXT_Anniversary,
  KDE_EXT_CUSTOM,

  RUBRICA_EXT_Group,           // Rubrica extensions
  RUBRICA_EXT_CompanyName,
  RUBRICA_EXT_Street,
  RUBRICA_EXT_StreetNumber,
  RUBRICA_EXT_ZipCode,
  RUBRICA_EXT_City,
  RUBRICA_EXT_Province,
  RUBRICA_EXT_Country,
  RUBRICA_EXT_Web,
  RUBRICA_EXT_Email,
  RUBRICA_EXT_Operator,
  RUBRICA_EXT_Fax,
  RUBRICA_EXT_Green,
  RUBRICA_EXT_CustomerCare,
  RUBRICA_EXT_Notes,
  RUBRICA_EXT_Department,
  RUBRICA_EXT_SubDepartment,
  RUBRICA_EXT_SecretaryName,
  RUBRICA_EXT_SecretaryPhone,
  RUBRICA_EXT_SpouseName,
  RUBRICA_EXT_Child,
  RUBRICA_EXT_Hobbies,

  BAD_TOKEN                   // this isn't a VCard token
} RubricaVCardTokenType;


typedef enum {
  TYPE = 1, 
  VALUE, 
  ENCODING,
  BAD_PARAM                   // this isn't a VCard token
} RubricaVCardParamType;


typedef enum {
  VCARD = 1,
  BINARY,
  BASIC, 
  PUBLIC, 
  PRIVATE, 
  CONFIDENTIAL,
  HOME,  
  WORK, 
  POSTAL, 
  PARCEL, 
  DOM, 
  INTL, 
  PREF,
  VOICE, 
  FAX, 
  MSG, 
  CELL, 
  PAGER, 
  BBS, 
  MODEM, 
  CAR, 
  ISDN, 
  VIDEO,  
  AOL, 
  INTERNET,
  APPLELINK, 
  ATTMAIL, 
  CIS, 
  EWORLD, 
  IBMMail, 
  MCIMAIL, 
  POWERSHARE, 
  PRODIGY, 
  TLX, 
  X400, 
  PGP, 
  X509, 
  TEXT,
  URI,
  JPEG,
  QUOTED_PRINTABLE,
  BAD_VALUE                       // this isn't a vcard token
} RubricaVCardValueType;



struct _RubricaVCardType {
  gchar *str;                /* token */
  gint tok;                  /* vcard decoded token */
};



GType         rubrica_vcard_get_type   (void);


/* ************ Public ************
*/

RubricaVCard* rubrica_vcard_new          (void);
gint          rubrica_vcard_open_file    (RubricaVCard* vcard, 
					  gchar* filename);

void          rubrica_vcard_free_vcard   (RubricaVCard *vcard);

gchar*        rubrica_vcard_get_fn       (RubricaVCard* vcard);
gchar*        rubrica_vcard_get_n        (RubricaVCard* vcard);
gchar*        rubrica_vcard_get_gn       (RubricaVCard* vcard);
gchar*        rubrica_vcard_get_an       (RubricaVCard* vcard);
gchar*        rubrica_vcard_get_hp       (RubricaVCard* vcard);
gchar*        rubrica_vcard_get_hs       (RubricaVCard* vcard);
gchar*        rubrica_vcard_get_email    (RubricaVCard* vcard);
gchar*        rubrica_vcard_get_url      (RubricaVCard* vcard);
gchar*        rubrica_vcard_get_bday     (RubricaVCard* vcard);
gchar*        rubrica_vcard_get_title    (RubricaVCard* vcard);
gchar*        rubrica_vcard_get_org      (RubricaVCard* vcard);
gchar*        rubrica_vcard_get_role     (RubricaVCard* vcard);
gchar*        rubrica_vcard_get_note     (RubricaVCard* vcard);
gchar*        rubrica_vcard_get_key      (RubricaVCard* vcard);

gchar*        rubrica_vcard_get_pbox     (RubricaVCard* vcard);
gchar*        rubrica_vcard_get_extadd   (RubricaVCard* vcard);
gchar*        rubrica_vcard_get_str      (RubricaVCard* vcard);
gchar*        rubrica_vcard_get_loc      (RubricaVCard* vcard);
gchar*        rubrica_vcard_get_reg      (RubricaVCard* vcard);
gchar*        rubrica_vcard_get_code     (RubricaVCard* vcard);
gchar*        rubrica_vcard_get_count    (RubricaVCard* vcard);
gchar*        rubrica_vcard_get_adr_type (RubricaVCard* vcard);
gchar*        rubrica_vcard_get_tel_num  (RubricaVCard* vcard);
gchar*        rubrica_vcard_get_tel_type (RubricaVCard* vcard);

RubricaVCardAddress*   rubrica_vcard_get_adr (RubricaVCard* vcard);
RubricaVCardTelephone* rubrica_vcard_get_tel (RubricaVCard* vcard);
// RubricaVCardGroup*     rubrica_vcard_get_grp (RubricaVCard* vcard);

gboolean rubrica_vcard_next_email (RubricaVCard* vcard);
gboolean rubrica_vcard_next_url   (RubricaVCard* vcard);
gboolean rubrica_vcard_next_adr   (RubricaVCard* vcard);
gboolean rubrica_vcard_next_tel   (RubricaVCard* vcard);
gboolean rubrica_vcard_next_grp   (RubricaVCard* vcard);

#endif
