# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator 0.17.0.0
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::ARM::Compute
  #
  # A service client - single point of access to the REST API.
  #
  class ComputeManagementClient < MsRestAzure::AzureServiceClient
    include MsRestAzure
    include MsRestAzure::Serialization

    # @return [String] the base URI of the service.
    attr_accessor :base_url

    # @return Credentials needed for the client to connect to Azure.
    attr_reader :credentials

    # @return [String] subscription credentials which uniquely identify
    # Microsoft Azure subscription. The subscription ID forms part of the URI
    # for every service call.
    attr_accessor :subscription_id

    # @return [String] Gets or sets the preferred language for the response.
    attr_accessor :accept_language

    # @return [Integer] Gets or sets the retry timeout in seconds for Long
    # Running Operations. Default value is 30.
    attr_accessor :long_running_operation_retry_timeout

    # @return [Boolean] When set to true a unique x-ms-client-request-id value
    # is generated and included in each request. Default is true.
    attr_accessor :generate_client_request_id

    # @return Subscription credentials which uniquely identify client
    # subscription.
    attr_accessor :credentials

    # @return [AvailabilitySets] availability_sets
    attr_reader :availability_sets

    # @return [VirtualMachineExtensionImages] virtual_machine_extension_images
    attr_reader :virtual_machine_extension_images

    # @return [VirtualMachineExtensions] virtual_machine_extensions
    attr_reader :virtual_machine_extensions

    # @return [VirtualMachineImages] virtual_machine_images
    attr_reader :virtual_machine_images

    # @return [UsageOperations] usage_operations
    attr_reader :usage_operations

    # @return [VirtualMachineSizes] virtual_machine_sizes
    attr_reader :virtual_machine_sizes

    # @return [VirtualMachines] virtual_machines
    attr_reader :virtual_machines

    # @return [VirtualMachineScaleSets] virtual_machine_scale_sets
    attr_reader :virtual_machine_scale_sets

    # @return [VirtualMachineScaleSetVMs] virtual_machine_scale_set_vms
    attr_reader :virtual_machine_scale_set_vms

    # @return [ContainerServiceOperations] container_service_operations
    attr_reader :container_service_operations

    #
    # Creates initializes a new instance of the ComputeManagementClient class.
    # @param credentials [MsRest::ServiceClientCredentials] credentials to authorize HTTP requests made by the service client.
    # @param base_url [String] the base URI of the service.
    # @param options [Array] filters to be applied to the HTTP requests.
    #
    def initialize(credentials, base_url = nil, options = nil)
      super(credentials, options)
      @base_url = base_url || 'https://management.azure.com'

      fail ArgumentError, 'credentials is nil' if credentials.nil?
      fail ArgumentError, 'invalid type of credentials input parameter' unless credentials.is_a?(MsRest::ServiceClientCredentials)
      @credentials = credentials

      @availability_sets = AvailabilitySets.new(self)
      @virtual_machine_extension_images = VirtualMachineExtensionImages.new(self)
      @virtual_machine_extensions = VirtualMachineExtensions.new(self)
      @virtual_machine_images = VirtualMachineImages.new(self)
      @usage_operations = UsageOperations.new(self)
      @virtual_machine_sizes = VirtualMachineSizes.new(self)
      @virtual_machines = VirtualMachines.new(self)
      @virtual_machine_scale_sets = VirtualMachineScaleSets.new(self)
      @virtual_machine_scale_set_vms = VirtualMachineScaleSetVMs.new(self)
      @container_service_operations = ContainerServiceOperations.new(self)
      @accept_language = 'en-US'
      @long_running_operation_retry_timeout = 30
      @generate_client_request_id = true
    end

  end
end
