# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator 0.17.0.0
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::ARM::DevTestLabs
  #
  # A service client - single point of access to the REST API.
  #
  class DevTestLabsClient < MsRestAzure::AzureServiceClient
    include MsRestAzure
    include MsRestAzure::Serialization

    # @return [String] the base URI of the service.
    attr_accessor :base_url

    # @return Credentials needed for the client to connect to Azure.
    attr_reader :credentials

    # @return [String] Client API version.
    attr_reader :api_version

    # @return [String] The subscription ID.
    attr_accessor :subscription_id

    # @return [String] Gets or sets the preferred language for the response.
    attr_accessor :accept_language

    # @return [Integer] Gets or sets the retry timeout in seconds for Long
    # Running Operations. Default value is 30.
    attr_accessor :long_running_operation_retry_timeout

    # @return [Boolean] When set to true a unique x-ms-client-request-id value
    # is generated and included in each request. Default is true.
    attr_accessor :generate_client_request_id

    # @return Subscription credentials which uniquely identify client
    # subscription.
    attr_accessor :credentials

    # @return [LabOperations] lab_operations
    attr_reader :lab_operations

    # @return [ArtifactSourceOperations] artifact_source_operations
    attr_reader :artifact_source_operations

    # @return [ArtifactOperations] artifact_operations
    attr_reader :artifact_operations

    # @return [CostOperations] cost_operations
    attr_reader :cost_operations

    # @return [CustomImageOperations] custom_image_operations
    attr_reader :custom_image_operations

    # @return [FormulaOperations] formula_operations
    attr_reader :formula_operations

    # @return [GalleryImageOperations] gallery_image_operations
    attr_reader :gallery_image_operations

    # @return [PolicySet] policy_set
    attr_reader :policy_set

    # @return [PolicyOperations] policy_operations
    attr_reader :policy_operations

    # @return [ScheduleOperations] schedule_operations
    attr_reader :schedule_operations

    # @return [VirtualMachine] virtual_machine
    attr_reader :virtual_machine

    # @return [VirtualNetworkOperations] virtual_network_operations
    attr_reader :virtual_network_operations

    #
    # Creates initializes a new instance of the DevTestLabsClient class.
    # @param credentials [MsRest::ServiceClientCredentials] credentials to authorize HTTP requests made by the service client.
    # @param base_url [String] the base URI of the service.
    # @param options [Array] filters to be applied to the HTTP requests.
    #
    def initialize(credentials, base_url = nil, options = nil)
      super(credentials, options)
      @base_url = base_url || 'https://management.azure.com'

      fail ArgumentError, 'credentials is nil' if credentials.nil?
      fail ArgumentError, 'invalid type of credentials input parameter' unless credentials.is_a?(MsRest::ServiceClientCredentials)
      @credentials = credentials

      @lab_operations = LabOperations.new(self)
      @artifact_source_operations = ArtifactSourceOperations.new(self)
      @artifact_operations = ArtifactOperations.new(self)
      @cost_operations = CostOperations.new(self)
      @custom_image_operations = CustomImageOperations.new(self)
      @formula_operations = FormulaOperations.new(self)
      @gallery_image_operations = GalleryImageOperations.new(self)
      @policy_set = PolicySet.new(self)
      @policy_operations = PolicyOperations.new(self)
      @schedule_operations = ScheduleOperations.new(self)
      @virtual_machine = VirtualMachine.new(self)
      @virtual_network_operations = VirtualNetworkOperations.new(self)
      @api_version = '2016-05-15'
      @accept_language = 'en-US'
      @long_running_operation_retry_timeout = 30
      @generate_client_request_id = true
    end

  end
end
