#! /usr/bin/env ruby
#
#----------------------------------------------------------------------
# 
# This program is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by the Free
# Software Foundation; either version 2 of the License, or (at your option)
# any later version. This program is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
# Public License for more details; it is available at
# <http://www.fsf.org/copyleft/gpl.html>, or by writing to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
# 
# Written by Gordon Miller <gmiller@bittwiddlers.com>. Inspired by and partly
# derived from the Python version by Michael Haggerty. If you find a problem
# or have a suggestion, please let me know at <gmiller@bittwiddlers.com>.
# Other feedback would also be appreciated.
#
#----------------------------------------------------------------------
#
# This is the main module of the Gnuplot package.
#
#---------------------------------------------------------------------- 

version = '1.4'
cvs_version = '$Revision: 1.3 $'

require 'gplot/Stream'
require 'gplot/PlotItem'
require 'gplot/Plot'

if __FILE__ == $0
  require 'narray'

  data = NArray.sfloat (3, 5).indgen!
  ds = DataSet.new (data)
  
  stream = GnuplotStream.new ()
  ds.pipein(stream)
end

# $Id: Gnuplot.rb,v 1.3 2001/01/25 06:49:08 gmiller Exp $
