/*
 * RailsAdmin remote form @VERSION
 *
 * License
 *
 * http://www.railsadmin.org
 *
 * Depends:
 *   jquery.ui.core.js
 *   jquery.ui.widget.js
 *   jquery.ui.dialog.js
 */
(function($) {
  $.widget("ra.remoteForm", {

    _create: function() {
      var widget = this
      var dom_widget = widget.element;

      var edit_url = dom_widget.find('select').first().data('options') && dom_widget.find('select').first().data('options')['edit-url'];
      if(typeof(edit_url) != 'undefined' && edit_url.length) {
        dom_widget.on('dblclick', '.ra-multiselect option', function(e){
          widget._bindModalOpening(e, edit_url.replace('__ID__', this.value))
        });
      }

      dom_widget.find('.create').unbind().bind("click", function(e){
        widget._bindModalOpening(e, $(this).data('link'))
      });

      dom_widget.find('.update').unbind().bind("click", function(e){
        if(value = dom_widget.find('select').val()) {
          widget._bindModalOpening(e, $(this).data('link').replace('__ID__', value))
        } else {
          e.preventDefault();
        }
      });
    },

    _bindModalOpening: function(e, url) {
      e.preventDefault();
      widget = this;
      if($("#modal").length)
        return false;

      var dialog = this._getModal();

      setTimeout(function(){ // fix race condition with modal insertion in the dom (Chrome => Team/add a new fan => #modal not found when it should have). Somehow .on('show') is too early, tried it too.
        $.ajax({
          url: url,
          beforeSend: function(xhr) {
            xhr.setRequestHeader("Accept", "text/javascript");
          },
          success: function(data, status, xhr) {
              dialog.find('.modal-body').html(data);
              widget._bindFormEvents();
          },
          error: function(xhr, status, error) {
            dialog.find('.modal-body').html(xhr.responseText);
          },
          dataType: 'text'
        });
      },200);

    },

    _bindFormEvents: function() {
      var widget = this,
          dialog = this._getModal(),
          form = dialog.find("form"),
          saveButtonText = dialog.find(":submit[name=_save]").html(),
          cancelButtonText = dialog.find(":submit[name=_continue]").html();
      dialog.find('.form-actions').remove();

      form.attr("data-remote", true);
      dialog.find('.modal-header-title').text(form.data('title'));
      dialog.find('.cancel-action').unbind().click(function(){
        dialog.modal('hide');
        return false;
      }).html(cancelButtonText);

      dialog.find('.save-action').unbind().click(function(){
        form.submit();
        return false;
      }).html(saveButtonText);

      $(document).trigger('rails_admin.dom_ready', [form])

      form.bind("ajax:complete", function(xhr, data, status) {
        if (status == 'error') {
          dialog.find('.modal-body').html(data.responseText);
          widget._bindFormEvents();
        } else {
          var json = $.parseJSON(data.responseText);
          var option = '<option value="' + json.id + '" selected>' + json.label + '</option>';
          var select = widget.element.find('select').filter(":hidden");

          if(widget.element.find('.filtering-select').length) { // select input
            var input = widget.element.find('.filtering-select').children('.ra-filtering-select-input');
            input.val(json.label);
            if (!select.find('option[value=' + json.id + ']').length) { // not a replace
              select.html(option).val(json.id);
              widget.element.find('.update').removeClass('disabled');
            }
          } else { // multi-select input
            var input = widget.element.find('.ra-filtering-select-input');
            var multiselect = widget.element.find('.ra-multiselect');
            if (multiselect.find('option[value=' + json.id + ']').length) { // replace
              select.find('option[value=' + json.id + ']').text(json.label);
              multiselect.find('option[value= ' + json.id + ']').text(json.label);
            } else { // add
              select.prepend(option);
              multiselect.find('select.ra-multiselect-selection').prepend(option);
            }
          }
          widget._trigger("success");
          dialog.modal("hide");
        }
      });
    },

    _getModal: function() {
      var widget = this;
      if (!widget.dialog) {
        widget.dialog = $('<div id="modal" class="modal fade">\
            <div class="modal-header">\
              <a href="#" class="close" data-dismiss="modal">&times;</a>\
              <h3 class="modal-header-title">...</h3>\
            </div>\
            <div class="modal-body">\
              ...\
            </div>\
            <div class="modal-footer">\
              <a href="#" class="btn cancel-action">...</a>\
              <a href="#" class="btn btn-primary save-action">...</a>\
            </div>\
          </div>')
          .modal({
            keyboard: true,
            backdrop: true,
            show: true
          })
          .on('hidden', function(){
            widget.dialog.remove();   // We don't want to reuse closed modals
            widget.dialog = null;
          });
        }
      return this.dialog;
    }
  });
})(jQuery);
