/*  Copyright (c) 2005 Romain BONDUE
    This file is part of RutilT.

    RutilT is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    RutilT is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with RutilT; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
/** \file ErrorsCode.h
    \author Romain BONDUE
    \date 05/07/2005 */
#ifndef __ERRORSCODE_H__
#define __ERRORSCODE_H__



namespace nsErrors
{
    enum ErrorsCode_t {InvalidArguments = 128, ProcParsing = 129,
                       NoDeviceFound = 130, OutOfMemory = 131,
                       GtkInitFailure = 132, ProfilesRecordFailure = 133,
                       ProfilesExtractionFailure = 134,
                       ProfilesExtractionMissingName = 135,
                       ProfilesExtractionMissingSSID = 136,
                       ProfilesExtractionMissingMode = 137,
                       ProfilesExtractionMissingChannel = 138,
                       ProfilesExtractionInvalidMode = 139,
                       ProfilesExtractionInvalidChannel = 140,
                       ProfilesExtractionInvalidKey = 141,
                       ProfilesExtractionExtraToken = 142,
                       ProfileFilePermissionError = 143, NoMatchingFreq = 144,
                       ScanningTimeOut = 145, RT2500SetIoctlNotFound = 146,
                       InvalidCommand = 147, UnknownHandler = 148,
                       InvalidData = 149, UnknownExc = 150, NoDriverSet = 151,
                       NoHandlerDefined = 152, InvalidRootPassword = 153,
                       InvalidDataFromHelper = 154, UnexpectedStreamEnd = 155,
                       RT2400AdHocLimitation = 156, StatsParsing = 157,
                       RT2570AdHocModeIoctlNotFound = 158,
                       RT2570EncIoctlNotFound = 159,
                       RT2570AuthIoctlNotFound = 160,
                       RT2570KeyIoctlNotFound = 161, InvalidInstanceNum = 162,
                       CodeNotTransmitted = 163,
                       OptionsExtractionInvalidValue = 164,
                       OptionsRecordFailure = 165};

} // namespace nsErrors

#endif // __ERRORSCODE_H__
