/*  Copyright (c) 2005 Romain BONDUE
    This file is part of RutilT.

    RutilT is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    RutilT is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with RutilT; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
/** \file RTDrivers.hxx
    \author Romain BONDUE
    \date 30/08/2005
    \warning This file should only be included from RTDrivers.h */
inline nsWireless::CRTDriver::CRTDriver (const std::string& DeviceName,
                                         int PrivateIoctl)
                                                throw (nsErrors::CSystemExc)
    : CWE17Driver (DeviceName), m_PrivateIoctl (PrivateIoctl) {}


inline int nsWireless::CRTDriver::GetPrivateIoctl () const throw()
{
    return m_PrivateIoctl;

} // GetPrivateIoctl()


inline void nsWireless::CRT2400Driver::GetScanResult
                                                (std::vector<CCell>& CellVec)
                            const throw (nsErrors::CException, std::bad_alloc)
{
        /* Don't call CWE17Driver::GetScanResult() because it's not supported
           by rt2400. */
    CRTDriver::GetScanResult (8001, CellVec);

} // GetScanResult()


inline bool nsWireless::CRT2500Driver::IsRfmontxSupported () const throw()
{
    return m_RfmontxIoctl != InvalidIoctl;

} // IsRfmontxSupported()


inline void nsWireless::CRT2500Driver::SetFlag (int Flag, bool B) throw()
{
    if (B) m_Flags |= Flag;
    else m_Flags &= ~Flag;

} // SetFlag()


inline void nsWireless::CRT2500Driver::SetWirelessMode (WirelessMode_e WMode)
                                                throw (nsErrors::CSystemExc)
{
    SetIoctl ("WirelessMode", WMode, "Can't set the wireless mode.");
    SetFlag (IsB_Only, WMode == B_Only);

} // SetWirelessMode()


inline void nsWireless::CRT2500Driver::SetTxBurst (bool B)
                                                throw (nsErrors::CSystemExc)
{
    SetIoctl ("TxBurst", B ? 1 : 0, "Can't set TxBurst.");
    SetFlag (TxBurst, B);

} // SetTxBurst()


inline void nsWireless::CRT2500Driver::SetBGProtection
                    (BGProtection_e Protection) throw (nsErrors::CSystemExc)
{
    SetIoctl ("BGProtection", Protection, "Can't set B/G protection.");
    m_BGProtection = Protection;

} // SetBGProtection()


inline void nsWireless::CRT2500Driver::SetTxPreamble (TxPreamble_e Preamble)
                                                throw (nsErrors::CSystemExc)
{
    SetIoctl ("TxPreamble", Preamble, "Can't set TxPreamble.");
    m_TxPreamble = Preamble;

} // SetTxPreamble()


inline void nsWireless::CRT2500Driver::SetTurboRate (bool B)
                                                throw (nsErrors::CSystemExc)
{
    SetIoctl ("TurboRate", B ? 1 : 0, "Can't set turbo rate.");
    SetFlag (TurboRate, B);

} // SetTurboRate()


inline void nsWireless::CRT2500Driver::SetAdHocOFDM (bool B)
                                                throw (nsErrors::CSystemExc)
{
    SetIoctl ("AdhocOfdm", B ? 1 : 0, "Can't set OFDM mode.");
    SetFlag (AdHocOFDM, B);

} // SetAdHocOFDM()


inline nsWireless::WirelessMode_e nsWireless::CRT2500Driver::GetWirelessMode ()
                                                                const throw()
{
    return m_Flags & IsB_Only ? B_Only : Mixed;

} // GetWirelessMode()


inline bool nsWireless::CRT2500Driver::GetTxBurst () const throw()
{
    return m_Flags & TxBurst;

} // GetTxBurst()


inline nsWireless::BGProtection_e nsWireless::CRT2500Driver::GetBGProtection ()
                                                                const throw()
{
    return m_BGProtection;

} // GetBGProtection()


inline nsWireless::TxPreamble_e nsWireless::CRT2500Driver::GetTxPreamble ()
                                                                const throw()
{
    return m_TxPreamble;

} // GetTxPreamble()


inline bool nsWireless::CRT2500Driver::GetTurboRate () const throw()
{
    return m_Flags & TurboRate;

} // GetTurboRate()


inline bool nsWireless::CRT2500Driver::GetAdHocOFDM () const throw()
{
    return m_Flags & AdHocOFDM;

} // GetAdHocOFDM()


inline bool nsWireless::CRT2500Driver::GetRfmontx () const throw()
{
    return m_Flags & Rfmontx;
    
} // GetRfmontx()


inline int nsWireless::CRT2500Driver::GetTxRate () const
                                                throw (nsErrors::CSystemExc)
{
    const int Rate (CWE17Driver::GetTxRate());
    return Rate == 5000 ? 5500 : Rate;

} // GetTxRate()


inline void nsWireless::CRT2500Driver::SetTxRate (int Rate)
                                                throw (nsErrors::CSystemExc)
{
    CWE17Driver::SetTxRate (Rate == 5500 ? 5000 : Rate);

} // SetTxRate()


inline void nsWireless::CRT2570Driver::PrivateIoctl (int IoctlCode, int Value,
                    const std::string& ErrorMsg) throw (nsErrors::CSystemExc)
{
    std::memcpy (m_Data.name, &Value, sizeof (Value));
    Ioctl (IoctlCode, ErrorMsg);

} // PrivateIoctl()


inline bool nsWireless::CRT2570Driver::IsRfmontxSupported () const throw()
{
    return m_RfmontxIoctl == InvalidIoctl;

} // IsRfmontxSupported()


inline void nsWireless::CRT2570Driver::SetRfmontx (bool B)
                                                throw (nsErrors::CSystemExc)
{
    PrivateIoctl (m_RfmontxIoctl, B ? 1 : 0, "Can't set rfmontx.");

} // SetRfmontx()


inline bool nsWireless::CRT2570Driver::IsPrismHeaderSupported () const throw()
{
    return m_PrismHeaderIoctl == InvalidIoctl;

} // IsPrismHeaderSupported()


inline void nsWireless::CRT2570Driver::SetPrismHeader (PrismMode_e PrismMode)
                                                throw (nsErrors::CSystemExc)
{
    PrivateIoctl (m_PrismHeaderIoctl, int (PrismMode),
                  "Can't force prism header.");

} // SetPrismHeader()


inline void nsWireless::CRT2570Driver::SetAdHocMode (AdHocMode_e Mode)
                                                throw (nsErrors::CSystemExc)
{
    PrivateIoctl (m_AdHocModeIoctl, int (Mode), "Can't set adhoc mode.");

} // SetAdHocMode()
