/*  Copyright (c) 2005 Romain BONDUE
    This file is part of RutilT.

    RutilT is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    RutilT is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with RutilT; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
/** \file WE17DriverRoot.h
    \author Romain BONDUE
    \date 17/02/2006 */
#ifndef __WE17DRIVERROOT_H__
#define __WE17DRIVERROOT_H__

#include "WE17Driver.h"
#include "SuWProtocol.h"



namespace nsWireless
{
    class CWE17DriverRoot : public CWE17Driver, protected CSuWProtocol
    {
      public :
        CWE17DriverRoot (const std::string&) throw (nsErrors::CSystemExc,
                                                    std::bad_alloc);
        ~CWE17DriverRoot () throw();

        void SetSSID (const std::string&) throw (nsErrors::CSystemExc);
        /** \param The unit is the GHz (2.462 for instance). */
        void SetFrequency (double) throw (nsErrors::CSystemExc);
        void SetChannel (unsigned) throw (nsErrors::CSystemExc);
        CEncryptionD GetEncryption () throw (nsErrors::CSystemExc,
                                             std::bad_alloc);
        void SetEncryption (const CEncryptionD&) throw (nsErrors::CSystemExc,
                                                        std::bad_alloc);
        void SetMode (Mode_e) throw (nsErrors::CSystemExc);
        /** \param The unit is the Kbps. */
        void SetTxRate (int) throw (nsErrors::CSystemExc);
        void SetAPMacAddr (const CMacAddress&) throw (std::bad_alloc,
                                                      nsErrors::CSystemExc);
        void Scan () throw (nsErrors::CSystemExc);

    }; // CWE17DriverRoot

} // namespace nsWireless

#include "private/WE17DriverRoot.hxx"

#endif // __WE17DRIVERROOT_H__
