/*  Copyright (c) 2005 Romain BONDUE
 *  if (pCBox ==
    This file is part of RutilT.

    RutilT is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    RutilT is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with RutilT; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
/** \file RTModules.hxx
    \author Romain BONDUE
    \date 19/08/2005
    \warning This file should only be included from RTModules.h */
inline nsCore::CRT2400CLIModule::CRT2400CLIModule
                        (const std::string& DeviceName, const std::string& Path)
                                 throw (nsErrors::CException, std::bad_alloc)
    : m_Driver (DeviceName), m_ProfilesFile (Path)
{
    m_ProfilesFile.Extract();

} // CRT2400CLIModule()


inline nsCore::CRT2400CLIModule::~CRT2400CLIModule () throw() {}


inline const nsUserData::CProfile& nsCore::CRT2400CLIModule::GetProfile
                                                    (unsigned Pos) const throw()
{
    return m_ProfilesFile [Pos];

} // GetProfile()


inline unsigned nsCore::CRT2400CLIModule::GetNbProfile () const throw()
{
    return m_ProfilesFile.size();

} // GetNbProfile()


inline nsWireless::IDriver& nsCore::CRT2400CLIModule::GetDriver () throw()
{
    return m_Driver;

} // GetDriver()


inline const nsWireless::IDriver& nsCore::CRT2400CLIModule::GetDriver () const
                                                                        throw()
{
    return m_Driver;

} // GetDriver()


inline nsWireless::IDriver& nsCore::CRT2400Module::GetDriver () throw()
{
    return *m_pDriver;

} // GetDriver()


inline const nsWireless::IDriver& nsCore::CRT2400Module::GetDriver () const
                                                                        throw()
{
    return *m_pDriver;

} // GetDriver()


inline void nsCore::CRT2400Module::DeleteProfile (unsigned Pos) throw()
{
    m_ProfilesFile.erase (m_ProfilesFile.begin() + Pos);

} // DeleteProfile()


inline nsUserData::CProfile& nsCore::CRT2400Module::GetProfile (unsigned Pos)
                                                                        throw()
{
    return m_ProfilesFile [Pos];

} // GetProfile()


inline unsigned nsCore::CRT2400Module::GetNbProfile () const throw()
{
    return m_ProfilesFile.size();

} // GetNbProfile()


inline ::GtkWidget* nsCore::CRT2400Module::GetPrivateTab () throw() {return 0;}


inline nsUserData::CProfile* nsCore::CRT2400Module::NewProfile () throw()
{
    m_ProfilesFile.NewProfile (NewProfileDefaultName);
    return EditNewProfile();

} // NewProfile()


inline nsUserData::CProfile* nsCore::CRT2400Module::NewProfile
                                        (const nsWireless::CCell& Cell) throw()
{
    m_ProfilesFile.NewProfile (NewProfileDefaultName, Cell);
    return EditNewProfile();

} // NewProfile()


inline bool nsCore::CRT2400Module::EditProfile (unsigned Pos) throw()
{
    return m_ProfileEditor.Edit (m_ProfilesFile [Pos]);

} // EditProfile()


inline nsCore::CRT2400Module::~CRT2400Module () throw() {}


inline nsCore::CRTAdvancedCLIModule::CRTAdvancedCLIModule
            (nsWireless::CRTAdvancedDriver* pDriver, const std::string& Path)
                                 throw (nsErrors::CException, std::bad_alloc)
    : m_pDriver (pDriver), m_ProfilesFile (Path)
{
    m_ProfilesFile.Extract();

} // CRTAdvancedCLIModule()


inline nsCore::CRTAdvancedCLIModule::~CRTAdvancedCLIModule () throw() {}


inline const nsUserData::CProfile& nsCore::CRTAdvancedCLIModule::GetProfile
                                                    (unsigned Pos) const throw()
{
    return m_ProfilesFile [Pos];

} // GetProfile()


inline unsigned nsCore::CRTAdvancedCLIModule::GetNbProfile () const throw()
{
    return m_ProfilesFile.size();

} // GetNbProfile()


inline nsCore::CRTAdvancedModule::~CRTAdvancedModule () throw() {}


inline nsWireless::IDriver& nsCore::CRTAdvancedCLIModule::GetDriver () throw()
{
    return *m_pDriver;

} // GetDriver()


inline const nsWireless::IDriver& nsCore::CRTAdvancedCLIModule::GetDriver ()
                                                                const throw()
{
    return *m_pDriver;

} // GetDriver()


inline nsUserData::CProfile* nsCore::CRTAdvancedModule::NewProfile () throw()
{
    m_ProfilesFile.NewProfile (NewProfileDefaultName);
    return EditNewProfile();

} // NewProfile()


inline nsWireless::IDriver& nsCore::CRTAdvancedModule::GetDriver () throw()
{
    return *m_pDriver;

} // GetDriver()


inline const nsWireless::IDriver& nsCore::CRTAdvancedModule::GetDriver () const
                                                                        throw()
{
    return *m_pDriver;

} // GetDriver()


inline nsUserData::CProfile* nsCore::CRTAdvancedModule::NewProfile
                                        (const nsWireless::CCell& Cell) throw()
{
    m_ProfilesFile.NewProfile (NewProfileDefaultName, Cell);
    return EditNewProfile();

} // NewProfile()


inline nsCore::CRT2500CLIModule::CRT2500CLIModule
                        (const std::string& DeviceName, const std::string& Path)
                                    throw (nsErrors::CException, std::bad_alloc)
    : CRTAdvancedCLIModule (new nsWireless::CRT2500Driver (DeviceName), Path) {}


inline nsCore::CRT61CLIModule::CRT61CLIModule
                        (const std::string& DeviceName, const std::string& Path)
                                    throw (nsErrors::CException, std::bad_alloc)
    : CRTAdvancedCLIModule (new nsWireless::CRT61Driver (DeviceName), Path) {}


inline nsCore::CRT73CLIModule::CRT73CLIModule
                        (const std::string& DeviceName, const std::string& Path)
                                    throw (nsErrors::CException, std::bad_alloc)
    : CRTAdvancedCLIModule (new nsWireless::CRT73Driver (DeviceName), Path) {}


inline bool nsCore::CRTAdvancedModule::EditProfile (unsigned Pos) throw()
{
    return m_ProfileEditor.Edit (m_ProfilesFile [Pos]);

} // EditProfile()


inline void nsCore::CRTAdvancedModule::DeleteProfile (unsigned Pos) throw()
{
    m_ProfilesFile.erase (m_ProfilesFile.begin() + Pos);

} // DeleteProfile()


inline nsUserData::CProfile& nsCore::CRTAdvancedModule::GetProfile
                                                        (unsigned Pos) throw()
{
    return m_ProfilesFile [Pos];

} // GetProfile()


inline unsigned nsCore::CRTAdvancedModule::GetNbProfile () const throw()
{
    return m_ProfilesFile.size();

} // GetNbProfile()


inline ::GtkWidget* nsCore::CRTAdvancedModule::GetPrivateTab () throw()
{
    return GTK_WIDGET (m_pTable);

} // GetPrivateTab()


inline void nsCore::CRTAdvancedModule::ResumePreviousState
                                                (::GtkComboBox* pCBox) throw()
{
    m_IsSkipped = true;
    ::gtk_combo_box_set_active (pCBox, m_CurrentActiveBoxItem);
    m_IsSkipped = false;

} // ResumePreviousState()


inline void nsCore::CRTAdvancedModule::SetDriver
                                (nsWireless::CRTAdvancedDriver* pDriver) throw()
{
    m_pDriver.reset (pDriver);

} // SetDriver()


inline void nsCore::CRTAdvancedModule::TxBurstCallBack
                (::GtkToggleButton* pButton, CRTAdvancedModule* This) throw()
{
    This->CommonCButtonCallBack (&nsWireless::CRTAdvancedDriver::SetTxBurst,
                                 pButton);

} // TxBurstCallBack()


inline void nsCore::CRTAdvancedModule::TurboRateCallBack
                (::GtkToggleButton* pButton, CRTAdvancedModule* This) throw()
{
    This->CommonCButtonCallBack (&nsWireless::CRTAdvancedDriver::SetTurboRate,
                                 pButton);

} // TurboRateCallBack()


inline void nsCore::CRTAdvancedModule::AdHocOFDMCallBack
                (::GtkToggleButton* pButton, CRTAdvancedModule* This) throw()
{
    This->CommonCButtonCallBack (&nsWireless::CRTAdvancedDriver::SetAdHocOFDM,
                                 pButton);

} // AdHocOFDMCallBack()


inline void nsCore::CRTAdvancedModule::RfmontxCallBack
                (::GtkToggleButton* pButton, CRTAdvancedModule* This) throw()
{
    This->CommonCButtonCallBack (&nsWireless::CRTAdvancedDriver::SetRfmontx,
                                 pButton);

} // RfmontxCallBack()


inline void nsCore::CRTAdvancedModule::BGProtectionCallBack
                        (::GtkComboBox* pCBox, CRTAdvancedModule* This) throw()
{
    This->CommonCBoxCallBack (reinterpret_cast<DriverCBoxMember_t>
                            (&nsWireless::CRTAdvancedDriver::SetBGProtection),
                              pCBox);

} // BGProtectionCallBack()


inline void nsCore::CRTAdvancedModule::TxPreambleCallBack (::GtkComboBox* pCBox,
                                                       CRTAdvancedModule* This)
                                                                        throw()
{
    This->CommonCBoxCallBack (reinterpret_cast<DriverCBoxMember_t>
                                (&nsWireless::CRTAdvancedDriver::SetTxPreamble),
                              pCBox);

} // TxPreambleCallBack()


inline void nsCore::CRTAdvancedModule::CBoxFocusCallBack (::GtkComboBox* pCBox,
                                bool, nsCore::CRTAdvancedModule* This) throw()
{
    This->m_CurrentActiveBoxItem = ::gtk_combo_box_get_active (pCBox);

} // CBoxFocusCallBack()


inline nsCore::CProfileEditor& nsCore::CRTAdvancedModule::GetProfileEditor ()
                                                                        throw()
{
    return m_ProfileEditor;

} // GetProfileEditor()


inline const nsCore::CProfileEditor&
                    nsCore::CRTAdvancedModule::GetProfileEditor () const throw()
{
    return m_ProfileEditor;

} // GetProfileEditor()


inline nsCore::CRT2570CLIModule::CRT2570CLIModule
                        (const std::string& DeviceName, const std::string& Path)
                                 throw (nsErrors::CException, std::bad_alloc)
    : m_Driver (DeviceName), m_ProfilesFile (Path)
{
    m_ProfilesFile.Extract();

} // CRT2570CLIModule()


inline nsCore::CRT2570CLIModule::~CRT2570CLIModule () throw() {}


inline const nsUserData::CProfile& nsCore::CRT2570CLIModule::GetProfile
                                                    (unsigned Pos) const throw()
{
    return m_ProfilesFile [Pos];

} // GetProfile()


inline unsigned nsCore::CRT2570CLIModule::GetNbProfile () const throw()
{
    return m_ProfilesFile.size();

} // GetNbProfile()


inline nsWireless::IDriver& nsCore::CRT2570CLIModule::GetDriver () throw()
{
    return m_Driver;

} // GetDriver()


inline const nsWireless::IDriver& nsCore::CRT2570CLIModule::GetDriver () const
                                                                        throw()
{
    return m_Driver;

} // GetDriver()


inline nsCore::CRT2570Module::~CRT2570Module () throw() {}


inline void nsCore::CRT2570Module::CBoxFocusCallBack (::GtkComboBox* pCBox,
                                    bool, nsCore::CRT2570Module* This) throw()
    {
    This->m_CurrentActiveBoxItem = ::gtk_combo_box_get_active (pCBox);

} // CBoxFocusCallBack()


inline nsWireless::IDriver& nsCore::CRT2570Module::GetDriver () throw()
{
    return *m_pDriver;

} // GetDriver()


inline const nsWireless::IDriver& nsCore::CRT2570Module::GetDriver () const
                                                                        throw()
{
    return *m_pDriver;

} // GetDriver()


inline void nsCore::CRT2570Module::RfmontxCallBack (::GtkToggleButton* pButton,
                                                    CRT2570Module* This) throw()
{
    This->CommonCButtonCallBack (&nsWireless::CRT2570Driver::SetRfmontx,
                                 pButton);

} // RfmontxCallBack()


inline void nsCore::CRT2570Module::PrismHeaderCallBack (::GtkComboBox* pCBox,
                                                        CRT2570Module* This)
                                                                        throw()
{
    This->CommonCBoxCallBack (reinterpret_cast<DriverBoxMember_t>
                                (&nsWireless::CRT2570Driver::SetPrismHeader),
                              pCBox);

} // PrismHeaderCallBack()


inline void nsCore::CRT2570Module::AdhocModeCallBack (::GtkComboBox* pCBox,
                                                      CRT2570Module* This)
                                                                        throw()
{
    This->CommonCBoxCallBack (reinterpret_cast<DriverBoxMember_t>
                                (&nsWireless::CRT2570Driver::SetAdHocMode),
                              pCBox);

} // AdhocModeCallBack()


inline nsUserData::CProfile* nsCore::CRT2570Module::NewProfile () throw()
{
    m_ProfilesFile.NewProfile (NewProfileDefaultName);
    return EditNewProfile();

} // NewProfile()


inline nsUserData::CProfile* nsCore::CRT2570Module::NewProfile
                                        (const nsWireless::CCell& Cell) throw()
{
    m_ProfilesFile.NewProfile (NewProfileDefaultName, Cell);
    return EditNewProfile();

} // NewProfile()


inline bool nsCore::CRT2570Module::EditProfile (unsigned Pos) throw()
{
    return m_ProfileEditor.Edit (m_ProfilesFile [Pos]);

} // EditProfile()


inline void nsCore::CRT2570Module::DeleteProfile (unsigned Pos) throw()
{
    m_ProfilesFile.erase (m_ProfilesFile.begin() + Pos);

} // DeleteProfile()


inline nsUserData::CProfile& nsCore::CRT2570Module::GetProfile (unsigned Pos)
                                                                        throw()
{
    return m_ProfilesFile [Pos];

} // GetProfile()


inline unsigned nsCore::CRT2570Module::GetNbProfile () const throw()
{
    return m_ProfilesFile.size();

} // GetNbProfile()


inline ::GtkWidget* nsCore::CRT2570Module::GetPrivateTab () throw()
{
    return GTK_WIDGET (m_pBox);

} // GetPrivateTab()


inline void nsCore::CRT2570Module::ResumePreviousState (::GtkComboBox* pCBox)
                                                                        throw()
{
    m_IsSkipped = true;
    ::gtk_combo_box_set_active (pCBox, m_CurrentActiveBoxItem);
    m_IsSkipped = false;

} // ResumePreviousState()


inline nsUserData::CProfilesFile<>& nsCore::CRTAdvancedModule::GetProfilesFile
                                                                    () throw()
{
    return m_ProfilesFile;

} // GetProfilesFile()


inline const nsUserData::CProfilesFile<>&
                    nsCore::CRTAdvancedModule::GetProfilesFile () const throw()
{
    return m_ProfilesFile;

} // GetProfilesFile()


inline nsUserData::CProfilesFile<>&
                        nsCore::CRTAdvancedCLIModule::GetProfilesFile () throw()
{
    return m_ProfilesFile;

} // GetProfilesFile()


inline const nsUserData::CProfilesFile<>&
                nsCore::CRTAdvancedCLIModule::GetProfilesFile () const throw()
{
    return m_ProfilesFile;

} // GetProfilesFile()
