/*  Copyright (c) 2005 Romain BONDUE
    This file is part of RutilT.

    RutilT is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    RutilT is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with RutilT; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
/** \file WWidgets.cxx
    \author Romain BONDUE
    \date 31/03/2006 */
#include <cctype> // isxdigit()

#include "WWidgets.h"



namespace
{
    ::GtkWidget* LabelWidget (::GtkWidget* pWidget, const char* Label) throw()
    {
        ::GtkBox* const pHBox (GTK_BOX (::gtk_hbox_new (false, 2)));
        ::gtk_box_pack_start_defaults (pHBox, ::gtk_label_new (Label));
        ::gtk_box_pack_start_defaults (pHBox, pWidget);

        return GTK_WIDGET (pHBox);
        
    } // LabelWidget()


    inline bool IsDisplayable (char C) throw()
    {
        return !(C & 0x80) && C >= ' ';

    } // IsDisplayable()

} // anonymous namespace



nsGUI::CKeyEntry::CKeyEntry () throw()
    : m_pEntry (GTK_ENTRY (::gtk_entry_new())),
      m_pIsASCIIButton (GTK_TOGGLE_BUTTON (::gtk_check_button_new_with_label
                                                            ("ASCII Key"))),
      m_pBox (GTK_BOX (::gtk_vbox_new (false, 2)))
{
    ::g_signal_connect (G_OBJECT (m_pEntry), "insert-text",
                        G_CALLBACK (NewTextTyped), this);
    ::g_signal_connect (G_OBJECT (m_pIsASCIIButton), "toggled",
                        G_CALLBACK (ASCIIButtonToggled), this);
    ::gtk_box_pack_start_defaults (m_pBox, GTK_WIDGET (m_pEntry));
    ::gtk_box_pack_start_defaults (m_pBox, GTK_WIDGET (m_pIsASCIIButton));

} // CKeyEntry()


void nsGUI::CKeyEntry::NewTextTyped  (::GtkEditable* pEditable, char* NewText,
                                      int Length, int* pNewPos,
                                      CKeyEntry* This) throw()
{
    if (!::gtk_toggle_button_get_active (This->m_pIsASCIIButton) &&
                                                    !std::isxdigit (*NewText))
        ::g_signal_stop_emission_by_name (pEditable, "insert-text");

} // NewTextTyped()


void nsGUI::CKeyEntry::ASCIIButtonToggled (::GtkToggleButton*, CKeyEntry* This)
                                                                        throw()
{
    if (!::gtk_toggle_button_get_active (This->m_pIsASCIIButton))
        for (const char* KeyStr (::gtk_entry_get_text (This->m_pEntry)) ;
                                                            *KeyStr ; ++KeyStr)
            if (!std::isxdigit (*KeyStr))
            {
                This->Clear();
                break;
            }

} // ASCIIButtonToggled()


void nsGUI::CKeyEntry::Set (const nsWireless::CHexaKey& Key) throw()
{
    if (Key.Empty())
        Clear();
    else
    {
        for (unsigned I (0) ; I < Key.Size() ; ++I)
            if (!IsDisplayable (Key.Get() [I]))
            {
                ::gtk_toggle_button_set_active (m_pIsASCIIButton, false);
                ::gtk_entry_set_text (m_pEntry, Key.GetStr().c_str());
                return;
            }
        ::gtk_toggle_button_set_active (m_pIsASCIIButton, true);
        ::gtk_entry_set_text (m_pEntry,
                              std::string (Key.Get(), 0, Key.Size()).c_str());
    }

} // Set()


nsWireless::CHexaKey nsGUI::CKeyEntry::Get () const throw()
{
    nsWireless::CHexaKey Key;
        // The CBadFormatExc is occulted here...
    const char* EntryValue (::gtk_entry_get_text (m_pEntry));
    if (*EntryValue) // Not Empty
    {
        if (::gtk_toggle_button_get_active (m_pIsASCIIButton))
            Key.SetFromASCII (EntryValue);
        else Key.Set (EntryValue);
    }
    return Key;

} // Get()


nsGUI::CConfigDialog::CConfigDialog (const nsWireless::Mode_e* ModeTab,
                                     unsigned TabModeSize,
                                 const std::vector<nsWireless::CFreq>& FreqVec,
                                     const nsWireless::EncryptType_e* EncTab,
                                     unsigned EncTabSize,
                                     const nsWireless::AuthType_e* AuthTab,
                                     unsigned AuthTabSize)
                                                        throw (std::bad_alloc)
    : m_pDialog (GTK_DIALOG (::gtk_dialog_new_with_buttons
                                             (0, 0,  ::GtkDialogFlags (0),
                                              GTK_STOCK_OK, GTK_RESPONSE_OK,
                                              GTK_STOCK_CANCEL,
                                              GTK_RESPONSE_CANCEL,
                                              reinterpret_cast<void*> (0)))),
      m_pNameEntry (GTK_ENTRY (::gtk_entry_new())),
      m_pSSIDEntry (GTK_ENTRY (::gtk_entry_new())),
      m_ModeBox (ModeTab, TabModeSize),
      m_EncryptBox (EncTab, EncTabSize),
      m_AuthBox (AuthTab, AuthTabSize),
      m_pIPNoneButton (GTK_RADIO_BUTTON (::gtk_radio_button_new_with_label
                                                            (0, "Disabled"))),
      m_pIPDhcpButton (GTK_RADIO_BUTTON
              (::gtk_radio_button_new_with_label_from_widget (m_pIPNoneButton,
                                                      "Automatic (DHCP)"))),
      m_pIPStaticButton (GTK_RADIO_BUTTON
              (::gtk_radio_button_new_with_label_from_widget (m_pIPNoneButton,
                                  "Manual (Might be for a future release.)")))
{
    SetAvailableChannel (FreqVec);
    BuildUI();

} // CConfigDialog()


nsGUI::CConfigDialog::CConfigDialog (const nsWireless::Mode_e* ModeTab,
                                     unsigned TabModeSize,
                                     const nsWireless::EncryptType_e* EncTab,
                                     unsigned EncTabSize,
                                     const nsWireless::AuthType_e* AuthTab,
                                     unsigned AuthTabSize)
                                                        throw (std::bad_alloc)
    : m_ChannelTab (0), m_ChannelTabSize (0),
      m_pDialog (GTK_DIALOG (::gtk_dialog_new_with_buttons
                                             (0, 0,  ::GtkDialogFlags (0),
                                              GTK_STOCK_OK, GTK_RESPONSE_OK,
                                              GTK_STOCK_CANCEL,
                                              GTK_RESPONSE_CANCEL,
                                              reinterpret_cast<void*> (0)))),
      m_pNameEntry (GTK_ENTRY (::gtk_entry_new())),
      m_pSSIDEntry (GTK_ENTRY (::gtk_entry_new())),
      m_ModeBox (ModeTab, TabModeSize),
      m_EncryptBox (EncTab, EncTabSize),
      m_AuthBox (AuthTab, AuthTabSize),
      m_pIPNoneButton (GTK_RADIO_BUTTON (::gtk_radio_button_new_with_label
                                                            (0, "Disabled"))),
      m_pIPDhcpButton (GTK_RADIO_BUTTON
              (::gtk_radio_button_new_with_label_from_widget (m_pIPNoneButton,
                                                      "Automatic (DHCP)"))),
      m_pIPStaticButton (GTK_RADIO_BUTTON
              (::gtk_radio_button_new_with_label_from_widget (m_pIPNoneButton,
                                  "Manual (Might be for a future release.)")))
{
    BuildUI();

} // CConfigDialog()


nsGUI::CConfigDialog::~CConfigDialog () throw()
{
    ::gtk_widget_destroy (GTK_WIDGET (m_pDialog));
    delete[] m_ChannelTab;

} // CConfigDialog()


void nsGUI::CConfigDialog::BuildUI () throw()
{
    ::gtk_window_set_resizable (GTK_WINDOW (m_pDialog), false);   
        // There's 2 unused rows, they're just here to make a blank space.
    ::GtkTable* const pTable (GTK_TABLE (::gtk_table_new (6, 2, false)));
    ::gtk_container_set_border_width (GTK_CONTAINER (pTable), 5);
    ::gtk_table_set_row_spacings (pTable, 6);
    ::gtk_table_set_col_spacings (pTable, 12);

    ::gtk_table_attach_defaults (pTable,
                                 LabelWidget (GTK_WIDGET (m_pNameEntry),
                                              "Name"),
                                 0, 1, 0, 1);
    ::gtk_table_attach_defaults (pTable,
                                 LabelWidget (GTK_WIDGET (m_pSSIDEntry),
                                              "SSID"),
                                 1, 2, 0, 1);
    ::gtk_table_attach_defaults (pTable, LabelWidget (m_ModeBox, "Mode"),
                                 0, 1, 1, 2);
    ::gtk_table_attach_defaults (pTable, LabelWidget (m_ChannelBox, "Channel"),
                                 1, 2, 1, 2);
    ::gtk_table_attach_defaults (pTable,
                                 LabelWidget (m_AuthBox, "Authentication"),
                                 0, 1, 4, 5);
    ::gtk_table_attach_defaults (pTable,
                                 LabelWidget (m_EncryptBox, "Encryption"),
                                 1, 2, 4, 5);
    ::gtk_table_attach_defaults (pTable, m_MultiKey, 0, 2, 5, 6);

    ::GtkNotebook* const pNoteBook (GTK_NOTEBOOK (::gtk_notebook_new()));
    ::gtk_notebook_append_page (pNoteBook, GTK_WIDGET (pTable),
                                ::gtk_label_new ("Wireless settings"));


    ::GtkBox* const pBox (GTK_BOX (::gtk_vbox_new (false, 2)));
    ::gtk_box_pack_start_defaults (pBox, GTK_WIDGET (m_pIPNoneButton));
    ::gtk_box_pack_start_defaults (pBox, GTK_WIDGET (m_pIPDhcpButton));
    ::gtk_box_pack_start_defaults (pBox, GTK_WIDGET (m_pIPStaticButton));

        // TODO Remove this line and do the rest of the work :
    ::gtk_widget_set_sensitive (GTK_WIDGET (m_pIPStaticButton), false);

    ::gtk_notebook_append_page (pNoteBook, GTK_WIDGET (pBox),
                                            ::gtk_label_new ("IP settings"));
    ::gtk_box_pack_start_defaults (GetBox(), GTK_WIDGET (pNoteBook));

} // BuildUI()



void nsGUI::CConfigDialog::SetAvailableChannel
        (const std::vector<nsWireless::CFreq>& FreqVec) throw (std::bad_alloc)
{
    m_ChannelTabSize = FreqVec.size();
    m_ChannelTab = new unsigned [m_ChannelTabSize];
    for (unsigned I (0) ; I < m_ChannelTabSize ; ++I)
        m_ChannelTab [I] = FreqVec [I].GetChannel();
    m_ChannelBox.SetElem (m_ChannelTab, m_ChannelTabSize);

} // SetAvailableChannel()


nsGUI::CSharedConfigDialog::CSharedConfigDialog
                                (const nsWireless::Mode_e* TabMode,
                                 unsigned TabModeSize,
                                 const std::vector<nsWireless::CFreq>& FreqVec,
                                 const nsWireless::AuthType_e* AuthTab,
                                 unsigned AuthTabSize,
                                 const nsWireless::EncryptType_e* EncTab1,
                                 unsigned EncTabSize1,
                                 const nsWireless::EncryptType_e* EncTab2,
                                 unsigned EncTabSize2,
                                 const nsWireless::EncryptType_e* EncTab3,
                                 unsigned EncTabSize3) throw (std::bad_alloc)
    : CConfigDialog (TabMode, TabModeSize, FreqVec, EncTab1, EncTabSize1,
                     AuthTab, AuthTabSize),
      m_AuthTabSize (AuthTabSize), m_AuthTab (AuthTab),
      m_EncryptTabSize1 (EncTabSize1), m_EncTab1 (EncTab1),
      m_EncryptTabSize2 (EncTabSize2), m_EncTab2 (EncTab2),
      m_EncryptTabSize3 (EncTabSize3), m_EncTab3 (EncTab3)
{
    ::g_signal_connect (G_OBJECT (GetAuthBox().operator ::GtkWidget*()),
                        "changed", G_CALLBACK (AuthButtonCallBack), this);
    ::g_signal_connect (G_OBJECT (GetEncryptBox().operator ::GtkWidget*()),
                        "changed", G_CALLBACK (EncryptButtonCallBack), this);

} // CSharedConfigDialog()


nsGUI::CSharedConfigDialog::CSharedConfigDialog
                                (const nsWireless::Mode_e* TabMode,
                                 unsigned TabModeSize,
                                 const nsWireless::AuthType_e* AuthTab,
                                 unsigned AuthTabSize,
                                 const nsWireless::EncryptType_e* EncTab1,
                                 unsigned EncTabSize1,
                                 const nsWireless::EncryptType_e* EncTab2,
                                 unsigned EncTabSize2,
                                 const nsWireless::EncryptType_e* EncTab3,
                                 unsigned EncTabSize3) throw (std::bad_alloc)
    : CConfigDialog (TabMode, TabModeSize, EncTab1, EncTabSize1, AuthTab,
                     AuthTabSize),
      m_AuthTabSize (AuthTabSize), m_AuthTab (AuthTab),
      m_EncryptTabSize1 (EncTabSize1), m_EncTab1 (EncTab1),
      m_EncryptTabSize2 (EncTabSize2), m_EncTab2 (EncTab2),
      m_EncryptTabSize3 (EncTabSize3), m_EncTab3 (EncTab3)
{
    ::g_signal_connect (G_OBJECT (GetAuthBox().operator ::GtkWidget*()),
                        "changed", G_CALLBACK (AuthButtonCallBack), this);
    ::g_signal_connect (G_OBJECT (GetEncryptBox().operator ::GtkWidget*()),
                        "changed", G_CALLBACK (EncryptButtonCallBack), this);

} // CSharedConfigDialog()


void nsGUI::CSharedConfigDialog::EncryptButtonCallBack
                (::GtkToggleButton* pButton, CSharedConfigDialog* This) throw()
{
    if (This->GetEncryptBox().GetActive() != nsWireless::None)
    {
        ::gtk_widget_set_sensitive (This->GetMultiKey(), true);
        This->GetMultiKey().AdditionnalKeyAvailable (
                        This->GetEncryptBox().GetActive() == nsWireless::WEP);
        This->GetMultiKey().GetKeyEntry (0).ASCIIOnly (
                        This->GetEncryptBox().GetActive() != nsWireless::WEP);
    }
    else
    {
        ::gtk_widget_set_sensitive (This->GetMultiKey(), false);
        This->ClearKeyEntry();
    }

} // EncryptButtonCallBack()


void nsGUI::CSharedConfigDialog::AuthButtonCallBack (::GtkToggleButton*,
                                            CSharedConfigDialog* This) throw()
{
    This->ClearKeyEntry();
    switch (This->GetAuthBox().GetActiveRow())
    {
      case 0 :
        This->SetEncryptBox (This->m_EncTab1, This->m_EncryptTabSize1);
      break;

      case 1 :
        This->SetEncryptBox (This->m_EncTab2, This->m_EncryptTabSize2);
      break;

      default :
        This->SetEncryptBox (This->m_EncTab3, This->m_EncryptTabSize3);
      //break;
    }

} // AuthButtonCallBack()
