/*  Copyright (c) 2005 Romain BONDUE
    This file is part of RutilT.

    RutilT is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    RutilT is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with RutilT; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
/** \file WWidgets.hxx
    \author Romain BONDUE
    \date 31/03/2006
    \warning This file should only be included from WWidgets.h */
#include <sstream>



template<class T>
std::string nsGUI::CConvert<T>::operator () (const T& Object) throw()
{
    std::ostringstream Os;
    Os << Object;
    return Os.str();

} // ToStr()


inline std::string nsGUI::CModeConvert::operator ()
                                    (const nsWireless::Mode_e& Mode) throw()
{
    return nsWireless::GetModeName (Mode);

} // operator ()()


inline std::string nsGUI::CAuthConvert::operator ()
                                (const nsWireless::AuthType_e& Auth) throw()
{
    return nsWireless::GetAuthName (Auth);

} // operator ()()


inline std::string nsGUI::CEncryptConvert::operator ()
                            (const nsWireless::EncryptType_e& Encrypt) throw()
{
    return nsWireless::GetEncryptName (Encrypt);

} // operator ()()


template<class T, class C>
inline nsGUI::CComboBox<T, C>::CComboBox () throw()
    : m_pBox (GTK_COMBO_BOX (::gtk_combo_box_new_text())), m_TabSize (0),
      m_Tab (0) {}


template<class T, class C>
inline nsGUI::CComboBox<T, C>::CComboBox (const T* Tab, unsigned TabSize)
                                                                        throw()
    : m_pBox (GTK_COMBO_BOX (::gtk_combo_box_new_text())), m_TabSize (0),
      m_Tab (0)
{
    SetElem (Tab, TabSize);

} // CComboBox<T>()


template<class T, class C>
void nsGUI::CComboBox<T, C>::SetElem (const T* Tab, unsigned TabSize) throw()
{
    while (m_TabSize)
        ::gtk_combo_box_remove_text (m_pBox, --m_TabSize);

    C Convertor;
    for (unsigned I (0) ; I < TabSize ; ++I)
        ::gtk_combo_box_append_text (m_pBox, Convertor (Tab [I]).c_str());
    m_Tab = Tab;
    m_TabSize = TabSize;

} // SetElem()


template<class T, class C>
void nsGUI::CComboBox<T, C>::SetActive (const T& Item) throw()
{
    for (unsigned I (0) ; I < m_TabSize ; ++I)
        if (Item == m_Tab [I])
        {
            ::gtk_combo_box_set_active (m_pBox, I);
            return;
        }
    ::gtk_combo_box_set_active (m_pBox, 0);

} // SetActive()


template<class T, class C>
inline const T& nsGUI::CComboBox<T, C>::GetActive () const throw()
{
    return m_Tab [::gtk_combo_box_get_active (m_pBox)];

} // GetActive()


template<class T, class C>
inline unsigned nsGUI::CComboBox<T, C>::GetActiveRow () const throw()
{
    return ::gtk_combo_box_get_active (m_pBox);

} // GetActive()


template<class T, class C>
inline nsGUI::CComboBox<T, C>::operator ::GtkWidget* () throw()
{
    return GTK_WIDGET (m_pBox);

} // operator ::GtkWidget*()


template<class T, class C>
inline nsGUI::CComboBox<T, C>::operator const ::GtkWidget* () const throw()
{
    return GTK_WIDGET (m_pBox);

} // operator const ::GtkWidget*()


inline void nsGUI::CKeyEntry::ASCIIOnly (bool State) throw()
{
    ::gtk_toggle_button_set_active (m_pIsASCIIButton, State);
    ::gtk_widget_set_sensitive (GTK_WIDGET (m_pIsASCIIButton), !State);

} // ASCIIOnly()


inline bool nsGUI::CKeyEntry::ASCIIOnly () const throw()
{
    return ::gtk_toggle_button_get_active (m_pIsASCIIButton);

} // ASCIIOnly()


inline nsGUI::CKeyEntry::operator ::GtkWidget* () throw()
{
    return GTK_WIDGET (m_pBox);

} // operator ::GtkWidget*()


inline nsGUI::CKeyEntry::operator const ::GtkWidget* () const throw()
{
    return GTK_WIDGET (m_pBox);

} // operator const ::GtkWidget*()


inline void nsGUI::CKeyEntry::Clear () throw()
{
    ::gtk_entry_set_text (m_pEntry, "");

} // Clear()


inline nsGUI::CKeyEntry::operator ::GtkEntry* () throw()
{
    return GTK_ENTRY (m_pEntry);

} // operator ::GtkEntry*()


inline nsGUI::CKeyEntry::operator const ::GtkEntry* () const throw()
{
    return GTK_ENTRY (m_pEntry);

} // operator const ::GtkEntry*()


template <unsigned N>
inline nsGUI::CMultiKey<N>::CMultiKey () throw()
    : m_pBox (GTK_VBOX (::gtk_vbox_new (false, 2))),
      m_pKeysExpander (GTK_EXPANDER (::gtk_expander_new ("More key"))),
      m_pDefaultKeyBox (GTK_COMBO_BOX (::gtk_combo_box_new_text()))
{
    BuildUI();

} // CMultiKey()


template <unsigned N>
inline nsGUI::CMultiKey<N>::operator ::GtkWidget* () throw()
{
    return GTK_WIDGET (m_pBox);

} // operator ::GtkWidget*()


template <unsigned N>
inline nsGUI::CMultiKey<N>::operator const ::GtkWidget* () const throw()
{
    return GTK_WIDGET (m_pBox);

} // operator const ::GtkWidget*()


template <unsigned N>
inline nsWireless::CHexaKey nsGUI::CMultiKey<N>::Get (unsigned Pos) const
                                                                        throw()
{
    return m_KeyEntryTab [Pos].Get();

} // Get()


template <unsigned N>
inline void nsGUI::CMultiKey<N>::Set (const nsWireless::CHexaKey& Key,
                                      unsigned Pos) throw()
{
    m_KeyEntryTab [Pos].Set (Key);

} // Set()


template <unsigned N>
inline void nsGUI::CMultiKey<N>::AdditionnalKeyAvailable (bool State) throw()
{
    ::gtk_widget_set_sensitive (GTK_WIDGET (m_pKeysExpander), State);
    if (!State)
        ::gtk_combo_box_set_active (m_pDefaultKeyBox, 0);

} // AdditionnalKeyAvailable()


template <unsigned N>
inline unsigned nsGUI::CMultiKey<N>::GetNbKey () const throw() {return N;}


template <unsigned N>
void nsGUI::CMultiKey<N>::BuildUI () throw()
{
    ::GtkBox* pHBox (GTK_BOX (::gtk_hbox_new (false, 2)));
    ::gtk_box_pack_start_defaults (pHBox, ::gtk_label_new ("Key"));
    ::gtk_box_pack_start_defaults (pHBox, m_KeyEntryTab [0]);
    ::gtk_box_pack_start_defaults (GTK_BOX (m_pBox), GTK_WIDGET (pHBox));
    if (N > 1)
    {
        ::GtkWidget* const pVBox (::gtk_vbox_new (true, 2));
        for (unsigned I (1) ; I < N ; ++I)
            ::gtk_box_pack_start_defaults (GTK_BOX (pVBox),
                                           m_KeyEntryTab [I]);
        for (unsigned I (1) ; I < N + 1 ; ++I)
        {
            std::ostringstream Os;
            Os << I;
            ::gtk_combo_box_append_text (m_pDefaultKeyBox, Os.str().c_str());
        }
        pHBox = GTK_BOX (::gtk_hbox_new (false, 2));
        ::gtk_box_pack_start_defaults (pHBox, ::gtk_label_new ("Default key"));
        ::gtk_box_pack_start_defaults (pHBox, GTK_WIDGET (m_pDefaultKeyBox));
        ::gtk_box_pack_start_defaults (GTK_BOX (pVBox), GTK_WIDGET (pHBox));
        ::gtk_container_add (GTK_CONTAINER (m_pKeysExpander), pVBox);
        ::gtk_box_pack_start_defaults (GTK_BOX (m_pBox),
                                       GTK_WIDGET (m_pKeysExpander));
    }
    else
        ::gtk_combo_box_append_text (m_pDefaultKeyBox, "1");
    ::gtk_combo_box_set_active (m_pDefaultKeyBox, 0);

} // BuildUI()


template <unsigned N>
void nsGUI::CMultiKey<N>::Clear () throw()
{
    for (unsigned I (0) ; I < N ; ++I)
        m_KeyEntryTab [I].Clear();

} // Clear()


template <unsigned N>
inline nsGUI::CKeyEntry& nsGUI::CMultiKey<N>::GetKeyEntry (unsigned Pos) throw()
{
    return m_KeyEntryTab [Pos];

} // GetKeyEntry()


template <unsigned N>
inline const nsGUI::CKeyEntry& nsGUI::CMultiKey<N>::GetKeyEntry (unsigned Pos)
                                                                const throw()
{
    return m_KeyEntryTab [Pos];

} // GetKeyEntry()


template <unsigned N>
inline unsigned nsGUI::CMultiKey<N>::GetDefaultKey () const throw()
{
    return ::gtk_combo_box_get_active (m_pDefaultKeyBox);

} // GetDefaultKey()


template <unsigned N>
inline void nsGUI::CMultiKey<N>::SetDefaultKey (unsigned DefaultKey) throw()
{
    ::gtk_combo_box_set_active (m_pDefaultKeyBox, DefaultKey);

} // SetDefaultKey()


inline bool nsGUI::CConfigDialog::Run (::GtkWindow* pMainWindow) throw()
{
    if (pMainWindow)
        ::gtk_window_set_transient_for (GTK_WINDOW (m_pDialog), pMainWindow);
    ::gtk_widget_show_all (m_pDialog->vbox);
    return ::gtk_dialog_run (m_pDialog) == GTK_RESPONSE_OK;

} // Run()


inline void nsGUI::CConfigDialog::Hide () throw()
{
    ::gtk_widget_hide (GTK_WIDGET (m_pDialog));

} // Hide()


inline std::string nsGUI::CConfigDialog::GetConfigName () const throw()
{
    return ::gtk_entry_get_text (m_pNameEntry);

} // GetConfigName()


inline std::string nsGUI::CConfigDialog::GetSSID () const throw()
{
    return ::gtk_entry_get_text (m_pSSIDEntry);

} // GetSSID()


inline nsWireless::Mode_e nsGUI::CConfigDialog::GetMode () const throw()
{
    return m_ModeBox.GetActive();

} // GetMode()


inline unsigned nsGUI::CConfigDialog::GetChannel () const throw()
{
    return m_ChannelBox.GetActive();

} // GetChannel()


inline nsWireless::EncryptType_e nsGUI::CConfigDialog::GetEncrypt () const
                                                                        throw()
{
    return m_EncryptBox.GetActive();

} // GetEncrypt()


inline nsWireless::AuthType_e nsGUI::CConfigDialog::GetAuth () const throw()
{
    return m_AuthBox.GetActive();

} // GetAuth()


inline unsigned nsGUI::CConfigDialog::GetNbKey () const throw()
{
    return nsWireless::CEncryptionD::MaxNbKey;

} // GetNbKey()


inline nsWireless::CHexaKey nsGUI::CConfigDialog::GetKey (unsigned Pos) const
                                                                        throw()
{
    return m_MultiKey.Get (Pos);

} // GetKey()


inline nsGUI::CConfigDialog::operator ::GtkDialog* () throw()
{
    return m_pDialog;

} // operator ::GtkDialog*()


inline nsGUI::CConfigDialog::operator const ::GtkDialog* () const throw()
{
    return m_pDialog;

} // operator const ::GtkDialog*()


inline nsGUI::CModeComboBox& nsGUI::CConfigDialog::GetModeBox () throw()
{
    return m_ModeBox;

} // GetModeBox()


inline const nsGUI::CModeComboBox& nsGUI::CConfigDialog::GetModeBox () const
                                                                        throw()
{
    return m_ModeBox;

} // GetModeBox()


inline const nsGUI::CChannelComboBox& nsGUI::CConfigDialog::GetChannelBox ()
                                                                const throw()
{
    return m_ChannelBox;

} // GetChannelBox()


inline nsGUI::CEncryptComboBox& nsGUI::CConfigDialog::GetEncryptBox () throw()
{
    return m_EncryptBox;

} // GetEncryptBox()


inline const nsGUI::CEncryptComboBox& nsGUI::CConfigDialog::GetEncryptBox ()
                                                                const throw()
{
    return m_EncryptBox;

} // GetEncryptBox()


inline nsGUI::CAuthComboBox& nsGUI::CConfigDialog::GetAuthBox () throw()
{
    return m_AuthBox;

} // GetAuthBox()


inline const nsGUI::CAuthComboBox& nsGUI::CConfigDialog::GetAuthBox () const
                                                                        throw()
{
    return m_AuthBox;

} // GetAuthBox()


inline ::GtkEntry* nsGUI::CConfigDialog::GetNameEntry () throw()
{
    return m_pNameEntry;

} // GetNameEntry()


inline const ::GtkEntry* nsGUI::CConfigDialog::GetNameEntry () const throw()
{
    return m_pNameEntry;

} // GetNameEntry()


inline ::GtkEntry* nsGUI::CConfigDialog::GetSSIDEntry () throw()
{
    return m_pSSIDEntry;

} // GetSSIDEntry()


inline const ::GtkEntry* nsGUI::CConfigDialog::GetSSIDEntry () const throw()
{
    return m_pSSIDEntry;

} // GetSSIDEntry()


inline ::GtkBox* nsGUI::CConfigDialog::GetBox () throw()
{
    return GTK_BOX (m_pDialog->vbox);

} // GetBox()


inline const ::GtkBox* nsGUI::CConfigDialog::GetBox () const throw()
{
    return GTK_BOX (m_pDialog->vbox);

} // GetBox()


inline nsGUI::CMultiKey<4>& nsGUI::CConfigDialog::GetMultiKey () throw()
{
    return m_MultiKey;

} // GetMultiKey()


inline const nsGUI::CMultiKey<4>& nsGUI::CConfigDialog::GetMultiKey () const
                                                                        throw()
{
    return m_MultiKey;

} // GetMultiKey()


inline void nsGUI::CConfigDialog::SetConfigName (const std::string& Name)
                                                                        throw()
{
    ::gtk_entry_set_text (m_pNameEntry, Name.c_str());
    ::gtk_window_set_title (GTK_WINDOW (m_pDialog), Name.c_str());

} // SetConfigName()


inline void nsGUI::CConfigDialog::SetSSID (const std::string& SSID) throw()
{
    ::gtk_entry_set_text (m_pSSIDEntry, SSID.c_str());

} // SetConfigName()


inline void nsGUI::CConfigDialog::SetMode (nsWireless::Mode_e Mode) throw()
{
    m_ModeBox.SetActive (Mode);

} // SetMode()


inline void nsGUI::CConfigDialog::SetChannel (unsigned Channel) throw()
{
    m_ChannelBox.SetActive (Channel);

} // SetChannel()


inline void nsGUI::CConfigDialog::SetEncrypt (nsWireless::EncryptType_e Enc)
                                                                        throw()
{
    m_EncryptBox.SetActive (Enc);

} // SetEncrypt()


inline void nsGUI::CConfigDialog::SetAuth (nsWireless::AuthType_e Auth) throw()
{
    m_AuthBox.SetActive (Auth);

} // SetAuth()


inline void nsGUI::CConfigDialog::SetKey (const nsWireless::CHexaKey& Key,
                                          unsigned Pos) throw()
{
    m_MultiKey.Set (Key, Pos);

} // SetKey()


inline ::GtkRadioButton* nsGUI::CConfigDialog::GetIPNoneButton () throw()
{
    return m_pIPNoneButton;

} // GetIPNoneButton()


inline const ::GtkRadioButton* nsGUI::CConfigDialog::GetIPNoneButton () const
                                                                        throw()
{
    return m_pIPNoneButton;

} // GetIPNoneButton()


inline ::GtkRadioButton* nsGUI::CConfigDialog::GetIPDhcpButton () throw()
{
    return m_pIPDhcpButton;

} // GetIPDhcpButton()


inline const ::GtkRadioButton* nsGUI::CConfigDialog::GetIPDhcpButton () const
                                                                        throw()
{
    return m_pIPDhcpButton;

} // GetIPDhcpButton()


inline ::GtkRadioButton* nsGUI::CConfigDialog::GetIPStaticButton () throw()
{
    return m_pIPStaticButton;

} // GetIPStaticButton()


inline const ::GtkRadioButton* nsGUI::CConfigDialog::GetIPStaticButton () const
                                                                        throw()
{
    return m_pIPStaticButton;

} // GetIPStaticButton()


inline nsUserData::IPSetting_e nsGUI::CConfigDialog::GetIPSetting () const
                                                                        throw()
{
    return (::gtk_toggle_button_get_active
                (GTK_TOGGLE_BUTTON (GetIPDhcpButton())) ? nsUserData::Dhcp
                                                        : nsUserData::None);

} // GetIPSetting()


inline void nsGUI::CConfigDialog::SetIPSetting
                                    (nsUserData::IPSetting_e Setting) throw()
{
    if (Setting == nsUserData::None)
        ::gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (m_pIPNoneButton),
                                        true);
    else ::gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (m_pIPDhcpButton),
                                         true);

} // SetIPSetting()


inline unsigned nsGUI::CConfigDialog::GetDefaultKey () const throw()
{
    return m_MultiKey.GetDefaultKey();

} // GetDefaultKey()


inline void nsGUI::CConfigDialog::SetDefaultKey (unsigned DefaultKey) throw()
{
    m_MultiKey.SetDefaultKey (DefaultKey);

} // SetDefaultKey()


inline void nsGUI::CSharedConfigDialog::ClearKeyEntry () throw()
{
    GetMultiKey().Clear();

} // ClearKeyEntry()


inline void nsGUI::CSharedConfigDialog::SetEncryptBox
(const nsWireless::EncryptType_e* TabEncrypt, unsigned TabEncryptSize) throw()
{
    GetEncryptBox().SetElem (TabEncrypt, TabEncryptSize);
    GetEncryptBox().SetActive (TabEncrypt [0]);

} // SetEncryptBox()
