/*
 * Decompiled with CFR 0.152.
 */
package gnu.io;

import gnu.io.CommDriver;
import gnu.io.CommPort;
import gnu.io.CommPortIdentifier;
import gnu.io.LPRPort;
import gnu.io.PortInUseException;
import gnu.io.RXTXPort;
import gnu.io.RXTXVersion;
import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;
import java.util.StringTokenizer;

public class RXTXCommDriver
implements CommDriver {
    private static final boolean debug = false;
    private String deviceDirectory;
    private String osName;

    static {
        System.loadLibrary("rxtxSerial");
        String JarVersion = RXTXVersion.getVersion();
        String LibVersion = RXTXCommDriver.nativeGetVersion();
        if (!JarVersion.equals(LibVersion)) {
            System.out.println("WARNING:  RXTX Version mismatch\n\tJar version = " + JarVersion + "\n\tnative lib Version = " + LibVersion);
        }
    }

    private static native String nativeGetVersion();

    private native boolean registerKnownPorts(int var1);

    private native boolean isPortPrefixValid(String var1);

    private native boolean testRead(String var1, int var2);

    private native String getDeviceDirectory();

    private final String[] getValidPortPrefixes(String[] CandidatePortPrefixes) {
        String[] ValidPortPrefixes = new String[256];
        int i = 0;
        int j = 0;
        while (j < CandidatePortPrefixes.length) {
            if (this.isPortPrefixValid(CandidatePortPrefixes[j])) {
                ValidPortPrefixes[i++] = new String(CandidatePortPrefixes[j]);
            }
            ++j;
        }
        String[] returnArray = new String[i];
        System.arraycopy(ValidPortPrefixes, 0, returnArray, 0, i);
        return returnArray;
    }

    private void checkSolaris(String PortName, int PortType) {
        char[] p = new char[]{'['};
        p[0] = 97;
        while (p[0] < '{') {
            if (this.testRead(PortName.concat(new String(p)), PortType)) {
                CommPortIdentifier.addPortName(PortName.concat(new String(p)), PortType, this);
            }
            p[0] = (char)(p[0] + '\u0001');
        }
    }

    private void registerValidPorts(String[] CandidateDeviceNames, String[] ValidPortPrefixes, int PortType) {
        int i = 0;
        int p = 0;
        if (CandidateDeviceNames != null && ValidPortPrefixes != null) {
            i = 0;
            while (i < CandidateDeviceNames.length) {
                p = 0;
                while (p < ValidPortPrefixes.length) {
                    String V = ValidPortPrefixes[p];
                    int VL = V.length();
                    String C = CandidateDeviceNames[i];
                    if (C.length() >= VL) {
                        String CU = C.substring(VL).toUpperCase();
                        String Cl = C.substring(VL).toLowerCase();
                        if (C.regionMatches(0, V, 0, VL) && CU.equals(Cl)) {
                            String PortName = new String(String.valueOf(this.deviceDirectory) + C);
                            if (this.osName.equals("Solaris") || this.osName.equals("SunOS")) {
                                this.checkSolaris(PortName, PortType);
                            } else if (this.testRead(PortName, PortType)) {
                                CommPortIdentifier.addPortName(PortName, PortType, this);
                            }
                        }
                    }
                    ++p;
                }
                ++i;
            }
        }
    }

    public void initialize() {
        this.osName = System.getProperty("os.name");
        this.deviceDirectory = this.getDeviceDirectory();
        int PortType = 1;
        while (PortType <= 2) {
            if (!this.registerSpecifiedPorts(PortType) && !this.registerKnownPorts(PortType)) {
                this.registerScannedPorts(PortType);
            }
            ++PortType;
        }
    }

    private void addSpecifiedPorts(String names, int PortType) {
        String pathSep = System.getProperty("path.separator", ":");
        StringTokenizer tok = new StringTokenizer(names, pathSep);
        while (tok.hasMoreElements()) {
            String PortName = tok.nextToken();
            if (!this.testRead(PortName, PortType)) continue;
            CommPortIdentifier.addPortName(PortName, PortType, this);
        }
    }

    private boolean registerSpecifiedPorts(int PortType) {
        String val = null;
        try {
            String ext_dir = String.valueOf(System.getProperty("java.ext.dirs")) + System.getProperty("file.separator");
            FileInputStream rxtx_prop = new FileInputStream(String.valueOf(ext_dir) + "gnu.io.rxtx.properties");
            Properties p = new Properties(System.getProperties());
            p.load(rxtx_prop);
            System.setProperties(p);
        }
        catch (Exception exception) {
            // empty catch block
        }
        switch (PortType) {
            case 1: {
                val = System.getProperty("gnu.io.rxtx.SerialPorts");
                if (val != null) break;
                val = System.getProperty("gnu.io.SerialPorts");
                break;
            }
            case 2: {
                val = System.getProperty("gnu.io.rxtx.ParallelPorts");
                if (val != null) break;
                val = System.getProperty("gnu.io.ParallelPorts");
                break;
            }
        }
        if (val != null) {
            this.addSpecifiedPorts(val, PortType);
            return true;
        }
        return false;
    }

    private void registerScannedPorts(int PortType) {
        String[] CandidateDeviceNames;
        String[] temp;
        if (this.osName.equals("Windows CE")) {
            temp = new String[]{"COM1:", "COM2:", "COM3:", "COM4:", "COM5:", "COM6:", "COM7:", "COM8:"};
            CandidateDeviceNames = temp;
        } else if (this.osName.toLowerCase().indexOf("windows") != -1) {
            temp = new String[]{"COM1", "COM2", "COM3", "COM4", "COM5", "COM6", "COM7", "COM8"};
            CandidateDeviceNames = temp;
        } else if (this.osName.equals("Solaris") || this.osName.equals("SunOS")) {
            String[] term = new String[2];
            int l = 0;
            File dev = null;
            dev = new File("/dev/term");
            dev.list();
            term[l++] = new String("term/");
            String[] temp2 = new String[l];
            --l;
            while (l >= 0) {
                temp2[l] = term[l];
                --l;
            }
            CandidateDeviceNames = temp2;
        } else {
            String[] temp3;
            File dev = new File(this.deviceDirectory);
            CandidateDeviceNames = temp3 = dev.list();
        }
        if (CandidateDeviceNames == null) {
            return;
        }
        String[] CandidatePortPrefixes = new String[]{};
        switch (PortType) {
            case 1: {
                if (this.osName.equals("Linux")) {
                    String[] Temp = new String[]{"ttyS"};
                    CandidatePortPrefixes = Temp;
                    break;
                }
                if (this.osName.equals("Linux-all-ports")) {
                    String[] Temp = new String[]{"comx", "holter", "modem", "ttyircomm", "ttycosa0c", "ttycosa1c", "ttyC", "ttyCH", "ttyD", "ttyE", "ttyF", "ttyH", "ttyI", "ttyL", "ttyM", "ttyMX", "ttyP", "ttyR", "ttyS", "ttySI", "ttySR", "ttyT", "ttyUSB", "ttyV", "ttyW", "ttyX"};
                    CandidatePortPrefixes = Temp;
                    break;
                }
                if (this.osName.equals("Irix")) {
                    String[] Temp = new String[]{"ttyc", "ttyd", "ttyf", "ttym", "ttyq", "tty4d", "tty4f", "midi", "us"};
                    CandidatePortPrefixes = Temp;
                    break;
                }
                if (this.osName.equals("FreeBSD")) {
                    String[] Temp = new String[]{"cuaa"};
                    CandidatePortPrefixes = Temp;
                    break;
                }
                if (this.osName.equals("NetBSD")) {
                    String[] Temp = new String[]{"tty0"};
                    CandidatePortPrefixes = Temp;
                    break;
                }
                if (this.osName.equals("Solaris") || this.osName.equals("SunOS")) {
                    String[] Temp = new String[]{"term/", "cua/"};
                    CandidatePortPrefixes = Temp;
                    break;
                }
                if (this.osName.equals("HP-UX")) {
                    String[] Temp = new String[]{"tty0p", "tty1p"};
                    CandidatePortPrefixes = Temp;
                    break;
                }
                if (this.osName.equals("UnixWare") || this.osName.equals("OpenUNIX")) {
                    String[] Temp = new String[]{"tty00s", "tty01s", "tty02s", "tty03s"};
                    CandidatePortPrefixes = Temp;
                    break;
                }
                if (this.osName.equals("OpenServer")) {
                    String[] Temp = new String[]{"tty1A", "tty2A", "tty3A", "tty4A", "tty5A", "tty6A", "tty7A", "tty8A", "tty9A", "tty10A", "tty11A", "tty12A", "tty13A", "tty14A", "tty15A", "tty16A", "ttyu1A", "ttyu2A", "ttyu3A", "ttyu4A", "ttyu5A", "ttyu6A", "ttyu7A", "ttyu8A", "ttyu9A", "ttyu10A", "ttyu11A", "ttyu12A", "ttyu13A", "ttyu14A", "ttyu15A", "ttyu16A"};
                    CandidatePortPrefixes = Temp;
                    break;
                }
                if (this.osName.equals("Compaq's Digital UNIX") || this.osName.equals("OSF1")) {
                    String[] Temp = new String[]{"tty0"};
                    CandidatePortPrefixes = Temp;
                    break;
                }
                if (this.osName.equals("BeOS")) {
                    String[] Temp = new String[]{"serial"};
                    CandidatePortPrefixes = Temp;
                    break;
                }
                if (this.osName.equals("Mac OS X")) {
                    String[] Temp = new String[]{"cu.KeyUSA28X191.", "tty.KeyUSA28X191.", "cu.KeyUSA28X181.", "tty.KeyUSA28X181.", "cu.KeyUSA19181.", "tty.KeyUSA19181."};
                    CandidatePortPrefixes = Temp;
                    break;
                }
                if (this.osName.toLowerCase().indexOf("windows") == -1) break;
                String[] Temp = new String[]{"COM"};
                CandidatePortPrefixes = Temp;
                break;
            }
            case 2: {
                if (this.osName.equals("Linux")) {
                    String[] temp4 = new String[]{"lp"};
                    CandidatePortPrefixes = temp4;
                    break;
                }
                if (this.osName.equals("FreeBSD")) {
                    String[] temp5 = new String[]{"lpt"};
                    CandidatePortPrefixes = temp5;
                    break;
                }
                String[] temp6 = new String[]{};
                CandidatePortPrefixes = temp6;
                break;
            }
        }
        this.registerValidPorts(CandidateDeviceNames, CandidatePortPrefixes, PortType);
    }

    public CommPort getCommPort(String PortName, int PortType) {
        try {
            switch (PortType) {
                case 1: {
                    return new RXTXPort(PortName);
                }
                case 2: {
                    return new LPRPort(PortName);
                }
                default: {
                    return null;
                }
            }
        }
        catch (PortInUseException portInUseException) {
            return null;
        }
    }

    public void Report(String arg) {
        System.out.println(arg);
    }
}

