/* rygel-gst-utils.c generated by valac 0.12.0, the Vala compiler
 * generated from rygel-gst-utils.vala, do not modify */

/*
 * Copyright (C) 2009 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gst/gst.h>
#include <glib/gi18n-lib.h>
#include <stdio.h>
#include <gobject/gvaluecollector.h>


#define RYGEL_TYPE_GST_UTILS (rygel_gst_utils_get_type ())
#define RYGEL_GST_UTILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_GST_UTILS, RygelGstUtils))
#define RYGEL_GST_UTILS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_GST_UTILS, RygelGstUtilsClass))
#define RYGEL_IS_GST_UTILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_GST_UTILS))
#define RYGEL_IS_GST_UTILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_GST_UTILS))
#define RYGEL_GST_UTILS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_GST_UTILS, RygelGstUtilsClass))

typedef struct _RygelGstUtils RygelGstUtils;
typedef struct _RygelGstUtilsClass RygelGstUtilsClass;
typedef struct _RygelGstUtilsPrivate RygelGstUtilsPrivate;
#define _gst_object_unref0(var) ((var == NULL) ? NULL : (var = (gst_object_unref (var), NULL)))
#define __g_list_free__gst_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__gst_object_unref0_ (var), NULL)))
#define _gst_structure_free0(var) ((var == NULL) ? NULL : (var = (gst_structure_free (var), NULL)))
typedef struct _RygelParamSpecGstUtils RygelParamSpecGstUtils;

typedef enum  {
	RYGEL_GST_ERROR_MISSING_PLUGIN,
	RYGEL_GST_ERROR_LINK
} RygelGstError;
#define RYGEL_GST_ERROR rygel_gst_error_quark ()
struct _RygelGstUtils {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelGstUtilsPrivate * priv;
};

struct _RygelGstUtilsClass {
	GTypeClass parent_class;
	void (*finalize) (RygelGstUtils *self);
};

struct _RygelParamSpecGstUtils {
	GParamSpec parent_instance;
};


static gpointer rygel_gst_utils_parent_class = NULL;

GQuark rygel_gst_error_quark (void);
gpointer rygel_gst_utils_ref (gpointer instance);
void rygel_gst_utils_unref (gpointer instance);
GParamSpec* rygel_param_spec_gst_utils (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_gst_utils (GValue* value, gpointer v_object);
void rygel_value_take_gst_utils (GValue* value, gpointer v_object);
gpointer rygel_value_get_gst_utils (const GValue* value);
GType rygel_gst_utils_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_GST_UTILS_DUMMY_PROPERTY
};
GstElement* rygel_gst_utils_create_element (const gchar* factoryname, const gchar* name, GError** error);
GstClockTime rygel_gst_utils_time_from_string (const gchar* str);
gchar* rygel_gst_utils_time_to_string (GstClockTime time);
GstElement* rygel_gst_utils_create_source_for_uri (const gchar* uri);
static inline void _dynamic_set_blocksize5 (GstElement* obj, glong value);
static inline void _dynamic_set_tcp_timeout6 (GstElement* obj, gint64 value);
GstElement* rygel_gst_utils_get_rtp_depayloader (GstCaps* caps);
static gboolean rygel_gst_utils_need_rtp_depayloader (GstCaps* caps);
static gboolean rygel_gst_utils_rtp_depay_filter (GstPluginFeature* feature);
static gboolean _rygel_gst_utils_rtp_depay_filter_gst_plugin_feature_filter (GstPluginFeature* feature, gpointer self);
static GstElement* rygel_gst_utils_get_best_depay (GList* features, GstCaps* caps);
static void _gst_object_unref0_ (gpointer var);
static void _g_list_free__gst_object_unref0_ (GList* self);
static gint rygel_gst_utils_compare_factories (GstElementFactory* factory_a, GstElementFactory* factory_b);
static gint _rygel_gst_utils_compare_factories_gcompare_func (gconstpointer a, gconstpointer b);
RygelGstUtils* rygel_gst_utils_construct (GType object_type);
static void rygel_gst_utils_finalize (RygelGstUtils* obj);


GQuark rygel_gst_error_quark (void) {
	return g_quark_from_static_string ("rygel_gst_error-quark");
}


GstElement* rygel_gst_utils_create_element (const gchar* factoryname, const gchar* name, GError** error) {
	GstElement* result = NULL;
	GstElement* _tmp0_ = NULL;
	GstElement* element;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (factoryname != NULL, NULL);
	_tmp0_ = gst_element_factory_make (factoryname, name);
	element = _tmp0_;
	if (element == NULL) {
		const gchar* _tmp1_ = NULL;
		GError* _tmp2_ = NULL;
		_tmp1_ = _ ("Required element %s missing");
		_tmp2_ = g_error_new (RYGEL_GST_ERROR, RYGEL_GST_ERROR_MISSING_PLUGIN, _tmp1_, factoryname);
		_inner_error_ = _tmp2_;
		g_propagate_error (error, _inner_error_);
		_gst_object_unref0 (element);
		return NULL;
	}
	result = element;
	return result;
}


GstClockTime rygel_gst_utils_time_from_string (const gchar* str) {
	GstClockTime result = 0ULL;
	guint64 hours = 0ULL;
	guint64 minutes = 0ULL;
	guint64 seconds = 0ULL;
	g_return_val_if_fail (str != NULL, 0ULL);
	sscanf (str, "%llu:%2llu:%2llu%*s", &hours, &minutes, &seconds);
	result = (GstClockTime) ((((hours * 3600) + (minutes * 60)) + seconds) * GST_SECOND);
	return result;
}


gchar* rygel_gst_utils_time_to_string (GstClockTime time) {
	gchar* result = NULL;
	guint64 hours = 0ULL;
	guint64 minutes = 0ULL;
	guint64 seconds = 0ULL;
	gchar* _tmp0_ = NULL;
	hours = (guint64) ((time / GST_SECOND) / 3600);
	seconds = (guint64) ((time / GST_SECOND) % 3600);
	minutes = seconds / 60;
	seconds = seconds % 60;
	_tmp0_ = g_strdup_printf ("%llu:%.2llu:%.2llu", hours, minutes, seconds);
	result = _tmp0_;
	return result;
}


static inline void _dynamic_set_blocksize5 (GstElement* obj, glong value) {
	g_object_set (obj, "blocksize", value, NULL);
}


static inline void _dynamic_set_tcp_timeout6 (GstElement* obj, gint64 value) {
	g_object_set (obj, "tcp-timeout", value, NULL);
}


GstElement* rygel_gst_utils_create_source_for_uri (const gchar* uri) {
	GstElement* result = NULL;
	GstElement* _tmp0_ = NULL;
	GstElement* src;
	g_return_val_if_fail (uri != NULL, NULL);
	_tmp0_ = gst_element_make_from_uri (GST_URI_SRC, uri, NULL);
	src = _tmp0_;
	if (src != NULL) {
		GObjectClass* _tmp1_ = NULL;
		GParamSpec* _tmp2_ = NULL;
		GObjectClass* _tmp3_ = NULL;
		GParamSpec* _tmp4_ = NULL;
		_tmp1_ = G_OBJECT_GET_CLASS ((GObject*) src);
		_tmp2_ = g_object_class_find_property (_tmp1_, "blocksize");
		if (_tmp2_ != NULL) {
			_dynamic_set_blocksize5 (src, (glong) 65536);
		}
		_tmp3_ = G_OBJECT_GET_CLASS ((GObject*) src);
		_tmp4_ = g_object_class_find_property (_tmp3_, "tcp-timeout");
		if (_tmp4_ != NULL) {
			_dynamic_set_tcp_timeout6 (src, (gint64) 60000000);
		}
	}
	result = src;
	return result;
}


static gboolean _rygel_gst_utils_rtp_depay_filter_gst_plugin_feature_filter (GstPluginFeature* feature, gpointer self) {
	gboolean result;
	result = rygel_gst_utils_rtp_depay_filter (feature);
	return result;
}


static void _gst_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (gst_object_unref (var), NULL));
}


static void _g_list_free__gst_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _gst_object_unref0_, NULL);
	g_list_free (self);
}


GstElement* rygel_gst_utils_get_rtp_depayloader (GstCaps* caps) {
	GstElement* result = NULL;
	gboolean _tmp0_;
	GstRegistry* _tmp1_ = NULL;
	GstRegistry* registry;
	GList* _tmp2_ = NULL;
	GList* features;
	GstElement* _tmp3_ = NULL;
	g_return_val_if_fail (caps != NULL, NULL);
	_tmp0_ = rygel_gst_utils_need_rtp_depayloader (caps);
	if (!_tmp0_) {
		result = NULL;
		return result;
	}
	_tmp1_ = gst_registry_get_default ();
	registry = _tmp1_;
	_tmp2_ = gst_registry_feature_filter (registry, _rygel_gst_utils_rtp_depay_filter_gst_plugin_feature_filter, FALSE, NULL);
	features = _tmp2_;
	_tmp3_ = rygel_gst_utils_get_best_depay (features, caps);
	result = _tmp3_;
	__g_list_free__gst_object_unref0_0 (features);
	return result;
}


static gpointer _gst_structure_copy0 (gpointer self) {
	return self ? gst_structure_copy (self) : NULL;
}


static gboolean rygel_gst_utils_need_rtp_depayloader (GstCaps* caps) {
	gboolean result = FALSE;
	const GstStructure* _tmp0_ = NULL;
	GstStructure* _tmp1_;
	GstStructure* structure;
	const gchar* _tmp2_ = NULL;
	g_return_val_if_fail (caps != NULL, FALSE);
	_tmp0_ = gst_caps_get_structure (caps, (guint) 0);
	_tmp1_ = _gst_structure_copy0 (_tmp0_);
	structure = _tmp1_;
	_tmp2_ = gst_structure_get_name (structure);
	result = g_strcmp0 (_tmp2_, "application/x-rtp") == 0;
	_gst_structure_free0 (structure);
	return result;
}


static gpointer _gst_object_ref0 (gpointer self) {
	return self ? gst_object_ref (self) : NULL;
}


static gint _rygel_gst_utils_compare_factories_gcompare_func (gconstpointer a, gconstpointer b) {
	gint result;
	result = rygel_gst_utils_compare_factories (a, b);
	return result;
}


static GstElement* rygel_gst_utils_get_best_depay (GList* features, GstCaps* caps) {
	GstElement* result = NULL;
	GList* relevant_factories;
	guint _tmp4_;
	GstElementFactory* _tmp5_;
	GstElementFactory* factory;
	const gchar* _tmp6_ = NULL;
	GstElement* _tmp7_ = NULL;
	g_return_val_if_fail (caps != NULL, NULL);
	relevant_factories = NULL;
	{
		GList* feature_collection;
		GList* feature_it;
		feature_collection = features;
		for (feature_it = feature_collection; feature_it != NULL; feature_it = feature_it->next) {
			GstPluginFeature* _tmp0_;
			GstPluginFeature* feature;
			_tmp0_ = _gst_object_ref0 ((GstPluginFeature*) feature_it->data);
			feature = _tmp0_;
			{
				GstElementFactory* _tmp1_;
				GstElementFactory* factory;
				gboolean _tmp2_;
				_tmp1_ = _gst_object_ref0 (GST_ELEMENT_FACTORY (feature));
				factory = _tmp1_;
				_tmp2_ = gst_element_factory_can_sink_caps (factory, caps);
				if (_tmp2_) {
					GstElementFactory* _tmp3_;
					_tmp3_ = _gst_object_ref0 (factory);
					relevant_factories = g_list_append (relevant_factories, _tmp3_);
				}
				_gst_object_unref0 (factory);
				_gst_object_unref0 (feature);
			}
		}
	}
	_tmp4_ = g_list_length (relevant_factories);
	if (_tmp4_ == 0) {
		result = NULL;
		__g_list_free__gst_object_unref0_0 (relevant_factories);
		return result;
	}
	relevant_factories = g_list_sort (relevant_factories, _rygel_gst_utils_compare_factories_gcompare_func);
	_tmp5_ = _gst_object_ref0 ((GstElementFactory*) relevant_factories->data);
	factory = _tmp5_;
	_tmp6_ = gst_plugin_feature_get_name ((GstPluginFeature*) factory);
	_tmp7_ = gst_element_factory_make (_tmp6_, NULL);
	result = _tmp7_;
	_gst_object_unref0 (factory);
	__g_list_free__gst_object_unref0_0 (relevant_factories);
	return result;
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}


static gboolean rygel_gst_utils_rtp_depay_filter (GstPluginFeature* feature) {
	gboolean result = FALSE;
	GType _tmp0_;
	gboolean _tmp1_;
	GstElementFactory* _tmp2_;
	GstElementFactory* factory;
	const gchar* _tmp3_ = NULL;
	gboolean _tmp4_;
	g_return_val_if_fail (feature != NULL, FALSE);
	_tmp0_ = G_TYPE_FROM_INSTANCE ((GObject*) feature);
	_tmp1_ = g_type_is_a (_tmp0_, GST_TYPE_ELEMENT_FACTORY);
	if (!_tmp1_) {
		result = FALSE;
		return result;
	}
	_tmp2_ = _gst_object_ref0 (GST_ELEMENT_FACTORY (feature));
	factory = _tmp2_;
	_tmp3_ = gst_element_factory_get_klass (factory);
	_tmp4_ = string_contains (_tmp3_, "Depayloader");
	result = _tmp4_;
	_gst_object_unref0 (factory);
	return result;
}


static gint rygel_gst_utils_compare_factories (GstElementFactory* factory_a, GstElementFactory* factory_b) {
	gint result = 0;
	guint _tmp0_;
	guint _tmp1_;
	g_return_val_if_fail (factory_a != NULL, 0);
	g_return_val_if_fail (factory_b != NULL, 0);
	_tmp0_ = gst_plugin_feature_get_rank ((GstPluginFeature*) factory_b);
	_tmp1_ = gst_plugin_feature_get_rank ((GstPluginFeature*) factory_a);
	result = (gint) (_tmp0_ - _tmp1_);
	return result;
}


RygelGstUtils* rygel_gst_utils_construct (GType object_type) {
	RygelGstUtils* self = NULL;
	self = (RygelGstUtils*) g_type_create_instance (object_type);
	return self;
}


static void rygel_value_gst_utils_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void rygel_value_gst_utils_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		rygel_gst_utils_unref (value->data[0].v_pointer);
	}
}


static void rygel_value_gst_utils_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = rygel_gst_utils_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer rygel_value_gst_utils_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* rygel_value_gst_utils_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		RygelGstUtils* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = rygel_gst_utils_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* rygel_value_gst_utils_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	RygelGstUtils** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = rygel_gst_utils_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* rygel_param_spec_gst_utils (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	RygelParamSpecGstUtils* spec;
	g_return_val_if_fail (g_type_is_a (object_type, RYGEL_TYPE_GST_UTILS), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer rygel_value_get_gst_utils (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_GST_UTILS), NULL);
	return value->data[0].v_pointer;
}


void rygel_value_set_gst_utils (GValue* value, gpointer v_object) {
	RygelGstUtils* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_GST_UTILS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_GST_UTILS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		rygel_gst_utils_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_gst_utils_unref (old);
	}
}


void rygel_value_take_gst_utils (GValue* value, gpointer v_object) {
	RygelGstUtils* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_GST_UTILS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_GST_UTILS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_gst_utils_unref (old);
	}
}


static void rygel_gst_utils_class_init (RygelGstUtilsClass * klass) {
	rygel_gst_utils_parent_class = g_type_class_peek_parent (klass);
	RYGEL_GST_UTILS_CLASS (klass)->finalize = rygel_gst_utils_finalize;
}


static void rygel_gst_utils_instance_init (RygelGstUtils * self) {
	self->ref_count = 1;
}


static void rygel_gst_utils_finalize (RygelGstUtils* obj) {
	RygelGstUtils * self;
	self = RYGEL_GST_UTILS (obj);
}


GType rygel_gst_utils_get_type (void) {
	static volatile gsize rygel_gst_utils_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_gst_utils_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { rygel_value_gst_utils_init, rygel_value_gst_utils_free_value, rygel_value_gst_utils_copy_value, rygel_value_gst_utils_peek_pointer, "p", rygel_value_gst_utils_collect_value, "p", rygel_value_gst_utils_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (RygelGstUtilsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_gst_utils_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelGstUtils), 0, (GInstanceInitFunc) rygel_gst_utils_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType rygel_gst_utils_type_id;
		rygel_gst_utils_type_id = g_type_register_fundamental (g_type_fundamental_next (), "RygelGstUtils", &g_define_type_info, &g_define_type_fundamental_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&rygel_gst_utils_type_id__volatile, rygel_gst_utils_type_id);
	}
	return rygel_gst_utils_type_id__volatile;
}


gpointer rygel_gst_utils_ref (gpointer instance) {
	RygelGstUtils* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void rygel_gst_utils_unref (gpointer instance) {
	RygelGstUtils* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		RYGEL_GST_UTILS_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}



