/* rygel-http-item-uri-test.c generated by valac 0.15.2.4-51044, the Vala compiler
 * generated from rygel-http-item-uri-test.vala, do not modify */

/*
 * Copyright (C) 2010 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshan.ali@nokia.com>
 *                               <zeeshanak@gnome.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libsoup/soup.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp/gupnp.h>
#include <libgssdp/gssdp.h>
#include <gee.h>
#include <gobject/gvaluecollector.h>


#define RYGEL_TYPE_TRANSCODER (rygel_transcoder_get_type ())
#define RYGEL_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODER, RygelTranscoder))
#define RYGEL_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODER, RygelTranscoderClass))
#define RYGEL_IS_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODER))
#define RYGEL_IS_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODER))
#define RYGEL_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODER, RygelTranscoderClass))

typedef struct _RygelTranscoder RygelTranscoder;
typedef struct _RygelTranscoderClass RygelTranscoderClass;
typedef struct _RygelTranscoderPrivate RygelTranscoderPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;
typedef struct _RygelHTTPServerPrivate RygelHTTPServerPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;
typedef struct _RygelMediaItemPrivate RygelMediaItemPrivate;

#define RYGEL_TYPE_THUMBNAIL (rygel_thumbnail_get_type ())
#define RYGEL_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnail))
#define RYGEL_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))
#define RYGEL_IS_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_IS_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_THUMBNAIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))

typedef struct _RygelThumbnail RygelThumbnail;
typedef struct _RygelThumbnailClass RygelThumbnailClass;
typedef struct _RygelThumbnailPrivate RygelThumbnailPrivate;
typedef struct _RygelParamSpecThumbnail RygelParamSpecThumbnail;

#define RYGEL_TYPE_VISUAL_ITEM (rygel_visual_item_get_type ())
#define RYGEL_VISUAL_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_VISUAL_ITEM, RygelVisualItem))
#define RYGEL_VISUAL_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_VISUAL_ITEM, RygelVisualItemClass))
#define RYGEL_IS_VISUAL_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_VISUAL_ITEM))
#define RYGEL_IS_VISUAL_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_VISUAL_ITEM))
#define RYGEL_VISUAL_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_VISUAL_ITEM, RygelVisualItemClass))

typedef struct _RygelVisualItem RygelVisualItem;
typedef struct _RygelVisualItemClass RygelVisualItemClass;
typedef struct _RygelVisualItemPrivate RygelVisualItemPrivate;

#define RYGEL_TYPE_SUBTITLE (rygel_subtitle_get_type ())
#define RYGEL_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitle))
#define RYGEL_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))
#define RYGEL_IS_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SUBTITLE))
#define RYGEL_IS_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SUBTITLE))
#define RYGEL_SUBTITLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))

typedef struct _RygelSubtitle RygelSubtitle;
typedef struct _RygelSubtitleClass RygelSubtitleClass;
typedef struct _RygelSubtitlePrivate RygelSubtitlePrivate;

#define RYGEL_TYPE_VIDEO_ITEM (rygel_video_item_get_type ())
#define RYGEL_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItem))
#define RYGEL_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItemClass))
#define RYGEL_IS_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_VIDEO_ITEM))
#define RYGEL_IS_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_VIDEO_ITEM))
#define RYGEL_VIDEO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItemClass))

typedef struct _RygelVideoItem RygelVideoItem;
typedef struct _RygelVideoItemClass RygelVideoItemClass;
typedef struct _RygelVideoItemPrivate RygelVideoItemPrivate;

#define RYGEL_TYPE_MUSIC_ITEM (rygel_music_item_get_type ())
#define RYGEL_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItem))
#define RYGEL_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItemClass))
#define RYGEL_IS_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MUSIC_ITEM))
#define RYGEL_IS_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MUSIC_ITEM))
#define RYGEL_MUSIC_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItemClass))

typedef struct _RygelMusicItem RygelMusicItem;
typedef struct _RygelMusicItemClass RygelMusicItemClass;
typedef struct _RygelMusicItemPrivate RygelMusicItemPrivate;
#define _rygel_thumbnail_unref0(var) ((var == NULL) ? NULL : (var = (rygel_thumbnail_unref (var), NULL)))

#define RYGEL_TYPE_HTTP_ITEM_URI_TEST (rygel_http_item_uri_test_get_type ())
#define RYGEL_HTTP_ITEM_URI_TEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_ITEM_URI_TEST, RygelHTTPItemURITest))
#define RYGEL_HTTP_ITEM_URI_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_ITEM_URI_TEST, RygelHTTPItemURITestClass))
#define RYGEL_IS_HTTP_ITEM_URI_TEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_ITEM_URI_TEST))
#define RYGEL_IS_HTTP_ITEM_URI_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_ITEM_URI_TEST))
#define RYGEL_HTTP_ITEM_URI_TEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_ITEM_URI_TEST, RygelHTTPItemURITestClass))

typedef struct _RygelHTTPItemURITest RygelHTTPItemURITest;
typedef struct _RygelHTTPItemURITestClass RygelHTTPItemURITestClass;
typedef struct _RygelHTTPItemURITestPrivate RygelHTTPItemURITestPrivate;

#define RYGEL_TYPE_HTTP_ITEM_URI (rygel_http_item_uri_get_type ())
#define RYGEL_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURI))
#define RYGEL_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))
#define RYGEL_IS_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_IS_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_HTTP_ITEM_URI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))

typedef struct _RygelHTTPItemURI RygelHTTPItemURI;
typedef struct _RygelHTTPItemURIClass RygelHTTPItemURIClass;

typedef enum  {
	RYGEL_HTTP_REQUEST_ERROR_UNACCEPTABLE = SOUP_STATUS_NOT_ACCEPTABLE,
	RYGEL_HTTP_REQUEST_ERROR_BAD_REQUEST = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND = SOUP_STATUS_NOT_FOUND
} RygelHTTPRequestError;
#define RYGEL_HTTP_REQUEST_ERROR rygel_http_request_error_quark ()
typedef enum  {
	RYGEL_TEST_ERROR_SKIP
} RygelTestError;
#define RYGEL_TEST_ERROR rygel_test_error_quark ()
struct _RygelTranscoder {
	GObject parent_instance;
	RygelTranscoderPrivate * priv;
};

struct _RygelTranscoderClass {
	GObjectClass parent_class;
};

struct _RygelTranscoderPrivate {
	gchar* _extension;
};

struct _RygelHTTPServer {
	GObject parent_instance;
	RygelHTTPServerPrivate * priv;
	GUPnPContext* context;
};

struct _RygelHTTPServerClass {
	GObjectClass parent_class;
};

struct _RygelHTTPServerPrivate {
	gchar* _path_root;
};

struct _RygelMediaItem {
	GObject parent_instance;
	RygelMediaItemPrivate * priv;
	gchar* id;
	GeeArrayList* uris;
	gchar* mime_type;
};

struct _RygelMediaItemClass {
	GObjectClass parent_class;
};

struct _RygelThumbnail {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelThumbnailPrivate * priv;
	gchar* file_extension;
};

struct _RygelThumbnailClass {
	GTypeClass parent_class;
	void (*finalize) (RygelThumbnail *self);
};

struct _RygelParamSpecThumbnail {
	GParamSpec parent_instance;
};

struct _RygelVisualItem {
	RygelMediaItem parent_instance;
	RygelVisualItemPrivate * priv;
	GeeArrayList* thumbnails;
};

struct _RygelVisualItemClass {
	RygelMediaItemClass parent_class;
};

struct _RygelSubtitle {
	GObject parent_instance;
	RygelSubtitlePrivate * priv;
	gchar* caption_type;
};

struct _RygelSubtitleClass {
	GObjectClass parent_class;
};

struct _RygelVideoItem {
	RygelVisualItem parent_instance;
	RygelVideoItemPrivate * priv;
	GeeArrayList* subtitles;
};

struct _RygelVideoItemClass {
	RygelVisualItemClass parent_class;
};

struct _RygelMusicItem {
	RygelMediaItem parent_instance;
	RygelMusicItemPrivate * priv;
	RygelThumbnail* album_art;
};

struct _RygelMusicItemClass {
	RygelMediaItemClass parent_class;
};

struct _RygelHTTPItemURITest {
	GObject parent_instance;
	RygelHTTPItemURITestPrivate * priv;
};

struct _RygelHTTPItemURITestClass {
	GObjectClass parent_class;
};

struct _RygelHTTPItemURITestPrivate {
	RygelVisualItem* item;
	RygelHTTPServer* server;
};


static gpointer rygel_transcoder_parent_class = NULL;
static gpointer rygel_http_server_parent_class = NULL;
static gpointer rygel_media_item_parent_class = NULL;
static gpointer rygel_thumbnail_parent_class = NULL;
static gpointer rygel_visual_item_parent_class = NULL;
static gpointer rygel_subtitle_parent_class = NULL;
static gpointer rygel_video_item_parent_class = NULL;
static gpointer rygel_music_item_parent_class = NULL;
static gpointer rygel_http_item_uri_test_parent_class = NULL;

GQuark rygel_http_request_error_quark (void);
GQuark rygel_test_error_quark (void);
GType rygel_transcoder_get_type (void) G_GNUC_CONST;
#define RYGEL_TRANSCODER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_TRANSCODER, RygelTranscoderPrivate))
enum  {
	RYGEL_TRANSCODER_DUMMY_PROPERTY,
	RYGEL_TRANSCODER_EXTENSION
};
RygelTranscoder* rygel_transcoder_new (const gchar* extension);
RygelTranscoder* rygel_transcoder_construct (GType object_type, const gchar* extension);
void rygel_transcoder_set_extension (RygelTranscoder* self, const gchar* value);
const gchar* rygel_transcoder_get_extension (RygelTranscoder* self);
static void rygel_transcoder_finalize (GObject* obj);
static void _vala_rygel_transcoder_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_transcoder_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType rygel_http_server_get_type (void) G_GNUC_CONST;
#define RYGEL_HTTP_SERVER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerPrivate))
enum  {
	RYGEL_HTTP_SERVER_DUMMY_PROPERTY,
	RYGEL_HTTP_SERVER_PATH_ROOT
};
#define RYGEL_HTTP_SERVER_SERVER_PATH "/Test"
RygelHTTPServer* rygel_http_server_new (GError** error);
RygelHTTPServer* rygel_http_server_construct (GType object_type, GError** error);
static void rygel_http_server_set_path_root (RygelHTTPServer* self, const gchar* value);
RygelTranscoder* rygel_http_server_get_transcoder (RygelHTTPServer* self, const gchar* target, GError** error);
const gchar* rygel_http_server_get_path_root (RygelHTTPServer* self);
static void rygel_http_server_finalize (GObject* obj);
static void _vala_rygel_http_server_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_http_server_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType rygel_media_item_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_MEDIA_ITEM_DUMMY_PROPERTY
};
RygelMediaItem* rygel_media_item_new (void);
RygelMediaItem* rygel_media_item_construct (GType object_type);
static void rygel_media_item_finalize (GObject* obj);
gpointer rygel_thumbnail_ref (gpointer instance);
void rygel_thumbnail_unref (gpointer instance);
GParamSpec* rygel_param_spec_thumbnail (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_thumbnail (GValue* value, gpointer v_object);
void rygel_value_take_thumbnail (GValue* value, gpointer v_object);
gpointer rygel_value_get_thumbnail (const GValue* value);
GType rygel_thumbnail_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_THUMBNAIL_DUMMY_PROPERTY
};
RygelThumbnail* rygel_thumbnail_new (void);
RygelThumbnail* rygel_thumbnail_construct (GType object_type);
static void rygel_thumbnail_finalize (RygelThumbnail* obj);
GType rygel_visual_item_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_VISUAL_ITEM_DUMMY_PROPERTY
};
RygelVisualItem* rygel_visual_item_new (void);
RygelVisualItem* rygel_visual_item_construct (GType object_type);
static void rygel_visual_item_finalize (GObject* obj);
GType rygel_subtitle_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_SUBTITLE_DUMMY_PROPERTY
};
RygelSubtitle* rygel_subtitle_new (void);
RygelSubtitle* rygel_subtitle_construct (GType object_type);
static void rygel_subtitle_finalize (GObject* obj);
GType rygel_video_item_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_VIDEO_ITEM_DUMMY_PROPERTY
};
RygelVideoItem* rygel_video_item_new (void);
RygelVideoItem* rygel_video_item_construct (GType object_type);
static void rygel_video_item_finalize (GObject* obj);
GType rygel_music_item_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_MUSIC_ITEM_DUMMY_PROPERTY
};
RygelMusicItem* rygel_music_item_new (void);
RygelMusicItem* rygel_music_item_construct (GType object_type);
static void rygel_music_item_finalize (GObject* obj);
GType rygel_http_item_uri_test_get_type (void) G_GNUC_CONST;
#define RYGEL_HTTP_ITEM_URI_TEST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_HTTP_ITEM_URI_TEST, RygelHTTPItemURITestPrivate))
enum  {
	RYGEL_HTTP_ITEM_URI_TEST_DUMMY_PROPERTY
};
#define RYGEL_HTTP_ITEM_URI_TEST_THUMBNAIL_INDEX 1
#define RYGEL_HTTP_ITEM_URI_TEST_SUBTITLE_INDEX 1
#define RYGEL_HTTP_ITEM_URI_TEST_TRANSCODE_TARGET "MP3"
gint rygel_http_item_uri_test_main (gchar** args, int args_length1);
static RygelHTTPItemURITest* rygel_http_item_uri_test_new (GError** error);
static RygelHTTPItemURITest* rygel_http_item_uri_test_construct (GType object_type, GError** error);
void rygel_http_item_uri_test_run (RygelHTTPItemURITest* self, GError** error);
GType rygel_http_item_uri_get_type (void) G_GNUC_CONST;
static RygelHTTPItemURI* rygel_http_item_uri_test_test_construction (RygelHTTPItemURITest* self);
static RygelHTTPItemURI* rygel_http_item_uri_test_test_construction_with_thumbnail (RygelHTTPItemURITest* self);
static RygelHTTPItemURI* rygel_http_item_uri_test_test_construction_with_subtitle (RygelHTTPItemURITest* self);
static RygelHTTPItemURI* rygel_http_item_uri_test_test_construction_with_transcoder (RygelHTTPItemURITest* self);
static gchar* rygel_http_item_uri_test_test_to_string (RygelHTTPItemURITest* self, RygelHTTPItemURI* uri);
static RygelHTTPItemURI* rygel_http_item_uri_test_test_construction_from_string (RygelHTTPItemURITest* self, const gchar* str, GError** error);
static void rygel_http_item_uri_test_test_error_construction (RygelHTTPItemURITest* self, const gchar* str, SoupKnownStatusCode error_code);
RygelHTTPItemURI* rygel_http_item_uri_new (RygelMediaItem* item, RygelHTTPServer* http_server, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target);
RygelHTTPItemURI* rygel_http_item_uri_construct (GType object_type, RygelMediaItem* item, RygelHTTPServer* http_server, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target);
RygelHTTPItemURI* rygel_http_item_uri_new_from_string (const gchar* uri, RygelHTTPServer* http_server, GError** error);
RygelHTTPItemURI* rygel_http_item_uri_construct_from_string (GType object_type, const gchar* uri, RygelHTTPServer* http_server, GError** error);
gchar* rygel_http_item_uri_to_string (RygelHTTPItemURI* self);
static void rygel_http_item_uri_test_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


GQuark rygel_http_request_error_quark (void) {
	return g_quark_from_static_string ("rygel_http_request_error-quark");
}


GQuark rygel_test_error_quark (void) {
	return g_quark_from_static_string ("rygel_test_error-quark");
}


RygelTranscoder* rygel_transcoder_construct (GType object_type, const gchar* extension) {
	RygelTranscoder * self = NULL;
	const gchar* _tmp0_;
#line 39 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	g_return_val_if_fail (extension != NULL, NULL);
#line 39 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	self = (RygelTranscoder*) g_object_new (object_type, NULL);
#line 40 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp0_ = extension;
#line 40 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	rygel_transcoder_set_extension (self, _tmp0_);
#line 39 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	return self;
#line 414 "rygel-http-item-uri-test.c"
}


RygelTranscoder* rygel_transcoder_new (const gchar* extension) {
#line 39 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	return rygel_transcoder_construct (RYGEL_TYPE_TRANSCODER, extension);
#line 421 "rygel-http-item-uri-test.c"
}


const gchar* rygel_transcoder_get_extension (RygelTranscoder* self) {
	const gchar* result;
	const gchar* _tmp0_;
#line 37 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 37 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp0_ = self->priv->_extension;
#line 37 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	result = _tmp0_;
#line 37 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	return result;
#line 436 "rygel-http-item-uri-test.c"
}


void rygel_transcoder_set_extension (RygelTranscoder* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
#line 37 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	g_return_if_fail (self != NULL);
#line 37 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp0_ = value;
#line 37 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 37 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_g_free0 (self->priv->_extension);
#line 37 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	self->priv->_extension = _tmp1_;
#line 37 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	g_object_notify ((GObject *) self, "extension");
#line 455 "rygel-http-item-uri-test.c"
}


static void rygel_transcoder_class_init (RygelTranscoderClass * klass) {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	rygel_transcoder_parent_class = g_type_class_peek_parent (klass);
#line 36 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	g_type_class_add_private (klass, sizeof (RygelTranscoderPrivate));
#line 36 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_transcoder_get_property;
#line 36 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_transcoder_set_property;
#line 36 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_transcoder_finalize;
#line 36 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_TRANSCODER_EXTENSION, g_param_spec_string ("extension", "extension", "extension", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 472 "rygel-http-item-uri-test.c"
}


static void rygel_transcoder_instance_init (RygelTranscoder * self) {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	self->priv = RYGEL_TRANSCODER_GET_PRIVATE (self);
#line 479 "rygel-http-item-uri-test.c"
}


static void rygel_transcoder_finalize (GObject* obj) {
	RygelTranscoder * self;
#line 36 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	self = RYGEL_TRANSCODER (obj);
#line 37 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_g_free0 (self->priv->_extension);
#line 36 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	G_OBJECT_CLASS (rygel_transcoder_parent_class)->finalize (obj);
#line 491 "rygel-http-item-uri-test.c"
}


GType rygel_transcoder_get_type (void) {
	static volatile gsize rygel_transcoder_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_transcoder_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelTranscoderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_transcoder_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelTranscoder), 0, (GInstanceInitFunc) rygel_transcoder_instance_init, NULL };
		GType rygel_transcoder_type_id;
		rygel_transcoder_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelTranscoder", &g_define_type_info, 0);
		g_once_init_leave (&rygel_transcoder_type_id__volatile, rygel_transcoder_type_id);
	}
	return rygel_transcoder_type_id__volatile;
}


static void _vala_rygel_transcoder_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelTranscoder * self;
	self = RYGEL_TRANSCODER (object);
#line 36 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	switch (property_id) {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		case RYGEL_TRANSCODER_EXTENSION:
#line 36 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		g_value_set_string (value, rygel_transcoder_get_extension (self));
#line 36 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		break;
#line 518 "rygel-http-item-uri-test.c"
		default:
#line 36 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 36 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		break;
#line 524 "rygel-http-item-uri-test.c"
	}
}


static void _vala_rygel_transcoder_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelTranscoder * self;
	self = RYGEL_TRANSCODER (object);
#line 36 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	switch (property_id) {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		case RYGEL_TRANSCODER_EXTENSION:
#line 36 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		rygel_transcoder_set_extension (self, g_value_get_string (value));
#line 36 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		break;
#line 540 "rygel-http-item-uri-test.c"
		default:
#line 36 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 36 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		break;
#line 546 "rygel-http-item-uri-test.c"
	}
}


RygelHTTPServer* rygel_http_server_construct (GType object_type, GError** error) {
	RygelHTTPServer * self = NULL;
	GUPnPContext* _tmp3_;
	GUPnPContext* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	GUPnPContext* _tmp7_;
	guint _tmp8_;
	guint _tmp9_;
	GError * _inner_error_ = NULL;
#line 51 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	self = (RygelHTTPServer*) g_object_new (object_type, NULL);
#line 52 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	rygel_http_server_set_path_root (self, RYGEL_HTTP_SERVER_SERVER_PATH);
#line 565 "rygel-http-item-uri-test.c"
	{
		GUPnPContext* _tmp0_;
		GUPnPContext* _tmp1_;
#line 55 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		_tmp0_ = gupnp_context_new (NULL, "lo", (guint) 0, &_inner_error_);
#line 55 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		_tmp1_ = _tmp0_;
#line 55 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		if (_inner_error_ != NULL) {
#line 575 "rygel-http-item-uri-test.c"
			goto __catch0_g_error;
		}
#line 55 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		_g_object_unref0 (self->context);
#line 55 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		self->context = _tmp1_;
#line 582 "rygel-http-item-uri-test.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp2_;
#line 54 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		_error_ = _inner_error_;
#line 54 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		_inner_error_ = NULL;
#line 57 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		_tmp2_ = g_error_new_literal (RYGEL_TEST_ERROR, RYGEL_TEST_ERROR_SKIP, "Network context not available");
#line 57 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		_inner_error_ = _tmp2_;
#line 57 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		_g_error_free0 (_error_);
#line 599 "rygel-http-item-uri-test.c"
		goto __finally0;
	}
	__finally0:
#line 54 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	if (_inner_error_ != NULL) {
#line 54 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		if (_inner_error_->domain == RYGEL_TEST_ERROR) {
#line 54 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
			g_propagate_error (error, _inner_error_);
#line 54 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
			_g_object_unref0 (self);
#line 54 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
			return NULL;
#line 613 "rygel-http-item-uri-test.c"
		} else {
#line 54 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 54 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
			g_clear_error (&_inner_error_);
#line 54 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
			return NULL;
#line 621 "rygel-http-item-uri-test.c"
		}
	}
#line 60 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp3_ = self->context;
#line 60 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	g_assert (_tmp3_ != NULL);
#line 61 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp4_ = self->context;
#line 61 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp5_ = gssdp_client_get_host_ip ((GSSDPClient*) _tmp4_);
#line 61 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp6_ = _tmp5_;
#line 61 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	g_assert (_tmp6_ != NULL);
#line 62 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp7_ = self->context;
#line 62 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp8_ = gupnp_context_get_port (_tmp7_);
#line 62 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp9_ = _tmp8_;
#line 62 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	g_assert (_tmp9_ > ((guint) 0));
#line 51 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	return self;
#line 646 "rygel-http-item-uri-test.c"
}


RygelHTTPServer* rygel_http_server_new (GError** error) {
#line 51 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	return rygel_http_server_construct (RYGEL_TYPE_HTTP_SERVER, error);
#line 653 "rygel-http-item-uri-test.c"
}


RygelTranscoder* rygel_http_server_get_transcoder (RygelHTTPServer* self, const gchar* target, GError** error) {
	RygelTranscoder* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp2_;
	GError* _tmp3_;
	GError * _inner_error_ = NULL;
#line 65 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 65 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	g_return_val_if_fail (target != NULL, NULL);
#line 66 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp0_ = target;
#line 66 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	if (g_strcmp0 (_tmp0_, "MP3") == 0) {
#line 671 "rygel-http-item-uri-test.c"
		RygelTranscoder* _tmp1_;
#line 67 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		_tmp1_ = rygel_transcoder_new ("mp3");
#line 67 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		result = _tmp1_;
#line 67 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		return result;
#line 679 "rygel-http-item-uri-test.c"
	}
#line 69 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp2_ = target;
#line 69 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp3_ = g_error_new (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND, "No transcoder available for target format '%s'", _tmp2_);
#line 69 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_inner_error_ = _tmp3_;
#line 69 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	g_propagate_error (error, _inner_error_);
#line 69 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	return NULL;
#line 691 "rygel-http-item-uri-test.c"
}


const gchar* rygel_http_server_get_path_root (RygelHTTPServer* self) {
	const gchar* result;
	const gchar* _tmp0_;
#line 47 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 47 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp0_ = self->priv->_path_root;
#line 47 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	result = _tmp0_;
#line 47 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	return result;
#line 706 "rygel-http-item-uri-test.c"
}


static void rygel_http_server_set_path_root (RygelHTTPServer* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
#line 47 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	g_return_if_fail (self != NULL);
#line 47 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp0_ = value;
#line 47 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 47 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_g_free0 (self->priv->_path_root);
#line 47 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	self->priv->_path_root = _tmp1_;
#line 47 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	g_object_notify ((GObject *) self, "path-root");
#line 725 "rygel-http-item-uri-test.c"
}


static void rygel_http_server_class_init (RygelHTTPServerClass * klass) {
#line 44 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	rygel_http_server_parent_class = g_type_class_peek_parent (klass);
#line 44 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	g_type_class_add_private (klass, sizeof (RygelHTTPServerPrivate));
#line 44 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_http_server_get_property;
#line 44 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_http_server_set_property;
#line 44 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_http_server_finalize;
#line 44 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_SERVER_PATH_ROOT, g_param_spec_string ("path-root", "path-root", "path-root", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 742 "rygel-http-item-uri-test.c"
}


static void rygel_http_server_instance_init (RygelHTTPServer * self) {
#line 44 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	self->priv = RYGEL_HTTP_SERVER_GET_PRIVATE (self);
#line 749 "rygel-http-item-uri-test.c"
}


static void rygel_http_server_finalize (GObject* obj) {
	RygelHTTPServer * self;
#line 44 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	self = RYGEL_HTTP_SERVER (obj);
#line 47 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_g_free0 (self->priv->_path_root);
#line 49 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_g_object_unref0 (self->context);
#line 44 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	G_OBJECT_CLASS (rygel_http_server_parent_class)->finalize (obj);
#line 763 "rygel-http-item-uri-test.c"
}


GType rygel_http_server_get_type (void) {
	static volatile gsize rygel_http_server_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_server_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPServerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_server_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPServer), 0, (GInstanceInitFunc) rygel_http_server_instance_init, NULL };
		GType rygel_http_server_type_id;
		rygel_http_server_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPServer", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_server_type_id__volatile, rygel_http_server_type_id);
	}
	return rygel_http_server_type_id__volatile;
}


static void _vala_rygel_http_server_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelHTTPServer * self;
	self = RYGEL_HTTP_SERVER (object);
#line 44 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	switch (property_id) {
#line 44 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		case RYGEL_HTTP_SERVER_PATH_ROOT:
#line 44 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		g_value_set_string (value, rygel_http_server_get_path_root (self));
#line 44 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		break;
#line 790 "rygel-http-item-uri-test.c"
		default:
#line 44 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 44 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		break;
#line 796 "rygel-http-item-uri-test.c"
	}
}


static void _vala_rygel_http_server_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelHTTPServer * self;
	self = RYGEL_HTTP_SERVER (object);
#line 44 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	switch (property_id) {
#line 44 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		case RYGEL_HTTP_SERVER_PATH_ROOT:
#line 44 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		rygel_http_server_set_path_root (self, g_value_get_string (value));
#line 44 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		break;
#line 812 "rygel-http-item-uri-test.c"
		default:
#line 44 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 44 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		break;
#line 818 "rygel-http-item-uri-test.c"
	}
}


RygelMediaItem* rygel_media_item_construct (GType object_type) {
	RygelMediaItem * self = NULL;
#line 75 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	self = (RygelMediaItem*) g_object_new (object_type, NULL);
#line 75 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	return self;
#line 829 "rygel-http-item-uri-test.c"
}


RygelMediaItem* rygel_media_item_new (void) {
#line 75 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	return rygel_media_item_construct (RYGEL_TYPE_MEDIA_ITEM);
#line 836 "rygel-http-item-uri-test.c"
}


static void rygel_media_item_class_init (RygelMediaItemClass * klass) {
#line 75 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	rygel_media_item_parent_class = g_type_class_peek_parent (klass);
#line 75 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_media_item_finalize;
#line 845 "rygel-http-item-uri-test.c"
}


static void rygel_media_item_instance_init (RygelMediaItem * self) {
	GeeArrayList* _tmp0_;
#line 77 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
#line 77 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	self->uris = _tmp0_;
#line 855 "rygel-http-item-uri-test.c"
}


static void rygel_media_item_finalize (GObject* obj) {
	RygelMediaItem * self;
#line 75 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	self = RYGEL_MEDIA_ITEM (obj);
#line 76 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_g_free0 (self->id);
#line 77 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_g_object_unref0 (self->uris);
#line 78 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_g_free0 (self->mime_type);
#line 75 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	G_OBJECT_CLASS (rygel_media_item_parent_class)->finalize (obj);
#line 871 "rygel-http-item-uri-test.c"
}


GType rygel_media_item_get_type (void) {
	static volatile gsize rygel_media_item_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaItem), 0, (GInstanceInitFunc) rygel_media_item_instance_init, NULL };
		GType rygel_media_item_type_id;
		rygel_media_item_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMediaItem", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_item_type_id__volatile, rygel_media_item_type_id);
	}
	return rygel_media_item_type_id__volatile;
}


RygelThumbnail* rygel_thumbnail_construct (GType object_type) {
	RygelThumbnail* self = NULL;
#line 81 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	self = (RygelThumbnail*) g_type_create_instance (object_type);
#line 81 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	return self;
#line 893 "rygel-http-item-uri-test.c"
}


RygelThumbnail* rygel_thumbnail_new (void) {
#line 81 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	return rygel_thumbnail_construct (RYGEL_TYPE_THUMBNAIL);
#line 900 "rygel-http-item-uri-test.c"
}


static void rygel_value_thumbnail_init (GValue* value) {
#line 81 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	value->data[0].v_pointer = NULL;
#line 907 "rygel-http-item-uri-test.c"
}


static void rygel_value_thumbnail_free_value (GValue* value) {
#line 81 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	if (value->data[0].v_pointer) {
#line 81 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		rygel_thumbnail_unref (value->data[0].v_pointer);
#line 916 "rygel-http-item-uri-test.c"
	}
}


static void rygel_value_thumbnail_copy_value (const GValue* src_value, GValue* dest_value) {
#line 81 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	if (src_value->data[0].v_pointer) {
#line 81 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		dest_value->data[0].v_pointer = rygel_thumbnail_ref (src_value->data[0].v_pointer);
#line 926 "rygel-http-item-uri-test.c"
	} else {
#line 81 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		dest_value->data[0].v_pointer = NULL;
#line 930 "rygel-http-item-uri-test.c"
	}
}


static gpointer rygel_value_thumbnail_peek_pointer (const GValue* value) {
#line 81 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	return value->data[0].v_pointer;
#line 938 "rygel-http-item-uri-test.c"
}


static gchar* rygel_value_thumbnail_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 81 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	if (collect_values[0].v_pointer) {
#line 945 "rygel-http-item-uri-test.c"
		RygelThumbnail* object;
		object = collect_values[0].v_pointer;
#line 81 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		if (object->parent_instance.g_class == NULL) {
#line 81 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 952 "rygel-http-item-uri-test.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 81 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 956 "rygel-http-item-uri-test.c"
		}
#line 81 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		value->data[0].v_pointer = rygel_thumbnail_ref (object);
#line 960 "rygel-http-item-uri-test.c"
	} else {
#line 81 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		value->data[0].v_pointer = NULL;
#line 964 "rygel-http-item-uri-test.c"
	}
#line 81 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	return NULL;
#line 968 "rygel-http-item-uri-test.c"
}


static gchar* rygel_value_thumbnail_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	RygelThumbnail** object_p;
	object_p = collect_values[0].v_pointer;
#line 81 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	if (!object_p) {
#line 81 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 979 "rygel-http-item-uri-test.c"
	}
#line 81 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	if (!value->data[0].v_pointer) {
#line 81 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		*object_p = NULL;
#line 985 "rygel-http-item-uri-test.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 81 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		*object_p = value->data[0].v_pointer;
#line 989 "rygel-http-item-uri-test.c"
	} else {
#line 81 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		*object_p = rygel_thumbnail_ref (value->data[0].v_pointer);
#line 993 "rygel-http-item-uri-test.c"
	}
#line 81 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	return NULL;
#line 997 "rygel-http-item-uri-test.c"
}


GParamSpec* rygel_param_spec_thumbnail (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	RygelParamSpecThumbnail* spec;
#line 81 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	g_return_val_if_fail (g_type_is_a (object_type, RYGEL_TYPE_THUMBNAIL), NULL);
#line 81 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 81 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 81 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	return G_PARAM_SPEC (spec);
#line 1011 "rygel-http-item-uri-test.c"
}


gpointer rygel_value_get_thumbnail (const GValue* value) {
#line 81 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_THUMBNAIL), NULL);
#line 81 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	return value->data[0].v_pointer;
#line 1020 "rygel-http-item-uri-test.c"
}


void rygel_value_set_thumbnail (GValue* value, gpointer v_object) {
	RygelThumbnail* old;
#line 81 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_THUMBNAIL));
#line 81 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	old = value->data[0].v_pointer;
#line 81 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	if (v_object) {
#line 81 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_THUMBNAIL));
#line 81 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 81 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		value->data[0].v_pointer = v_object;
#line 81 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		rygel_thumbnail_ref (value->data[0].v_pointer);
#line 1040 "rygel-http-item-uri-test.c"
	} else {
#line 81 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		value->data[0].v_pointer = NULL;
#line 1044 "rygel-http-item-uri-test.c"
	}
#line 81 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	if (old) {
#line 81 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		rygel_thumbnail_unref (old);
#line 1050 "rygel-http-item-uri-test.c"
	}
}


void rygel_value_take_thumbnail (GValue* value, gpointer v_object) {
	RygelThumbnail* old;
#line 81 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_THUMBNAIL));
#line 81 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	old = value->data[0].v_pointer;
#line 81 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	if (v_object) {
#line 81 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_THUMBNAIL));
#line 81 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 81 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		value->data[0].v_pointer = v_object;
#line 1069 "rygel-http-item-uri-test.c"
	} else {
#line 81 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		value->data[0].v_pointer = NULL;
#line 1073 "rygel-http-item-uri-test.c"
	}
#line 81 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	if (old) {
#line 81 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		rygel_thumbnail_unref (old);
#line 1079 "rygel-http-item-uri-test.c"
	}
}


static void rygel_thumbnail_class_init (RygelThumbnailClass * klass) {
#line 81 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	rygel_thumbnail_parent_class = g_type_class_peek_parent (klass);
#line 81 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	RYGEL_THUMBNAIL_CLASS (klass)->finalize = rygel_thumbnail_finalize;
#line 1089 "rygel-http-item-uri-test.c"
}


static void rygel_thumbnail_instance_init (RygelThumbnail * self) {
#line 81 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	self->ref_count = 1;
#line 1096 "rygel-http-item-uri-test.c"
}


static void rygel_thumbnail_finalize (RygelThumbnail* obj) {
	RygelThumbnail * self;
#line 81 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	self = RYGEL_THUMBNAIL (obj);
#line 82 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_g_free0 (self->file_extension);
#line 1106 "rygel-http-item-uri-test.c"
}


GType rygel_thumbnail_get_type (void) {
	static volatile gsize rygel_thumbnail_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_thumbnail_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { rygel_value_thumbnail_init, rygel_value_thumbnail_free_value, rygel_value_thumbnail_copy_value, rygel_value_thumbnail_peek_pointer, "p", rygel_value_thumbnail_collect_value, "p", rygel_value_thumbnail_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (RygelThumbnailClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_thumbnail_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelThumbnail), 0, (GInstanceInitFunc) rygel_thumbnail_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType rygel_thumbnail_type_id;
		rygel_thumbnail_type_id = g_type_register_fundamental (g_type_fundamental_next (), "RygelThumbnail", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&rygel_thumbnail_type_id__volatile, rygel_thumbnail_type_id);
	}
	return rygel_thumbnail_type_id__volatile;
}


gpointer rygel_thumbnail_ref (gpointer instance) {
	RygelThumbnail* self;
	self = instance;
#line 81 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	g_atomic_int_inc (&self->ref_count);
#line 81 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	return instance;
#line 1131 "rygel-http-item-uri-test.c"
}


void rygel_thumbnail_unref (gpointer instance) {
	RygelThumbnail* self;
	self = instance;
#line 81 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 81 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		RYGEL_THUMBNAIL_GET_CLASS (self)->finalize (self);
#line 81 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 1144 "rygel-http-item-uri-test.c"
	}
}


RygelVisualItem* rygel_visual_item_construct (GType object_type) {
	RygelVisualItem * self = NULL;
#line 85 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	self = (RygelVisualItem*) rygel_media_item_construct (object_type);
#line 85 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	return self;
#line 1155 "rygel-http-item-uri-test.c"
}


RygelVisualItem* rygel_visual_item_new (void) {
#line 85 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	return rygel_visual_item_construct (RYGEL_TYPE_VISUAL_ITEM);
#line 1162 "rygel-http-item-uri-test.c"
}


static void rygel_visual_item_class_init (RygelVisualItemClass * klass) {
#line 85 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	rygel_visual_item_parent_class = g_type_class_peek_parent (klass);
#line 85 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_visual_item_finalize;
#line 1171 "rygel-http-item-uri-test.c"
}


static void rygel_visual_item_instance_init (RygelVisualItem * self) {
	GeeArrayList* _tmp0_;
#line 86 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp0_ = gee_array_list_new (RYGEL_TYPE_THUMBNAIL, (GBoxedCopyFunc) rygel_thumbnail_ref, rygel_thumbnail_unref, NULL);
#line 86 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	self->thumbnails = _tmp0_;
#line 1181 "rygel-http-item-uri-test.c"
}


static void rygel_visual_item_finalize (GObject* obj) {
	RygelVisualItem * self;
#line 85 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	self = RYGEL_VISUAL_ITEM (obj);
#line 86 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_g_object_unref0 (self->thumbnails);
#line 85 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	G_OBJECT_CLASS (rygel_visual_item_parent_class)->finalize (obj);
#line 1193 "rygel-http-item-uri-test.c"
}


GType rygel_visual_item_get_type (void) {
	static volatile gsize rygel_visual_item_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_visual_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelVisualItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_visual_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelVisualItem), 0, (GInstanceInitFunc) rygel_visual_item_instance_init, NULL };
		GType rygel_visual_item_type_id;
		rygel_visual_item_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_ITEM, "RygelVisualItem", &g_define_type_info, 0);
		g_once_init_leave (&rygel_visual_item_type_id__volatile, rygel_visual_item_type_id);
	}
	return rygel_visual_item_type_id__volatile;
}


RygelSubtitle* rygel_subtitle_construct (GType object_type) {
	RygelSubtitle * self = NULL;
#line 89 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	self = (RygelSubtitle*) g_object_new (object_type, NULL);
#line 89 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	return self;
#line 1215 "rygel-http-item-uri-test.c"
}


RygelSubtitle* rygel_subtitle_new (void) {
#line 89 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	return rygel_subtitle_construct (RYGEL_TYPE_SUBTITLE);
#line 1222 "rygel-http-item-uri-test.c"
}


static void rygel_subtitle_class_init (RygelSubtitleClass * klass) {
#line 89 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	rygel_subtitle_parent_class = g_type_class_peek_parent (klass);
#line 89 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_subtitle_finalize;
#line 1231 "rygel-http-item-uri-test.c"
}


static void rygel_subtitle_instance_init (RygelSubtitle * self) {
}


static void rygel_subtitle_finalize (GObject* obj) {
	RygelSubtitle * self;
#line 89 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	self = RYGEL_SUBTITLE (obj);
#line 90 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_g_free0 (self->caption_type);
#line 89 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	G_OBJECT_CLASS (rygel_subtitle_parent_class)->finalize (obj);
#line 1247 "rygel-http-item-uri-test.c"
}


GType rygel_subtitle_get_type (void) {
	static volatile gsize rygel_subtitle_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_subtitle_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelSubtitleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_subtitle_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelSubtitle), 0, (GInstanceInitFunc) rygel_subtitle_instance_init, NULL };
		GType rygel_subtitle_type_id;
		rygel_subtitle_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelSubtitle", &g_define_type_info, 0);
		g_once_init_leave (&rygel_subtitle_type_id__volatile, rygel_subtitle_type_id);
	}
	return rygel_subtitle_type_id__volatile;
}


RygelVideoItem* rygel_video_item_construct (GType object_type) {
	RygelVideoItem * self = NULL;
#line 93 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	self = (RygelVideoItem*) rygel_visual_item_construct (object_type);
#line 93 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	return self;
#line 1269 "rygel-http-item-uri-test.c"
}


RygelVideoItem* rygel_video_item_new (void) {
#line 93 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	return rygel_video_item_construct (RYGEL_TYPE_VIDEO_ITEM);
#line 1276 "rygel-http-item-uri-test.c"
}


static void rygel_video_item_class_init (RygelVideoItemClass * klass) {
#line 93 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	rygel_video_item_parent_class = g_type_class_peek_parent (klass);
#line 93 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_video_item_finalize;
#line 1285 "rygel-http-item-uri-test.c"
}


static void rygel_video_item_instance_init (RygelVideoItem * self) {
	GeeArrayList* _tmp0_;
#line 94 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp0_ = gee_array_list_new (RYGEL_TYPE_SUBTITLE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
#line 94 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	self->subtitles = _tmp0_;
#line 1295 "rygel-http-item-uri-test.c"
}


static void rygel_video_item_finalize (GObject* obj) {
	RygelVideoItem * self;
#line 93 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	self = RYGEL_VIDEO_ITEM (obj);
#line 94 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_g_object_unref0 (self->subtitles);
#line 93 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	G_OBJECT_CLASS (rygel_video_item_parent_class)->finalize (obj);
#line 1307 "rygel-http-item-uri-test.c"
}


GType rygel_video_item_get_type (void) {
	static volatile gsize rygel_video_item_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_video_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelVideoItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_video_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelVideoItem), 0, (GInstanceInitFunc) rygel_video_item_instance_init, NULL };
		GType rygel_video_item_type_id;
		rygel_video_item_type_id = g_type_register_static (RYGEL_TYPE_VISUAL_ITEM, "RygelVideoItem", &g_define_type_info, 0);
		g_once_init_leave (&rygel_video_item_type_id__volatile, rygel_video_item_type_id);
	}
	return rygel_video_item_type_id__volatile;
}


RygelMusicItem* rygel_music_item_construct (GType object_type) {
	RygelMusicItem * self = NULL;
#line 97 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	self = (RygelMusicItem*) rygel_media_item_construct (object_type);
#line 97 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	return self;
#line 1329 "rygel-http-item-uri-test.c"
}


RygelMusicItem* rygel_music_item_new (void) {
#line 97 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	return rygel_music_item_construct (RYGEL_TYPE_MUSIC_ITEM);
#line 1336 "rygel-http-item-uri-test.c"
}


static void rygel_music_item_class_init (RygelMusicItemClass * klass) {
#line 97 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	rygel_music_item_parent_class = g_type_class_peek_parent (klass);
#line 97 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_music_item_finalize;
#line 1345 "rygel-http-item-uri-test.c"
}


static void rygel_music_item_instance_init (RygelMusicItem * self) {
}


static void rygel_music_item_finalize (GObject* obj) {
	RygelMusicItem * self;
#line 97 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	self = RYGEL_MUSIC_ITEM (obj);
#line 98 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_rygel_thumbnail_unref0 (self->album_art);
#line 97 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	G_OBJECT_CLASS (rygel_music_item_parent_class)->finalize (obj);
#line 1361 "rygel-http-item-uri-test.c"
}


GType rygel_music_item_get_type (void) {
	static volatile gsize rygel_music_item_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_music_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMusicItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_music_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMusicItem), 0, (GInstanceInitFunc) rygel_music_item_instance_init, NULL };
		GType rygel_music_item_type_id;
		rygel_music_item_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_ITEM, "RygelMusicItem", &g_define_type_info, 0);
		g_once_init_leave (&rygel_music_item_type_id__volatile, rygel_music_item_type_id);
	}
	return rygel_music_item_type_id__volatile;
}


gint rygel_http_item_uri_test_main (gchar** args, int args_length1) {
	gint result = 0;
	GError * _inner_error_ = NULL;
	{
		RygelHTTPItemURITest* _tmp0_;
		RygelHTTPItemURITest* test;
		RygelHTTPItemURITest* _tmp1_;
#line 110 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		_tmp0_ = rygel_http_item_uri_test_new (&_inner_error_);
#line 110 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		test = _tmp0_;
#line 110 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		if (_inner_error_ != NULL) {
#line 110 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
			if (g_error_matches (_inner_error_, RYGEL_TEST_ERROR, RYGEL_TEST_ERROR_SKIP)) {
#line 1392 "rygel-http-item-uri-test.c"
				goto __catch1_rygel_test_error_skip;
			}
			goto __catch1_g_error;
		}
#line 112 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		_tmp1_ = test;
#line 112 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		rygel_http_item_uri_test_run (_tmp1_, &_inner_error_);
#line 112 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		if (_inner_error_ != NULL) {
#line 112 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
			_g_object_unref0 (test);
#line 112 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
			if (g_error_matches (_inner_error_, RYGEL_TEST_ERROR, RYGEL_TEST_ERROR_SKIP)) {
#line 1407 "rygel-http-item-uri-test.c"
				goto __catch1_rygel_test_error_skip;
			}
			goto __catch1_g_error;
		}
#line 109 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		_g_object_unref0 (test);
#line 1414 "rygel-http-item-uri-test.c"
	}
	goto __finally1;
	__catch1_rygel_test_error_skip:
	{
		GError* _error_ = NULL;
#line 109 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		_error_ = _inner_error_;
#line 109 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		_inner_error_ = NULL;
#line 114 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		result = 77;
#line 114 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		_g_error_free0 (_error_);
#line 114 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		return result;
#line 1430 "rygel-http-item-uri-test.c"
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
#line 109 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		_error_ = _inner_error_;
#line 109 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		_inner_error_ = NULL;
#line 116 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		_tmp2_ = _error_;
#line 116 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		_tmp3_ = _tmp2_->message;
#line 116 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		g_critical ("rygel-http-item-uri-test.vala:116: %s", _tmp3_);
#line 118 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		result = -1;
#line 118 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		_g_error_free0 (_error_);
#line 118 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		return result;
#line 1454 "rygel-http-item-uri-test.c"
	}
	__finally1:
#line 109 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	if (_inner_error_ != NULL) {
#line 109 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 109 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		g_clear_error (&_inner_error_);
#line 109 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		return 0;
#line 1465 "rygel-http-item-uri-test.c"
	}
#line 121 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	result = 0;
#line 121 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	return result;
#line 1471 "rygel-http-item-uri-test.c"
}


int main (int argc, char ** argv) {
#line 108 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	g_thread_init (NULL);
#line 108 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	g_type_init ();
#line 108 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	return rygel_http_item_uri_test_main (argv, argc);
#line 1482 "rygel-http-item-uri-test.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 139 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	return self ? g_object_ref (self) : NULL;
#line 1489 "rygel-http-item-uri-test.c"
}


void rygel_http_item_uri_test_run (RygelHTTPItemURITest* self, GError** error) {
	RygelThumbnail* _tmp0_;
	RygelThumbnail* thumb;
	RygelThumbnail* _tmp1_;
	gchar* _tmp2_;
	RygelVisualItem* _tmp3_;
	GeeArrayList* _tmp4_;
	RygelThumbnail* _tmp5_;
	RygelVisualItem* _tmp6_;
	gchar* _tmp7_;
	RygelVisualItem* _tmp8_;
	GeeArrayList* _tmp9_;
	RygelVisualItem* _tmp10_;
	gchar* _tmp11_;
	RygelHTTPItemURI* _tmp12_ = NULL;
	RygelHTTPItemURI* _tmp13_ = NULL;
	RygelHTTPItemURI* _tmp14_ = NULL;
	RygelHTTPItemURI* _tmp15_ = NULL;
	RygelHTTPItemURI** _tmp16_ = NULL;
	RygelHTTPItemURI** uris;
	gint uris_length1;
	gint _uris_size_;
	RygelHTTPItemURI** _tmp17_;
	gint _tmp17__length1;
	GError * _inner_error_ = NULL;
#line 124 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	g_return_if_fail (self != NULL);
#line 125 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp0_ = rygel_thumbnail_new ();
#line 125 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	thumb = _tmp0_;
#line 127 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp1_ = thumb;
#line 127 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp2_ = g_strdup ("png");
#line 127 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_g_free0 (_tmp1_->file_extension);
#line 127 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp1_->file_extension = _tmp2_;
#line 128 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp3_ = self->priv->item;
#line 128 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp4_ = _tmp3_->thumbnails;
#line 128 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp5_ = thumb;
#line 128 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp4_, _tmp5_);
#line 129 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp6_ = self->priv->item;
#line 129 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp7_ = g_strdup ("HELLO");
#line 129 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_g_free0 (((RygelMediaItem*) _tmp6_)->id);
#line 129 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	((RygelMediaItem*) _tmp6_)->id = _tmp7_;
#line 130 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp8_ = self->priv->item;
#line 130 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp9_ = ((RygelMediaItem*) _tmp8_)->uris;
#line 130 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp9_, "foo.mp3");
#line 131 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp10_ = self->priv->item;
#line 131 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp11_ = g_strdup ("audio/mp3");
#line 131 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_g_free0 (((RygelMediaItem*) _tmp10_)->mime_type);
#line 131 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	((RygelMediaItem*) _tmp10_)->mime_type = _tmp11_;
#line 133 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp12_ = rygel_http_item_uri_test_test_construction (self);
#line 133 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp13_ = rygel_http_item_uri_test_test_construction_with_thumbnail (self);
#line 133 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp14_ = rygel_http_item_uri_test_test_construction_with_subtitle (self);
#line 133 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp15_ = rygel_http_item_uri_test_test_construction_with_transcoder (self);
#line 133 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp16_ = g_new0 (RygelHTTPItemURI*, 4 + 1);
#line 133 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp16_[0] = _tmp12_;
#line 133 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp16_[1] = _tmp13_;
#line 133 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp16_[2] = _tmp14_;
#line 133 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp16_[3] = _tmp15_;
#line 133 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	uris = _tmp16_;
#line 133 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	uris_length1 = 4;
#line 133 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_uris_size_ = uris_length1;
#line 139 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp17_ = uris;
#line 139 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp17__length1 = uris_length1;
#line 1590 "rygel-http-item-uri-test.c"
	{
		RygelHTTPItemURI** uri_collection = NULL;
		gint uri_collection_length1 = 0;
		gint _uri_collection_size_ = 0;
		gint uri_it = 0;
#line 139 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		uri_collection = _tmp17_;
#line 139 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		uri_collection_length1 = _tmp17__length1;
#line 139 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		for (uri_it = 0; uri_it < _tmp17__length1; uri_it = uri_it + 1) {
#line 1602 "rygel-http-item-uri-test.c"
			RygelHTTPItemURI* _tmp18_;
			RygelHTTPItemURI* uri = NULL;
#line 139 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
			_tmp18_ = _g_object_ref0 (uri_collection[uri_it]);
#line 139 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
			uri = _tmp18_;
#line 1609 "rygel-http-item-uri-test.c"
			{
				RygelHTTPItemURI* _tmp19_;
				gchar* _tmp20_ = NULL;
				gchar* str;
				const gchar* _tmp21_;
				RygelHTTPItemURI* _tmp22_ = NULL;
				RygelHTTPItemURI* _tmp23_;
#line 140 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
				_tmp19_ = uri;
#line 140 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
				_tmp20_ = rygel_http_item_uri_test_test_to_string (self, _tmp19_);
#line 140 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
				str = _tmp20_;
#line 141 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
				_tmp21_ = str;
#line 141 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
				_tmp22_ = rygel_http_item_uri_test_test_construction_from_string (self, _tmp21_, &_inner_error_);
#line 141 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
				_tmp23_ = _tmp22_;
#line 141 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
				_g_object_unref0 (_tmp23_);
#line 141 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
				if (_inner_error_ != NULL) {
#line 141 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
					g_propagate_error (error, _inner_error_);
#line 141 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
					_g_free0 (str);
#line 141 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
					_g_object_unref0 (uri);
#line 141 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
					uris = (_vala_array_free (uris, uris_length1, (GDestroyNotify) g_object_unref), NULL);
#line 141 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
					_rygel_thumbnail_unref0 (thumb);
#line 141 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
					return;
#line 1645 "rygel-http-item-uri-test.c"
				}
#line 139 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
				_g_free0 (str);
#line 139 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
				_g_object_unref0 (uri);
#line 1651 "rygel-http-item-uri-test.c"
			}
		}
	}
#line 143 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	rygel_http_item_uri_test_test_error_construction (self, "/Ttt", SOUP_STATUS_BAD_REQUEST);
#line 124 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	uris = (_vala_array_free (uris, uris_length1, (GDestroyNotify) g_object_unref), NULL);
#line 124 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_rygel_thumbnail_unref0 (thumb);
#line 1661 "rygel-http-item-uri-test.c"
}


static RygelHTTPItemURITest* rygel_http_item_uri_test_construct (GType object_type, GError** error) {
	RygelHTTPItemURITest * self = NULL;
	RygelHTTPServer* _tmp0_;
	RygelHTTPServer* _tmp1_;
	GError * _inner_error_ = NULL;
#line 146 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	self = (RygelHTTPItemURITest*) g_object_new (object_type, NULL);
#line 147 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp0_ = rygel_http_server_new (&_inner_error_);
#line 147 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp1_ = _tmp0_;
#line 147 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	if (_inner_error_ != NULL) {
#line 147 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		if (_inner_error_->domain == RYGEL_TEST_ERROR) {
#line 147 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
			g_propagate_error (error, _inner_error_);
#line 147 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
			_g_object_unref0 (self);
#line 147 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
			return NULL;
#line 1686 "rygel-http-item-uri-test.c"
		} else {
#line 147 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 147 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
			g_clear_error (&_inner_error_);
#line 147 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
			return NULL;
#line 1694 "rygel-http-item-uri-test.c"
		}
	}
#line 147 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_g_object_unref0 (self->priv->server);
#line 147 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	self->priv->server = _tmp1_;
#line 146 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	return self;
#line 1703 "rygel-http-item-uri-test.c"
}


static RygelHTTPItemURITest* rygel_http_item_uri_test_new (GError** error) {
#line 146 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	return rygel_http_item_uri_test_construct (RYGEL_TYPE_HTTP_ITEM_URI_TEST, error);
#line 1710 "rygel-http-item-uri-test.c"
}


static RygelHTTPItemURI* rygel_http_item_uri_test_test_construction (RygelHTTPItemURITest* self) {
	RygelHTTPItemURI* result = NULL;
	RygelVisualItem* _tmp0_;
	RygelHTTPServer* _tmp1_;
	RygelHTTPItemURI* _tmp2_;
	RygelHTTPItemURI* uri;
#line 150 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 151 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp0_ = self->priv->item;
#line 151 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp1_ = self->priv->server;
#line 151 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp2_ = rygel_http_item_uri_new ((RygelMediaItem*) _tmp0_, _tmp1_, -1, -1, NULL);
#line 151 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	uri = _tmp2_;
#line 152 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	g_assert (uri != NULL);
#line 154 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	result = uri;
#line 154 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	return result;
#line 1736 "rygel-http-item-uri-test.c"
}


static RygelHTTPItemURI* rygel_http_item_uri_test_test_construction_with_subtitle (RygelHTTPItemURITest* self) {
	RygelHTTPItemURI* result = NULL;
	RygelVisualItem* _tmp0_;
	RygelHTTPServer* _tmp1_;
	RygelHTTPItemURI* _tmp2_;
	RygelHTTPItemURI* uri;
#line 157 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 158 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp0_ = self->priv->item;
#line 158 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp1_ = self->priv->server;
#line 158 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp2_ = rygel_http_item_uri_new ((RygelMediaItem*) _tmp0_, _tmp1_, -1, RYGEL_HTTP_ITEM_URI_TEST_SUBTITLE_INDEX, NULL);
#line 158 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	uri = _tmp2_;
#line 162 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	g_assert (uri != NULL);
#line 164 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	result = uri;
#line 164 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	return result;
#line 1762 "rygel-http-item-uri-test.c"
}


static RygelHTTPItemURI* rygel_http_item_uri_test_test_construction_with_thumbnail (RygelHTTPItemURITest* self) {
	RygelHTTPItemURI* result = NULL;
	RygelVisualItem* _tmp0_;
	RygelHTTPServer* _tmp1_;
	RygelHTTPItemURI* _tmp2_;
	RygelHTTPItemURI* uri;
#line 167 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 168 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp0_ = self->priv->item;
#line 168 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp1_ = self->priv->server;
#line 168 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp2_ = rygel_http_item_uri_new ((RygelMediaItem*) _tmp0_, _tmp1_, RYGEL_HTTP_ITEM_URI_TEST_THUMBNAIL_INDEX, -1, NULL);
#line 168 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	uri = _tmp2_;
#line 171 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	g_assert (uri != NULL);
#line 173 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	result = uri;
#line 173 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	return result;
#line 1788 "rygel-http-item-uri-test.c"
}


static RygelHTTPItemURI* rygel_http_item_uri_test_test_construction_with_transcoder (RygelHTTPItemURITest* self) {
	RygelHTTPItemURI* result = NULL;
	RygelVisualItem* _tmp0_;
	RygelHTTPServer* _tmp1_;
	RygelHTTPItemURI* _tmp2_;
	RygelHTTPItemURI* uri;
#line 176 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 177 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp0_ = self->priv->item;
#line 177 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp1_ = self->priv->server;
#line 177 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp2_ = rygel_http_item_uri_new ((RygelMediaItem*) _tmp0_, _tmp1_, RYGEL_HTTP_ITEM_URI_TEST_THUMBNAIL_INDEX, -1, RYGEL_HTTP_ITEM_URI_TEST_TRANSCODE_TARGET);
#line 177 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	uri = _tmp2_;
#line 182 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	g_assert (uri != NULL);
#line 184 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	result = uri;
#line 184 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	return result;
#line 1814 "rygel-http-item-uri-test.c"
}


static RygelHTTPItemURI* rygel_http_item_uri_test_test_construction_from_string (RygelHTTPItemURITest* self, const gchar* str, GError** error) {
	RygelHTTPItemURI* result = NULL;
	const gchar* _tmp0_;
	RygelHTTPServer* _tmp1_;
	RygelHTTPItemURI* _tmp2_;
	RygelHTTPItemURI* uri;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	GError * _inner_error_ = NULL;
#line 187 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 187 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	g_return_val_if_fail (str != NULL, NULL);
#line 189 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp0_ = str;
#line 189 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp1_ = self->priv->server;
#line 189 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp2_ = rygel_http_item_uri_new_from_string (_tmp0_, _tmp1_, &_inner_error_);
#line 189 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	uri = _tmp2_;
#line 189 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	if (_inner_error_ != NULL) {
#line 189 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		g_propagate_error (error, _inner_error_);
#line 189 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		return NULL;
#line 1846 "rygel-http-item-uri-test.c"
	}
#line 190 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	g_assert (uri != NULL);
#line 191 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp3_ = rygel_http_item_uri_to_string (uri);
#line 191 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp4_ = _tmp3_;
#line 191 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp5_ = str;
#line 191 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	g_assert (g_strcmp0 (_tmp4_, _tmp5_) == 0);
#line 191 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_g_free0 (_tmp4_);
#line 193 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	result = uri;
#line 193 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	return result;
#line 1864 "rygel-http-item-uri-test.c"
}


static void rygel_http_item_uri_test_test_error_construction (RygelHTTPItemURITest* self, const gchar* str, SoupKnownStatusCode error_code) {
	GError * _inner_error_ = NULL;
#line 196 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	g_return_if_fail (self != NULL);
#line 196 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	g_return_if_fail (str != NULL);
#line 1874 "rygel-http-item-uri-test.c"
	{
		const gchar* _tmp0_;
		RygelHTTPServer* _tmp1_;
		RygelHTTPItemURI* _tmp2_;
		RygelHTTPItemURI* uri;
#line 199 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		_tmp0_ = str;
#line 199 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		_tmp1_ = self->priv->server;
#line 199 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		_tmp2_ = rygel_http_item_uri_new_from_string (_tmp0_, _tmp1_, &_inner_error_);
#line 199 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		uri = _tmp2_;
#line 199 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		if (_inner_error_ != NULL) {
#line 199 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
			if (_inner_error_->domain == RYGEL_HTTP_REQUEST_ERROR) {
#line 1892 "rygel-http-item-uri-test.c"
				goto __catch2_rygel_http_request_error;
			}
#line 199 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 199 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
			g_clear_error (&_inner_error_);
#line 199 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
			return;
#line 1901 "rygel-http-item-uri-test.c"
		}
#line 200 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		g_assert (uri == NULL);
#line 198 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		_g_object_unref0 (uri);
#line 1907 "rygel-http-item-uri-test.c"
	}
	goto __finally2;
	__catch2_rygel_http_request_error:
	{
		GError* _error_ = NULL;
		GError* _tmp3_;
		gint _tmp4_;
		SoupKnownStatusCode _tmp5_;
#line 198 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		_error_ = _inner_error_;
#line 198 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		_inner_error_ = NULL;
#line 202 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		_tmp3_ = _error_;
#line 202 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		_tmp4_ = _tmp3_->code;
#line 202 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		_tmp5_ = error_code;
#line 202 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		g_assert (_tmp4_ == ((gint) _tmp5_));
#line 198 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		_g_error_free0 (_error_);
#line 1930 "rygel-http-item-uri-test.c"
	}
	__finally2:
#line 198 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	if (_inner_error_ != NULL) {
#line 198 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 198 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		g_clear_error (&_inner_error_);
#line 198 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		return;
#line 1941 "rygel-http-item-uri-test.c"
	}
}


static gchar* rygel_http_item_uri_test_test_to_string (RygelHTTPItemURITest* self, RygelHTTPItemURI* uri) {
	gchar* result = NULL;
	RygelHTTPItemURI* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* str;
#line 206 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 206 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	g_return_val_if_fail (uri != NULL, NULL);
#line 207 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp0_ = uri;
#line 207 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp1_ = rygel_http_item_uri_to_string (_tmp0_);
#line 207 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	str = _tmp1_;
#line 208 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	g_assert (str != NULL);
#line 210 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	result = str;
#line 210 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	return result;
#line 1967 "rygel-http-item-uri-test.c"
}


static void rygel_http_item_uri_test_class_init (RygelHTTPItemURITestClass * klass) {
#line 101 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	rygel_http_item_uri_test_parent_class = g_type_class_peek_parent (klass);
#line 101 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	g_type_class_add_private (klass, sizeof (RygelHTTPItemURITestPrivate));
#line 101 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_http_item_uri_test_finalize;
#line 1978 "rygel-http-item-uri-test.c"
}


static void rygel_http_item_uri_test_instance_init (RygelHTTPItemURITest * self) {
	RygelVisualItem* _tmp0_;
#line 101 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	self->priv = RYGEL_HTTP_ITEM_URI_TEST_GET_PRIVATE (self);
#line 105 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp0_ = rygel_visual_item_new ();
#line 105 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	self->priv->item = _tmp0_;
#line 1990 "rygel-http-item-uri-test.c"
}


static void rygel_http_item_uri_test_finalize (GObject* obj) {
	RygelHTTPItemURITest * self;
#line 101 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	self = RYGEL_HTTP_ITEM_URI_TEST (obj);
#line 105 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_g_object_unref0 (self->priv->item);
#line 106 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_g_object_unref0 (self->priv->server);
#line 101 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	G_OBJECT_CLASS (rygel_http_item_uri_test_parent_class)->finalize (obj);
#line 2004 "rygel-http-item-uri-test.c"
}


GType rygel_http_item_uri_test_get_type (void) {
	static volatile gsize rygel_http_item_uri_test_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_item_uri_test_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPItemURITestClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_item_uri_test_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPItemURITest), 0, (GInstanceInitFunc) rygel_http_item_uri_test_instance_init, NULL };
		GType rygel_http_item_uri_test_type_id;
		rygel_http_item_uri_test_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPItemURITest", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_item_uri_test_type_id__volatile, rygel_http_item_uri_test_type_id);
	}
	return rygel_http_item_uri_test_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



