/* regression.c generated by valac 0.24.0.112-bbf5, the Vala compiler
 * generated from regression.vala, do not modify */

/*
 * Copyright (C) 2013 Intel Corporation.
 *
 * Author: Jens Georg <jensg@openismus.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include "rygel-media-export-internal.h"
#include "rygel-server.h"
#include <sqlite3.h>
#include "rygel-core.h"
#include <stdlib.h>
#include <string.h>

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _rygel_media_export_database_cursor_iterator_unref0(var) ((var == NULL) ? NULL : (var = (rygel_media_export_database_cursor_iterator_unref (var), NULL)))

#define TYPE_TEST_CONFIG (test_config_get_type ())
#define TEST_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TEST_CONFIG, TestConfig))
#define TEST_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TEST_CONFIG, TestConfigClass))
#define IS_TEST_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TEST_CONFIG))
#define IS_TEST_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TEST_CONFIG))
#define TEST_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TEST_CONFIG, TestConfigClass))

typedef struct _TestConfig TestConfig;
typedef struct _TestConfigClass TestConfigClass;
typedef struct _TestConfigPrivate TestConfigPrivate;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _TestConfig {
	RygelBaseConfiguration parent_instance;
	TestConfigPrivate * priv;
};

struct _TestConfigClass {
	RygelBaseConfigurationClass parent_class;
};


static gpointer test_config_parent_class = NULL;

void test_bgo683926_1 (void);
static void _vala_GValue_array_free (GValue* array, gint array_length);
void test_bgo683926_2 (void);
void test_silence_vala (void);
GType test_config_get_type (void) G_GNUC_CONST;
enum  {
	TEST_CONFIG_DUMMY_PROPERTY
};
static gboolean test_config_real_get_bool (RygelBaseConfiguration* base, const gchar* section, const gchar* key, GError** error);
TestConfig* test_config_new (void);
TestConfig* test_config_construct (GType object_type);
gint _vala_main (gchar** args, int args_length1);
static void _test_bgo683926_1_gtest_func (void);
static void _test_bgo683926_2_gtest_func (void);


/**
 * Test that database errors are reported correctly. This is a side-bug
 * discovered during fixing this bug.
 */
static void _vala_GValue_array_free (GValue* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			g_value_unset (&array[i]);
		}
	}
	g_free (array);
}


void test_bgo683926_1 (void) {
	RygelMediaExportDatabase* db = NULL;
	GError * _inner_error_ = NULL;
	db = NULL;
	{
		RygelMediaExportDatabase* _tmp0_ = NULL;
		RygelMediaExportDatabase* _tmp1_ = NULL;
		RygelMediaExportDatabase* _tmp2_ = NULL;
		RygelMediaExportDatabase* _tmp3_ = NULL;
		RygelMediaExportDatabase* _tmp4_ = NULL;
		_tmp1_ = rygel_media_export_database_new (":memory:", &_inner_error_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (db);
		db = _tmp2_;
		_tmp3_ = db;
		rygel_media_export_database_exec (_tmp3_, "create table object (id text not null, title text not null);", NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (_tmp0_);
			goto __catch0_g_error;
		}
		_tmp4_ = db;
		rygel_media_export_database_exec (_tmp4_, "insert into object (id, title) VALUES ('a', 'b');", NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (_tmp0_);
			goto __catch0_g_error;
		}
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp5_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp5_ = e->message;
		g_error ("regression.vala:35: => Database preparation failed: %s", _tmp5_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (db);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	{
		GValue* val = NULL;
		GValue _tmp6_ = {0};
		GValue* _tmp7_ = NULL;
		gint val_length1 = 0;
		gint _val_size_ = 0;
		RygelMediaExportDatabase* _tmp8_ = NULL;
		g_value_init (&_tmp6_, G_TYPE_STRING);
		g_value_set_string (&_tmp6_, "c");
		_tmp7_ = g_new0 (GValue, 1);
		_tmp7_[0] = _tmp6_;
		val = _tmp7_;
		val_length1 = 1;
		_val_size_ = val_length1;
		_tmp8_ = db;
		rygel_media_export_database_exec (_tmp8_, "replace into object (title) VALUES (?);", val, val_length1, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			val = (_vala_GValue_array_free (val, val_length1), NULL);
			goto __catch1_g_error;
		}
		g_assert_not_reached ();
		val = (_vala_GValue_array_free (val, val_length1), NULL);
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (db);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (db);
}


void test_bgo683926_2 (void) {
	GError * _inner_error_ = NULL;
	{
		RygelMediaExportMediaCache* cache = NULL;
		RygelMediaExportMediaCache* _tmp0_ = NULL;
		RygelSimpleContainer* container = NULL;
		RygelSimpleContainer* _tmp1_ = NULL;
		RygelSimpleContainer* _tmp2_ = NULL;
		RygelMediaExportMediaCache* _tmp3_ = NULL;
		RygelSimpleContainer* _tmp4_ = NULL;
		RygelMusicItem* item = NULL;
		RygelSimpleContainer* _tmp5_ = NULL;
		RygelMusicItem* _tmp6_ = NULL;
		RygelMusicItem* _tmp7_ = NULL;
		RygelMediaExportMediaCache* _tmp8_ = NULL;
		RygelMusicItem* _tmp9_ = NULL;
		RygelMusicItem* _tmp10_ = NULL;
		RygelMediaExportMediaCache* _tmp11_ = NULL;
		RygelMusicItem* _tmp12_ = NULL;
		RygelMediaObject* _tmp13_ = NULL;
		RygelMediaExportMediaCache* _tmp14_ = NULL;
		RygelMediaObject* _tmp15_ = NULL;
		RygelMediaObject* _tmp16_ = NULL;
		RygelMusicItem* _tmp17_ = NULL;
		RygelMusicItem* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_ = NULL;
		rygel_media_export_media_cache_ensure_exists (&_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch2_g_error;
		}
		_tmp0_ = rygel_media_export_media_cache_get_default ();
		cache = _tmp0_;
		_tmp1_ = rygel_simple_container_new_root ("foo");
		container = _tmp1_;
		_tmp2_ = container;
		rygel_media_object_set_id ((RygelMediaObject*) _tmp2_, "foo");
		_tmp3_ = cache;
		_tmp4_ = container;
		rygel_media_export_media_cache_save_container (_tmp3_, (RygelMediaContainer*) _tmp4_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (container);
			_g_object_unref0 (cache);
			goto __catch2_g_error;
		}
		_tmp5_ = container;
		_tmp6_ = rygel_music_item_new ("1", (RygelMediaContainer*) _tmp5_, "Static Title", RYGEL_MUSIC_ITEM_UPNP_CLASS);
		item = _tmp6_;
		_tmp7_ = item;
		rygel_media_item_set_mime_type ((RygelMediaItem*) _tmp7_, "audio/mpeg");
		_tmp8_ = cache;
		_tmp9_ = item;
		rygel_media_export_media_cache_save_item (_tmp8_, (RygelMediaItem*) _tmp9_, TRUE, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (item);
			_g_object_unref0 (container);
			_g_object_unref0 (cache);
			goto __catch2_g_error;
		}
		_tmp10_ = item;
		rygel_media_object_set_title ((RygelMediaObject*) _tmp10_, "Changed title");
		_tmp11_ = cache;
		_tmp12_ = item;
		rygel_media_export_media_cache_save_item (_tmp11_, (RygelMediaItem*) _tmp12_, FALSE, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (item);
			_g_object_unref0 (container);
			_g_object_unref0 (cache);
			goto __catch2_g_error;
		}
		_tmp14_ = cache;
		_tmp15_ = rygel_media_export_media_cache_get_object (_tmp14_, "1", &_inner_error_);
		_tmp13_ = _tmp15_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (item);
			_g_object_unref0 (container);
			_g_object_unref0 (cache);
			goto __catch2_g_error;
		}
		_tmp16_ = _tmp13_;
		_tmp13_ = NULL;
		_tmp17_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, RYGEL_TYPE_MUSIC_ITEM) ? ((RygelMusicItem*) _tmp16_) : NULL;
		if (_tmp17_ == NULL) {
			_g_object_unref0 (_tmp16_);
		}
		_g_object_unref0 (item);
		item = _tmp17_;
		_tmp18_ = item;
		_tmp19_ = rygel_media_object_get_title ((RygelMediaObject*) _tmp18_);
		_tmp20_ = _tmp19_;
		_vala_assert (g_strcmp0 (_tmp20_, "Static Title") == 0, "item.title == \"Static Title\"");
		_g_object_unref0 (_tmp13_);
		_g_object_unref0 (item);
		_g_object_unref0 (container);
		_g_object_unref0 (cache);
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (_error_);
	}
	__finally2:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


/**
 * Dummy function to silence the vala warnings
 */
void test_silence_vala (void) {
	GError * _inner_error_ = NULL;
	{
		GValue _tmp0_ = {0};
		GValue _tmp1_ = {0};
		RygelMediaExportDatabase* db = NULL;
		RygelMediaExportDatabase* _tmp2_ = NULL;
		RygelMediaExportDatabase* _tmp3_ = NULL;
		RygelMediaExportDatabase* _tmp4_ = NULL;
		RygelMediaExportDatabase* _tmp5_ = NULL;
		RygelMediaExportDatabase* _tmp6_ = NULL;
		RygelMediaExportDatabase* _tmp7_ = NULL;
		RygelMediaExportDatabaseCursor* _tmp8_ = NULL;
		RygelMediaExportDatabase* _tmp9_ = NULL;
		RygelMediaExportDatabaseCursor* _tmp10_ = NULL;
		rygel_media_export_database_null (&_tmp0_);
		_tmp1_ = _tmp0_;
		G_IS_VALUE (&_tmp1_) ? (g_value_unset (&_tmp1_), NULL) : NULL;
		_tmp2_ = rygel_media_export_database_new (":memory:", &_inner_error_);
		db = _tmp2_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch3_g_error;
		}
		_tmp3_ = db;
		rygel_media_export_database_analyze (_tmp3_);
		_tmp4_ = db;
		rygel_media_export_database_begin (_tmp4_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (db);
			goto __catch3_g_error;
		}
		_tmp5_ = db;
		rygel_media_export_database_commit (_tmp5_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (db);
			goto __catch3_g_error;
		}
		_tmp6_ = db;
		rygel_media_export_database_rollback (_tmp6_);
		_tmp7_ = db;
		rygel_media_export_database_query_value (_tmp7_, "SELECT 1;", NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (db);
			goto __catch3_g_error;
		}
		_tmp9_ = db;
		_tmp10_ = rygel_media_export_database_exec_cursor (_tmp9_, "SELECT 1;", NULL, 0, &_inner_error_);
		_tmp8_ = _tmp10_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (db);
			goto __catch3_g_error;
		}
		{
			RygelMediaExportDatabaseCursorIterator* _c_it = NULL;
			RygelMediaExportDatabaseCursor* _tmp11_ = NULL;
			RygelMediaExportDatabaseCursor* _tmp12_ = NULL;
			RygelMediaExportDatabaseCursorIterator* _tmp13_ = NULL;
			RygelMediaExportDatabaseCursorIterator* _tmp14_ = NULL;
			_tmp11_ = _tmp8_;
			_tmp8_ = NULL;
			_tmp12_ = _tmp11_;
			_tmp13_ = rygel_media_export_database_cursor_iterator (_tmp12_);
			_tmp14_ = _tmp13_;
			_g_object_unref0 (_tmp12_);
			_c_it = _tmp14_;
			while (TRUE) {
				gboolean _tmp15_ = FALSE;
				RygelMediaExportDatabaseCursorIterator* _tmp16_ = NULL;
				gboolean _tmp17_ = FALSE;
				sqlite3_stmt* c = NULL;
				RygelMediaExportDatabaseCursorIterator* _tmp18_ = NULL;
				sqlite3_stmt* _tmp19_ = NULL;
				sqlite3_stmt* _tmp20_ = NULL;
				_tmp16_ = _c_it;
				_tmp17_ = rygel_media_export_database_cursor_iterator_next (_tmp16_, &_inner_error_);
				_tmp15_ = _tmp17_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					_rygel_media_export_database_cursor_iterator_unref0 (_c_it);
					_g_object_unref0 (_tmp8_);
					_g_object_unref0 (db);
					goto __catch3_g_error;
				}
				if (!_tmp15_) {
					break;
				}
				_tmp18_ = _c_it;
				_tmp19_ = rygel_media_export_database_cursor_iterator_get (_tmp18_, &_inner_error_);
				c = _tmp19_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					_rygel_media_export_database_cursor_iterator_unref0 (_c_it);
					_g_object_unref0 (_tmp8_);
					_g_object_unref0 (db);
					goto __catch3_g_error;
				}
				_tmp20_ = c;
				sqlite3_data_count (_tmp20_);
			}
			_rygel_media_export_database_cursor_iterator_unref0 (_c_it);
		}
		_g_object_unref0 (_tmp8_);
		_g_object_unref0 (db);
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (_error_);
	}
	__finally3:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static gboolean test_config_real_get_bool (RygelBaseConfiguration* base, const gchar* section, const gchar* key, GError** error) {
	TestConfig * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
	GError* _tmp3_ = NULL;
	GError * _inner_error_ = NULL;
	self = (TestConfig*) base;
	g_return_val_if_fail (section != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	_tmp1_ = section;
	if (g_strcmp0 (_tmp1_, "MediaExport") == 0) {
		const gchar* _tmp2_ = NULL;
		_tmp2_ = key;
		_tmp0_ = g_strcmp0 (_tmp2_, "use-temp-db") == 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	}
	_tmp3_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, "No value available");
	_inner_error_ = _tmp3_;
	g_propagate_error (error, _inner_error_);
	return FALSE;
}


TestConfig* test_config_construct (GType object_type) {
	TestConfig * self = NULL;
	self = (TestConfig*) rygel_base_configuration_construct (object_type);
	return self;
}


TestConfig* test_config_new (void) {
	return test_config_construct (TYPE_TEST_CONFIG);
}


static void test_config_class_init (TestConfigClass * klass) {
	test_config_parent_class = g_type_class_peek_parent (klass);
	RYGEL_BASE_CONFIGURATION_CLASS (klass)->get_bool = test_config_real_get_bool;
}


static void test_config_instance_init (TestConfig * self) {
}


GType test_config_get_type (void) {
	static volatile gsize test_config_type_id__volatile = 0;
	if (g_once_init_enter (&test_config_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TestConfigClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) test_config_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TestConfig), 0, (GInstanceInitFunc) test_config_instance_init, NULL };
		GType test_config_type_id;
		test_config_type_id = g_type_register_static (RYGEL_TYPE_BASE_CONFIGURATION, "TestConfig", &g_define_type_info, 0);
		g_once_init_leave (&test_config_type_id__volatile, test_config_type_id);
	}
	return test_config_type_id__volatile;
}


static void _test_bgo683926_1_gtest_func (void) {
	test_bgo683926_1 ();
}


static void _test_bgo683926_2_gtest_func (void) {
	test_bgo683926_2 ();
}


gint _vala_main (gchar** args, int args_length1) {
	gint result = 0;
	TestConfig* _tmp0_ = NULL;
	TestConfig* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	g_test_init (&args_length1, &args, NULL);
	if (FALSE != FALSE) {
		test_silence_vala ();
	}
	_tmp0_ = test_config_new ();
	_tmp1_ = _tmp0_;
	rygel_meta_config_register_configuration ((RygelConfiguration*) _tmp1_);
	_g_object_unref0 (_tmp1_);
	g_test_add_func ("/plugins/media-export/regression/bgo689326_1", _test_bgo683926_1_gtest_func);
	g_test_add_func ("/plugins/media-export/regression/bgo689326_2", _test_bgo683926_2_gtest_func);
	_tmp2_ = g_test_run ();
	result = _tmp2_;
	return result;
}


int main (int argc, char ** argv) {
#if !GLIB_CHECK_VERSION (2,35,0)
	g_type_init ();
#endif
	return _vala_main (argv, argc);
}



