/*************************************************************************
 *
 * File...........: s390-tools/tape390/tape390.h
 * Author(s)......: Despina Papadopoulou <despina_p@de.ibm.com>
 *                  Stefan Bader <shbader@de.ibm.com>
 * Bugreports.to..: <Linux390@de.ibm.com>
 *
 * (C) IBM Corporation, IBM Deutschland Entwicklung GmbH, 2002
 *
 *************************************************************************/
#ifndef _TAPE390_H
#define _TAPE390_H

#define TAPE390_DISPLAY _IOW('d', 1, struct display_struct)

/*
 * The TAPE390_DISPLAY ioctl calls the Load Display command
 * which transfers 17 bytes of data from the channel to the subsystem:
 *     - 1 format control byte, and
 *     - two 8-byte messages
 *
 * Format control byte:
 *   0-2: New Message Overlay
 *     3: Alternate Messages
 *     4: Blink Message
 *     5: Display Low/High Message
 *     6: Reserved
 *     7: Automatic Load Request
 *
 */
#define TAPE_MSGTYPE_STANDARD		0
#define TAPE_MSGTYPE_UNLOAD		1
#define TAPE_MSGTYPE_LOAD		2
#define TAPE_MSGTYPE_NOOP		3
#define TAPE_MSGTYPE_UNLOAD_LOAD	7

typedef struct display_struct {
	struct {
		unsigned char	type		:3;
		unsigned char	alternate	:1;
		unsigned char	blink		:1;
		unsigned char	use_second	:1;
		unsigned char	reserved	:1;
		unsigned char	load_request	:1;
	}			cntrl;
        char			message1[8];
        char			message2[8];
} __attribute__ ((packed))	display_struct;

#endif 
