/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : Command.c
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2007 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2001/02/07
 *    Last                 : 2007/11/08
 * ====================================================================
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <gtk/gtk.h>
#include <unistd.h>
//#include <pwd.h>
#include <sys/types.h>
#include <sys/stat.h>

//#include <langinfo.h>
#include <iconv.h>

#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include "intl.h"

#include "MemoryLeak.h"
#include "List_cad.h"
#include "List_Dimension.h"
#include "List_PolyLine.h"
#include "List_insert.h"
#include "List_Ellipse.h"
#include "List_Block.h"
#include "List_Undo.h"
#include "List_Select.h"
#include "global.h"

#include "toolbar.h"
#include "Mouse.h"
#include "etc.h"
#include "culcfunc.h"
#include "Ellipse.h"
#include "sagcad.h"
#include "Draw.h"
#include "Select.h"
#include "InputBox.h"
#include "MsgBox.h"

#include "sgy.h"
#include "iges.h"
#include "DXF_read.h"
#include "DXF_write.h"
#include "NC_read.h"

#include "Dimension.h"
#include "B_spline.h"
#include "spline.h"
#include "CopyFunc.h"
#include "CopyDlg.h"
#include "TurnDlg.h"
#include "ScalingDlg.h"
#include "GridCopyDlg.h"
#include "SnapDlg.h"
#include "TextEditDlg.h"
#include "LayerSet.h"
#include "EnvSetDlg.h"
#include "plcDlg.h"
#include "PrintSetDlg.h"
#include "CamSetDlg.h"
#include "EllipseSetDlg.h"

#include "about.h"
#include "PostScript.h"
#include "CulcInputDlg.h"
#include "OutsideProcess.h"

#ifdef G_OS_WIN32
#  include <windows.h>
#endif

#define _COMMAND_
#include "Command.h"





/* -------------------------------------------------------------------
 * テスト用 key 't' に設定
 */
void test(void)
{
	return;
}



/* ---------------------------------------------------------
 * 外部処理 (Outside Proces)
 * 
 */
void cmd_outside_process(void)
{
	os_process();
	return;
}



/* ---------------------------------------------------------
 * 楕円作図
 * 
 */
void cmd_Ellipse_Draw(void)
{
	ELLIPSE ellipse;
	ELLIPSE_SET_DLG ellipse_set_dlg;
	struct RtnDat PAPH;
//	char str[256];

	ellipse_set_dlg.value = 0;
	ellipse_set_dlg.cx = 0;
	ellipse_set_dlg.cy = 0;
	ellipse_set_dlg.long_r = 5;
	ellipse_set_dlg.k = 0.5;
	ellipse_set_dlg.angle = 0;
	ellipse_set_dlg.sa = 0;
	ellipse_set_dlg.ea = 360;

	ellipse_set_dlg.cx_entry = NULL;
	ellipse_set_dlg.cy_entry = NULL;
	ellipse_set_dlg.long_r_entry = NULL;
	ellipse_set_dlg.k_entry = NULL;
	ellipse_set_dlg.angle_entry = NULL;
	ellipse_set_dlg.sa_entry = NULL;
	ellipse_set_dlg.ea_entry = NULL;

	ellipse_set_dlg.parent = MainWindow;
	ellipse_set_dlg.dialog = NULL;


	EllipseSetDialog(&ellipse_set_dlg);

#ifdef TEST
	if (ellipse_set_dlg.value == 0) {
		g_print("Cancel されました\n");
	}
	else {
		g_print ("中心(%f,%f) L = %f   S = %f   angle = %f   sa = %f   ea = %f\n", 
				 ellipse_set_dlg.cx, 
				 ellipse_set_dlg.cy, 
				 ellipse_set_dlg.long_r, 
				 ellipse_set_dlg.k, 
				 ellipse_set_dlg.angle, 
				 ellipse_set_dlg.sa, 
				 ellipse_set_dlg.ea 
				);
	}
#endif

	ellipse.layer = NowLayer;
	ellipse.color = NowColor;
	ellipse.style = NowStyle;

	ellipse.cx = ellipse_set_dlg.cx;
	ellipse.cy = ellipse_set_dlg.cy;
	ellipse.k = ellipse_set_dlg.k;
	ellipse.sa = ellipse_set_dlg.sa;
	ellipse.ea = ellipse_set_dlg.ea;

	/* -------------------------------------------------------------------
	 * pap : [6] 始点と角度と距離で直線の終点を求める
	 */
	PAPH.sx[1] = ellipse_set_dlg.cx;
	PAPH.sy[1] = ellipse_set_dlg.cy;
	PAPH.angle = ellipse_set_dlg.angle;
	PAPH.l = ellipse_set_dlg.long_r;
	pap(&PAPH);
	ellipse.dx = PAPH.ex[1] - ellipse_set_dlg.cx;
	ellipse.dy = PAPH.ey[1] - ellipse_set_dlg.cy;

	undo_index_plus();
	ellipse_list_add_first_with_undo(&ellipse, &ellipse_list_info);
	EllipseDraw(drawing_area, &ellipse, SCD_ORG);
	UpDate();




	return;
}



/* ---------------------------------------------------------
 * 印刷設定
 * 
 */
void cmd_print_set(void)
{
	PRINTSET_DLG printset_dlg;


	printset_dlg.value = 0;
	printset_dlg.view = printer.Draw_View;
	printset_dlg.paper = printer.Paper;
	printset_dlg.orientation = printer.Orientation;
	printset_dlg.up_scale = printer.up_scale;
	printset_dlg.low_scale = printer.low_scale;

	printset_dlg.toggle_frag = 0;

	printset_dlg.display_check = NULL;
	printset_dlg.drawing_check = NULL;
	printset_dlg.up_scale_entry = NULL;
	printset_dlg.low_scale_entry = NULL;
	printset_dlg.A4_check = NULL;
	printset_dlg.A3_check = NULL;
	printset_dlg.B5_check = NULL;
	printset_dlg.B4_check = NULL;
	printset_dlg.portrait_check = NULL;
	printset_dlg.landscape_check = NULL;

	printset_dlg.parent = MainWindow;
	printset_dlg.dialog = NULL;


	PrintSetDialog(&printset_dlg);


	if (printset_dlg.value != 0) {
		printer.Paper = printset_dlg.paper;
		printer.Orientation = printset_dlg.orientation;
		printer.Draw_View = printset_dlg.view;
		printer.up_scale = printset_dlg.up_scale;
		printer.low_scale = printset_dlg.low_scale;
		printer.scale = printer.up_scale / printer.low_scale;
		
		Redraw();
	}
	if (printset_dlg.value == 2) {
		keep_printer = printer;
		ConfigWrite();
	}
}



/* ---------------------------------------------------------
 * 印刷 (ID_PRINT)
 *	
 */
void cmd_print(void)
{
	char str[256], command[256], path[256];
//	int ps = 1, 
	int Ret;

#ifdef TEST
	Ret = MsgBox("ps or eps", "ps File ですか", "それとも eps Fileですか", "ps", "eps", "CANCEL");
	
	/* ps */
	if (Ret == 1) {
		strcpy(str, "NoName.ps");
		ps = 1;
	}
	/* eps */
	else if (Ret == 0) {
		strcpy(str, "NoName.eps");
		ps = 0;
	}
	/* CANCEL */
	else {
		return;
	}
#endif



	sprintf(str, "%s/NoName.ps", sagcad_user.CadPath);
	Ret = save_file_name_get(str);
	/* ファイルの選択をキャンセル */
	if (Ret == -1 || str == NULL) {
		//g_print("save_file : str = NULL\n");
		return;
	}
	if (Ret == 0 && str != NULL){
		PostScript(str);
	}



	/* Editor command */
	strcpy(path, sagcad_user.print_command);
	replace(path, "&", "");

	if (strstr(path, "%s") != NULL) {
		replace(path, "%s", str);
	}
//	else {
//		sprintf(path , "%s %s", sagcad_user.editor_command, FileName);
//	}

	sprintf(command, "%s &", path);
	g_print("%s\n", command);
	system(command);


#ifdef OLD
	sprintf(command,  _("The file saved. [%s]\n") , str);
	Ret = MsgBox("印刷 / GhostView", command,  _("Which does it execute?") , "GhostView",  _("Print") , "終了");

	/* GhostView */
	if (Ret == 1) {
		sprintf(command, "ghostview %s &", str);
		system(command);
	}
	/* 印刷 */
	else if (Ret == 0) {
		sprintf(command, "lpr %s &", str);
		system(command);
	}
#endif

	return;
}



/* -------------------------------------------------------------------
 * 連続線
 */
void cmd_polyline(void)
{
	SelectCancel(drawing_area);
	ReturnFunc = MouseRet_PolyLine;
	select_list_all_free();
	DcObj = 15;
	mode = 255;
	(*ReturnFunc)(drawing_area, 1, 0, 0);
	return;
}



/* -------------------------------------------------------------------
 * レイヤー設定
 */
void cmd_LayerSet(void)
{
	LAYERSET_DLG layerset_dlg;
	int i;

	layerset_dlg.value = 0;
	layerset_dlg.layerNo = 0;
	layerset_dlg.entry = NULL;
	for (i=0;i<256;i++) {
		layerset_dlg.Layer_widget[i] = NULL;
	}
	layerset_dlg.parent = MainWindow;
	layerset_dlg.dialog = NULL;

	//g_print("LayerSetDialog() : START !\n");
	LayerSetDialog(&layerset_dlg);
	//g_print("LayerSetDialog() : END !\n");
	
	return;
}



/* -------------------------------------------------------------------
 * Help 表示
 */
void cmd_help(void)
{
	FILE *stream;
	char str[256], path[256], *command, BrowserPath[256];

	char *envvalue, str_locale[256];

	/* ja_JP.eucJP */
	envvalue = getenv("LANGUAGE");
	if (envvalue == NULL) {
		envvalue = getenv("LANG");
	}

	if (envvalue != NULL) {
		/* japanese */
		if (strstr(envvalue, "ja_JP.eucJP") != NULL) {
			strcpy(str_locale, "ja");
		}
		else if (strstr(envvalue, "ja") != NULL) {
			strcpy(str_locale, "ja");
		}
		/* German */
		else if (strstr(envvalue, "de_DE@euro") != NULL) {
			strcpy(str_locale, "de");
		}
		else if (strstr(envvalue, "de") != NULL) {
			strcpy(str_locale, "de");
		}
#ifdef AFTER
		/* english */
		else if (strstr(envvalue, "en") != NULL) {
			strcpy(str_locale, "en");
		}
		else if (strstr(envvalue, "cs") != NULL) {
			strcpy(str_locale, "cs");
		}
		else if (strstr(envvalue, "da") != NULL) {
			strcpy(str_locale, "da");
		}
		else if (strstr(envvalue, "el") != NULL) {
			strcpy(str_locale, "el");
		}
		else if (strstr(envvalue, "es") != NULL) {
			strcpy(str_locale, "es");
		}
		else if (strstr(envvalue, "et") != NULL) {
			strcpy(str_locale, "et");
		}
		else if (strstr(envvalue, "fr") != NULL) {
			strcpy(str_locale, "fr");
		}
		else if (strstr(envvalue, "gl") != NULL) {
			strcpy(str_locale, "gl");
		}
		else if (strstr(envvalue, "hr") != NULL) {
			strcpy(str_locale, "hr");
		}
		else if (strstr(envvalue, "hu") != NULL) {
			strcpy(str_locale, "hu");
		}
		else if (strstr(envvalue, "it") != NULL) {
			strcpy(str_locale, "it");
		}
		else if (strstr(envvalue, "ko") != NULL) {
			strcpy(str_locale, "ko");
		}
		else if (strstr(envvalue, "nl") != NULL) {
			strcpy(str_locale, "nl");
		}
		else if (strstr(envvalue, "pl") != NULL) {
			strcpy(str_locale, "pl");
		}
		else if (strstr(envvalue, "pt_BR") != NULL) {
			strcpy(str_locale, "pt_BR");
		}
		else if (strstr(envvalue, "ro") != NULL) {
			strcpy(str_locale, "ro");
		}
		else if (strstr(envvalue, "ru") != NULL) {
			strcpy(str_locale, "ru");
		}
		else if (strstr(envvalue, "sk") != NULL) {
			strcpy(str_locale, "sk");
		}
		else if (strstr(envvalue, "sl") != NULL) {
			strcpy(str_locale, "sl");
		}
		else if (strstr(envvalue, "sr") != NULL) {
			strcpy(str_locale, "sr");
		}
		else if (strstr(envvalue, "sv") != NULL) {
			strcpy(str_locale, "sv");
		}
		else if (strstr(envvalue, "tr") != NULL) {
			strcpy(str_locale, "tr");
		}
		else if (strstr(envvalue, "zh_CN") != NULL) {
			strcpy(str_locale, "zh_CN");
		}
		else if (strstr(envvalue, "zh_TW.Big5") != NULL) {
			strcpy(str_locale, "zh_TW.Big5");
		}
#endif

		else {
			strcpy(str_locale, "ja");
		}
	}
	else {
		strcpy(str_locale, "ja");
	}

	/* ヘルプファイルパス確認 */
	strcpy(path, DOCDIR);
	sprintf(str, "%s/%s/index.html", path, str_locale);
	g_print("search 1 %s\n", str);
	if ( (stream  = fopen( str, "r" )) == NULL ) {
		g_print("Can't Find Help File. 1 [ %s ] \n", str);
		
		/* ../doc/locale/ (インストールしないとき用) */
		sprintf(str, "../doc/%s/index.html", str_locale);
		g_print("search 2 %s\n", str);
		if ( (stream  = fopen( str, "r" )) == NULL ) {
			g_print("Can't Find Help File. 2 [ %s ] \n", str);
			
			/* カレント */
			sprintf(str, "./%s/index.html", str_locale);
			g_print("search 3 %s\n", str);
			if ( (stream  = fopen( str, "r" )) == NULL ) {
				g_print("Can't Find Help File. 3 [ %s ] \n", str);
				MsgBox("SagCAD", _("Can't Find Help File.") , str, "OK", NULL, NULL);
				return;
			}
		}
	}
	fclose(stream);
	g_print("Help file find. [%s]\n", str);

#ifdef G_OS_WIN32
	strcpy(path, str);
	command = g_locale_from_utf8(path, -1, NULL, NULL, NULL);
	ShellExecute(0, "Open", command, "", "", 1); 	
	g_free(command);
#else

	strcpy(path, sagcad_user.browser_command);
	replace(path, "&", "");

	if (strstr(path, "%s") != NULL) {
		replace(path, "%s", str);
	}
	else {
		sprintf(path , "%s %s", sagcad_user.browser_command, str);
	}

	sprintf(BrowserPath, "%s &", path);
	g_print("%s\n", BrowserPath);
	if ( system(BrowserPath) ) {
		MsgBox("SagCAD", _("Can't Open Browser.") , _("The path setting will be how.") , "OK", NULL, NULL);
	}
#endif
}



/* ---------------------------------------------------------
 * 環境設定
 */
void cmd_env_set(void)
{
	ENVSET_DLG envset_dlg;
	int i;


	envset_dlg.Value = 0;	// 0:CANCEL  1:OK
	
	/* User */
	strcpy(envset_dlg.user_name, sagcad_user.UserName);
	strcpy(envset_dlg.user_company, sagcad_user.CompanyName);

	envset_dlg.entry_user_name = NULL;
	envset_dlg.entry_user_company = NULL;


	/* Path */
	strcpy(envset_dlg.KeepCadPath, sagcad_user.KeepCadPath);
	strcpy(envset_dlg.NcPath, sagcad_user.NcPath);
//	strcpy(envset_dlg.BrowserPath, sagcad_user.BrowserPath);

	envset_dlg.entry_cad_path = NULL;
	envset_dlg.entry_nc_path = NULL;
	envset_dlg.entry_browser_path = NULL;


	/* Command */
	strcpy(envset_dlg.print_command, sagcad_user.print_command);
	strcpy(envset_dlg.editor_command, sagcad_user.editor_command);
	strcpy(envset_dlg.browser_command, sagcad_user.browser_command);

	envset_dlg.entry_p_command = NULL;
	envset_dlg.entry_e_command = NULL;
	envset_dlg.entry_b_command = NULL;


	/* System */
	envset_dlg.system_WinMode = sagcad_system.WinMode;
	envset_dlg.system_win_x_pos = sagcad_system.win_x_pos;
	envset_dlg.system_win_y_pos = sagcad_system.win_y_pos;
	envset_dlg.system_win_width = sagcad_system.win_width;
	envset_dlg.system_win_height = sagcad_system.win_height;
	envset_dlg.system_Search = sagcad_system.Search;
	envset_dlg.system_Wait = sagcad_system.Wait;
//	envset_dlg.system_MaxLayer = sagcad_system.MaxLayer;
	envset_dlg.system_Splits = sagcad_system.Splits;
	envset_dlg.system_ZoomMag = sagcad_system.ZoomMag;
	envset_dlg.system_ViewX = sagcad_system.ViewX;
	envset_dlg.system_FilletRC = sagcad_system.FilletRC;
	envset_dlg.system_Length = sagcad_system.Length;

	envset_dlg.entry_system_WinMode = NULL;
	envset_dlg.entry_system_win_x_pos = NULL;
	envset_dlg.entry_system_win_y_pos = NULL;
	envset_dlg.entry_system_win_width = NULL;
	envset_dlg.entry_system_win_height = NULL;
	envset_dlg.entry_system_Search = NULL;
	envset_dlg.entry_system_Wait = NULL;
//	envset_dlg.entry_system_MaxLayer = NULL;
	envset_dlg.entry_system_Splits = NULL;
	envset_dlg.entry_system_ZoomMag = NULL;
	envset_dlg.entry_system_ViewX = NULL;
	envset_dlg.entry_system_FilletRC = NULL;
	envset_dlg.entry_system_Length = NULL;


	/* Dimension */
	envset_dlg.dimension_FontHeight = sagcad_dimension.Font_height;
	envset_dlg.dimension_FontLetterSpace = sagcad_dimension.Font_space;
	envset_dlg.dimension_FontWordSpace = sagcad_dimension.Word_space;
	envset_dlg.dimension_FontOverLineLength = sagcad_dimension.Font_space_line;
	strcpy(envset_dlg.dimension_Font1, sagcad_dimension.font_file);
	strcpy(envset_dlg.dimension_Font2, sagcad_dimension.font_file2);
	envset_dlg.dimension_DimensionArrowLength = sagcad_dimension.arrow_length;
	envset_dlg.dimension_DimensionArrowAngle = sagcad_dimension.arrow_angle;
	envset_dlg.dimension_DimensionOverArrowLength = sagcad_dimension.arrow_line_extension;
	envset_dlg.dimension_DimensionOverLength = sagcad_dimension.assistance_line_extension;
	envset_dlg.dimension_DimensionUnderLength = sagcad_dimension.assistance_line_space;

	envset_dlg.entry_dimension_FontHeight = NULL;
	envset_dlg.entry_dimension_FontLetterSpace = NULL;
	envset_dlg.entry_dimension_FontWordSpace = NULL;
	envset_dlg.entry_dimension_FontOverLineLength = NULL;
	envset_dlg.entry_dimension_Font1 = NULL;
	envset_dlg.entry_dimension_Font2 = NULL;
	envset_dlg.entry_dimension_DimensionArrowLength = NULL;
	envset_dlg.entry_dimension_DimensionArrowAngle = NULL;
	envset_dlg.entry_dimension_DimensionOverArrowLength = NULL;
	envset_dlg.entry_dimension_DimensionOverLength = NULL;
	envset_dlg.entry_dimension_DimensionUnderLength = NULL;


	/* SystemColor */
	envset_dlg.BackColor = sagcad_color.Back;
	envset_dlg.SelectColor = sagcad_color.Select;
	envset_dlg.DimensionColor = sagcad_color.Dimension;
	envset_dlg.CamColor = sagcad_color.Cam;
	envset_dlg.PrinterRectColor = sagcad_color.PrinterRect;
	envset_dlg.FirstCenterLine = sagcad_color.FirstCenterLine;

	envset_dlg.entry_system_color_BackColor = NULL;
	envset_dlg.entry_system_color_SelectColor = NULL;
	envset_dlg.entry_system_color_DimensionColor = NULL;
	envset_dlg.entry_system_color_CamColor = NULL;
	envset_dlg.entry_system_color_PrinterRectColor = NULL;
	envset_dlg.entry_system_color_FirstCenterLine = NULL;


	/* Color */
	for (i = 0 ; i < 25 ; i++) {
		envset_dlg.color_name[i] = sagcad_color.Menu[i+1];
		envset_dlg.entry_color_name[i] = NULL;
	}


	/* Style */
	for (i = 0 ; i < 7 ; i++) {
		envset_dlg.style_max[i] = sagcad_line_style[i].max;
		envset_dlg.style_min[i] = sagcad_line_style[i].min;
		envset_dlg.style_DisplayWidth[i] = sagcad_line_style[i].DsplayWidth;
		envset_dlg.style_PrinterWidth[i] = sagcad_line_style[i].PrinterWidth;

		envset_dlg.entry_style_max[i] = NULL;
		envset_dlg.entry_style_min[i] = NULL;
		envset_dlg.entry_style_DisplayWidth[i] = NULL;
		envset_dlg.entry_style_PrinterWidth[i] = NULL;
	}


	envset_dlg.parent = MainWindow;
	envset_dlg.dialog = NULL;


	/* 環境設定ダイアログ表示 */
	EnvSetDialog(&envset_dlg);
	if (envset_dlg.Value == -1) {
		return;	// -1:CANCEL  0:OK
	}


	/* User */
	strcpy(sagcad_user.UserName, envset_dlg.user_name);
	strcpy(sagcad_user.CompanyName, envset_dlg.user_company);

	/* Path */
	strcpy(sagcad_user.KeepCadPath, envset_dlg.KeepCadPath);
	strcpy(sagcad_user.NcPath, envset_dlg.NcPath);
//	strcpy(sagcad_user.BrowserPath, envset_dlg.BrowserPath);

	/* Command */
	strcpy(sagcad_user.print_command, envset_dlg.print_command);
	strcpy(sagcad_user.editor_command, envset_dlg.editor_command);
	strcpy(sagcad_user.browser_command, envset_dlg.browser_command);

	/* System */
	sagcad_system.Search	= envset_dlg.system_Search;
	sagcad_system.Wait		= envset_dlg.system_Wait;
//	sagcad_system.MaxLayer	= envset_dlg.system_MaxLayer;
	sagcad_system.Splits	= envset_dlg.system_Splits;
	sagcad_system.ZoomMag	= envset_dlg.system_ZoomMag;
	sagcad_system.ViewX		= envset_dlg.system_ViewX;
	sagcad_system.FilletRC	= envset_dlg.system_FilletRC;
	sagcad_system.Length	= envset_dlg.system_Length;

	sagcad_system.WinMode	= envset_dlg.system_WinMode;
	sagcad_system.win_x_pos	= envset_dlg.system_win_x_pos;
	sagcad_system.win_y_pos	= envset_dlg.system_win_y_pos;
	sagcad_system.win_width	= envset_dlg.system_win_width;
	sagcad_system.win_height= envset_dlg.system_win_height;

	/* Dimension */
	sagcad_dimension.Font_height		 = envset_dlg.dimension_FontHeight;
	sagcad_dimension.Font_space			 = envset_dlg.dimension_FontLetterSpace;
	sagcad_dimension.Word_space			 = envset_dlg.dimension_FontWordSpace;
	sagcad_dimension.Font_space_line	 = envset_dlg.dimension_FontOverLineLength;
	strcpy(sagcad_dimension.font_file, envset_dlg.dimension_Font1);
	strcpy(sagcad_dimension.font_file2, envset_dlg.dimension_Font2);
	sagcad_dimension.arrow_length				 = envset_dlg.dimension_DimensionArrowLength;
	sagcad_dimension.arrow_angle				 = envset_dlg.dimension_DimensionArrowAngle;
	sagcad_dimension.arrow_line_extension		 = envset_dlg.dimension_DimensionOverArrowLength;
	sagcad_dimension.assistance_line_extension	 = envset_dlg.dimension_DimensionOverLength;
	sagcad_dimension.assistance_line_space		 = envset_dlg.dimension_DimensionUnderLength;

	/* SystemColor */
	sagcad_color.Back				 = envset_dlg.BackColor;
	sagcad_color.Select				 = envset_dlg.SelectColor;
	sagcad_color.Dimension			 = envset_dlg.DimensionColor;
	sagcad_color.Cam				 = envset_dlg.CamColor;
	sagcad_color.PrinterRect		 = envset_dlg.PrinterRectColor;
	sagcad_color.FirstCenterLine	 = envset_dlg.FirstCenterLine;


	/* Color */
	for (i = 0 ; i < 25 ; i++) {
		sagcad_color.Menu[i+1] = envset_dlg.color_name[i];
	}


	/* Style */
	for (i = 0 ; i < 7 ; i++) {
		sagcad_line_style[i].max				 = envset_dlg.style_max[i];
		sagcad_line_style[i].min				 = envset_dlg.style_min[i];
		sagcad_line_style[i].DsplayWidth		 = envset_dlg.style_DisplayWidth[i];
		sagcad_line_style[i].PrinterWidth		 = envset_dlg.style_PrinterWidth[i];
	}


	ConfigWrite();
	Redraw();
}



/* -------------------------------------------------------------------
 * まだできてない表示
 */
void not_make(void)
{
	MsgBox("SagCAD", _("It is sorry.") , _("It creates from now.") , "OK", NULL, NULL);

}



/* -------------------------------------------------------
 * SagCAD の終了
 */
void cmd_end(void)
{
	int Ret;


	if (Undo_index != 0) {
		//                                                                          1     0        -1
		Ret = MsgBox("SagCAD", _("A drawing is changed!") , _("Does it save?") , "Yes", "No", "Cancel");
		/* Yes : (Save) */
		if (Ret == 1) {
			cmd_save();
		}
		/* No : (No Save) */
		else if (Ret == 0) {
		}
		/* Cancel : (return) */
		else {
			return;
		}
	}

	ending();
	gtk_main_quit(); 
}





/* =====================================================================
 * << 設定表示＆入力 >>
 * =====================================================================
 */

/* -------------------------------------------------------
 * 倍率(Mag)の設定
 */
void mag_box_click(GtkWidget *widget, GtkWidget *data)
{
	char str[256];
	double dbl;
	int Ret;

	dbl=Mag;
	FloatOut6(str, dbl, 0); /* 数値(小数点)出力用 */
	Ret = InputBox( _("Setting of magnification") , _("Input a magnification.") , _("(0 is hopeless!)"), str);
	if (Ret != -1) {
		dbl = atof(str);
		if(dbl == 0) {
			MsgBox("SagCAD", "Error", _("It is impossible to set 0.") , NULL, NULL, "OK");
		}
		else {
			SetMag(dbl);
			Redraw();
		}
	}
}



/* -------------------------------------------------------
 * filletRC の設定
 */
void fillet_box_click(GtkWidget *widget, GtkWidget *data)
{
	char str[256], DumyStr[256];
	double dbl;
	int Ret;

	dbl=sagcad_system.FilletRC;
	FloatOut6(str, dbl, 0); /* 数値(小数点)出力用 */
	Ret = InputBox("R or C", _("Set R of Fillet.") , _("Or Set C of Chamfer.") , str);
	if(Ret != -1) {
		dbl = atof(str);
		if(dbl == 0) {
			MsgBox("SagCAD", "Error", _("It is impossible to set 0.") , NULL, NULL, "OK");
		}
		else {
			/* < filletRC > */
			sagcad_system.FilletRC = dbl;
			FloatOut(str, dbl, 0);
			sprintf(DumyStr," R %s ",str);
			gtk_label_set_text(GTK_LABEL(fillet), DumyStr);
		}
	}
}



/* -------------------------------------------------------
 * length の設定
 */
void length_box_click(GtkWidget *widget, GtkWidget *data)
{
	char str[256], DumyStr[256];
	double dbl;
	int Ret;

	dbl = sagcad_system.Length;
	FloatOut6(str, dbl, 0); /* 数値(小数点)出力用 */
	Ret = InputBox( _("Basic Length Setting") , " ", _("Input basic length.") , str);
	if(Ret != -1) {
		dbl = atof(str);
		if(dbl == 0) {
			MsgBox("SagCAD", "Error", _("It is impossible to set 0.") , NULL, NULL, "OK");
		}
		else {
			/* < length > */
			sagcad_system.Length = atof(str);
			FloatOut(str, sagcad_system.Length, 0);
			sprintf(DumyStr," L %s ",str);
			gtk_label_set_text(GTK_LABEL(length), DumyStr);
			dbl = sagcad_system.Length;
		}
	}
}



/* -------------------------------------------------------
 * ScrollPitch の設定
 */
void scroll_pitch_box_click(GtkWidget *widget, GtkWidget *data)
{
	char str[256], DumyStr[256];
	double dbl;
	int Ret;

	dbl = sagcad_system.ScrollPitch;
	FloatOut6(str, dbl, 0); /* 数値(小数点)出力用 */
	Ret = InputBox( _("Scroll Pitch Setting") , "", _("Input Scroll Pitch") , str);
	if(Ret != -1) {
		dbl = atof(str);
		if(dbl==0) {
			MsgBox("SagCAD", "Error", _("It is impossible to set 0.") , NULL, NULL, "OK");
		}
		else {
			/* < ScrollPitch > */
			sagcad_system.ScrollPitch = atof(str);
			FloatOut(str, sagcad_system.ScrollPitch, 0);
			sprintf(DumyStr," SP %s ",str);
			gtk_label_set_text(GTK_LABEL(scroll_pitch), DumyStr);
			dbl = sagcad_system.ScrollPitch;
		}
	}
}





/* -------------------------------------------------------------------
 * モードキャンセル
 */
void cmd_all_cancel(void)
{
	SelectCancel(drawing_area);
	mode = 0;
	OnlyOne_mode = 0;
	Center_set_mode = 0;
	ReturnFunc = MouseRet_Non;
	(*ReturnFunc)(drawing_area, 1, 0, 0);
	return;
}



/* -------------------------------------------------------------------
 * バージョン情報
 */
void cmd_version(void)
{
	about(MainWindow);
}



/* -------------------------------------------------------------------
 * 保存データファイル名の選択
 * 
 */
int save_file_name_get(char *save_filename)
{
	GtkWidget *dialog;
	char path[1024];
	gint ret = -1;
	
	dialog = gtk_file_chooser_dialog_new ("Save File",
						NULL,
						GTK_FILE_CHOOSER_ACTION_SAVE,
						GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
						GTK_STOCK_SAVE, GTK_RESPONSE_ACCEPT,
						NULL);
	
#if GTK_CHECK_VERSION(2,8,0)
 	// GTK >= 2.8 code...
 	g_print("GTK >= 2.8\n");
	gtk_file_chooser_set_do_overwrite_confirmation (GTK_FILE_CHOOSER (dialog), TRUE);
#else
	// GTK < 2.8 code...
 	g_print("GTK < 2.8\n");
#endif
	//gtk_file_chooser_set_do_overwrite_confirmation (GTK_FILE_CHOOSER (dialog), TRUE);
	
	
	strcpy(path, save_filename);
	cutFileName(path);
	gtk_file_chooser_set_current_folder (GTK_FILE_CHOOSER (dialog), path);
	gtk_file_chooser_set_current_name (GTK_FILE_CHOOSER (dialog), getFileName(save_filename));
	
	if (gtk_dialog_run (GTK_DIALOG (dialog)) == GTK_RESPONSE_ACCEPT) {
		char *filename;
		
		/* filename (UTF-8) */
		filename = gtk_file_chooser_get_filename (GTK_FILE_CHOOSER (dialog));
		strcpy (save_filename, filename);
		g_free (filename);
		ret = 0;
	}
	gtk_widget_destroy (dialog);
	return ret;
}



/* -------------------------------------------------------------------
 * 読み込みデータファイル名の選択
 * 
 */
int read_file_name_get(char *read_filename)
{
	GtkWidget *dialog;
	gint ret = -1;
	
	dialog = gtk_file_chooser_dialog_new ("Open File",
						NULL,
						GTK_FILE_CHOOSER_ACTION_OPEN,
						GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
						GTK_STOCK_OPEN, GTK_RESPONSE_ACCEPT,
						NULL);
	
	if (gtk_dialog_run (GTK_DIALOG (dialog)) == GTK_RESPONSE_ACCEPT) {
		char *filename;
		
		/* filename (UTF-8) */
		filename = gtk_file_chooser_get_filename (GTK_FILE_CHOOSER (dialog));
		strcpy(read_filename, filename);
		g_free (filename);
		ret = 0;
	}
	gtk_widget_destroy (dialog);
	return ret;
}





/* =====================================================================
 * << ファイル >>
 * =====================================================================
 */

/* 図面ファイルを開く */
void cmd_open(void)
{
	char str[256], check_str[256], msg[256];
	int Ret;
	char *locale_str;
	
	if (Undo_index != 0) {
		Ret = MsgBox("SagCAD", _("A drawing is changed!") , _("Does it save?") , "Yes", "No", "Cancel");
		if (Ret == 1) cmd_save();		/* Yes : (Save) */
		else if (Ret == -1) return;		/* Cancel : (return) */
	}
	
	sprintf(check_str, "%s/Untitled.sgy", sagcad_user.CadPath);
	if (strcmp(check_str, NowFile) == 0) {
		sprintf (str, "%s/", sagcad_user.CadPath);
	}
	else {
		strcpy (str, NowFile);
	}
	
	
	Ret = read_file_name_get(str);
	/* ファイルの選択をキャンセル */
	if (Ret == -1) {
		g_print("File select cancel !\n");
		return;
	}
	g_print("File select OK !\n");
	if (str == NULL) g_print("str == NULL !\n");
	
	
	if (Ret == 0 && str != NULL){
		if (strstr(str, ".sgy") != NULL || strstr(str, ".SGY") != NULL) {
			cad_list_all_free(&cad_list_info);
			dimension_list_all_free(&dimension_list_info);
			polyline_list_all_free(&polyline_list_info);
			insert_list_all_free(&insert_list_info);
			block_list_all_free(&block_list_info);
			/* アンドゥを削除 */
			undo_list_all_free();

			sprintf(msg, "Reading SGY       ■□□□□□□");
			StatusMsg(msg);
			UpDate_widget(MainWindow);
			
			locale_str = g_locale_from_utf8(str, -1, NULL, NULL, NULL);
			if (locale_str == NULL) {
				g_print("cmd_open() : g_locale_from_utf8 error !\n");
				return;
			}
			strcpy(NowFile, str);
			sgyFileOpen(locale_str);
		}
		else if(strstr(str, ".dxf") != NULL || strstr(str, ".DXF") != NULL) {
			cad_list_all_free(&cad_list_info);
			dimension_list_all_free(&dimension_list_info);
			polyline_list_all_free(&polyline_list_info);
			ellipse_list_all_free(&ellipse_list_info);
			insert_list_all_free(&insert_list_info);
			block_list_all_free(&block_list_info);
			/* アンドゥを削除 */
			undo_list_all_free();

			sprintf(msg, "Reading DXF       ■□□□□□□");
			StatusMsg(msg);
			//g_print("%s\n", msg);
			UpDate_widget(MainWindow);
			
			locale_str = g_locale_from_utf8(str, -1, NULL, NULL, NULL);
			if (locale_str == NULL) {
				g_print("cmd_open() : g_locale_from_utf8 error !\n");
				return;
			}
			strcpy(NowFile, str);
			Ret = DxfFileOpen(locale_str, 0, 0);
		}

		//strcpy(NowFile, str);
		/* タイトルを設定 */
		SetTitle(NowFile);
		undo_buttun(0);
		redo_buttun(0);

		//Redraw();
		sprintf(msg, _("Reading OK! display Now. [%d]") , Ret);
		StatusMsg(msg);
		UpDate_widget(MainWindow);
		SetMag(Mag);
		sprintf(msg, _("display OK!") );
		StatusMsg(msg);
	}
	return;
}



/* 図面をファイルに保存 */
void cmd_rename(void)
{
	char *locale_str;
	char str[256];
	int Ret;

	if (Undo_index != 0) {
		//                                                                          1     0        -1
		Ret = MsgBox("SagCAD", _("A drawing is changed!") , _("Does it save?") , "Yes", "No", "Cancel");
		/* Yes : (Save) */
		if (Ret == 1) {
			cmd_save();
		}
		/* No : (No Save) */
		else if (Ret == 0) {
		}
		/* Cancel : (return) */
		else {
			return;
		}
	}

	strcpy (str, NowFile);
	Ret = save_file_name_get(str);
	/* ファイルの選択をキャンセル */
	if (Ret == -1) {
		//g_print("save_file : str = NULL\n");
		return;
	}
	if(Ret == 0 && str != NULL){
		locale_str = g_locale_from_utf8(str, -1, NULL, NULL, NULL);
		if (locale_str == NULL) {
			return;
		}
		if (strstr(str, ".sgy") != NULL || strstr(str, ".SGY") != NULL) {
			sgyFileSave(locale_str);
		}
		else if(strstr(str, ".igs") != NULL || strstr(str, ".IGS") != NULL) {
			igesFileSave(locale_str);
		}
		else if(strstr(str, ".dxf") != NULL || strstr(str, ".DXF") != NULL) {
			DxfFileSave(locale_str);
		}

		strcpy(NowFile, str);
		/* タイトルを設定 */
		SetTitle(NowFile);

		undo_buttun(0);
		redo_buttun(0);

		/* アンドゥを削除 */
		undo_list_all_free();
	}
	return;
}



/* 上書き保存 */
void cmd_save(void)
{
	char *locale_str;
	char str[256];


	strcpy (str, NowFile);
	locale_str = g_locale_from_utf8(str, -1, NULL, NULL, NULL);
	if (locale_str == NULL) {
		return;
	}
	if(str != NULL){
		if (strstr(str, ".sgy") != NULL || strstr(str, ".SGY") != NULL) {
			sgyFileSave(locale_str);
		}
		else if(strstr(str, ".igs") != NULL || strstr(str, ".IGS") != NULL) {
			igesFileSave(locale_str);
		}
		else if(strstr(str, ".dxf") != NULL || strstr(str, ".DXF") != NULL) {
			DxfFileSave(locale_str);
		}

		/* アンドゥを削除 */
		undo_list_all_free();

		/* タイトルを設定 */
		SetTitle(NowFile);

		undo_buttun(0);
		redo_buttun(0);

	}
	return;
}



/* 選択図形削除 */ 
void cmd_delete(void)
{
	if (select_list_info.head == NULL) {
		MsgBox("SagCAD", _("Execute after selecting a diagram.") , "", NULL, NULL, "OK");
		return;
	}
	SelectDelete(drawing_area);
}



/* 選択図形キャンセル */ 
void cmd_cancel(void)
{
	SelectCancel(drawing_area);
}



/* レイヤー移動 */ 
void cmd_layer_move(void)
{
	if (select_list_info.head == NULL) {
		MsgBox("SagCAD", _("Execute after selecting a diagram.") , "", NULL, NULL, "OK");
		return;
	}

	 Change_Layer(1);
}



/* レイヤー複写 */ 
void cmd_layer_copy(void)
{
	if (select_list_info.head == NULL) {
		MsgBox("SagCAD", _("Execute after selecting a diagram.") , "", NULL, NULL, "OK");
		return;
	}

	Change_Layer(2);
}



/* 線種変更 */ 
void cmd_line_style_change(void)
{
	Change_Line_Style();
}



/* New */
void cmd_New(void)
{
	system("sagcad &");
}



int cmd_view(GtkWidget *widget, GdkEventButton *event, gint i)
{
//	g_print("View = %d     event->button = %d\n", i, event->button);
	if (event->button == 1)
		view_func(1, i);
	else if (event->button == 3)
		view_func(0, i);
	return 1;
}



/* View 0 - 5 の制御 */
void view_func(int save0_or_view1, int number)
{
	/* 表示の状態を保存 */
	if (save0_or_view1 == 0)
	{
		GamenMag[number]  = Mag;
		GamenMagX[number] = MagX;
		GamenMagY[number] = MagY;
//		g_print("Mag = %f\n", Mag);
		return;
	}

	/* 表示の状態を復元 */
	else 
	{
		Mag = GamenMag[number];
		MagX = GamenMagX[number];
		MagY = GamenMagY[number];
//		g_print("Mag = %f\n", Mag);
		SetMag(Mag);
		/* 再描画 */
		Redraw();
		return;
	}
}



/* 中心設定 */
void cmd_center(void)
{
	char str[256];

	sprintf(str, _(" [View Center] (Left Search Point / Right Mouse Point / Center Cencel)") );
	StatusMsg(str);
	Center_set_mode = 100;
	return;
}



/* -------------------------------------------------------------------
 * 選択 
 */
void cmd_select(void)
{
	if (outside_process_on == 1) {
		ReturnFunc = MouseRet_Select_ops;
		DcObj = outside_process.Work[outside_process.now].sel_obj;
		mode = 300;
		(*ReturnFunc)(drawing_area, 1, 0, 0);
		SelectChainFrag = 0;
		SelectColorFrag = 0;
	}

	else {
		if (mode != 300 && mode != 310 && mode != 900) {
			SelectCancel(drawing_area);
		}
		ReturnFunc = MouseRet_Select;
		DcObj = 15+256+512+2048;
		mode = 300;
		(*ReturnFunc)(drawing_area, 1, 0, 0);
		SelectChainFrag = 0;
		SelectColorFrag = 0;
	}

	return;
}



/* -------------------------------------------------------------------
 * 範囲選択
 */
void cmd_rect_select(void)
{
	if (outside_process_on == 1) {
		if (outside_process.Work[outside_process.now].work == OPS_SELECT_ONE) {
			MsgBox("SagCAD　Outside Process", 
				   _("Now SELECT ONE Mode") , 
				   _("So this feature Can't use Now.") , NULL, NULL, "OK");
			return;
		}
		
		ReturnFunc = MouseRet_Rect_ops;
		DcObj = outside_process.Work[outside_process.now].sel_obj;
		mode = 310;
		(*ReturnFunc)(drawing_area, 1, 0, 0);
		SelectChainFrag = 0;
		SelectColorFrag = 0;
	}


	else {
		if (mode != 300 && mode != 310 && mode != 900) {
			SelectCancel(drawing_area);
		}
		ReturnFunc = MouseRet_Rect;
		DcObj = 15+256+512+2048;
		mode = 310;
		(*ReturnFunc)(drawing_area, 1, 0, 0);
		SelectChainFrag = 0;
		SelectColorFrag = 0;
	}

	return;
}



/* =====================================================================
 * << 作図 >>
 * =====================================================================
 */


/* -------------------------------------------------------------------
 * 作図
 */
void cmd_draw(void)
{
	SelectCancel(drawing_area);
	ReturnFunc = MouseRet_Draw;
	select_list_all_free();
	DcObj = 15+2048;
	mode = 200;
	(*ReturnFunc)(drawing_area, 1, 0, 0);
	return;
}



/* -------------------------------------------------------------------
 * チェイン
 */
void cmd_select_chain(void)
{
	SelectChainFrag = 1;
	SelectColorFrag = 0;

	/* 現在２個以上セレクトされている */
	if (select_list_info.tail != NULL) {
		OP_SelectList = select_list_info.tail;
	}

	/* 現在１個セレクトされている */
	else if (select_list_info.head != NULL) {
		OP_SelectList = select_list_info.head;
	}

	/* 現在１個もセレクトされていない */
	else if (select_list_info.head == NULL) {
		OP_SelectList = NULL;
	}

	return;
}



/* -------------------------------------------------------------------
 * 一筆チェイン
 */
void cmd_select_chain2(void)
{
	SelectChainFrag = 2;
	SelectColorFrag = 0;

	/* 現在２個以上セレクトされている */
	if (select_list_info.tail != NULL) {
		OP_SelectList = select_list_info.tail;
	}

	/* 現在１個セレクトされている */
	else if (select_list_info.head != NULL) {
		OP_SelectList = select_list_info.head;
	}

	/* 現在１個もセレクトされていない */
	else if (select_list_info.head == NULL) {
		OP_SelectList = NULL;
	}

	return;
}



/* -------------------------------------------------------------------
 * カラー
 */
void cmd_select_color(void)
{
	SelectColorFrag = 1;
	SelectChainFrag = 0;
	if (select_list_info.tail != NULL)
		OP_SelectList = select_list_info.tail;
	else if (select_list_info.head != NULL)
		OP_SelectList = select_list_info.head;
	else if (select_list_info.head == NULL)
		OP_SelectList = NULL;

	return;
}



/* -------------------------------------------------------------------
 * 片方トリム
 */
void cmd_trim(void)
{
	SelectCancel(drawing_area);
	ReturnFunc = MouseRet_Trim;
	select_list_all_free();
	DcObj = 15+2048;
	mode = 220;
	(*ReturnFunc)(drawing_area, 1, 0, 0);
	return;
}



/* -------------------------------------------------------------------
 * 両方トリム
 */
void cmd_both_trim(void) 
{
	SelectCancel(drawing_area);
	ReturnFunc = MouseRet_Trim;
	select_list_all_free();
	DcObj = 15+2048;
	mode = 225;
	(*ReturnFunc)(drawing_area, 1, 0, 0);
	return;
}



/* -------------------------------------------------------------------
 * 分割
 */
void cmd_split(void) 
{
	SelectCancel(drawing_area);
	ReturnFunc = MouseRet_Split;
	select_list_all_free();
	DcObj = 15+2048;
	mode = 260;
	(*ReturnFunc)(drawing_area, 1, 0, 0);
	return;
}



/* -----------------------------------------------------------------------
 * フィレット
 */
void cmd_fillet(void)
{
	SelectCancel(drawing_area);
	ReturnFunc = MouseRet_Fillet;
	select_list_all_free();
	DcObj = 15;
	mode = 270;
	(*ReturnFunc)(drawing_area, 1, 0, 0);
	return;
}



/* -------------------------------------------------------------------
 * Ｃ面取り
 */
void cmd_Chamfering(void)
{
	SelectCancel(drawing_area);
	ReturnFunc = MouseRet_Chamfering;
	select_list_all_free();
	DcObj = 15;
	mode = 280;
	(*ReturnFunc)(drawing_area, 1, 0, 0);
	return;
}



/* -------------------------------------------------------------------
 * 連続線
 */
void cmd_cont_line(void)
{
	SelectCancel(drawing_area);
	ReturnFunc = MouseRet_ContLine;
	select_list_all_free();
	DcObj = 15;
	mode = 250;
	(*ReturnFunc)(drawing_area, 1, 0, 0);
	return;
}



/* -------------------------------------------------------------------
 * ３点で円
 */
void cmd_3point(void)
{
	SelectCancel(drawing_area);
	ReturnFunc = MouseRet_3P_Circle;
	select_list_all_free();
	DcObj = 1;
	mode = 230;
	(*ReturnFunc)(drawing_area, 1, 0, 0);
	return;
}



/* -------------------------------------------------------------------
 * ３辺で円
 */
void cmd_3line(void)
{
	SelectCancel(drawing_area);
	ReturnFunc = MouseRet_3L_Circle;
	select_list_all_free();
	DcObj = 2;
	mode = 240;
	(*ReturnFunc)(drawing_area, 1, 0, 0);
	return;
}



/* -------------------------------------------------------------------
 * 点座標入力
 */
void cmd_point(void)
{
	int Ret;
	CAD cad;
	char str[256];
	double x, y;
	CAD_LIST *p_cad_list;


	while(1) {
		/* 数値入力ダイアログボックス表示 */
//		plaX = 100;
//		plaY = 105;
		Ret = InputBox( _("Make Point - Input Coordinates") , _("Input the coordinates of X.") , "", str);
		if (Ret == -1) return;
		x = atof(str);

		/* 数値入力ダイアログボックス表示 */
		Ret = InputBox( _("Make Point - Input Coordinates") , _("Input the coordinates of Y") , "", str);
		if (Ret == -1) return;
		y = atof(str);

		/* 点データを登録 */
		cad.code = 0;
		cad.layer = NowLayer;
		cad.style = NowStyle;
		cad.color = NowColor;
		cad.sx = x;
		cad.sy = y;
		cad.ex = 0;
		cad.ey = 0;
		cad.cx = 0;
		cad.cy = 0;
		cad.r  = 0;
		cad.OnScreen = 0;

		undo_index_plus();
		p_cad_list = cad_list_add_first_with_undo(&cad, &cad_list_info);
		SelectCadDraw(drawing_area, p_cad_list->cad, SCD_ORG);
	}
	return;
}



/* 再描画 */
void cmd_redraw(void)
{
	Redraw();
	return;
}



/* -------------------------------------------------------------------
 * 平行
 */
void cmd_parallel_copy(void)
{
	if (select_list_num() == 0) {
		MsgBox("SagCAD", _("Execute after selecting a diagram.") , "", NULL, NULL, "OK");
		return;
	}

	CopyFrag = select_list_num();
	ReturnFunc = MouseRet_Parallel;
	DcObj = 15;
	mode = 340;
	(*ReturnFunc)(drawing_area, 1, 0, 0);
	return;
}



/* -------------------------------------------------------------------
 * 回転
 */
void cmd_turn(void)
{
	if (select_list_num() == 0) {
		MsgBox("SagCAD", _("Execute after selecting a diagram.") , "", NULL, NULL, "OK");
		return;
	}

	CopyFrag = select_list_num();
	ReturnFunc = MouseRet_Turn;
	DcObj = 15;
	mode = 350;
	(*ReturnFunc)(drawing_area, 1, 0, 0);
	return;
}



/* -------------------------------------------------------------------
 * 対称
 */
void cmd_mirr(void)
{
	if (select_list_num() == 0) {
		MsgBox("SagCAD", _("Execute after selecting a diagram.") , "", NULL, NULL, "OK");
		return;
	}

	CopyFrag = select_list_num();
	ReturnFunc = MouseRet_Mirror;
	DcObj = 15;
	mode = 330;
	(*ReturnFunc)(drawing_area, 1, 0, 0);
	return;
}



/* -------------------------------------------------------------------
 * スケーリング
 */
void cmd_scaling(void)
{
	SCALING_DLG scaling_dlg;
	char str[256];

	if (select_list_num() == 0) {
		MsgBox("SagCAD", _("Execute after selecting a diagram.") , "", NULL, NULL, "OK");
		return;
	}

	sprintf(str, _("Scaling Setting") );
	StatusMsg(str);

	/* ScalingDialog */
	scaling_dlg.value = 1;
	scaling_dlg.x_pos = 0;
	scaling_dlg.y_pos = 0;
	scaling_dlg.coefficient = 1;
	scaling_dlg.x_pos_entry = NULL;
	scaling_dlg.y_pos_entry = NULL;
	scaling_dlg.coefficient_entry = NULL;
	scaling_dlg.parent = MainWindow;
	scaling_dlg.dialog = NULL;

	//g_print("ScalingDialog() : START !\n");
	ScalingDialog(&scaling_dlg);
	//g_print("ScalingDialog() : END !\n");
	if (scaling_dlg.value != -1) {
		CopyScaling(scaling_dlg.x_pos, scaling_dlg.y_pos, scaling_dlg.coefficient, 1);
	}
	
	/* mode を選択モード 300 に */
	ReturnFunc = MouseRet_Select;
	DcObj = 15;
	mode = 300;
	/* メッセージ表示 */
	(*ReturnFunc)(drawing_area, 1, 0, 0);

	return;
}



/* -------------------------------------------------------------------
 * 行列複写
 */
void cmd_grid_copy(void)
{
	GRIDCOPY_DLG gridcopy_dlg;
	char str[256];
	
	if (select_list_num() == 0) {
		MsgBox("SagCAD", _("Execute after selecting a diagram.") , "", NULL, NULL, "OK");
		return;
	}
	
	sprintf(str, _("Procession Copy Setting") );
	StatusMsg(str);
	
	/* GridCopyDialog */
	gridcopy_dlg.value = 1;
	gridcopy_dlg.x_pitch = 0;
	gridcopy_dlg.y_pitch = 0;
	gridcopy_dlg.x_repeats = 1;
	gridcopy_dlg.y_repeats = 1;
	gridcopy_dlg.x_pitch_entry = NULL;
	gridcopy_dlg.y_pitch_entry = NULL;
	gridcopy_dlg.x_repeats_entry = NULL;
	gridcopy_dlg.y_repeats_entry = NULL;
	gridcopy_dlg.parent = MainWindow;
	gridcopy_dlg.dialog = NULL;
	
	//g_print("GridCopyDialog() : START !\n");
	GridCopyDialog(&gridcopy_dlg);
	if (gridcopy_dlg.value != -1) {
		//g_print("(%f, %f),(%d, %d)\n", gridcopy_dlg.x_pitch, gridcopy_dlg.y_pitch, 
		//			gridcopy_dlg.x_repeats, gridcopy_dlg.y_repeats);
		CopyKousi(gridcopy_dlg.x_pitch, gridcopy_dlg.y_pitch, gridcopy_dlg.x_repeats, gridcopy_dlg.y_repeats);
	}
	
	/* mode を選択モード 300 に */
	ReturnFunc = MouseRet_Select;
	DcObj = 15;
	mode = 300;
	/* メッセージ表示 */
	(*ReturnFunc)(drawing_area, 1, 0, 0);
	return;
}



/* =====================================================================
 * << 寸法 >>
 * =====================================================================
 */
/* -------------------------------------------------------------------
 * 寸法 X
 */
void cmd_x_dimension(void)
{
	double scale;

	SelectCancel(drawing_area);
	ReturnFunc = MouseRet_DimensionX;
	DcObj = 113;
	Dim_now.Type = 10;
	Dim_now.Layer = NowLayer;
	Dim_now.text_color = sagcad_color.Dimension;
	Dim_now.Assist_color = sagcad_color.Dimension;
	Dim_now.FontType = sagcad_dimension.font_Type;

	Dim_now.FontHeight = sagcad_dimension.Font_height;
	scale = (Dim_now.FontHeight / 9.);
	Dim_now.FontSpace = sagcad_dimension.Font_space * scale;
	Dim_now.WordSpace = sagcad_dimension.Word_space * scale;
	Dim_now.FontOverLineSpace = sagcad_dimension.Font_space_line * scale;

//g_print("Command.c : cmd_x_dimension() : Dim_now.FontHeight = %f\n", Dim_now.FontHeight);
//g_print("Command.c : cmd_x_dimension() : Dim_now.FontSpace = %f\n", Dim_now.FontSpace);

	Dim_now.DrawType = DRAW_REAL;//sagcad_dimension.Draw_Type;
	Dim_now.UpperText[0] = '\0';
	Dim_now.LowerText[0] = '\0';
	Dim_old.Text[0] = '\0';
//	Dim_now.FontType = 1;
	
	Dim_now.start.x = 0;
	Dim_now.start.y = 0;
	Dim_now.end.x = 0;
	Dim_now.end.y = 0;

	Dim_now.diagram_of_char_index = 0;
	Dim_now.diagram_of_char = NULL;
	Dim_now.index = 0;
	Dim_now.AssistLine = NULL;
	mode = 510;
	(*ReturnFunc)(drawing_area, 1, 0, 0);
	return;
}



/* -------------------------------------------------------------------
 * 寸法 Y
 */
void cmd_y_dimension(void)
{
	double scale;

	SelectCancel(drawing_area);
	ReturnFunc = MouseRet_DimensionY;
	DcObj = 113;
	Dim_now.Type = 20;
	Dim_now.Layer = NowLayer;
	Dim_now.text_color = sagcad_color.Dimension;
	Dim_now.Assist_color = sagcad_color.Dimension;
	Dim_now.FontType = sagcad_dimension.font_Type;

	Dim_now.FontHeight = sagcad_dimension.Font_height;
	scale = (Dim_now.FontHeight / 9.);
	Dim_now.FontSpace = sagcad_dimension.Font_space * scale;
	Dim_now.WordSpace = sagcad_dimension.Word_space * scale;
	Dim_now.FontOverLineSpace = sagcad_dimension.Font_space_line * scale;

	Dim_now.DrawType = DRAW_REAL;
	Dim_now.UpperText[0] = '\0';
	Dim_now.LowerText[0] = '\0';
	Dim_old.Text[0] = '\0';
	
	Dim_now.start.x = 0;
	Dim_now.start.y = 0;
	Dim_now.end.x = 0;
	Dim_now.end.y = 0;

	Dim_now.diagram_of_char_index = 0;
	Dim_now.diagram_of_char = NULL;
	Dim_now.index = 0;
//	Dim_now.FontType = 1;
	Dim_now.AssistLine = NULL;
	mode = 520;
	(*ReturnFunc)(drawing_area, 1, 0, 0);
	return;
}



/* -------------------------------------------------------------------
 * 寸法 距離
 */
void cmd_p_dimension(void)
{
	double scale;

	SelectCancel(drawing_area);
	ReturnFunc = MouseRet_DimensionP;
	DcObj = 113;
	Dim_now.Type = 30;
	Dim_now.Layer = NowLayer;
	Dim_now.text_color = sagcad_color.Dimension;
	Dim_now.Assist_color = sagcad_color.Dimension;
	Dim_now.FontType = sagcad_dimension.font_Type;

	Dim_now.FontHeight = sagcad_dimension.Font_height;
	scale = (Dim_now.FontHeight / 9.);
	Dim_now.FontSpace = sagcad_dimension.Font_space * scale;
	Dim_now.WordSpace = sagcad_dimension.Word_space * scale;
	Dim_now.FontOverLineSpace = sagcad_dimension.Font_space_line * scale;

	Dim_now.DrawType = DRAW_REAL;
	Dim_now.UpperText[0] = '\0';
	Dim_now.LowerText[0] = '\0';
	Dim_old.Text[0] = '\0';
//	Dim_now.FontType = 1;
	
	Dim_now.start.x = 0;
	Dim_now.start.y = 0;
	Dim_now.end.x = 0;
	Dim_now.end.y = 0;

	Dim_now.diagram_of_char_index = 0;
	Dim_now.diagram_of_char = NULL;
	Dim_now.index = 0;
	Dim_now.AssistLine = NULL;
	mode = 530;
	(*ReturnFunc)(drawing_area, 1, 0, 0);
	return;
}



/* -------------------------------------------------------------------
 * 寸法 半径
 */
void cmd_r_dimension(void)
{
	double scale;

	SelectCancel(drawing_area);
	ReturnFunc = MouseRet_DimensionR;
	DcObj = 113;
	Dim_now.Type = 40;
	Dim_now.Layer = NowLayer;
	Dim_now.text_color = sagcad_color.Dimension;
	Dim_now.Assist_color = sagcad_color.Dimension;
	Dim_now.FontType = sagcad_dimension.font_Type;

	Dim_now.FontHeight = sagcad_dimension.Font_height;
	scale = (Dim_now.FontHeight / 9.);
	Dim_now.FontSpace = sagcad_dimension.Font_space * scale;
	Dim_now.WordSpace = sagcad_dimension.Word_space * scale;
	Dim_now.FontOverLineSpace = sagcad_dimension.Font_space_line * scale;

	Dim_now.DrawType = DRAW_REAL;
	Dim_now.Text[0] = '\0';
	Dim_now.UpperText[0] = '\0';
	Dim_now.LowerText[0] = '\0';
	Dim_old.Text[0] = '\0';
//	Dim_now.FontType = 1;
	
	Dim_now.start.x = 0;
	Dim_now.start.y = 0;
	Dim_now.end.x = 0;
	Dim_now.end.y = 0;

	Dim_now.diagram_of_char_index = 0;
	Dim_now.diagram_of_char = NULL;
	Dim_now.index = 0;
	Dim_now.AssistLine = NULL;
	mode = 540;
	(*ReturnFunc)(drawing_area, 1, 0, 0);
	return;
}



/* -------------------------------------------------------------------
 * 寸法 直径
 */
void cmd_d_dimension(void)
{
	double scale;

	SelectCancel(drawing_area);
	ReturnFunc = MouseRet_DimensionD;
	DcObj = 113;
	Dim_now.Type = 50;
	Dim_now.Layer = NowLayer;
	Dim_now.text_color = sagcad_color.Dimension;
	Dim_now.Assist_color = sagcad_color.Dimension;
	Dim_now.FontType = sagcad_dimension.font_Type;

	Dim_now.FontHeight = sagcad_dimension.Font_height;
	scale = (Dim_now.FontHeight / 9.);
	Dim_now.FontSpace = sagcad_dimension.Font_space * scale;
	Dim_now.WordSpace = sagcad_dimension.Word_space * scale;
	Dim_now.FontOverLineSpace = sagcad_dimension.Font_space_line * scale;

	Dim_now.DrawType = DRAW_REAL;
	Dim_now.Text[0] = '\0';
	Dim_now.UpperText[0] = '\0';
	Dim_now.LowerText[0] = '\0';
	Dim_old.Text[0] = '\0';
//	Dim_now.FontType = 1;
	
	Dim_now.start.x = 0;
	Dim_now.start.y = 0;
	Dim_now.end.x = 0;
	Dim_now.end.y = 0;

	Dim_now.diagram_of_char_index = 0;
	Dim_now.diagram_of_char = NULL;
	Dim_now.index = 0;
	Dim_now.AssistLine = NULL;
	mode = 550;
	(*ReturnFunc)(drawing_area, 1, 0, 0);
	return;
}



/* -------------------------------------------------------------------
 * 寸法 角度
 */
void cmd_a_dimension(void)
{
	double scale;

	SelectCancel(drawing_area);
	ReturnFunc = MouseRet_DimensionA;
	DcObj = 113;
	Dim_now.Type = 60;
	Dim_now.Layer = NowLayer;
	Dim_now.text_color = sagcad_color.Dimension;
	Dim_now.Assist_color = sagcad_color.Dimension;
	Dim_now.FontType = sagcad_dimension.font_Type;

	Dim_now.FontHeight = sagcad_dimension.Font_height;
	scale = (Dim_now.FontHeight / 9.);
	Dim_now.FontSpace = sagcad_dimension.Font_space * scale;
	Dim_now.WordSpace = sagcad_dimension.Word_space * scale;
	Dim_now.FontOverLineSpace = sagcad_dimension.Font_space_line * scale;

	Dim_now.DrawType = DRAW_REAL;
	Dim_now.UpperText[0] = '\0';
	Dim_now.LowerText[0] = '\0';
	Dim_old.Text[0] = '\0';
//	Dim_now.FontType = 1;
	
	Dim_now.start.x = 0;
	Dim_now.start.y = 0;
	Dim_now.end.x = 0;
	Dim_now.end.y = 0;

	Dim_now.diagram_of_char_index = 0;
	Dim_now.diagram_of_char = NULL;
	Dim_now.index = 0;
	Dim_now.AssistLine = NULL;
	mode = 560;
	(*ReturnFunc)(drawing_area, 1, 0, 0);
	return;
}



/* -------------------------------------------------------------------
 * 寸法 座標
 */
void cmd_pt_dimension(void)
{
	double scale;

	SelectCancel(drawing_area);
	ReturnFunc = MouseRet_DimensionPT;
	DcObj = 113;
	Dim_now.Type = 70;
	Dim_now.Layer = NowLayer;
	Dim_now.text_color = sagcad_color.Dimension;
	Dim_now.Assist_color = sagcad_color.Dimension;
	Dim_now.FontType = sagcad_dimension.font_Type;

	Dim_now.FontHeight = sagcad_dimension.Font_height;
	scale = (Dim_now.FontHeight / 9.);
	Dim_now.FontSpace = sagcad_dimension.Font_space * scale;
	Dim_now.WordSpace = sagcad_dimension.Word_space * scale;
	Dim_now.FontOverLineSpace = sagcad_dimension.Font_space_line * scale;

	Dim_now.DrawType = DRAW_REAL;
	Dim_now.UpperText[0] = '\0';
	Dim_now.LowerText[0] = '\0';
//	Dim_now.FontType = 1;
	
	Dim_now.start.x = 0;
	Dim_now.start.y = 0;
	Dim_now.end.x = 0;
	Dim_now.end.y = 0;

	Dim_now.diagram_of_char_index = 0;
	Dim_now.diagram_of_char = NULL;
	Dim_now.index = 0;
	Dim_now.AssistLine = NULL;
	Dim_old.Text[0] = '\0';
	mode = 570;
	(*ReturnFunc)(drawing_area, 1, 0, 0);
	return;
}



/* -------------------------------------------------------------------
 * 寸法 引出
 */
void cmd_hd_dimension(void)
{
	double scale;
	TEXT_EDIT_DLG a;

	SelectCancel(drawing_area);
	ReturnFunc = MouseRet_DimensionHD;
	(*ReturnFunc)(drawing_area, 1, 0, 0);


	/* TextEditDialog */
	strcpy(a.Text, "");
	strcpy(a.UpperText, "");
	strcpy(a.LowerText, "");

	a.FontHeight = sagcad_dimension.Font_height;
	scale = a.FontHeight / 9;
	a.FontSpace = sagcad_dimension.Font_space * scale;
	a.WordSpace = sagcad_dimension.Word_space * scale;
	a.FontOverLineSpace = sagcad_dimension.Font_space_line * scale;

	a.Angle = 0;
	a.SearchPointX = 0;
	a.SearchPointY = 0;
	a.FitPointX = 0;
	a.FitPointY = 1;


	a.entry_Text = NULL;
	a.entry_UpperText = NULL;
	a.entry_LowerText = NULL;

	a.entry_FontHeight = NULL;
	a.entry_FontSpace = NULL;
	a.entry_WordSpace = NULL;
	a.entry_FontOverLineSpace = NULL;
	a.entry_SearchPointX = NULL;
	a.entry_SearchPointY = NULL;
	a.entry_Angle = NULL;
	a.entry_FitPointX = NULL;
	a.entry_FitPointY = NULL;

	a.parent = MainWindow;
	a.dialog = NULL;

	TextEditDialog(&a);
	if (a.FontHeight == 0) {
		SelectCancel(drawing_area);
		mode = 0;
		return;
	}

	strcpy(Dim_now.Text, a.Text);
	strcpy(Dim_now.UpperText, a.UpperText);
	strcpy(Dim_now.LowerText, a.LowerText);
	Dim_now.FontHeight = a.FontHeight;
	Dim_now.FontSpace = a.FontSpace;
	Dim_now.WordSpace = a.WordSpace;
	Dim_now.FontOverLineSpace = a.FontOverLineSpace;


	ReturnFunc = MouseRet_DimensionHD;
	DcObj = 113;
	Dim_now.Type = 80;
	Dim_now.Layer = NowLayer;
	Dim_now.text_color = sagcad_color.Dimension;
	Dim_now.Assist_color = sagcad_color.Dimension;

	Dim_now.FontType = sagcad_dimension.font_Type;
	Dim_now.DrawType = DRAW_REAL;
	Dim_old.Text[0] = '\0';
	
	Dim_now.start.x = 0;
	Dim_now.start.y = 0;
	Dim_now.end.x = 0;
	Dim_now.end.y = 0;

	Dim_now.diagram_of_char_index = 0;
	Dim_now.diagram_of_char = NULL;
	Dim_now.index = 0;
	Dim_now.AssistLine = NULL;
	mode = 580;
	(*ReturnFunc)(drawing_area, 1, 0, 0);
	return;
}



/* -------------------------------------------------------------------
 * 寸法 注釈
 */
void cmd_at_dimension(void)
{
	double scale;
	TEXT_EDIT_DLG a;
	char mstr[256];


	SelectCancel(drawing_area);
	/* コマンドラインに表示 */
	sprintf(mstr, _(" [Drawer Line Dimension] Text Setting") );
	StatusMsg(mstr);

	/* TextEditDialog */
	strcpy(a.Text, "");
	strcpy(a.UpperText, "");
	strcpy(a.LowerText, "");

	a.FontHeight = sagcad_dimension.Font_height;
	scale = a.FontHeight / 9;
	a.FontSpace = sagcad_dimension.Font_space * scale;
	a.WordSpace = sagcad_dimension.Word_space * scale;
	a.FontOverLineSpace = sagcad_dimension.Font_space_line * scale;

	a.Angle = 0;
	a.SearchPointX = 0;
	a.SearchPointY = 0;
	a.FitPointX = 0;
	a.FitPointY = 1;


	a.entry_Text = NULL;
	a.entry_UpperText = NULL;
	a.entry_LowerText = NULL;

	a.entry_FontHeight = NULL;
	a.entry_FontSpace = NULL;
	a.entry_WordSpace = NULL;
	a.entry_FontOverLineSpace = NULL;
	a.entry_SearchPointX = NULL;
	a.entry_SearchPointY = NULL;
	a.entry_Angle = NULL;
	a.entry_FitPointX = NULL;
	a.entry_FitPointY = NULL;

	a.parent = MainWindow;
	a.dialog = NULL;

	TextEditDialog(&a);
	if (a.FontHeight == 0) {
		SelectCancel(drawing_area);
		mode = 0;
		return;
	}

	strcpy(Dim_now.Text, a.Text);
	strcpy(Dim_now.UpperText, a.UpperText);
	strcpy(Dim_now.LowerText, a.LowerText);
	Dim_now.FontHeight = a.FontHeight;
	Dim_now.FontSpace = a.FontSpace;
	Dim_now.WordSpace = a.WordSpace;
	Dim_now.FontOverLineSpace = a.FontOverLineSpace;


	ReturnFunc = MouseRet_DimensionAT;
	DcObj = 113;
	Dim_now.Type = 90;
	Dim_now.Layer = NowLayer;
	Dim_now.text_color = sagcad_color.Dimension;
	Dim_now.Assist_color = sagcad_color.Dimension;

	Dim_now.FontType = sagcad_dimension.font_Type;
	Dim_now.DrawType = DRAW_REAL;
	Dim_old.Text[0] = '\0';
	
	Dim_now.start.x = 0;
	Dim_now.start.y = 0;
	Dim_now.end.x = 0;
	Dim_now.end.y = 0;

	Dim_now.diagram_of_char_index = 0;
	Dim_now.diagram_of_char = NULL;
	Dim_now.index = 0;
	Dim_now.AssistLine = NULL;
	mode = 590;
	(*ReturnFunc)(drawing_area, 1, 0, 0);
	return;
}



/* -------------------------------------------------------------------
 * 寸法 編集
 */
void cmd_edt_dimension(void)
{
	SelectCancel(drawing_area);
	ReturnFunc = MouseRet_DimensionEDT;
	DcObj = 256;
	mode = 610;
	(*ReturnFunc)(drawing_area, 1, 0, 0);
	return;
}



/* -------------------------------------------------------------------
 * Undo
 */
void cmd_Undo(void)
{
	StartData = NULL;

	if (Undo() != 0) {
		Redraw();
		if (Undo_Now == 1) {
			undo_buttun(0);
		}
		redo_buttun(1);
	}
//	else MsgBox("err", "Undo End", " ", NULL, NULL, NULL);

	return;
}



/* -------------------------------------------------------------------
 * Redo
 */
void cmd_Redo(void)
{
	StartData = NULL;

	if (Redo() != 0) {
		Redraw();
		if (Undo_index +1 ==Undo_Now) {
			redo_buttun(0);
		}
		undo_buttun(1);
	}

//	else MsgBox("err", "Redo End", " ", NULL, NULL, NULL);

	return;
}



/* -------------------------------------------------------------------
 * カット
 */
void cmd_cut(void)
{
	if (select_list_num() == 0) {
		MsgBox("SagCAD", _("Execute after selecting a diagram.") , "", NULL, NULL, "OK");
		return;
	}

	WriteClipFile();
	SelectDelete(drawing_area);
}



/* -------------------------------------------------------------------
 * コピー
 */
void cmd_copy(void)
{
	if (select_list_num() == 0) {
		MsgBox("SagCAD", _("Execute after selecting a diagram.") , "", NULL, NULL, "OK");
		return;
	}

	WriteClipFile();
}



/* -------------------------------------------------------------------
 * ペースト
 */
void cmd_paste(void)
{
	ReadClipFile();
	ModifiedFlag = 1;
	/* 再描画処理 */
	Redraw();
}





/* -------------------------------------------------------------------
 * 部品図挿入
 */
void cmd_parts_in(void)
{
	char mstr[256];
	int Ret;


	sprintf(PartsFile, "%s/NoName.dxf", sagcad_user.CadPath);
	Ret = read_file_name_get(PartsFile);
	/* ファイルの選択をキャンセル */
	if (Ret == -1) {
		return;
	}
	if(Ret == 0 && PartsFile != NULL){
		if (strstr(PartsFile, ".sgy") != NULL || strstr(PartsFile, ".SGY") != NULL) {
			//
		}
		else if (strstr(PartsFile, ".dxf") != NULL || strstr(PartsFile, ".DXF") != NULL) {
			//
		}
		else {
			return;
		}
	}

//g_print("PartsFile = [%s]\n", PartsFile);

	SelectCancel(drawing_area);
	ReturnFunc = MouseRet_PartsRead;
	/* コマンドラインに表示 */
	sprintf(mstr, _(" [Part Insert] Select Starting Point") );
	StatusMsg(mstr);
	mode = 110;
	select_list_all_free();
	(*ReturnFunc)(drawing_area, 1, 0, 0);
	return;
}



/* ---------------------------------------------------------
 * CAM Profile
 * 
 */
void cmd_profile(void)
{
	if (select_list_num() == 0) {
		MsgBox("SagCAD", _("Execute after selecting a diagram.") , "", NULL, NULL, "OK");
		return;
	}

	ReturnFunc = MouseRet_CamProfile;
	mode = 900;
	CopyFrag = select_list_num();
	(*ReturnFunc)(drawing_area, 1, 0, 0);

	return;
}



/* ---------------------------------------------------------
 * NC 作図
 * 
 */
void cmd_NcDraw(void)
{
	NcFileRead();
	UpDate();
	return;
}





















#ifdef AFTER
void DUMMY_____________________________1(void) {}




/* CAM ポケット (ID_POKET) */
void cmd_poket(void)
{
	char str[256];

	if(select_list_num() == 0) {
		sprintf(str, "図形がセレクトされていません。");
		MsgBox("Boo !", str);
		return;
	}

//	sprintf(str, "これはまだテスト中です。\nフリーズする可能性が大きいので\n覚悟して下さい。");
//	MsgBox("やめた方がいいよメッセージ", str);


	ReturnFunc = MouseRet_offset;
	mode = 1000;
	CopyFrag = select_list_num();
	(*ReturnFunc)(drawing_area, 1, 0, 0);
	return;
}



/* -------------------------------------------------------------------
 * Key 設定 (ID_ESC_PUSH)
 */
void cmd_key_ESC(void)
{
	if (OnlyOne_mode == 210) OnlyOne (0); /* Cancel */
//	if(Chain2_OnlyOne_mode == 211)	SelectChain2_OnlyOne (0); /* Cancel */
	else {
		SelectCancel(drawing_area);
	}
	return;
}



/* -------------------------------------------------------------------
 * Key 設定 (ID_SPACE_PUSH)
 */
void cmd_key_SPACE(void)
{
	if(OnlyOne_mode == 210)	OnlyOne (2); /* No */
//	if(Chain2_OnlyOne_mode == 211)	SelectChain2_OnlyOne (2); /* No */
	return;
}



/* -------------------------------------------------------------------
 * Key 設定 (ID_RETURN_PUSH)
 */
void cmd_key_RETURN(void)
{
	if(OnlyOne_mode == 210)	OnlyOne (1); /* Yes */
//	if(Chain2_OnlyOne_mode == 211)	SelectChain2_OnlyOne (1); /* Yes */
	return;
}



#endif


/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : Command.c
 * ====================================================================
 */

