#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <gtk/gtk.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include "intl.h"

#include "MemoryLeak.h"
#include "List_cad.h"
#include "List_Dimension.h"
#include "List_PolyLine.h"
#include "List_Block.h"
#include "List_Undo.h"
#include "List_Select.h"
#include "global.h"
#include "Command.h"
#define TOOLBAR
#include "toolbar.h"




/* -------------------------------------------------------------------
 * ツールバーの作成  hbox  (横型)
 * 
 */
GtkWidget *create_hbox_toolbar(GtkWidget *container)
{
	/* ツールバーに載せるボタン */
	struct ToolBarItem ToolBarItem_hbox[] = {
		{_("New"),						GTK_STOCK_NEW,			NULL,			cmd_New,				1, 0},
		{_("Open"),						GTK_STOCK_OPEN,			NULL,			cmd_open,				1, 0},
		{_("Save As"),					GTK_STOCK_SAVE_AS,		NULL,			cmd_rename,				1, 0},
		{_("Save"),						GTK_STOCK_SAVE,			NULL,			cmd_save,				1, 0},
		{_("Part Insert"),				NULL,					Parts_in_xpm,	cmd_parts_in,			0, 0},
		{_("Print"),					GTK_STOCK_PRINT,		NULL,			cmd_print,				1, 0},
		{_("Printer Setting"),			NULL,					print_setup_xpm,cmd_print_set,			0, 0},
		{_("Quit"),						GTK_STOCK_QUIT,			NULL,			cmd_end,				1, 0},
		{SPACE_CMD,						NULL,					NULL,			NULL,					0, 0},
		{_("Undo"),						GTK_STOCK_UNDO,			NULL,			cmd_Undo,				1, 0},
		{_("Redo"), 					GTK_STOCK_REDO,			NULL,			cmd_Redo,				1, 0},
		{SPACE_CMD,						NULL, 					NULL,			NULL,					0, 0},
		{_("Cut"), 						GTK_STOCK_CUT,			NULL,			cmd_cut,				1, 0},
		{_("Copy"), 					GTK_STOCK_COPY,			NULL,			cmd_copy,				1, 0},
		{_("Paste"),					GTK_STOCK_PASTE,		NULL,			cmd_paste,				1, 0},
		{SPACE_CMD,						NULL,					NULL,			NULL,					0, 0},
		{_("Redraw"),					GTK_STOCK_CLEAR,		NULL,			cmd_redraw,				1, 0},
		{_("View Center"),				NULL,					Center_xpm,		cmd_center,				0, 0},
		{_("View 0 [Left : Recovery] [Right : Save]"), NULL,	View_0_xpm, 	cmd_view,				0, 1},
		{_("View 1 [Left : Recovery] [Right : Save]"), NULL,	View_1_xpm, 	cmd_view, 				0, 2},
		{_("View 2 [Left : Recovery] [Right : Save]"), NULL,	View_2_xpm, 	cmd_view, 				0, 3},
		{_("View 3 [Left : Recovery] [Right : Save]"), NULL,	View_3_xpm, 	cmd_view, 				0, 4},
		{_("View 4 [Left : Recovery] [Right : Save]"), NULL,	View_4_xpm, 	cmd_view, 				0, 5},
		{_("View 5 [Left : Recovery] [Right : Save]"), NULL,	View_5_xpm, 	cmd_view, 				0, 6},
		{SPACE_CMD,						NULL,					NULL,			NULL,					0, 0},
		{_("Environment Setting"),		GTK_STOCK_PREFERENCES,	NULL,			cmd_env_set,			1, 0},
		{_("Version Info"),				NULL,					about_xpm,		cmd_version,			0, 0},
		{_("Help"),						GTK_STOCK_HELP,			NULL,			cmd_help,				1, 0},
		{NULL,							NULL,					NULL,			NULL, 					0, 0}
	};
	GtkWidget *hbox_toolbar;


	/* hbox_toolbar */
	hbox_toolbar = gtk_hbox_new(FALSE, 2);
	gtk_widget_show (hbox_toolbar);

	gtk_box_pack_start(GTK_BOX(container), hbox_toolbar, FALSE, FALSE, 2);

	/* ツールバーにボタンを追加 */
	AppendButtons(container, hbox_toolbar, ToolBarItem_hbox);

	return hbox_toolbar;
}


void AppendButtons(GtkWidget *container, GtkWidget *toolbar, struct ToolBarItem *Item)
{
	GtkWidget *image;
	GtkWidget *button;
	GtkTooltips *tooltips;
	GtkWidget *separator;
	GdkPixmap *pixmap;
	GdkBitmap *mask;
	
	
	/* ツールバーにItem1をもとにボタンを追加 */
	while (Item->tooltips != NULL) {
		/* スペースの追加 */
		if (strcmp(Item->tooltips, SPACE_CMD) == 0){
			/* ツールバーに隙間を空ける */
			separator = gtk_vseparator_new();
			gtk_box_pack_start(GTK_BOX(toolbar), separator, FALSE, FALSE, 2);
			gtk_widget_show(separator);
			
			Item++;
			continue;
		}
		
		/* XPM のボタン */
		if (Item->button_type == 0) {
			//image = gtk_image_new_from_file (Item->xpm_file);
			pixmap = gdk_pixmap_create_from_xpm_d(toolbar->window, 
						 &mask, 
						 &toolbar->style->bg[GTK_STATE_NORMAL],
						 (gchar **)Item->xpm);
			image = gtk_image_new_from_pixmap(pixmap, mask);
		}
		/* STOK のボタン */
		else if (Item->button_type == 1) {
			image = gtk_image_new_from_stock (Item->xpm_file, GTK_ICON_SIZE_SMALL_TOOLBAR);
		}
		
		button = gtk_button_new();
		gtk_button_set_image(GTK_BUTTON(button), image);
		gtk_widget_set_size_request(button, TLLOBAR_ICON_SIZE, TLLOBAR_ICON_SIZE);
		gtk_box_pack_start(GTK_BOX(toolbar), button, FALSE, FALSE, 0);
		tooltips = gtk_tooltips_new();
		gtk_tooltips_set_tip(tooltips, button, Item->tooltips, Item->tooltips);
		
		if (Item->signal_type == 0) {
			/* "clicked" (left only) */
			g_signal_connect (G_OBJECT(button), "clicked", G_CALLBACK(Item->func), NULL);
		}
		else if (Item->signal_type != 0) {
			/* "button_press_event" (Right & Left) */
			g_signal_connect (G_OBJECT(button), "button_press_event", G_CALLBACK(Item->func), (gpointer)Item->signal_type);
		}
		
		gtk_widget_show (image);
		gtk_widget_show (button);
		
		/* Undo button save */
		if (strcmp(Item->tooltips, "Undo") == 0){
			UndoButton = button;
			undo_buttun(0);
		}
		/* Redo button save */
		if (strcmp(Item->tooltips, "Redo") == 0){
			RedoButton = button;
			redo_buttun(0);
		}
		
		/* 次へ */
		Item++;
	}
}



/* -------------------------------------------------------------------
 * ツールバーの作成  table  (縦２列型)
 * 
 */
GtkWidget *create_table_toolbar(GtkWidget *container)
{
	/* ツールバーに載せるボタン */
	struct TableToolBarItem table_toolbar_item[] = {
		{_("Delete"),					GTK_STOCK_DELETE,	NULL,					cmd_delete,			0,  0, 1},
		{_("Drawing"),					NULL,				Draw_xpm,				cmd_draw,			0,  1, 0},
		{_("Trim"),						NULL,				Trim_xpm,				cmd_trim,			0,  2, 0},
		{_("Fillet"),					NULL,				Fillet_xpm,				cmd_fillet,			0,  3, 0},
		{_("Point Input"),				NULL,				Point_Input_xpm,		cmd_point,			0,  4, 0},
		{_("Circle from three points"),	NULL,				Point3_xpm,				cmd_3point,			0,  5, 0},
		{_("Curve"),					NULL,				PolyLine_xpm,			cmd_polyline,		0,  6, 0},
		{TABLE_SPACE,					NULL,				NULL,					NULL,				0,  6, 0},

		{_("Select"),					NULL,				Select_xpm,				cmd_select,			0,  7, 0},
		{_("Mirror"),					NULL,				Mirr_xpm,				cmd_mirr,			0,  8, 0},
		{_("Rotate"),					NULL,				Roll_xpm,				cmd_turn,			0,  9, 0},
		{_("Scaling"),					NULL,				Scaling_xpm,			cmd_scaling,		0, 10, 0},
		{_("Layer Copy"),				NULL,				LayerCopy_xpm,			cmd_layer_copy,		0, 11, 0},
		{TABLE_SPACE,					NULL,				NULL,					NULL,				0, 11, 0},

		{_("Horizontal Dimension"),		NULL,				DimenX_xpm,				cmd_x_dimension,	0, 12, 0},
		{_("Distance Dimension"),		NULL,				DimenDistance_xpm,		cmd_p_dimension,	0, 13, 0},
		{_("Radius Dimansion"),			NULL,				DimenR_xpm,				cmd_r_dimension,	0, 14, 0},
		{_("Coordinates Dimension"),	NULL,				DimenPoint_xpm,			cmd_pt_dimension,	0, 15, 0},
		{_("Text"),						NULL,				DimenAtension_xpm,		cmd_at_dimension,	0, 16, 0},
		{TABLE_SPACE,					NULL,				NULL,					NULL ,				0, 16, 0},

		{_("CAM"),						NULL,				CamProfile_xpm,			cmd_profile,		0, 17, 0},
		{_("Outside Process"),			NULL,				outside_process_xpm,	cmd_outside_process,	0, 18, 0},



		{_("Cancel"),					NULL,				Cancel_xpm,				cmd_all_cancel,		1,  0, 0},
		{_("Divide"),					NULL,				Split_xpm,				cmd_split,			1,  1, 0},
		{_("Trim two"),					NULL,				Both_Trim_xpm,			cmd_both_trim,		1,  2, 0},
		{_("Chamfer"),					NULL,				C_Cut_xpm,				cmd_Chamfering,		1,  3, 0},
		{_("Continuation Line"),		NULL,				Cont_Line_xpm,			cmd_cont_line,		1,  4, 0},
		{_("Circle from three lines"),	NULL,				Line3_xpm,				cmd_3line,			1,  5, 0},
		{_("Ellipse"),					NULL,				Ellipse_xpm,			cmd_Ellipse_Draw,	1,  6, 0},
		{TABLE_SPACE,					NULL,				NULL,					NULL,				1,  6, 0},

		{_("Rect Select"),				NULL,				RectSelect_xpm,			cmd_rect_select,	1,  7, 0},
		{_("Parallel"),					NULL,				Para_xpm,				cmd_parallel_copy,	1,  8, 0},
		{_("Procession Copy"),			NULL,				Matrix_xpm,				cmd_grid_copy,		1,  9, 0},
		{_("Line Style Change"),		NULL,				LineStyleChange_xpm,	cmd_line_style_change,	1, 10, 0},
		{_("Layer Move"),				NULL,				LayerMove_xpm,			cmd_layer_move,		1, 11, 0},
		{TABLE_SPACE,					NULL,				NULL,					NULL ,				1, 11, 0},

		{_("Vertical Dimension"),		NULL,				DimenY_xpm,				cmd_y_dimension,	1, 12, 0},
		{_("Angle Dimension"),			NULL,				DimenAngle_xpm,			cmd_a_dimension,	1, 13, 0},
		{_("Diameter Dimension"),		NULL,				DimenD_xpm,				cmd_d_dimension,	1, 14, 0},
		{_("Drawer Line Dimension"),	NULL,				DimenPullLine_xpm,		cmd_hd_dimension,	1, 15, 0},
		{_("Edit Dimension"),			NULL,				DimenEdit_xpm,			cmd_edt_dimension,	1, 16, 0},
		{TABLE_SPACE,					NULL,				NULL,					NULL ,				1, 16, 0},

		{_("NC Drawing"),				NULL,				CamNcDraw_xpm,			cmd_NcDraw,			1, 17, 0},
		{NULL,							NULL, 				NULL,					NULL,				1, 18, 0}
	};
	GtkWidget *table_toolbar;

	/* table_toolbar */
	table_toolbar = gtk_table_new (2, 23, FALSE);
	gtk_widget_show (table_toolbar);

	gtk_box_pack_start(GTK_BOX(container), table_toolbar, FALSE, FALSE, 0);

	/* ツールバーにボタンを追加 */
	table_append_buttons(container, table_toolbar, table_toolbar_item);

	return table_toolbar;
}



void table_append_buttons(GtkWidget *container, GtkWidget *toolbar, struct TableToolBarItem *Item)
{
	GtkWidget *image;
	GtkWidget *button;
	GtkTooltips *tooltips;
	//GtkWidget *separator;
	GdkPixmap *pixmap;
	GdkBitmap *mask;
	
	
	/* ツールバーにItem1をもとにボタンを追加 */
	while (Item->tooltips != NULL) {
		/* スペースの追加 */
		if (strcmp(Item->tooltips, TABLE_SPACE) == 0){
			/* ツールバーに隙間を空ける */
			gtk_table_set_row_spacing (GTK_TABLE(toolbar), Item->columns, 5);
			Item++;
			continue;
		}
		
		/* XPM のボタン */
		if (Item->button_type == 0) {
			//image = gtk_image_new_from_file (Item->xpm_file);
			pixmap = gdk_pixmap_create_from_xpm_d(toolbar->window, 
						 &mask, 
						 &toolbar->style->bg[GTK_STATE_NORMAL],
						 (gchar **)Item->xpm);
			image = gtk_image_new_from_pixmap(pixmap, mask);
		}
		/* STOK のボタン */
		else if (Item->button_type == 1) {
			image = gtk_image_new_from_stock (Item->xpm_file, GTK_ICON_SIZE_SMALL_TOOLBAR);
		}
		
		button = gtk_button_new();
		gtk_button_set_image(GTK_BUTTON(button), image);
		gtk_widget_set_size_request(button, TLLOBAR_ICON_SIZE, TLLOBAR_ICON_SIZE);
		
		gtk_table_attach (	GTK_TABLE(toolbar), 
							button, 
							Item->rows, 
							Item->rows + 1, 
							Item->columns, 
							Item->columns + 1, 
							0,
							0,
							1,
							1);
		
		tooltips = gtk_tooltips_new();
		gtk_tooltips_set_tip(tooltips, button, Item->tooltips, Item->tooltips);
		g_signal_connect (G_OBJECT(button), "clicked", G_CALLBACK(Item->func), NULL);

		
		gtk_widget_show (image);
		gtk_widget_show (button);
		/* 次へ */
		Item++;
	}
}



/* -------------------------------------------------------------------
 * Undo Button を使用可能にする
 *     frag : 
 *            0 : 使用不可
 *            1 : 使用可能
 * 
 * -------------------------------------------------------------------
 */
int undo_buttun(int frag)
{
	if (frag == 0) {
		gtk_widget_set_sensitive(GTK_WIDGET(UndoButton), FALSE);
		return 1;
	}
	else if (frag == 1) {
		gtk_widget_set_sensitive(GTK_WIDGET(UndoButton), TRUE);
		return 1;
	}

	return 0;
}



/* -------------------------------------------------------------------
 * Redo Button を使用可能にする
 *     frag : 
 *            0 : 使用不可
 *            1 : 使用可能
 * 
 * -------------------------------------------------------------------
 */
int redo_buttun(int frag)
{
	if (frag == 0) {
		gtk_widget_set_sensitive(GTK_WIDGET(RedoButton), FALSE);
		return 1;
	}
	else if (frag == 1) {
		gtk_widget_set_sensitive(GTK_WIDGET(RedoButton), TRUE);
		return 1;
	}

	return 0;
}



