/* ====================================================================
 * ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : B_spline.c
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2003 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2003/01/03
 *    Last                 : 2003/04/16
 * ====================================================================
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <math.h>
#include <stdlib.h>
#include "MemoryLeak.h"
#include "List_PolyLine.h"
#include "Trace.h"
#define _B_SPLINE_
#include "B_spline.h"



/* -------------------------------------------------------------------
 *	
 */
int split2(VERTEX sp, VERTEX ep, VERTEX *ap)
{
	struct RtnDat PPPH;

	/* -----------------------------------------------------
	 * Ƚʬ sx[2] : ex[2] 
	 * ʬ
	 */
	PPPH.sx[1] = sp.x;
	PPPH.sy[1] = sp.y;
	PPPH.ex[1] = ep.x;
	PPPH.ey[1] = ep.y;
	PPPH.sx[2] = 1;
	PPPH.ex[2] = 1;
	ppp(&PPPH);
	
	ap->x = PPPH.sx[3];
	ap->y = PPPH.sy[3];
	return 1;
}



/* -------------------------------------------------------------------
 *	
 */
int split3(VERTEX sp, VERTEX ep, VERTEX *ap1, VERTEX *ap2)
{
	struct RtnDat PPPH;

	/* -----------------------------------------------------
	 * Ƚʬ sx[2] : ex[2] 
	 * ʬ
	 */
	PPPH.sx[1] = sp.x;
	PPPH.sy[1] = sp.y;
	PPPH.ex[1] = ep.x;
	PPPH.ey[1] = ep.y;
	PPPH.sx[2] = 1;
	PPPH.ex[2] = 2;
	ppp(&PPPH);
	
	ap1->x = PPPH.sx[3];
	ap1->y = PPPH.sy[3];



	PPPH.sx[1] = sp.x;
	PPPH.sy[1] = sp.y;
	PPPH.ex[1] = ep.x;
	PPPH.ey[1] = ep.y;
	PPPH.sx[2] = 2;
	PPPH.ex[2] = 1;
	ppp(&PPPH);
	
	ap2->x = PPPH.sx[3];
	ap2->y = PPPH.sy[3];
	return 1;
}



/* -------------------------------------------------------------------
 * ǽζ֤Υץ饤ؿ
 */
int spl1(double u, double *s1, double *s2, double *s3, double *s4)
{
	*s1 = pow((1-u), 3);
	*s2 = ((21.0/12.0) * pow(u, 3)) - ((9.0/2.0) * pow(u, 2)) + ((3.0) * u);
	*s3 = -((11.0/12.0) * pow(u, 3)) + ((3.0/2.0) * pow(u, 2));
	*s4 = (1.0/6.0) * pow(u, 3);
	return 1;
}



/* -------------------------------------------------------------------
 * ܤζ֤Υץ饤ؿ
 */
int spl2(double u, double *s1, double *s2, double *s3, double *s4)
{
	*s1 = (1.0/4.0) * pow((1-u), 3);
	*s2 = ((7.0/12.0) * pow(u, 3)) - ((5.0/4.0) * pow(u, 2)) + ((1.0/4.0) * u) + (7.0/12.0);
	*s3 = -((1.0/2.0) * pow(u, 3)) + ((1.0/2.0) * pow(u, 2)) + ((1.0/2.0) * u) + (1.0/6.0);
	*s4 = (1.0/6.0) * pow(u, 3);
	return 1;
}



/* -------------------------------------------------------------------
 * ֤ζ֤Υץ饤ؿ
 */
int spl3(double u, double *s1, double *s2, double *s3, double *s4)
{
	*s1 = (1.0/6.0) * pow((1-u), 3);
	*s2 = ((1.0/2.0) * pow(u, 3)) - pow(u, 2) + (2.0/3.0);
	*s3 = -((1.0/2.0) * pow(u, 3)) + ((1.0/2.0) * pow(u, 2)) + ((1.0/2.0) * u) + (1.0/6.0);
	*s4 = (1.0/6.0) * pow(u, 3);
	return 1;
}



/* -------------------------------------------------------------------
 * Ǹ夫飲ܤζ֤Υץ饤ؿ
 */
int spl4(double u, double *s1, double *s2, double *s3, double *s4)
{
	spl2(u, s1, s2, s3, s4);
	conv(s1, s2, s3, s4);
	return 1;
}



/* -------------------------------------------------------------------
 * Ǹζ֤Υץ饤ؿ
 */
int spl5(double u, double *s1, double *s2, double *s3, double *s4)
{
	spl1(u, s1, s2, s3, s4);
	conv(s1, s2, s3, s4);
	return 1;
}



/* -------------------------------------------------------------------
 * ؿȿž
 */
int conv(double *s1, double *s2, double *s3, double *s4)
{
	double s11, s22, s33, s44;

	s11 = *s1;
	s22 = *s2;
	s33 = *s3;
	s44 = *s4;

	*s1 = s44;
	*s2 = s33;
	*s3 = s22;
	*s4 = s11;

	return 1;
}



/* -------------------------------------------------------------------
 * ¥ץ饤
 *	
 * ǡο㣷ĤɬפȤʤ롣
 *	   ǡοĤξ硢ʬ
 *	   ǡοĤ飶Ĥξ硢ʬ
 *	
 *	
 *	
 */
int b_spline(int n, VERTEX *vertex, long color, double pitch)
{
	int i, j;
	double u, s1, s2, s3, s4;
	double x, y;
	static double old_x = 0, old_y = 0;
	VERTEX *dummy_vertex = NULL;

	VERTEX sp = {0,0};
	VERTEX ep = {0,0};
	VERTEX ap1 = {0,0};
	VERTEX ap2 = {0,0};


	if (n == 3) {
		dummy_vertex = (VERTEX *)xmalloc( 7 * sizeof(VERTEX) );
		j = 0;
		dummy_vertex[j].x = vertex[0].x;
		dummy_vertex[j].y = vertex[0].y;
		for (i = 1 ; i < n ; i++) {
			sp.x = vertex[i-1].x;
			sp.y = vertex[i-1].y;
			ep.x = vertex[i].x;
			ep.y = vertex[i].y;
			split3(sp, ep, &ap1, &ap2);
			j++;
			dummy_vertex[j].x = ap1.x;
			dummy_vertex[j].y = ap1.y;
			j++;
			dummy_vertex[j].x = ap2.x;
			dummy_vertex[j].y = ap2.y;
			j++;
			dummy_vertex[j].x = vertex[i].x;
			dummy_vertex[j].y = vertex[i].y;
		}
		n = 7;
	}
	else if (n > 3 && n < 7) {
		dummy_vertex = (VERTEX *)xmalloc(((n * 2) - 1) * sizeof(VERTEX));
		j = 0;
		dummy_vertex[j].x = vertex[0].x;
		dummy_vertex[j].y = vertex[0].y;
		for (i = 1 ; i < n ; i++) {
			sp.x = vertex[i-1].x;
			sp.y = vertex[i-1].y;
			ep.x = vertex[i].x;
			ep.y = vertex[i].y;
			split2(sp, ep, &ap1);
			j++;
			dummy_vertex[j].x = ap1.x;
			dummy_vertex[j].y = ap1.y;
			j++;
			dummy_vertex[j].x = vertex[i].x;
			dummy_vertex[j].y = vertex[i].y;
		}
		n = (n * 2) - 1;
	}
	else if (n > 6) {
		dummy_vertex = (VERTEX *)xmalloc( n * sizeof(VERTEX) );
		for (i = 0 ; i < n ; i++) {
			dummy_vertex[i].x = vertex[i].x;
			dummy_vertex[i].y = vertex[i].y;
		}
	}



	for (i = 0 ; i < n-3 ; i++) {
		for (u = 0.0 ; u <= 1.0 + pitch/2 ; u = u + pitch) {
			/* ǽζ */
			if (i == 0) {
				spl1(u, &s1, &s2, &s3, &s4);
			}
			/* ܤζ */
			else if (i == 1) {
				spl2(u, &s1, &s2, &s3, &s4);
			}
			/* ֤ζ */
			else if (i > 1 && i < n-5) {
				spl3(u, &s1, &s2, &s3, &s4);
			}
			/* Ǹ夫飲ܤζ */
			else if (i > 1 && i == n-5) {
				spl4(u, &s1, &s2, &s3, &s4);
			}
			/* Ǹζ */
			else if (i > 2 && i == n-4) {
				spl5(u, &s1, &s2, &s3, &s4);
			}
			x = s1*dummy_vertex[i].x + s2*dummy_vertex[i+1].x + s3*dummy_vertex[i+2].x + s4*dummy_vertex[i+3].x;
			y = s1*dummy_vertex[i].y + s2*dummy_vertex[i+1].y + s3*dummy_vertex[i+2].y + s4*dummy_vertex[i+3].y;
			if (u == 0) {
				//pset;
			}
			else {
				//LineDraw(drawing_area, old_x, old_y, x, y, 1, color);
				//line;
			}
			old_x = x;
			old_y = y;
		}
	}

	xfree(dummy_vertex);
	return 1;
}



/* ====================================================================
 * ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : B_spline.c
 * ====================================================================
 */

