/* ====================================================================
 * ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : DXF_read.h
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2003 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2002/12/24
 *    Last                 : 2003/04/16
 * ====================================================================
 */

#ifndef __DXF_READ_H__
#define __DXF_READ_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */



/* -------------------------------------------------------
 * 1 :   (struct #define etc)
 * -------------------------------------------------------
 */



/* -------------------------------------------------------
 * 2 : ѿ (global)
 * -------------------------------------------------------
 */
#ifdef _DXF_READ_
#define   GLOBAL
// 
#define   GLOBAL_VAL(v)  = (v)
#else
#define   GLOBAL	extern
// ʬ̵
#define   GLOBAL_VAL(v)  /* */
#endif


	GLOBAL char DxfVersion[256];
	GLOBAL int DxfLayerIndex;


#undef	GLOBAL
#undef	GLOBAL_VAL
#undef _DXF_READ_



/* -------------------------------------------------------
 * 3 : ؿ (Function)
 * -------------------------------------------------------
 */
int DxfFileOpen(char *OpenFileName, double x, double y);

/* إå */
int header_section_read(FILE *stream);

/* 饹 */
int classes_section_read(FILE *stream);

/* ơ֥륻 */
int tables_section_read(FILE *stream);
int table_read(FILE *stream);
int table_read_layer(FILE *stream);

/* ֥å */
int blocks_section_read(FILE *stream);
int blocks_read(FILE *stream);

/* ƥƥ */
int entities_section_read(FILE *stream, double x, double y);
/* ƥƥ */
int entitie_read(FILE *stream, double x, double y);

int DxfPointRead(FILE *stream, CAD *cad);
int DxfLineRead(FILE *stream, CAD *cad);
int DxfArcRead(FILE *stream, CAD *cad);
int DxfCircleRead(FILE *stream, CAD *cad);
int DxfTextRead(FILE *stream, DIMENSION *dimension);
int DxfSplineRead(FILE *stream, POLYLINE *polyline);
int DxfPolyLineRead(FILE *stream, POLYLINE *polyline);
int DxfVertexRead(FILE *stream, VERTEX *vertex);
int DxfSolidRead(FILE *stream, POLYLINE *polyline);
int DxfEllipseRead(FILE *stream, ELLIPSE *ellipse);
int DxfInsertRead(FILE *stream, INSERT *insert);
int DxfEtcRead(FILE *stream);

/* ֥ȥ */
int objects_section_read(FILE *stream);

long DxfColorCh(long DxfColor);
int DxfStyleCh(char *Style);
int LayerCh(char *Lay);
void DXF_Info(void);

/* 󥵡ȥǡǤʬ */
int split_insert(INSERT *insert,  CAD_LIST_INFO *p_cad_list_info, 
				 DIMENSION_LIST_INFO *p_dimension_list_info, 
				 POLYLINE_LIST_INFO *p_polyline_list_info, 
				 ELLIPSE_LIST_INFO *p_ellipse_list_info, 
				 double x, 
				 double y
				 );

/* CAD_LIST_INFO_1  CAD_LIST_INFO_2 ˥ԡ */
int copy_cad_list_info(CAD_LIST_INFO *org_cad_list_info, CAD_LIST_INFO *cpy_cad_list_info);



#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* __DXF_READ_H__ */
/* ====================================================================
 * ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : DXF_read.h
 * ====================================================================
 */
