/* ====================================================================
 * ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : DXF_write.c
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2003 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2002/12/24
 *    Last                 : 2003/04/16
 * ====================================================================
 */

#ifndef __DXF_WRITE_H__
#define __DXF_WRITE_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */



/* -------------------------------------------------------
 * 1 :   (struct #define etc)
 * -------------------------------------------------------
 */



/* -------------------------------------------------------
 * 2 : ѿ (global)
 * -------------------------------------------------------
 */
#ifdef _DXF_WRITE_
#define   GLOBAL
// 
#define   GLOBAL_VAL(v)  = (v)
#else
#define   GLOBAL	extern
// ʬ̵
#define   GLOBAL_VAL(v)  /* */
#endif




#undef  GLOBAL
#undef  GLOBAL_VAL
#undef _DXF_WRITE_



/* -------------------------------------------------------
 * 3 : ؿ (Function)
 * -------------------------------------------------------
 */
int DxfFileSave(char *SaveFileName);
/* إå */
int header_section_write(FILE *stream);
/* classes_section_write */
int classes_section_write(FILE *stream);
/* objects_section_write */
int objects_section_write(FILE *stream);
/* ơ֥륻 */
int tables_section_write(FILE *stream);
/*	    */
int tables_section_LTYPE_write(FILE *stream);
/*	   쥤䡼 */
int tables_section_LAYER_write(FILE *stream);
/*	    */
int tables_section_STYLE_write(FILE *stream);
/* ֥å */
int blocks_section_write(FILE *stream);
/* ƥƥ */
int entities_section_write(FILE *stream);
int entities_section_point_write(CAD *cad, FILE *stream);
int entities_section_line_write(CAD *cad, FILE *stream);
int entities_section_arc_write(CAD *cad, FILE *stream);
int entities_section_circle_write(CAD *cad, FILE *stream);
int entities_section_polyline_write(POLYLINE *polyline, FILE *stream);
int entities_section_ellipse_write(ELLIPSE *ellipse, FILE *stream);
int entities_section_dimension_AssistLine_write(DIMENSION *dimension, FILE *stream);
int entities_section_dimension_Text_write(DIMENSION *dimension, FILE *stream);
int eof_section_write(FILE *stream);
int SagToDXF_Style(int style, char *org);
int SgyToDxf_color(long SgyColor);

int DXF_LineEndArrow(FILE *stream, int LAYER, double SX, double SY, double EX, double EY, int LineFrag, int DrawType);
int DXF_LineBothArrow(FILE *stream, int LAYER, double SX, double SY, double EX, double EY, int LineFrag, int DrawType);
int DXF_LineBothConverseArrow(FILE *stream, int LAYER, double SX, double SY, double EX, double EY, int LineFrag, int DrawType);
int DXF_ArcBothArrow(FILE *stream, int LAYER, double CX, double CY, double R, double SX, double SY, double EX, double EY, int ArcFrag, int DrawType);
int DXF_AssistanceLine(FILE *stream, int LAYER, double SX, double SY, double EX, double EY, int DrawType);
int DXF_LineEndExtension(FILE *stream, int LAYER, double SX, double SY, double EX, double EY, int DrawType);



#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* __DXF_WRITE_H__ */
/* ====================================================================
 * ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : DXF_write.c
 * ====================================================================
 */
