/* ====================================================================
 * ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : Dimension.h
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2003 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2001/02/27
 *    Last                 : 2003/04/16
 * ====================================================================
 */

#ifndef __DIMENSION_H__
#define __DIMENSION_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */



/* -------------------------------------------------------
 * 1 :   (struct #define etc)
 * -------------------------------------------------------
 */



/* -------------------------------------------------------
 * 2 : ѿ (global)
 * -------------------------------------------------------
 */
#ifdef _DIMENSION_
#define   GLOBAL
// 
#define   GLOBAL_VAL(v)  = (v)
#else
#define   GLOBAL	extern
// ʬ̵
#define   GLOBAL_VAL(v)  /* */
#endif




#undef	GLOBAL
#undef	GLOBAL_VAL
#undef _DIMENSION_



/* -------------------------------------------------------
 * 3 : ؿ (Function)
 * -------------------------------------------------------
 */
/* ˡɽ */
int DimensionDraw(GtkWidget *widget, DIMENSION *a, int TextFrag);
int Dimension_Line_Basic(GtkWidget *widget, DIMENSION *a, int TextFrag);
int Dimension_Text_Basic(GtkWidget *widget, DIMENSION *a, int TextFrag);

/* ˡǡ׻ */
int Dimension_X_Culc(DIMENSION *a, DIMENSION_CULC PicPoint);
int Dimension_Y_Culc(DIMENSION *a, DIMENSION_CULC PicPoint);
int Dimension_P_Culc(DIMENSION *a, DIMENSION_CULC PicPoint);
int Dimension_A_Culc(DIMENSION *a, DIMENSION_CULC PicPoint);
int Dimension_R_Culc(DIMENSION *a, DIMENSION_CULC PicPoint);
int Dimension_D_Culc(DIMENSION *a, DIMENSION_CULC PicPoint);
int Dimension_HD_Culc(DIMENSION *a, DIMENSION_CULC PicPoint);
int Dimension_PT_Culc(DIMENSION *a, DIMENSION_CULC PicPoint);
int DimensionAngleCH(float *angle, int *point);



#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* __DIMENSION_H__ */
/* ====================================================================
 * ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : Dimension.h
 * ====================================================================
 */

