/* ====================================================================
 * ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : GridCopyDlg.c
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2003 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2003/02/20
 *    Last                 : 2003/02/20
 * ====================================================================
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <gtk/gtk.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include "intl.h"

#include "Trace.h"
#define _GRIDCOPYDLG_
#include "GridCopyDlg.h"





/* -------------------------------------------------------------------
 * CANCEL
 */
void gridcopy_dlg_cancel_pushed(GtkWidget *widget, GRIDCOPY_DLG *gridcopy_dlg)
{
	gridcopy_dlg->x_pitch = 0;
	gridcopy_dlg->y_pitch = 0;
	gridcopy_dlg->x_repeats = 0;
	gridcopy_dlg->y_repeats = 0;
}



/* -------------------------------------------------------------------
 * OK
 */
void gridcopy_dlg_ok_pushed(GtkWidget *widget, GRIDCOPY_DLG *gridcopy_dlg)
{
	char str[256];


	/* ƥȥȥ꡼ʸ */
	if (gridcopy_dlg->x_pitch_entry) {
		strcpy(str, gtk_entry_get_text(GTK_ENTRY(gridcopy_dlg->x_pitch_entry)));
		gridcopy_dlg->x_pitch = atof(str);
	}

	if (gridcopy_dlg->y_pitch_entry) {
		strcpy(str, gtk_entry_get_text(GTK_ENTRY(gridcopy_dlg->y_pitch_entry)));
		gridcopy_dlg->y_pitch = atof(str);
	}

	if (gridcopy_dlg->x_repeats_entry) {
		strcpy(str, gtk_entry_get_text(GTK_ENTRY(gridcopy_dlg->x_repeats_entry)));
		gridcopy_dlg->x_repeats = atoi(str);
	}

	if (gridcopy_dlg->y_repeats_entry) {
		strcpy(str, gtk_entry_get_text(GTK_ENTRY(gridcopy_dlg->y_repeats_entry)));
		gridcopy_dlg->y_repeats = atoi(str);
	}

}



/* -------------------------------------------------------------------
 * 줿٥
 * key_press_event
 */
static gint gridcopy_dlg_key_press_event(GtkWidget *widget, GdkEventKey *event, GRIDCOPY_DLG *gridcopy_dlg)
{
//	g_print("sagcad.c : gridcopy_dlg_key_press_event  state:%d  keyval:0x%x  length:%d  string:%s\n", 
//			event->state, event->keyval, event->length, event->string);


	if (event->keyval == 0xff0d || event->keyval == 0xff8d) {		/* Enter */
		/* ե x_pitch_entry  Enter ʤե y_pitch_entry ˰ܤ */
		if (GTK_WIDGET( gridcopy_dlg->x_pitch_entry) == GTK_WINDOW(gridcopy_dlg->dialog)->focus_widget) {
			gtk_window_set_focus(GTK_WINDOW(gridcopy_dlg->dialog), gridcopy_dlg->y_pitch_entry);
			gtk_entry_select_region( GTK_ENTRY(gridcopy_dlg->y_pitch_entry), 0, 
									 GTK_ENTRY(gridcopy_dlg->y_pitch_entry)->text_length);
		}
		/* ե y_pitch_entry  Enter ʤե x_repeats_entry ˰ܤ */
		else if (GTK_WIDGET(gridcopy_dlg->y_pitch_entry) == GTK_WINDOW(gridcopy_dlg->dialog)->focus_widget) {
			gtk_window_set_focus(GTK_WINDOW(gridcopy_dlg->dialog), gridcopy_dlg->x_repeats_entry);
			gtk_entry_select_region( GTK_ENTRY(gridcopy_dlg->x_repeats_entry), 0, 
									 GTK_ENTRY(gridcopy_dlg->x_repeats_entry)->text_length);
		}
		/* ե x_repeats_entry  Enter ʤե y_repeats_entry ˰ܤ */
		else if (GTK_WIDGET(gridcopy_dlg->x_repeats_entry) == GTK_WINDOW(gridcopy_dlg->dialog)->focus_widget) {
			gtk_window_set_focus(GTK_WINDOW(gridcopy_dlg->dialog), gridcopy_dlg->y_repeats_entry);
			gtk_entry_select_region( GTK_ENTRY(gridcopy_dlg->y_repeats_entry), 0, 
									 GTK_ENTRY(gridcopy_dlg->y_repeats_entry)->text_length);
		}
		/* ե y_repeats_entry  Enter ʤ齪 */
		else if (GTK_WIDGET(gridcopy_dlg->y_repeats_entry) == GTK_WINDOW(gridcopy_dlg->dialog)->focus_widget) {
			gridcopy_dlg_ok_pushed(widget, gridcopy_dlg);
			gtk_main_quit();
		}
	}
	return TRUE; 
}



/* -------------------------------------------------------------------
 * ԡڰư/ʣ̡
 * 
 */
gint GridCopyDialog(GRIDCOPY_DLG *gridcopy_dlg)
{
	char str[256];

//	GtkWidget *dialog;
	GtkWidget *main_vbox;
		GtkWidget *hbox;
			GtkWidget *label_vbox;
				GtkWidget *null_label;
				GtkWidget *pitch_label;
				GtkWidget *repeats_label;
			GtkWidget *x_entry_vbox;
				GtkWidget *x_label;
//				GtkWidget *x_pitch_entry;
//				GtkWidget *x_repeats_entry;
			GtkWidget *y_entry_vbox;
				GtkWidget *y_label;
//				GtkWidget *y_pitch_entry;
//				GtkWidget *y_repeats_entry;
		GtkWidget *separator;
		GtkWidget *action_hbox;
			GtkWidget *cancel_buttun;
			GtkWidget *ok_buttun;


	/* (gridcopy_dlg->dialog) */
	gridcopy_dlg->dialog = gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_window_set_position(GTK_WINDOW(gridcopy_dlg->dialog), GTK_WIN_POS_CENTER);
	gtk_window_set_title(GTK_WINDOW(gridcopy_dlg->dialog),  _("Procession Copy Setting") );
	gtk_signal_connect( GTK_OBJECT(gridcopy_dlg->dialog), "key_press_event",
						GTK_SIGNAL_FUNC(gridcopy_dlg_key_press_event), gridcopy_dlg);



	/* ˤޤѥå󥰥ܥå(main_vbox) */
	main_vbox = gtk_vbox_new(0, 5);
	gtk_container_add(GTK_CONTAINER(gridcopy_dlg->dialog), main_vbox);
	gtk_container_border_width(GTK_CONTAINER(gridcopy_dlg->dialog), 5);
	gtk_widget_show(main_vbox);

	/* -----------------------------------------------------
	 * ѥå󥰥ܥå(main_vbox) 
	 * ѥå󥰥ܥå(hbox & action_hbox) 
	 * Ǽ
	 */
	/* ѥå󥰥ܥå(hbox) */
	hbox = gtk_hbox_new(FALSE, 2);
	gtk_box_pack_start( (GtkBox *)GTK_BOX(main_vbox), 
						hbox, TRUE, TRUE, 0);
	gtk_widget_show(hbox);

	/* ѥ졼(separator) */
	separator = gtk_hseparator_new();
	gtk_box_pack_start( GTK_BOX(main_vbox), separator, TRUE, TRUE, 0);
	gtk_widget_show(separator);

	/* ѥå󥰥ܥå(action_hbox) */
	action_hbox = gtk_hbox_new(FALSE, 2);
	gtk_box_pack_start( GTK_BOX(main_vbox), 
						action_hbox, TRUE, TRUE, 0);
	gtk_widget_show(action_hbox);


		/* -----------------------------------------------------
		 * ѥå󥰥ܥå(hbox) 
		 * ѥå󥰥ܥå(label_vbox & entry_vbox) 
		 * Ǽ
		 */
		/* ѥå󥰥ܥå(label_vbox) */
		label_vbox = gtk_vbox_new(FALSE, 2);
		gtk_box_pack_start( (GtkBox *)GTK_BOX(hbox), label_vbox, TRUE, TRUE, 0);
		gtk_widget_show(label_vbox);

		/* ѥå󥰥ܥå(x_entry_vbox) */
		x_entry_vbox = gtk_vbox_new(FALSE, 2);
		gtk_box_pack_start( (GtkBox *)GTK_BOX(hbox), x_entry_vbox, TRUE, TRUE, 0);
		gtk_widget_show(x_entry_vbox);

		/* ѥå󥰥ܥå(y_entry_vbox) */
		y_entry_vbox = gtk_vbox_new(FALSE, 2);
		gtk_box_pack_start( (GtkBox *)GTK_BOX(hbox), y_entry_vbox, TRUE, TRUE, 0);
		gtk_widget_show(y_entry_vbox);


			/* -----------------------------------------------------
			 * ѥå󥰥ܥå(label_vbox) 
			 * ٥(x_pitch_label & y_pitch_label & repeats_label) 
			 * Ǽ
			 */
			
			null_label = gtk_label_new("");
//			gtk_widget_set_usize (null_label, 80, 20);
			gtk_box_pack_start((GtkBox *)GTK_BOX(label_vbox), null_label, TRUE, TRUE, 0);
			gtk_widget_show(null_label);

			pitch_label = gtk_label_new( _("Pitch") );
//			gtk_widget_set_usize (pitch_label, 80, 20);
			gtk_box_pack_start((GtkBox *)GTK_BOX(label_vbox), pitch_label, TRUE, TRUE, 0);
			gtk_widget_show(pitch_label);

			repeats_label = gtk_label_new( _("Number of times") );
//			gtk_widget_set_usize (repeats_label, 80, 20);
			gtk_box_pack_start((GtkBox *)GTK_BOX(label_vbox), repeats_label, TRUE, TRUE, 0);
			gtk_widget_show(repeats_label);


			/* -----------------------------------------------------
			 * ѥå󥰥ܥå(x_entry_vbox) 
			 * å(x_label & gridcopy_dlg->x_pitch_entry & gridcopy_dlg->x_repeats_entry) 
			 * Ǽ
			 */
			/* ٥ */
			x_label = gtk_label_new( _("X") );
//			gtk_widget_set_usize (x_label, 150, 20);
			gtk_box_pack_start((GtkBox *)GTK_BOX(x_entry_vbox), x_label, TRUE, TRUE, 0);
			gtk_widget_show(x_label);

			/* ƥȥȥ꡼ */
			gridcopy_dlg->x_pitch_entry = gtk_entry_new();
//			gtk_widget_set_usize (gridcopy_dlg->x_pitch_entry, 150, 20);
			gtk_box_pack_start((GtkBox *)GTK_BOX(x_entry_vbox), gridcopy_dlg->x_pitch_entry, TRUE, TRUE, 1);
			/*  */
			FloatOut_n(str, gridcopy_dlg->x_pitch, 6, 0);
			gtk_entry_set_text(GTK_ENTRY(gridcopy_dlg->x_pitch_entry), str);
			//gtk_signal_connect (GTK_OBJECT(entry), "activate", GTK_SIGNAL_FUNC(entry_callback), NULL);
			gtk_widget_show(gridcopy_dlg->x_pitch_entry);


			/* ƥȥȥ꡼ */
			gridcopy_dlg->x_repeats_entry = gtk_entry_new();
//			gtk_widget_set_usize (gridcopy_dlg->x_repeats_entry, 150, 20);
			gtk_box_pack_start((GtkBox *)GTK_BOX(x_entry_vbox), gridcopy_dlg->x_repeats_entry, TRUE, TRUE, 1);
			/*  */
			sprintf(str, "%d", gridcopy_dlg->x_repeats);
			gtk_entry_set_text(GTK_ENTRY(gridcopy_dlg->x_repeats_entry), str);
			gtk_widget_show(gridcopy_dlg->x_repeats_entry);



			/* -----------------------------------------------------
			 * ѥå󥰥ܥå(y_entry_vbox) 
			 * å(y_label & gridcopy_dlg->y_pitch_entry & gridcopy_dlg->y_repeats_entry) 
			 * Ǽ
			 */
			/* ٥ */
			y_label = gtk_label_new( _("Y") );
//			gtk_widget_set_usize (y_label, 150, 20);
			gtk_box_pack_start((GtkBox *)GTK_BOX(y_entry_vbox), y_label, TRUE, TRUE, 0);
			gtk_widget_show(y_label);

			/* ƥȥȥ꡼ */
			gridcopy_dlg->y_pitch_entry = gtk_entry_new();
//			gtk_widget_set_usize (gridcopy_dlg->y_pitch_entry, 150, 20);
			gtk_box_pack_start((GtkBox *)GTK_BOX(y_entry_vbox), gridcopy_dlg->y_pitch_entry, TRUE, TRUE, 1);
			/*  */
			FloatOut_n(str, gridcopy_dlg->y_pitch, 6, 0);
			gtk_entry_set_text(GTK_ENTRY(gridcopy_dlg->y_pitch_entry), str);
			gtk_widget_show(gridcopy_dlg->y_pitch_entry);


			/* ƥȥȥ꡼ */
			gridcopy_dlg->y_repeats_entry = gtk_entry_new();
//			gtk_widget_set_usize (gridcopy_dlg->y_repeats_entry, 150, 20);
			gtk_box_pack_start((GtkBox *)GTK_BOX(y_entry_vbox), gridcopy_dlg->y_repeats_entry, TRUE, TRUE, 1);
			/*  */
			sprintf(str, "%d", gridcopy_dlg->y_repeats);
			gtk_entry_set_text(GTK_ENTRY(gridcopy_dlg->y_repeats_entry), str);
			gtk_widget_show(gridcopy_dlg->y_repeats_entry);



		/* -----------------------------------------------------
		 * ѥå󥰥ܥå(action_hbox) 
		 * ܥ(cancel_buttun & ok_buttun) 
		 * Ǽ
		 */
		/* CANCELܥ */
		cancel_buttun = gtk_button_new_with_label("CANCEL");
		gtk_widget_set_usize (cancel_buttun, 80, 20);
		gtk_box_pack_start((GtkBox *)GTK_BOX(action_hbox), cancel_buttun, TRUE, TRUE, 2);
		gtk_signal_connect( GTK_OBJECT(cancel_buttun), "clicked", GTK_SIGNAL_FUNC(gridcopy_dlg_cancel_pushed), gridcopy_dlg);
		gtk_signal_connect( GTK_OBJECT(cancel_buttun), "clicked", GTK_SIGNAL_FUNC(gtk_main_quit), NULL);
		gtk_widget_show(cancel_buttun);

		/* OKܥ */
		ok_buttun = gtk_button_new_with_label("OK");
		gtk_widget_set_usize (ok_buttun, 80, 20);
		gtk_box_pack_start((GtkBox *)GTK_BOX(action_hbox), ok_buttun, TRUE, TRUE, 2);
		gtk_signal_connect(GTK_OBJECT(ok_buttun), "clicked", GTK_SIGNAL_FUNC(gridcopy_dlg_ok_pushed), gridcopy_dlg);
		gtk_signal_connect(GTK_OBJECT(ok_buttun), "clicked", GTK_SIGNAL_FUNC(gtk_main_quit), NULL);
	//	  GTK_WIDGET_SET_FLAGS(ok_buttun, GTK_CAN_DEFAULT);
	//	  gtk_widget_grab_default(ok_buttun);
		gtk_widget_show(ok_buttun);


	/*  ե x_pitch_entry  */
	gtk_window_set_focus(GTK_WINDOW(gridcopy_dlg->dialog), gridcopy_dlg->x_pitch_entry);
	//GTK_WINDOW(gridcopy_dlg->dialog)->focus_widget = GTK_WIDGET(gridcopy_dlg->x_pitch_entry);
	gtk_entry_select_region( GTK_ENTRY(gridcopy_dlg->x_pitch_entry), 0, 
							 GTK_ENTRY(gridcopy_dlg->x_pitch_entry)->text_length);


	/* ̤ɽ */
	gtk_window_set_modal(GTK_WINDOW(gridcopy_dlg->dialog), TRUE);
	/* ᥤ󥦥ɥǤʤ褦 */
	gtk_window_set_transient_for(GTK_WINDOW(gridcopy_dlg->dialog), GTK_WINDOW(gridcopy_dlg->parent));


	/* Ļ֤ */
	gtk_widget_show(gridcopy_dlg->dialog);
	/* ᥤ󥤥٥ȥ롼 */
	gtk_main();
	gtk_widget_destroy(gridcopy_dlg->dialog);
	return 0; 
}





/* ====================================================================
 * ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : GridCopyDlg.c
 * ====================================================================
 */
