/* ====================================================================
 * ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : List_Ellipse.c
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2003 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2003/03/25
 *    Last                 : 2003/03/25
 * ====================================================================
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <gtk/gtk.h>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "MemoryLeak.h"
#include "types.h"
#include "List_Undo.h"
#include "Trace.h"

#define _LIST_ELLIPSE_
#include "List_Ellipse.h"





/* ELLIPSE Data ν */
int init_ellipse(ELLIPSE *ellipse)
{
	ellipse->layer = 0;
	ellipse->color = 0xffffff;
	ellipse->style = 0;
	ellipse->cx = 0;
	ellipse->cy = 0;
	ellipse->dx = 0;
	ellipse->dy = 0;
	ellipse->k = 1;
	ellipse->k = 0;
	ellipse->k = 360;
	return 1;
}





/* -------------------------------------------------------------------
 * ΰݺѤߤ ELLIPSE Data ꥹȤκǽɲ
 * 
 */
ELLIPSE_LIST *r_ellipse_list_add_first(ELLIPSE *add_ellipse, ELLIPSE_LIST_INFO *p_ellipse_list_info)
{
	ELLIPSE_LIST *p;


	/* ǡ (LIST) 񤭹िΰݤ */
	p_ellipse_list = (ELLIPSE_LIST *)xmalloc(sizeof(ELLIPSE_LIST));

	/* ݤΰ˥ǡ (ellipse) 񤭹 */
	p_ellipse_list->ellipse = add_ellipse;
	p_ellipse_list->next = NULL;

	/* -----------------------------------------------------
	 * head & tail ξ NULL ΤȤϡĤǡʤ 
	 */
	if (p_ellipse_list_info->head == NULL && p_ellipse_list_info->tail == NULL) {
		p_ellipse_list_info->head = p_ellipse_list;
		p_ellipse_list_info->tail = p_ellipse_list;
	}

	/* -----------------------------------------------------
	 * ǡİʾ夢
	 */
	else {
		p = p_ellipse_list_info->head;
		p_ellipse_list_info->head = p_ellipse_list;
		p_ellipse_list->next = p;
	}

	return p_ellipse_list_info->head;
}





/* -------------------------------------------------------------------
 * ELLIPSE Data ꥹȤκǽɲ
 * 
 */
ELLIPSE_LIST *ellipse_list_add_first(ELLIPSE *add_ellipse, ELLIPSE_LIST_INFO *p_ellipse_list_info)
{
	ELLIPSE_LIST *p;


	/* ǡ (LIST) 񤭹िΰݤ */
	p_ellipse_list = (ELLIPSE_LIST *)xmalloc(sizeof(ELLIPSE_LIST));
	/* ǡ (ellipse) 񤭹िΰݤ */
	p_ellipse_list->ellipse = (ELLIPSE *)xmalloc(sizeof(ELLIPSE));

	/* ݤΰ˥ǡ (ellipse) 񤭹 */
	*p_ellipse_list->ellipse = *add_ellipse;
	p_ellipse_list->next = NULL;

	/* -----------------------------------------------------
	 * head & tail ξ NULL ΤȤϡĤǡʤ 
	 */
	if (p_ellipse_list_info->head == NULL && p_ellipse_list_info->tail == NULL) {
		p_ellipse_list_info->head = p_ellipse_list;
		p_ellipse_list_info->tail = p_ellipse_list;
	}

	/* -----------------------------------------------------
	 * ǡİʾ夢
	 */
	else {
		p = p_ellipse_list_info->head;
		p_ellipse_list_info->head = p_ellipse_list;
		p_ellipse_list->next = p;
	}

	return p_ellipse_list_info->head;
}





/* -------------------------------------------------------------------
 * ELLIPSE Data ꥹȤκǽɲäơ Undo Baffer ˽
 *	
 */
ELLIPSE_LIST *ellipse_list_add_first_with_undo(ELLIPSE *add_ellipse, ELLIPSE_LIST_INFO *p_ellipse_list_info)
{
	ELLIPSE_LIST *p;
	ELLIPSE ellipse = {0,0,0, 0,0,0,0,0,0,0};

	DIAGRAM diagram;
	LPDIAGRAM lpdiagram;


	/* ǡ (LIST) 񤭹िΰݤ */
	p_ellipse_list = (ELLIPSE_LIST *)xmalloc(sizeof(ELLIPSE_LIST));
	/* ǡ (ellipse) 񤭹िΰݤ */
	p_ellipse_list->ellipse = (ELLIPSE *)xmalloc(sizeof(ELLIPSE));

	/* ݤΰ˥ǡ (ellipse) 񤭹 */
	*p_ellipse_list->ellipse = *add_ellipse;
	p_ellipse_list->next = NULL;

	/* -----------------------------------------------------
	 * head & tail ξ NULL ΤȤϡĤǡʤ 
	 */
	if (p_ellipse_list_info->head == NULL && p_ellipse_list_info->tail == NULL) {
		p_ellipse_list_info->head = p_ellipse_list;
		p_ellipse_list_info->tail = p_ellipse_list;
	}

	/* -----------------------------------------------------
	 * ǡİʾ夢
	 */
	else {
		p = p_ellipse_list_info->head;
		p_ellipse_list_info->head = p_ellipse_list;
		p_ellipse_list->next = p;
	}

	lpdiagram.ellipse_point = p_ellipse_list_info->head->ellipse;
	diagram.ellipse = ellipse;

	/* Undo Buffa Write */
	undo_list_add_first(ELLIPSE_NEW, lpdiagram, diagram);
	return p_ellipse_list_info->head;
}





/* -------------------------------------------------------------------
 * ELLIPSE Data ꥹȤκǸɲ
 * 
 */
ELLIPSE_LIST *ellipse_list_add_last(ELLIPSE *add_ellipse, ELLIPSE_LIST_INFO *p_ellipse_list_info)
{
	ELLIPSE_LIST *p;


	/* ǡ (LIST) 񤭹िΰݤ */
	p_ellipse_list = (ELLIPSE_LIST *)xmalloc(sizeof(ELLIPSE_LIST));
	/* ǡ (ellipse) 񤭹िΰݤ */
	p_ellipse_list->ellipse = (ELLIPSE *)xmalloc(sizeof(ELLIPSE));

	/* ݤΰ˥ǡ (ellipse) 񤭹 */
	*p_ellipse_list->ellipse = *add_ellipse;
	p_ellipse_list->next = NULL;

	/* -----------------------------------------------------
	 * head & tail ξ NULL ΤȤϡĤǡʤ 
	 */
	if (p_ellipse_list_info->head == NULL && p_ellipse_list_info->tail == NULL) {
		p_ellipse_list_info->head = p_ellipse_list;
		p_ellipse_list_info->tail = p_ellipse_list;
	}

	/* -----------------------------------------------------
	 * head = tail  NULL ǤϤʤȤϡĤǡ
	 */
	else if (p_ellipse_list_info->head != NULL 
				&& p_ellipse_list_info->tail != NULL 
					&& p_ellipse_list_info->head == p_ellipse_list_info->tail) {
		p_ellipse_list_info->head->next = p_ellipse_list;
		p_ellipse_list_info->tail = p_ellipse_list;
	}

	/* -----------------------------------------------------
	 * ǡİʾ夢
	 */
	else {
		p = p_ellipse_list_info->tail;
		p_ellipse_list_info->tail = p_ellipse_list;
		p->next = p_ellipse_list_info->tail;
	}

	/* ɥХåե˽ */
//	undo_list_add_first(11, p_ellipse_list_info->tail, NULL);
	return p_ellipse_list_info->tail;
}





/* -------------------------------------------------------------------
 * ELLIPSE Data ꥹȤκǸɲá Undo Baffer ˽
 *	
 */
ELLIPSE_LIST *ellipse_list_add_last_with_undo(ELLIPSE *add_ellipse, ELLIPSE_LIST_INFO *p_ellipse_list_info)
{
	ELLIPSE_LIST *p;
	ELLIPSE ellipse = {0,0,0, 0,0,0,0,0,0,0};

	DIAGRAM diagram;
	LPDIAGRAM lpdiagram;


	/* ǡ (LIST) 񤭹िΰݤ */
	p_ellipse_list = (ELLIPSE_LIST *)xmalloc(sizeof(ELLIPSE_LIST));
	/* ǡ (ellipse) 񤭹िΰݤ */
	p_ellipse_list->ellipse = (ELLIPSE *)xmalloc(sizeof(ELLIPSE));

	/* ݤΰ˥ǡ (ellipse) 񤭹 */
	*p_ellipse_list->ellipse = *add_ellipse;
	p_ellipse_list->next = NULL;

	/* -----------------------------------------------------
	 * head & tail ξ NULL ΤȤϡĤǡʤ 
	 */
	if (p_ellipse_list_info->head == NULL && p_ellipse_list_info->tail == NULL) {
		p_ellipse_list_info->head = p_ellipse_list;
		p_ellipse_list_info->tail = p_ellipse_list;
	}

	/* -----------------------------------------------------
	 * head = tail  NULL ǤϤʤȤϡĤǡ
	 */
	else if (p_ellipse_list_info->head != NULL 
				&& p_ellipse_list_info->tail != NULL 
					&& p_ellipse_list_info->head == p_ellipse_list_info->tail) {
		p_ellipse_list_info->head->next = p_ellipse_list;
		p_ellipse_list_info->tail = p_ellipse_list;
	}

	/* -----------------------------------------------------
	 * ǡİʾ夢
	 */
	else {
		p = p_ellipse_list_info->tail;
		p_ellipse_list_info->tail = p_ellipse_list;
		p->next = p_ellipse_list_info->tail;
	}

	lpdiagram.ellipse_point = p_ellipse_list_info->tail->ellipse;
	diagram.ellipse = ellipse;

	/* Undo Buffa Write */
	undo_list_add_first(ELLIPSE_NEW, lpdiagram, diagram);
	return p_ellipse_list_info->tail;
}





/* -------------------------------------------------------------------
 * ELLIPSE Data κǽ (κǤϤʤ)
 * 
 */
int ellipse_list_delete(ELLIPSE_LIST *del_List, ELLIPSE_LIST_INFO *p_ellipse_list_info)
{
	ELLIPSE_LIST *p = NULL;
	ELLIPSE_LIST *pb = NULL;


	/* ǡƬǣĤ  */
	if (del_List == p_ellipse_list_info->head && del_List->next == NULL) {
		p_ellipse_list_info->head = NULL;
		p_ellipse_list_info->tail = NULL;
	}
	/* ǡƬǣİʾ  */
	else if (del_List == p_ellipse_list_info->head && del_List->next != NULL) {
		p_ellipse_list_info->head = p_ellipse_list_info->head->next;
	}
	else {
		/* -------------------------------------------
		 * ݥ󥿤ΥǡΤꤿΤǡ
		 * head (ꥹȤƬ) ݥ󥿤
		 * ĤޤǷ֤Υǡõ
		 */
		p = p_ellipse_list_info->head;
		/* -------------------------------------------
		 * ǸޤǸĤʤ硢 p  NULL  
		 * äƥ롼פȴ롣
		 */
		while(p != NULL && p != del_List) {
			pb = p;			/* ΥǡΥݥ󥿤Ȥ¸Ƥ */
			p = p->next;	/* ݥ󥿤򼡤Υǡ˰ܤ */
		}

		if(p != NULL){
			/* ǸΥǡ */
			if (del_List == p_ellipse_list_info->tail) {
				pb->next = NULL;
				p_ellipse_list_info->tail = pb;
			}
			/* ֤Υǡ */
			else if (del_List != p_ellipse_list_info->head && del_List != p_ellipse_list_info->tail) {
				pb->next = p->next;
			}
		}
		else {
			g_print("List_ellipse.c : ellipse_list_delete() : There is not data of structure data ELLIPSE.\n");
			return 0;
		}
	}
	xfree(del_List);
//	StartData = p_ellipse_list_info->head;
	return 1;
}





/* -------------------------------------------------------------------
 * ELLIPSE Data κǽ (κǤϤʤUndo Buffer ذܤ)
 * 
 */
int ellipse_list_delete_Undo(ELLIPSE_LIST *del_List, ELLIPSE_LIST_INFO *p_ellipse_list_info)
{
	ELLIPSE_LIST *p = NULL;
	ELLIPSE_LIST *pb = NULL;

	DIAGRAM diagram;
	LPDIAGRAM lpdiagram;


	/* ǡƬǣĤ  */
	if (del_List == p_ellipse_list_info->head && del_List->next == NULL) {
		p_ellipse_list_info->head = NULL;
		p_ellipse_list_info->tail = NULL;
	}
	/* ǡƬǣİʾ  */
	else if (del_List == p_ellipse_list_info->head && del_List->next != NULL) {
		p_ellipse_list_info->head = p_ellipse_list_info->head->next;
	}
	else {
		/* -------------------------------------------
		 * ݥ󥿤ΥǡΤꤿΤǡ
		 * head (ꥹȤƬ) ݥ󥿤
		 * ĤޤǷ֤Υǡõ
		 */
		p = p_ellipse_list_info->head;
		/* -------------------------------------------
		 * ǸޤǸĤʤ硢 p  NULL  
		 * äƥ롼פȴ롣
		 */
		while(p != NULL && p != del_List) {
			pb = p;			/* ΥǡΥݥ󥿤Ȥ¸Ƥ */
			p = p->next;	/* ݥ󥿤򼡤Υǡ˰ܤ */
		}

		if(p != NULL){
			/* ǸΥǡ */
			if (del_List == p_ellipse_list_info->tail) {
				pb->next = NULL;
				p_ellipse_list_info->tail = pb;
			}
			/* ֤Υǡ */
			else if (del_List != p_ellipse_list_info->head && del_List != p_ellipse_list_info->tail) {
				pb->next = p->next;
			}
		}
		else {
			g_print("List_ellipse.c : ellipse_list_delete() : There is not data of structure data ELLIPSE.\n");
			return 0;
		}
	}

	lpdiagram.ellipse_point = del_List->ellipse;
	diagram.ellipse = *del_List->ellipse;

	undo_list_add_first(ELLIPSE_DEL, lpdiagram, diagram);
	xfree(del_List);
//	StartData = p_ellipse_list_info->head;
	return 1;
}





/* -------------------------------------------------------------------
 * ELLIPSE Υݥ󥿤Υǡ Undo ХåեԽˤơ
 * ξ˿ǡ롣
 *	
 * ͡ΥǡΥɥ쥹
 */
ELLIPSE_LIST *ellipse_list_edit(ELLIPSE_LIST *point, ELLIPSE *change_ellipse, ELLIPSE_LIST_INFO *p_ellipse_list_info)
{
	/* ǡ (LIST) 񤭹िΰݤ */
	p_ellipse_list = (ELLIPSE_LIST *)xmalloc(sizeof(ELLIPSE_LIST));

	/* ǡ (ellipse) 񤭹िΰݤ */
	p_ellipse_list->ellipse = (ELLIPSE *)xmalloc(sizeof(ELLIPSE));

	/* ݤΰѹΥǡ (ellipse) 񤭹 */
	*p_ellipse_list->ellipse = *point->ellipse;
	p_ellipse_list->next = point;

	/* ѹǡ񤭹 */
	*point->ellipse = *change_ellipse;

//	undo_list_add_first(13, p_ellipse_list, NULL);
	return p_ellipse_list;
}





/* -------------------------------------------------------------------
 * ELLIPSE Υݥ󥿤Υǡ Undo ХåեԽˤơ
 * ξ˿ǡ졢Undo Baffer ˽
 *	
 * ͡ΥǡΥɥ쥹
 */
ELLIPSE_LIST *ellipse_list_edit_with_undo(ELLIPSE_LIST *point, ELLIPSE *change_ellipse, ELLIPSE_LIST_INFO *p_ellipse_list_info)
{
	ELLIPSE ellipse = {0,0,0, 0,0,0,0,0,0,0};

	DIAGRAM diagram;
	LPDIAGRAM lpdiagram;


	/* ݤΰѹΥǡ (ELLIPSE) 񤭹 */
	ellipse = *point->ellipse;

	/* ѹǡ񤭹 */
	*point->ellipse = *change_ellipse;

	lpdiagram.ellipse_point = point->ellipse;
	diagram.ellipse = ellipse;

	undo_list_add_first(ELLIPSE_EDIT, lpdiagram, diagram);
	return point;
}





/* -------------------------------------------------------------------
 *	ꥹȤĴ٤
 */
long ellipse_list_num(ELLIPSE_LIST_INFO *p_ellipse_list_info)
{
	ELLIPSE_LIST *p;
	long i;

	p = p_ellipse_list_info->head;
	i = 0;
	/* -------------------------------------------
	 * ǸޤǸĤʤ硢 p  NULL  
	 * äƥ롼פȴ롣
	 */
	while(p != NULL) {
		i++;
		p = p->next;	/* ݥ󥿤򼡤Υǡ˰ܤ */
	}
	return i;
}





/* -------------------------------------------------------------------
 * n ܤΥǡθ
 * 
 */
ELLIPSE_LIST *ellipse_search_num(long search_number, ELLIPSE_LIST_INFO *p_ellipse_list_info)
{
	ELLIPSE_LIST *p;
	long i;


	p = p_ellipse_list_info->head;
	i = 1;
	/*	*/
	while( p != NULL && i != search_number) {
		i++;
		p = p->next;
	}

	/* n ܤΥǡΥɥ쥹֤ */
	if (p != NULL) {
		return p;
	}
	/* ޤǥǡʤ */
	else {
		return NULL;
	}
}





/* -------------------------------------------------------------------
 * ELLIPSE Υǡθ
 * 
 *   ELLIPSE_LIST
 */
ELLIPSE_LIST *ellipse_search_ellipse(ELLIPSE *p_ellipse, ELLIPSE_LIST_INFO *p_ellipse_list_info)
{
	ELLIPSE_LIST *p;


	p = p_ellipse_list_info->head;
	/*	*/
	while( p != NULL && p->ellipse != p_ellipse) {
		p = p->next;
	}

	/* p_ellipse ΥǡΥɥ쥹֤ */
	if (p != NULL) {
		return p;
	}
	/* ޤǥǡʤ */
	else {
		return NULL;
	}
}





/* -------------------------------------------------------------------
 * ELLIPSE Υǡθ
 * 
 *   long
 */
long ellipse_search_ellipse_to_num(ELLIPSE *p_ellipse, ELLIPSE_LIST_INFO *p_ellipse_list_info)
{
	ELLIPSE_LIST *p;
	long i;

	i = 1;
	p = p_ellipse_list_info->head;
	/*	*/
	while( p != NULL && p->ellipse != p_ellipse) {
		p = p->next;
		i++;
	}

	/* p_ellipse ΥǡΥɥ쥹֤ */
	if (p != NULL) {
		return i;
	}
	/* ޤǥǡʤ */
	else {
		return 0;
	}
}





/* -------------------------------------------------------------------
 *	ELLIPSE Data ꥹȤ
 */
int ellipse_list_free(ELLIPSE_LIST *del_List, ELLIPSE_LIST_INFO *p_ellipse_list_info)
{
	ELLIPSE_LIST *p = NULL;
	ELLIPSE_LIST *pb = NULL;


	if (del_List == EllipseStartData) {
		EllipseStartData = NULL;
		//g_print ("List_Ellipse.c : ellipse_list_free() : del_List = EllipseStartData\n");
	}


	/* ǡƬǣĤ  */
	if (del_List == p_ellipse_list_info->head && del_List->next == NULL) {
		p_ellipse_list_info->head = NULL;
		p_ellipse_list_info->tail = NULL;
	}
	/* ǡƬǣİʾ  */
	else if (del_List == p_ellipse_list_info->head && del_List->next != NULL) {
		p_ellipse_list_info->head = p_ellipse_list_info->head->next;
	}
	else {
		/* -------------------------------------------
		 * ݥ󥿤ΥǡΤꤿΤǡ
		 * head (ꥹȤƬ) ݥ󥿤
		 * ĤޤǷ֤Υǡõ
		 */
		p = p_ellipse_list_info->head;
		/* -------------------------------------------
		 * ǸޤǸĤʤ硢 p  NULL  
		 * äƥ롼פȴ롣
		 */
		while(p != NULL && p != del_List) {
			pb = p;			/* ΥǡΥݥ󥿤Ȥ¸Ƥ */
			p = p->next;	/* ݥ󥿤򼡤Υǡ˰ܤ */
		}


		if(p != NULL){
			/* ǸΥǡ */
			if (del_List == p_ellipse_list_info->tail) {
				pb->next = NULL;
				p_ellipse_list_info->tail = pb;
			}
			/* ֤Υǡ */
			else if (del_List != p_ellipse_list_info->head && del_List != p_ellipse_list_info->tail) {
				pb->next = p->next;
			}
		}
		else {
			g_print("List_ellipse.c : ellipse_list_free() : There is not data of structure data ELLIPSE.\n");
			return 0;
		}
	}
	xfree(del_List->ellipse);
	xfree(del_List);
	return 1;
}





/* -------------------------------------------------------------------
 *	ꥹȤ
 */
void ellipse_list_all_free(ELLIPSE_LIST_INFO *p_ellipse_list_info)
{
	while(p_ellipse_list_info->head != NULL) {
		if (ellipse_list_free(p_ellipse_list_info->head, p_ellipse_list_info) == 0) {
			g_print("List_ellipse.c : ellipse_list_all_free() : ellipse_list_free() ǥ顼\n");
			g_print("%s : %d : ellipse_list_all_free() : ERROR\n", __FILE__, __LINE__);
		}
	}
}





void ellipse_list_print(ELLIPSE_LIST_INFO *p_ellipse_list_info)
{
	ELLIPSE_LIST *p;
	int i = 0;

	g_print("----- ELLIPSE ꥹȤɽ -----\n");
	p = p_ellipse_list_info->head;
	while (p != NULL) {
		i++;
		g_print("%d(0x%x) : layer[%d] : color[%d] : style[0x%x]\n", 
					i, (int)p->ellipse, p->ellipse->layer, (int)p->ellipse->color, p->ellipse->style);
		g_print("    濴(%f,%f) Ĺΰ(%f,%f) [ûΡ %f] [ϳ %f] [λ %f]\n", 
					p->ellipse->cx, p->ellipse->cy, p->ellipse->dx, p->ellipse->dy, 
					p->ellipse->k, p->ellipse->sa, p->ellipse->ea);
		p = p->next;
	}
	g_print("-----------------------------\n");
}





/* ====================================================================
 * ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : List_Ellipse.c
 * ====================================================================
 */
