/* ====================================================================
 * ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : List_Undo.c
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2003 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2001/01/16
 *    Last                 : 2003/04/16
 * ====================================================================
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <gtk/gtk.h>
#include <stdio.h>
#include <stdlib.h>
#include "MemoryLeak.h"
#include "List_cad.h"
#include "List_Dimension.h"
#include "List_PolyLine.h"
#include "List_Ellipse.h"
#include "List_Vertex.h"
#include "List_insert.h"
#include "List_Block.h"
#include "toolbar.h"
#define _LIST_UNDO_
#include "List_Undo.h"
#include "List_Select.h"
#include "etc.h"





/* -------------------------------------------------------------------
 * Undo_index 򥤥󥯥Ȥ
 * -------------------------------------------------------------------
 * Undo/Redo ΤȤϡ޷񤯤Τ
 * ʹߤ Redo Ϻ
 *	
 * -------------------------------------------------------------------
 */
void undo_index_plus(void)
{
	/* Undo/Redo ǿ޷򤷤Ȥ */
	if (Undo_index + 1 != Undo_Now) {
		/* Undo_Now ʹߤ index  Undo Buffer  */
		Redo_Delete();
		Undo_index = Undo_Now - 1;
	}

	Undo_index++;
	Undo_Now = Undo_index + 1;

	undo_buttun(1);
	redo_buttun(0);
}



/* -------------------------------------------------------------------
 * Undo  CAD or Dimension  Data ꥹȤκǽɲ
 * -------------------------------------------------------------------
 * ѿ Undo_index ϤδؿγǤ餫ꤷƤ
 *	
 * type : 11 : CAD_NEW  : CAD Data οεϿ
 *		: 12 : CAD_DEL  : CAD Data κεϿ
 *		: 13 : CAD_EDIT : CAD Data ԽεϿ
 *  : 21 : DIMENSION_NEW  : Dimension Data οεϿ
 *		: 22 : DIMENSION_DEL  : Dimension Data κεϿ
 *		: 23 : DIMENSION_EDIT : Dimension Data ԽεϿ
 * -------------------------------------------------------------------
 */
int undo_list_add_first(int type, LPDIAGRAM diagram_point, DIAGRAM diagram)
{
	UNDO_LIST *p;
//	int i;


	/* ǡ (LIST) 񤭹िΰݤ */
	p_undo_list = (UNDO_LIST *)xmalloc(sizeof(UNDO_LIST));

	/* -----------------------------------------------------
	 * ΤȤϺǡؤɥ쥹
	 * 
	 * ΤȤϺǡؤɥ쥹
	 * (ºݤ˺˥ǡ Undo Buffer ˰ܤ)
	 * 
	 * ԽΤȤϡΥǡѹ˿ǡ
	 * ãĥǡꥹȤ夨롣
	 * ơΥǡ򥢥ɥꥹȤ롣
	 * κݡnext ˤϿǡΥɥ쥹Ƥ
	 */

	/* ݤΰ˥ǡ (undo) 񤭹 */
	p_undo_list->type = type;
	p_undo_list->index = Undo_index;
	p_undo_list->next = NULL;


	/*  */
	if (type == CAD_NEW) {
		p_undo_list->diagram_point.cad_point = diagram_point.cad_point;
		p_undo_list->diagram.cad = diagram.cad;
	}
	else if (type == DIMENSION_NEW) {
		p_undo_list->diagram_point.dimension_point = diagram_point.dimension_point;
		p_undo_list->diagram.dimension = diagram.dimension;
	}
	else if (type == POLYLINE_NEW) {
		p_undo_list->diagram_point.polyline_point = diagram_point.polyline_point;
		p_undo_list->diagram.polyline = diagram.polyline;
	}
	else if (type == ELLIPSE_NEW) {
		p_undo_list->diagram_point.ellipse_point = diagram_point.ellipse_point;
		p_undo_list->diagram.ellipse = diagram.ellipse;
	}
	else if (type == INSERT_NEW) {
		p_undo_list->diagram_point.insert_point = diagram_point.insert_point;
		p_undo_list->diagram.insert = diagram.insert;
	}
	else if (type == BLOCK_NEW) {
		p_undo_list->diagram_point.block_point = diagram_point.block_point;
		p_undo_list->diagram.block = diagram.block;
	}


	/*  */
	else if (type == CAD_DEL) {
		p_undo_list->diagram_point.cad_point = diagram_point.cad_point;
		p_undo_list->diagram.cad = diagram.cad;
	}
	else if (type == DIMENSION_DEL) {
		p_undo_list->diagram_point.dimension_point = diagram_point.dimension_point;
		p_undo_list->diagram.dimension = diagram.dimension;
	}
	else if (type == POLYLINE_DEL) {
		p_undo_list->diagram_point.polyline_point = diagram_point.polyline_point;
		p_undo_list->diagram.polyline = diagram.polyline;
	}
	else if (type == ELLIPSE_DEL) {
		p_undo_list->diagram_point.ellipse_point = diagram_point.ellipse_point;
		p_undo_list->diagram.ellipse = diagram.ellipse;
	}
	else if (type == INSERT_DEL) {
		p_undo_list->diagram_point.insert_point = diagram_point.insert_point;
		p_undo_list->diagram.insert = diagram.insert;
	}
	else if (type == BLOCK_DEL) {
		p_undo_list->diagram_point.block_point = diagram_point.block_point;
		p_undo_list->diagram.block = diagram.block;
	}


	/* Խ */
	else if (type == CAD_EDIT) {
		p_undo_list->diagram_point.cad_point = diagram_point.cad_point;
		p_undo_list->diagram.cad = diagram.cad;
	}
	else if (type == DIMENSION_EDIT) {
		p_undo_list->diagram_point.dimension_point = diagram_point.dimension_point;
		p_undo_list->diagram.dimension = diagram.dimension;
	}
	else if (type == POLYLINE_EDIT) {
		p_undo_list->diagram_point.polyline_point = diagram_point.polyline_point;
		p_undo_list->diagram.polyline = diagram.polyline;
	}
	else if (type == ELLIPSE_EDIT) {
		p_undo_list->diagram_point.ellipse_point = diagram_point.ellipse_point;
		p_undo_list->diagram.ellipse = diagram.ellipse;
	}
	else if (type == INSERT_EDIT) {
		p_undo_list->diagram_point.insert_point = diagram_point.insert_point;
		p_undo_list->diagram.insert = diagram.insert;
	}
	else if (type == BLOCK_EDIT) {
		p_undo_list->diagram_point.block_point = diagram_point.block_point;
		p_undo_list->diagram.block = diagram.block;
	}


	else {
		xfree(p_undo_list);
		return 0;
	}


	/* -----------------------------------------------------
	 * head & tail ξ NULL ΤȤϡĤǡʤ 
	 */
	if (undo_list_info.head == NULL && undo_list_info.tail == NULL) {
		undo_list_info.head = p_undo_list;
		undo_list_info.tail = p_undo_list;
	}
	/* -----------------------------------------------------
	 * ǡİʾ夢
	 */
	else {
		p = undo_list_info.head;
		undo_list_info.head = p_undo_list;
		p_undo_list->next = p;
	}
	return 0;
}





/* -------------------------------------------------------------------
 * Redo 
 * -------------------------------------------------------------------
 * Undo/Redo ΤȤϡ޷񤯤Τ
 * (Undo_Now)ʹߤ Redo Ϻ
 *	
 * -------------------------------------------------------------------
 */
void Redo_Delete(void)
{
	UNDO_LIST *p;


	p = search_list_undo_end(Undo_Now);
	if (p == NULL) {
		return;
	}

	while (undo_list_info.head != NULL && undo_list_info.head->index >= Undo_Now) {
		if (undo_list_free(undo_list_info.head) == 0) {
			break;
		}
	}
}





/* -------------------------------------------------------------------
 *  index Ʊǽ Undo_index õ, Undo Buffer Υݥ󥿤֤	
 * 
 */
UNDO_LIST *search_list_undo_start(long index)
{
	UNDO_LIST *p;

	p = undo_list_info.head;
	/* -------------------------------------------
	 * ǸޤǸĤʤ硢 p  NULL  
	 * äƥ롼פȴ롣
	 */
	while( p != NULL && p->index > index ) {
		p = p->next;	/* ݥ󥿤򼡤Υǡ˰ܤ */
	}

	if (p != NULL && p->next != NULL) {
		return p;
	}
	else {
		return NULL;
	}
}





/* -------------------------------------------------------------------
 *  index ƱǸ Undo_index õ, Undo Buffer Υݥ󥿤֤	
 * 
 */
UNDO_LIST *search_list_undo_end(long index)
{
	UNDO_LIST *p = NULL;
	UNDO_LIST *pb = NULL;


	p = undo_list_info.head;
	/* -------------------------------------------
	 * ǸޤǸĤʤ硢 p  NULL  
	 * äƥ롼פȴ롣
	 */
	while( p != NULL && p->index >= index ) {
		pb = p;
		p = p->next;	/* ݥ󥿤򼡤Υǡ˰ܤ */
	}

	if (pb != NULL) {
		return pb;
	}
	else {
		return NULL;
	}
}





/* -------------------------------------------------------------------
 * Undo
 * -------------------------------------------------------------------
 * ɥ¹
 *	
 *	 ɥϡޤ Undo_Now  -1 ˤơʣޤϣĤ Undo_Now 
 * Ʊֹ index Фƽ¹Ԥ롣
 *	 ĤΥǡФơºݤν򤹤ΤϡUndoRedo() ؿǤϡ
 * ɥǽؿƱ
 *	 ɥϡindex Ǥ⡢夫äǡ򤹤롣(ɥϡ)
 * -------------------------------------------------------------------
 */
int Undo(void)
{
	UNDO_LIST *p;
	UNDO_LIST *p_start;
	UNDO_LIST *p_end;


	/* Undo ϡ1 礭ʤм¹ԤǤʤ */
	if (1 < Undo_Now) Undo_Now--;
	else return 0;


	/* index κǽΥɥ쥹õ */
	p_start = search_list_undo_start(Undo_Now);
	/* index κǸΥɥ쥹õ */
	p_end = search_list_undo_end(Undo_Now);


	/* index ĤΤȤ */
	if (p_start == p_end) {
		UndoRedo(p_start);
	}

	else if (p_start == NULL && p_end == undo_list_info.tail) {
		UndoRedo(p_end);
	}



	/* index ʣȤ */
	else {
		p = p_start;
		while( p != NULL && p != p_end->next ) {
			UndoRedo(p);
			p = p->next;	/* ݥ󥿤򼡤Υǡ˰ܤ */
		}
	}
	return 1;
}



/* -------------------------------------------------------------------
 * Redo
 * -------------------------------------------------------------------
 * ɥ¹
 *	
 *	 ɥϡUndo_Now  +1 ˤΤϡɥȤϵդ θ塣
 *	 ʣޤϣĤ Undo_Now Ʊֹ index Фƽ¹Ԥ뤬
 * index Ǥ⡢äŤǡ򤹤롣(ɥȤϵ)
 *	 ĤΥǡФơºݤν򤹤ΤϡUndoRedo() ؿǤϡ
 * ɥǽؿƱ
 * -------------------------------------------------------------------
 */
int Redo(void)
{
	UNDO_LIST *p = NULL;
	UNDO_LIST *pb = NULL;
	UNDO_LIST *p_start = NULL;
	UNDO_LIST *p_end = NULL;


	/* Rndo ϡ(Undo_index + 1) ⾮ʤм¹ԤǤʤ */
	if (Undo_index + 1 > Undo_Now) {
		/* index κǽΥɥ쥹õ */
		p_start = search_list_undo_start(Undo_Now);
		/* index κǸΥɥ쥹õ */
		p_end = search_list_undo_end(Undo_Now);


		if (p_start == NULL && p_end == undo_list_info.tail) {
//			LogFileWrite("Undo run : p_end = tail\n");
			UndoRedo(p_end);
		}

		else {
			/* -------------------------------------------------
			 * p_end  p_start  UndoRedo() ¹Ԥ 
			 * index ΥǡĤΤȤϡwhile ȴ
			 * UndoRedo(p_start); ¹Ԥ롣
			 */
			while (p_start != p_end) {
				p = p_start;
				while (p != NULL && p != p_end) {
					pb = p;
					p = p->next;
				}
				UndoRedo(p);
				p_end = pb;
			}
			UndoRedo(p_start);
		}
		Undo_Now++;
		return 1;
	}
	return 0;
}



/* -------------------------------------------------------------------
 * Undo/Redo μºݤν򤹤
 * -------------------------------------------------------------------
 *	 (type = 11 or 21) ǡäȤ󤬤СΥǡ
 * CAD ǡ List 鳰(꤫鳫ʤ)(type = 12 or 22) ѹ롣
 *	
 *	 (type = 12 or 22) ǡȤ󤬤СΥǡ
 * CAD ǡ List ɲäơ(type = 11 or 21) ѹ롣
 *	
 *	 (type = 13 or 23) ǡѹȤ󤬤СUndo List ˤǡ
 * Undo List  next ФؤƤ CAD Υǡ줫롣
 * -------------------------------------------------------------------
 */
void UndoRedo(UNDO_LIST *undo)
{
	CAD dummy_cad;
	DIMENSION dummy_dimension;
	ELLIPSE dummy_ellipse;
	POLYLINE dummy_polyline;
	INSERT dummy_insert;


	if (undo == NULL) return;

	/* -----------------------------------------------------
	 * CAD Data 
	 * -----------------------------------------------------
	 */
	/* New */
	if (undo->type == CAD_NEW) {
		/* CAD Υǡơtype = 12 ˤ */
		cad_list_delete(cad_search_cad(undo->diagram_point.cad_point, &cad_list_info), &cad_list_info);
		undo->type = CAD_DEL;
	}

	/* Delete */
	else if (undo->type == CAD_DEL) {
		/* CAD Υǡɲäơtype = 11 ˤ */
		/* CAD Data ꥹȤκǽɲ */
		r_cad_list_add_first(undo->diagram_point.cad_point, &cad_list_info);
		undo->type = CAD_NEW;
	}

	/* Edit */
	else if (undo->type == CAD_EDIT) {
		/* CAD_LIST ΰΥǡ keep */
		dummy_cad = *undo->diagram_point.cad_point;
		/* CAD_LIST ΰ Undo ˤäƤǡ */
		*undo->diagram_point.cad_point = undo->diagram.cad;
		/* Undo ΰ keep Ƥäѹ CAD Υǡ򤤤 */
		undo->diagram.cad = dummy_cad;
	}



	/* -----------------------------------------------------
	 * DIMENSION Data 
	 * -----------------------------------------------------
	 */
	/* New */
	else if (undo->type == DIMENSION_NEW) {
		/* DIMENSION Υǡơtype = 22 ˤ */
		dimension_list_delete(dimension_search_dimension(undo->diagram_point.dimension_point, &dimension_list_info), &dimension_list_info);
		undo->type = DIMENSION_DEL;
	}

	/* Delete */
	else if (undo->type == DIMENSION_DEL) {
		/* DIMENSION Υǡɲäơtype = 21 ˤ */
		/* CAD Data ꥹȤκǽɲ */
		r_dimension_list_add_first(undo->diagram_point.dimension_point, &dimension_list_info);
		undo->type = DIMENSION_NEW;
	}
	/* Edit */
	else if (undo->type == DIMENSION_EDIT) {
		/* DIMENSION_LIST ΰΥǡ keep */
		dummy_dimension = *undo->diagram_point.dimension_point;
		/* DIMENSION_LIST ΰ Undo ˤäƤǡ */
		*undo->diagram_point.dimension_point = undo->diagram.dimension;
		/* Undo ΰ keep Ƥäѹ DIMENSION Υǡ򤤤 */
		undo->diagram.dimension = dummy_dimension;
	}



	/* -----------------------------------------------------
	 * ELLIPSE Data 
	 * -----------------------------------------------------
	 */
	/* New */
	else if (undo->type == ELLIPSE_NEW) {
		/* ELLIPSE Υǡơtype = ELLIPSE_DEL ˤ */
		ellipse_list_delete(ellipse_search_ellipse(undo->diagram_point.ellipse_point, &ellipse_list_info), &ellipse_list_info);
		undo->type = ELLIPSE_DEL;
	}

	/* Delete */
	else if (undo->type == ELLIPSE_DEL) {
		/* ELLIPSE Υǡɲäơtype = ELLIPSE_NEW ˤ */
		/* ELLIPSE Data ꥹȤκǽɲ */
		r_ellipse_list_add_first(undo->diagram_point.ellipse_point, &ellipse_list_info);
		undo->type = ELLIPSE_NEW;
	}

	/* Edit */
	else if (undo->type == ELLIPSE_EDIT) {
		/* ELLIPSE_LIST ΰΥǡ keep */
		dummy_ellipse = *undo->diagram_point.ellipse_point;
		/* ELLIPSE_LIST ΰ Undo ˤäƤǡ */
		*undo->diagram_point.ellipse_point = undo->diagram.ellipse;
		/* Undo ΰ keep Ƥäѹ ELLIPSE Υǡ򤤤 */
		undo->diagram.ellipse = dummy_ellipse;
	}



	/* -----------------------------------------------------
	 * POLYLINE Data 
	 * -----------------------------------------------------
	 */
	/* New */
	else if (undo->type == POLYLINE_NEW) {
		/* POLYLINE Υǡơtype = POLYLINE_DEL ˤ */
		polyline_list_delete(polyline_search_polyline(undo->diagram_point.polyline_point, &polyline_list_info), &polyline_list_info);
		undo->type = POLYLINE_DEL;
	}

	/* Delete */
	else if (undo->type == POLYLINE_DEL) {
		/* POLYLINE Υǡɲäơtype = POLYLINE_NEW ˤ */
		/* POLYLINE Data ꥹȤκǽɲ */
		r_polyline_list_add_first(undo->diagram_point.polyline_point, &polyline_list_info);
		undo->type = POLYLINE_NEW;
	}

	/* Edit */
	else if (undo->type == POLYLINE_EDIT) {
		/* ELLIPSE_LIST ΰΥǡ keep */
		dummy_polyline = *undo->diagram_point.polyline_point;
		/* ELLIPSE_LIST ΰ Undo ˤäƤǡ */
		*undo->diagram_point.polyline_point = undo->diagram.polyline;
		/* Undo ΰ keep Ƥäѹ ELLIPSE Υǡ򤤤 */
		undo->diagram.polyline = dummy_polyline;
	}



	/* -----------------------------------------------------
	 * INSERT Data 
	 * -----------------------------------------------------
	 */
	/* New */
	else if (undo->type == INSERT_NEW) {
		/* INSERT Υǡơtype = INSERT_DEL ˤ */
		insert_list_delete(insert_search_insert(undo->diagram_point.insert_point, &insert_list_info), &insert_list_info);
		undo->type = INSERT_DEL;
	}

	/* Delete */
	else if (undo->type == INSERT_DEL) {
		/* INSERT Υǡɲäơtype = INSERT_NEW ˤ */
		/* INSERT Data ꥹȤκǽɲ */
		r_insert_list_add_first(undo->diagram_point.insert_point, &insert_list_info);
		undo->type = INSERT_NEW;
	}

	/* Edit */
	else if (undo->type == INSERT_EDIT) {
		/* ELLIPSE_LIST ΰΥǡ keep */
		dummy_insert = *undo->diagram_point.insert_point;
		/* ELLIPSE_LIST ΰ Undo ˤäƤǡ */
		*undo->diagram_point.insert_point = undo->diagram.insert;
		/* Undo ΰ keep Ƥäѹ ELLIPSE Υǡ򤤤 */
		undo->diagram.insert = dummy_insert;
	}



}



/* ---------------------------------------------------------
 * ݥ󥿤ؤ Undo Data ꥹȤ
 */
int undo_list_free(UNDO_LIST *del_List)
{
char str[256];
	UNDO_LIST *p = NULL;
	UNDO_LIST *pb = NULL;
	long i;

	/* -------------------------------------------
	 * ݥ󥿤ΥǡΤꤿΤǡ
	 * head (ꥹȤƬ) ݥ󥿤
	 * ĤޤǷ֤Υǡõ
	 */
	p = undo_list_info.head;
	i = 0;
	/* -------------------------------------------
	 * ǸޤǸĤʤ硢 p  NULL  
	 * äƥ롼פȴ롣
	 */
	while(p != NULL && p != del_List) {
		i++;
		pb = p;			/* ΥǡΥݥ󥿤Ȥ¸Ƥ */
		p = p->next;	/* ݥ󥿤򼡤Υǡ˰ܤ */
	}


	/* Ĥä (p  NULL ǤϤʤȤ) */
	if (p != NULL){
		/* ƬΥǡ (i = 0 ΤȤ) */
		if (i == 0) {
			/* ƬΥǡĤʤ(ΥǡΥݥ󥿤 NULL) */
			if (p->next == NULL) {
				undo_list_info.head = NULL;
				undo_list_info.tail = NULL;
			}
			/* İʾǡȤ */
			else 
				undo_list_info.head = p->next;
		}

		/* ǸΥǡΤȤ (p->next = NULL) */
		else if (p->next == NULL) pb->next = NULL;

		/* ֤Υǡ (ξʳ) */
		else pb->next = p->next;


		/* -------------------------------------------------
		 * CAD DATA 
		 */
		if (del_List->type == CAD_DEL/* || del_List->type == 13*/) {
			if (del_List->diagram_point.cad_point != NULL) {
				xfree(del_List->diagram_point.cad_point);
			}
		}


		/* -------------------------------------------------
		 * DIMENSION DATA 
		 */
		/*  */
		else if (del_List->type == DIMENSION_DEL) {
			/* AssistLine */
			if (
				del_List->diagram_point.dimension_point->index > 0 
				&& 
				del_List->diagram_point.dimension_point->AssistLine != NULL
				) 
			{
				xfree(del_List->diagram_point.dimension_point->AssistLine);
			}

			/* diagram_of_char */
			if (
				del_List->diagram_point.dimension_point->diagram_of_char_index > 0 
				&& 
				del_List->diagram_point.dimension_point->diagram_of_char != NULL
				) 
			{
				xfree(del_List->diagram_point.dimension_point->diagram_of_char);
			}

			/* DIMENSION */
			if (del_List->diagram_point.dimension_point != NULL) {
				xfree(del_List->diagram_point.dimension_point);
			}
			else if (del_List->diagram_point.dimension_point == NULL) {
				printf("This place is funny for NULL.");
			}
		}
		/* Խ */
		else if (del_List->type == DIMENSION_EDIT) {
			/* AssistLine */
			if (
				del_List->diagram.dimension.index > 0 
				&& 
				del_List->diagram.dimension.AssistLine != NULL
				) 
			{
				// ϡˡϡԽϤʤΤǡ¥ǡФ
				//xfree(del_List->diagram.dimension.AssistLine);
			}

			/* diagram_of_char */
			if (
				del_List->diagram.dimension.diagram_of_char_index > 0 
				&& 
				del_List->diagram.dimension.diagram_of_char != NULL
				) 
			{
				xfree(del_List->diagram.dimension.diagram_of_char);
			}
		}


		/* -------------------------------------------------
		 * POLYLINE DATA 
		 */
		if (del_List->type == POLYLINE_DEL) {
			if (del_List->diagram_point.polyline_point->vertex_list_info.head != NULL) {
				vertex_list_all_free(&del_List->diagram_point.polyline_point->vertex_list_info);
			}
			
			if (del_List->diagram_point.polyline_point != NULL) {
				xfree(del_List->diagram_point.polyline_point);
			}
		}


		/* -------------------------------------------------
		 * ELLIPSE DATA 
		 */
		if (del_List->type == ELLIPSE_DEL) {
			if (del_List->diagram_point.ellipse_point != NULL) {
				xfree(del_List->diagram_point.ellipse_point);
			}
		}


		xfree(del_List);
		return 1;
	}
	else {
		sprintf(str, "list_undo.cpp : undo_list_free() : Not Found(0x%x)\n", (int)p);
		OneShotLog(str);
	}

	return 0;
//	xfree(del_List);
}





/* ---------------------------------------------------------
 *	ꥹȤ
 */
void undo_list_all_free(void)
{
	while (undo_list_info.head != NULL) {
		undo_list_free(undo_list_info.head);
	}
	Undo_index = 0;
	Undo_Now = 1;
}





/* ---------------------------------------------------------
 * UNDO_LIST Υǡ log
 *	
 */
void undo_list_log(void)
{
	UNDO_LIST *p;
	int i = 0;
	char str[256], msg[256];

	sprintf(str, "----- Undo List Start -----\n");
	OneShotLog(str);
	sprintf(str, "Undo_index = %d   Undo_Now = %d\n", (int)Undo_index, (int)Undo_Now);
	OneShotLog(str);

	p = undo_list_info.head;
	while (p != NULL) {
		i++;


		if (p->type == 11) {
			sprintf(msg, "ǡ  POINT ϡCAD_LIST ");
		}
		if (p->type == 12) {
			sprintf(msg, "ǡ  POINT ϡCAD_LIST ˤϤʤ");
		}
		if (p->type == 13) {
			sprintf(msg, "ǡԽ  POINT ϡCAD_LIST 塣CAD ϡԽΥǡ");
		}


		sprintf(str, "%d : 0x%x : index = %d  %s\n", 
				i, (int)p->diagram_point.cad_point, (int) p->index, msg);
		OneShotLog(str);
		if (p->diagram_point.cad_point != NULL) {
			if (p->diagram_point.cad_point != NULL) {
				sprintf (str, "    POINT    : %d (%f,%f)-(%f,%f)  (%f,%f),R%f\n", 
						p->diagram_point.cad_point->code, 
						p->diagram_point.cad_point->sx, p->diagram_point.cad_point->sy, 
						p->diagram_point.cad_point->ex, p->diagram_point.cad_point->ey, 
						p->diagram_point.cad_point->cx, p->diagram_point.cad_point->cy, p->diagram_point.cad_point->r);
				OneShotLog(str);
			}
		}		
		
		if (p->type == 13) {
			sprintf (str, "    OLD DATA : %d (%f,%f)-(%f,%f)  (%f,%f),R%f\n", 
						p->diagram_point.cad_point->code, 
						p->diagram_point.cad_point->sx, p->diagram_point.cad_point->sy, 
						p->diagram_point.cad_point->ex, p->diagram_point.cad_point->ey, 
						p->diagram_point.cad_point->cx, p->diagram_point.cad_point->cy, p->diagram_point.cad_point->r);
			OneShotLog(str);
		}

		p = p->next;
	}

	sprintf(str, "----- Undo List End   -----\n");
	OneShotLog(str);
}





/* ====================================================================
 * ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : List_Undo.c
 * ====================================================================
 */
