/* ====================================================================
 * ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : List_Vertex.c
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2003 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2003/03/23
 *    Last                 : 2003/03/23
 * ====================================================================
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <gtk/gtk.h>
#include <stdio.h>
#include <stdlib.h>
#include "MemoryLeak.h"
#include "types.h"
#define _LIST_VERTEX_
#include "List_Vertex.h"





int init_vertex(VERTEX *vertex)
{
	/* VERTEX Data ν */
	vertex->x = 0;
	vertex->y = 0;
	vertex->frag = 0;
	return 1;
}





/* -------------------------------------------------------------------
 * VERTEX Data ꥹȤκǽɲ
 * 
 */
VERTEX_LIST *vertex_list_add_first(VERTEX *add_vertex, VERTEX_LIST_INFO *p_vertex_list_info)
{
	VERTEX_LIST *p;


	/* ǡ (LIST) 񤭹िΰݤ */
	p_vertex_list = (VERTEX_LIST *)xmalloc(sizeof(VERTEX_LIST));
	/* ǡ (vertex) 񤭹िΰݤ */
	p_vertex_list->vertex = (VERTEX *)xmalloc(sizeof(VERTEX));

	/* ݤΰ˥ǡ (vertex) 񤭹 */
	*p_vertex_list->vertex = *add_vertex;
	p_vertex_list->next = NULL;

	/* -----------------------------------------------------
	 * head & tail ξ NULL ΤȤϡĤǡʤ 
	 */
	if (p_vertex_list_info->head == NULL && p_vertex_list_info->tail == NULL) {
		p_vertex_list_info->head = p_vertex_list;
		p_vertex_list_info->tail = p_vertex_list;
	}

	/* -----------------------------------------------------
	 * ǡİʾ夢
	 */
	else {
		p = p_vertex_list_info->head;
		p_vertex_list_info->head = p_vertex_list;
		p_vertex_list->next = p;
	}

	return p_vertex_list_info->head;
}





/* -------------------------------------------------------------------
 * VERTEX Data ꥹȤκǸɲ
 * 
 */
VERTEX_LIST *vertex_list_add_last(VERTEX *add_vertex, VERTEX_LIST_INFO *p_vertex_list_info)
{
	VERTEX_LIST *p;


	/* ǡ (LIST) 񤭹िΰݤ */
	p_vertex_list = (VERTEX_LIST *)xmalloc(sizeof(VERTEX_LIST));
	/* ǡ (vertex) 񤭹िΰݤ */
	p_vertex_list->vertex = (VERTEX *)xmalloc(sizeof(VERTEX));

	/* ݤΰ˥ǡ (vertex) 񤭹 */
	*p_vertex_list->vertex = *add_vertex;
	p_vertex_list->next = NULL;

	/* -----------------------------------------------------
	 * head & tail ξ NULL ΤȤϡĤǡʤ 
	 */
	if (p_vertex_list_info->head == NULL && p_vertex_list_info->tail == NULL) {
		p_vertex_list_info->head = p_vertex_list;
		p_vertex_list_info->tail = p_vertex_list;
	}

	/* -----------------------------------------------------
	 * head = tail  NULL ǤϤʤȤϡĤǡ
	 */
	else if (p_vertex_list_info->head != NULL 
				&& p_vertex_list_info->tail != NULL 
					&& p_vertex_list_info->head == p_vertex_list_info->tail) {
		p_vertex_list_info->head->next = p_vertex_list;
		p_vertex_list_info->tail = p_vertex_list;
	}

	/* -----------------------------------------------------
	 * ǡİʾ夢
	 */
	else {
		p = p_vertex_list_info->tail;
		p_vertex_list_info->tail = p_vertex_list;
		p->next = p_vertex_list_info->tail;
	}

	/* ɥХåե˽ */
//	undo_list_add_first(11, p_vertex_list_info->tail, NULL);
	return p_vertex_list_info->tail;
}





/* -------------------------------------------------------------------
 * VERTEX Data κǽ (κǤϤʤ)
 * 
 */
int vertex_list_delete(VERTEX_LIST *del_List, VERTEX_LIST_INFO *p_vertex_list_info)
{
	VERTEX_LIST *p = NULL;
	VERTEX_LIST *pb = NULL;


	/* ǡƬǣĤ  */
	if (del_List == p_vertex_list_info->head && del_List->next == NULL) {
		p_vertex_list_info->head = NULL;
		p_vertex_list_info->tail = NULL;
	}
	/* ǡƬǣİʾ  */
	else if (del_List == p_vertex_list_info->head && del_List->next != NULL) {
		p_vertex_list_info->head = p_vertex_list_info->head->next;
	}
	else {
		/* -------------------------------------------
		 * ݥ󥿤ΥǡΤꤿΤǡ
		 * head (ꥹȤƬ) ݥ󥿤
		 * ĤޤǷ֤Υǡõ
		 */
		p = p_vertex_list_info->head;
		/* -------------------------------------------
		 * ǸޤǸĤʤ硢 p  NULL  
		 * äƥ롼פȴ롣
		 */
		while(p != NULL && p != del_List) {
			pb = p;			/* ΥǡΥݥ󥿤Ȥ¸Ƥ */
			p = p->next;	/* ݥ󥿤򼡤Υǡ˰ܤ */
		}

		if(p != NULL){
			/* ǸΥǡ */
			if (del_List == p_vertex_list_info->tail) {
				pb->next = NULL;
				p_vertex_list_info->tail = pb;
			}
			/* ֤Υǡ */
			else if (del_List != p_vertex_list_info->head && del_List != p_vertex_list_info->tail) {
				pb->next = p->next;
			}
		}
		else {
			g_print("List_vertex.c : vertex_list_delete() : There is not data of structure data VERTEX.\n");
			return 0;
		}
	}
	xfree(del_List);
//	StartData = p_vertex_list_info->head;
	return 1;
}





/* -------------------------------------------------------------------
 * VERTEX Υݥ󥿤Υǡ Undo ХåեԽˤơ
 * ξ˿ǡ롣
 *	
 * ͡ΥǡΥɥ쥹
 */
VERTEX_LIST *vertex_list_edit(VERTEX_LIST *point, VERTEX *change_vertex, VERTEX_LIST_INFO *p_vertex_list_info)
{
	/* ǡ (LIST) 񤭹िΰݤ */
	p_vertex_list = (VERTEX_LIST *)xmalloc(sizeof(VERTEX_LIST));

	/* ǡ (vertex) 񤭹िΰݤ */
	p_vertex_list->vertex = (VERTEX *)xmalloc(sizeof(VERTEX));

	/* ݤΰѹΥǡ (vertex) 񤭹 */
	*p_vertex_list->vertex = *point->vertex;
	p_vertex_list->next = point;

	/* ѹǡ񤭹 */
	*point->vertex = *change_vertex;

//	undo_list_add_first(13, p_vertex_list, NULL);
	return p_vertex_list;
}





/* -------------------------------------------------------------------
 *	ꥹȤĴ٤
 */
long vertex_list_num(VERTEX_LIST_INFO *p_vertex_list_info)
{
	VERTEX_LIST *p;
	long i;

	p = p_vertex_list_info->head;
	i = 0;
	/* -------------------------------------------
	 * ǸޤǸĤʤ硢 p  NULL  
	 * äƥ롼פȴ롣
	 */
	while(p != NULL) {
		i++;
		p = p->next;	/* ݥ󥿤򼡤Υǡ˰ܤ */
	}
	return i;
}





/* -------------------------------------------------------------------
 * n ܤΥǡθ
 * 
 */
VERTEX_LIST *vertex_search_num(long search_number, VERTEX_LIST_INFO *p_vertex_list_info)
{
	VERTEX_LIST *p;
	long i;


	p = p_vertex_list_info->head;
	i = 1;
	/*	*/
	while( p != NULL && i != search_number) {
		i++;
		p = p->next;
	}

	/* n ܤΥǡΥɥ쥹֤ */
	if (p != NULL) {
		return p;
	}
	/* ޤǥǡʤ */
	else {
		return NULL;
	}
}





/* -------------------------------------------------------------------
 * VERTEX Υǡθ
 * 
 *   VERTEX_LIST
 */
VERTEX_LIST *vertex_search_vertex(VERTEX *p_vertex, VERTEX_LIST_INFO *p_vertex_list_info)
{
	VERTEX_LIST *p;


	p = p_vertex_list_info->head;
	/*	*/
	while( p != NULL && p->vertex != p_vertex) {
		p = p->next;
	}

	/* p_vertex ΥǡΥɥ쥹֤ */
	if (p != NULL) {
		return p;
	}
	/* ޤǥǡʤ */
	else {
		return NULL;
	}
}





/* -------------------------------------------------------------------
 * VERTEX Υǡθ
 * 
 *   long
 */
long vertex_search_vertex_to_num(VERTEX *p_vertex, VERTEX_LIST_INFO *p_vertex_list_info)
{
	VERTEX_LIST *p;
	long i;

	i = 1;
	p = p_vertex_list_info->head;
	/*	*/
	while( p != NULL && p->vertex != p_vertex) {
		p = p->next;
		i++;
	}

	/* p_vertex ΥǡΥɥ쥹֤ */
	if (p != NULL) {
		return i;
	}
	/* ޤǥǡʤ */
	else {
		return 0;
	}
}





/* -------------------------------------------------------------------
 *	VERTEX Data ꥹȤ
 */
int vertex_list_free(VERTEX_LIST *del_List, VERTEX_LIST_INFO *p_vertex_list_info)
{
	VERTEX_LIST *p = NULL;
	VERTEX_LIST *pb = NULL;


	/* ǡƬǣĤ  */
	if (del_List == p_vertex_list_info->head && del_List->next == NULL) {
		p_vertex_list_info->head = NULL;
		p_vertex_list_info->tail = NULL;
	}
	/* ǡƬǣİʾ  */
	else if (del_List == p_vertex_list_info->head && del_List->next != NULL) {
		p_vertex_list_info->head = p_vertex_list_info->head->next;
	}
	else {
		/* -------------------------------------------
		 * ݥ󥿤ΥǡΤꤿΤǡ
		 * head (ꥹȤƬ) ݥ󥿤
		 * ĤޤǷ֤Υǡõ
		 */
		p = p_vertex_list_info->head;
		/* -------------------------------------------
		 * ǸޤǸĤʤ硢 p  NULL  
		 * äƥ롼פȴ롣
		 */
		while(p != NULL && p != del_List) {
			pb = p;			/* ΥǡΥݥ󥿤Ȥ¸Ƥ */
			p = p->next;	/* ݥ󥿤򼡤Υǡ˰ܤ */
		}


		if(p != NULL){
			/* ǸΥǡ */
			if (del_List == p_vertex_list_info->tail) {
				pb->next = NULL;
				p_vertex_list_info->tail = pb;
			}
			/* ֤Υǡ */
			else if (del_List != p_vertex_list_info->head && del_List != p_vertex_list_info->tail) {
				pb->next = p->next;
			}
		}
		else {
			g_print("List_vertex.c : vertex_list_free() : There is not data of structure data VERTEX.\n");
			return 0;
		}
	}
	xfree(del_List->vertex);
	xfree(del_List);
	return 1;
}





/* -------------------------------------------------------------------
 *	ꥹȤ
 */
void vertex_list_all_free(VERTEX_LIST_INFO *p_vertex_list_info)
{
	while(p_vertex_list_info->head != NULL) {
		if (vertex_list_free(p_vertex_list_info->head, p_vertex_list_info) == 0) {
			g_print("List_vertex.c : vertex_list_all_free() : vertex_list_free() ǥ顼\n");
			g_print("%s : %d : vertex_list_all_free() : ERROR\n", __FILE__, __LINE__);
		}
	}
}





void vertex_list_print(VERTEX_LIST_INFO *p_vertex_list_info)
{
	VERTEX_LIST *p;
	int i = 0;

	g_print("----- VERTEX ꥹȤɽ -----\n");
	p = p_vertex_list_info->head;
	while (p != NULL) {
		i++;
		g_print("%d(0x%x) : (%f,%f)\n", i, (int)p->vertex, p->vertex->x, p->vertex->y);
		p = p->next;
	}
	g_print("-----------------------------\n");
}





/* -------------------------------------------------------------------
 * VERTEX_LIST_INFO_1  VERTEX_LIST_INFO_2 ˥ԡ
 * 
 */
int copy_vertex_list_info(VERTEX_LIST_INFO *org_vertex_list_info, VERTEX_LIST_INFO *cpy_vertex_list_info)
{
	VERTEX_LIST *pv;
	VERTEX vertex;


	cpy_vertex_list_info->head = NULL;
	cpy_vertex_list_info->tail = NULL;

	/* BLOCK  VERTEX ǡ VERTEX_LIST_INFO Ͽ */
	pv = org_vertex_list_info->head;
	while (pv != NULL) {
		init_vertex(&vertex);
		vertex = *pv->vertex;
		vertex_list_add_last(&vertex, cpy_vertex_list_info);
		pv = pv->next;
	}
	return 1;
}





/* ====================================================================
 * ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : List_Vertex.c
 * ====================================================================
 */
