/* ====================================================================
 * ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : PrintSetDlg.h
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2003 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2003/04/12
 *    Last                 : 2003/04/12
 * ====================================================================
 */
#ifndef __PRINTSETDLG_H__
#define __PRINTSETDLG_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */



/* -------------------------------------------------------
 * 1 :   (struct #define etc)
 * -------------------------------------------------------
 */

struct _PRINTSET_DLG
{
	gint value;					/* 0:cancel  1:OK */
	gint view;					/* 0:display  1:drawing */
	gint paper;					/* a4:1  a3:2  b5:3  b4:4 */
	gint orientation;			/* :0:portrait   :1:landscape */
	gdouble up_scale;
	gdouble low_scale;

	gint toggle_frag;

	GtkWidget *display_check;
	GtkWidget *drawing_check;

	GtkWidget *up_scale_entry;
	GtkWidget *low_scale_entry;

	GtkWidget *A4_check;
	GtkWidget *A3_check;
	GtkWidget *B5_check;
	GtkWidget *B4_check;

	GtkWidget *portrait_check;
	GtkWidget *landscape_check;

	GtkWidget *parent;			
	GtkWidget *dialog;			
};
typedef struct _PRINTSET_DLG PRINTSET_DLG;



/* -------------------------------------------------------
 * 2 : ѿ (global)
 * -------------------------------------------------------
 */
#ifdef _PRINTSETDLG_
#define   GLOBAL
/*  */
#define   GLOBAL_VAL(v)  = (v)
#else
#define   GLOBAL	extern
/* ʬ̵ */
#define   GLOBAL_VAL(v)  /* */
#endif




#undef  GLOBAL
#undef  GLOBAL_VAL
#undef _PRINTSETDLG_



/* -------------------------------------------------------
 * 3 : ؿ (Function)
 * -------------------------------------------------------
 */

/*  */
gint PrintSetDialog(PRINTSET_DLG *printset_dlg);



#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* __PRINTSETDLG_H__ */
/* ====================================================================
 * ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : PrintSetDlg.h
 * ====================================================================
 */
