/* ====================================================================
 * ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : TrimFunc.c
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2003 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2001/01/18
 *    Last                 : 2003/04/16
 * ====================================================================
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <gtk/gtk.h>
#include <unistd.h>
#include <pwd.h>
#include <sys/types.h>
#include <sys/stat.h>

#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "intl.h"

#include "MemoryLeak.h"
#include "List_cad.h"
#include "List_Dimension.h"
#include "List_PolyLine.h"
#include "List_Block.h"
#include "List_Undo.h"
#include "List_Select.h"
#include "Trace.h"
#include "Ellipse.h"
#include "Dimension.h"
#include "etc.h"
#include "global.h"
#include "Draw.h"
#include "Select.h"
#include "Dimension.h"
#define _TRIMFUNC_
#include "TrimFunc.h"





/* -------------------------------------------------------------------
 * ȥȽ
 *	
 */
int TrimMain(struct TrimDat *a)
{
//#define TRIMMAIN
	struct TrimDat Both;
	int Ret;
	double x1, y1, x2, y2, dumy_x, dumy_y;
	int debug = 0;


#ifdef TRIMMAIN
	debug = 1;
#endif

	/* ȥ޷ʱߤޤϱߤʤȥ¹ */
	if ((a->TraceData[1].code == 16 && a->ellipse[1].code == 0) || a->TraceData[1].code == 4) {
		/* ȥ޷ʱ */
		if (a->TraceData[1].code == 16) {
			if (debug > 0) g_print("ȥ޷ʱ\n");
			Ret = TrimE(a, &x1, &y1, &x2, &y2);
			TrimE_Run(a, &x1, &y1, &x2, &y2);
		}
		/* ȥ޷ */
		else if (a->TraceData[1].code == 4) {
			if (debug > 0) g_print("ȥ޷\n");
			Ret = TrimC(a, &x1, &y1, &x2, &y2);
			TrimC_Run(a, &x1, &y1, &x2, &y2);
		}


		/* ξȥࣱ */
		if (a->Index == 2 && a->TraceData[2].code != 4) {
			Both.Index			= 1;
			Both.TraceData[1] = a->TraceData[2];
			Both.ellipse[1] = Both.ellipse[2];
			Both.PicX[1]		= a->PicX[2];
			Both.PicY[1]		= a->PicY[2];
			Both.TraceData[2] = a->TraceData[1];
			Both.ellipse[2] = Both.ellipse[1];
			Both.PicX[2]		= a->PicX[1];
			Both.PicY[2]		= a->PicY[1];

			if (Both.TraceData[1].code == 1) {
				TrimL_Run(&Both, x1, y1);
			}
			if (Both.TraceData[1].code == 2) {
				Ret = TrimA(&Both, &dumy_x, &dumy_y);
				if (Ret == 1) {
					TrimA_Run(&Both, x1, y1);
				}
				else if (Ret == 2) {
					TrimA_Pull(&Both, x1, y1);
				}
			}
			if (Both.TraceData[1].code == 16) {
				if (Both.ellipse[1].code == 1) {
					Ret = TrimEA(&Both, &dumy_x, &dumy_y);
					if (Ret == 1) {
						TrimEA_Run(&Both, x1, y1);
					}
					else if (Ret == 2) {
						TrimEA_Pull(&Both, x1, y1);
					}
				}
			}
			/* ᤹ */
			a->TraceData[2]		= Both.TraceData[1];
			a->ellipse[2]		= Both.ellipse[1];
			a->PicX[2]			= Both.PicX[1];
			a->PicY[2]			= Both.PicY[1];
		}


		/* ξȥࣲ */
		if (a->Index == 2 && a->TraceData[3].code != 4) {
			Both.Index			= 1;
			Both.TraceData[1]	= a->TraceData[3];
			Both.ellipse[1] = Both.ellipse[3];
			Both.PicX[1]		= a->PicX[3];
			Both.PicY[1]		= a->PicY[3];
			Both.TraceData[2]	= a->TraceData[1];
			Both.ellipse[2] = Both.ellipse[1];
			Both.PicX[2]		= a->PicX[1];
			Both.PicY[2]		= a->PicY[1];

			if (Both.TraceData[1].code == 1) {
				TrimL_Run(&Both, x2, y2);
			}
			if (Both.TraceData[1].code == 2) {
				Ret = TrimA(&Both, &dumy_x, &dumy_y);
				if (Ret == 1) {
					TrimA_Run(&Both, x2, y2);
				}
				else if (Ret == 2) {
					TrimA_Pull(&Both, x2, y2);
				}
			}
			if (Both.TraceData[1].code == 16) {
				if (Both.ellipse[1].code == 1) {
					Ret = TrimEA(&Both, &dumy_x, &dumy_y);
					if (Ret == 1) {
						TrimEA_Run(&Both, x2, y2);
					}
					else if (Ret == 2) {
						TrimEA_Pull(&Both, x2, y2);
					}
				}
			}
			/* ᤹ */
			a->TraceData[3]		= Both.TraceData[1];
			a->ellipse[3]		= Both.ellipse[1];
			a->PicX[3]			= Both.PicX[1];
			a->PicY[3]			= Both.PicY[1];
		}
	}





	/* ȥ޷ʤȥ¹ */
	else if (a->TraceData[1].code == 1 ) {
		if (debug > 0) g_print("ȥ޷\n");
		Ret = TrimL(a, &x1, &y1);
		TrimL_Run(a, x1, y1);
		if (a->Index == 2 && a->TraceData[2].code != 4 ) {
			Both.Index			= 1;
			Both.TraceData[1] = a->TraceData[2];
			Both.ellipse[1] = Both.ellipse[2];
			Both.PicX[1]		= a->PicX[2];
			Both.PicY[1]		= a->PicY[2];
			Both.TraceData[2]	= a->TraceData[1];
			Both.ellipse[2] = Both.ellipse[1];
			Both.PicX[2]		= a->PicX[1];
			Both.PicY[2]		= a->PicY[1];

			if (Both.TraceData[1].code == 1) {
				TrimL_Run(&Both, x1, y1);
			}
			if (Both.TraceData[1].code == 2) {
				Ret = TrimA(&Both, &dumy_x, &dumy_y);
				if (Ret == 1) {
					TrimA_Run(&Both, x1, y1);
				}
				else if (Ret == 2) {
					TrimA_Pull(&Both, x1, y1);
				}
			}
			if (Both.TraceData[1].code == 16) {
				if (Both.ellipse[1].code == 1) {
					Ret = TrimEA(&Both, &dumy_x, &dumy_y);
					if (Ret == 1) {
						TrimEA_Run(&Both, x2, y2);
					}
					else if (Ret == 2) {
						TrimEA_Pull(&Both, x2, y2);
					}
				}
			}
			/* ᤹ */
			a->TraceData[2]		= Both.TraceData[1];
			a->ellipse[2]		= Both.ellipse[1];
			a->PicX[2]			= Both.PicX[1];
			a->PicY[2]			= Both.PicY[1];
		}
	}





	/* ȥ޷߸̤ޤʱ߸̤ʤȥ¹ */
	else if ((a->TraceData[1].code == 16 && a->ellipse[1].code == 1) || a->TraceData[1].code == 2) {
		if (debug > 0) if (debug > 0) g_print("ȥ޷߸̤ޤʱ߸\n");
		if (a->TraceData[1].code == 2) {
			Ret = TrimA(a, &x1, &y1);
			if (Ret == 1) {
				TrimA_Run(a, x1, y1);
			}
			else if (Ret == 2) {
				TrimA_Pull(a, x1, y1);
			}
		}
		/* ȥ޷ʱ߸ */
		if (a->TraceData[1].code == 16) {
			if (debug > 0) g_print("ȥ޷ʱ߸\n");
			Ret = TrimEA(a, &x1, &y1);
			if (debug > 0) g_print("Ret = %d\n", Ret);
			if (Ret == 1) {
				if (debug > 0) g_print("TrimEA_Run\n");
				TrimEA_Run(a, x1, y1);
			}
			else if (Ret == 2) {
				if (debug > 0) g_print("TrimEA_Pull\n");
				TrimEA_Pull(a, x1, y1);
			}
		}


		if (a->Index == 2 && a->TraceData[2].code != 4) {
			Both.Index			= 1;
			Both.TraceData[1]	= a->TraceData[2];
			Both.ellipse[1] = Both.ellipse[2];
			Both.PicX[1]		= a->PicX[2];
			Both.PicY[1]		= a->PicY[2];
			Both.TraceData[2]	= a->TraceData[1];
			Both.ellipse[2] = Both.ellipse[1];
			Both.PicX[2]		= a->PicX[1];
			Both.PicY[2]		= a->PicY[1];

			if (Both.TraceData[1].code == 1) {
				TrimL_Run(&Both, x1, y1);
			}
			if (Both.TraceData[1].code == 2) {
				Ret = TrimA(&Both, &dumy_x, &dumy_y);
				if (Ret == 1) {
					TrimA_Run(&Both, x1, y1);
				}
				else if (Ret == 2) {
					TrimA_Pull(&Both, x1, y1);
				}
			}
			if (Both.TraceData[1].code == 16) {
				if (Both.ellipse[1].code == 1) {
					Ret = TrimEA(&Both, &dumy_x, &dumy_y);
					if (Ret == 1) {
						TrimEA_Run(&Both, x1, y1);
					}
					else if (Ret == 2) {
						TrimEA_Pull(&Both, x1, y1);
					}
				}
			}
			/* ᤹ */
			a->TraceData[2]		= Both.TraceData[1];
			a->ellipse[2]		= Both.ellipse[1];
			a->PicX[2]			= Both.PicX[1];
			a->PicY[2]			= Both.PicY[1];
		}
	}

	return 1;
}





/* -------------------------------------------------------------------
 * ǥȥह
 */
int TrimL_Point(struct TrimDat a, double *x, double *y)
{
	struct RtnDat PLPH;
	char str[256];

	/* ȥ޷()ȶ޷()κǶ */
	PLPH.sx[1] = a.TraceData[1].sx;
	PLPH.sy[1] = a.TraceData[1].sy;
	PLPH.ex[1] = a.TraceData[1].ex;
	PLPH.ey[1] = a.TraceData[1].ey;
	PLPH.sx[2] = a.TraceData[2].sx;
	PLPH.sy[2] = a.TraceData[2].sy;
	plp(&PLPH);

	/* ʤʤ顣 */
	if (PLPH.type == 0) {
		strcpy(str, "Trim : error : ");
		strcat(str, _("There is not a point of intersection."));
		strcat(str, " (Line & Point)");
		g_print("%s\n", str);
		return 0;
	}
	/* ᤿Ƕ */
	*x = PLPH.ex[2];
	*y = PLPH.ey[2];
	return 1;
}





/* -------------------------------------------------------------------
 * ǥȥह
 */
int TrimL_Line(struct TrimDat a, double *x, double *y)
{
	struct RtnDat LLPH;
	char str[256];

	/* ȥ޷()ȶ޷()θ */
	LLPH.sx[1] = a.TraceData[1].sx;
	LLPH.sy[1] = a.TraceData[1].sy;
	LLPH.ex[1] = a.TraceData[1].ex;
	LLPH.ey[1] = a.TraceData[1].ey;
	LLPH.sx[2] = a.TraceData[2].sx;
	LLPH.sy[2] = a.TraceData[2].sy;
	LLPH.ex[2] = a.TraceData[2].ex;
	LLPH.ey[2] = a.TraceData[2].ey;
	llp(&LLPH);
	
	/* ʤʤ */
	if (LLPH.type == 0 ) {
		strcpy(str, "Trim : error : ");
		strcat(str, _("There is not a point of intersection."));
		strcat(str, " (Line & Line)");
		g_print("%s\n", str);
		return 0;
	}
	
	/* ᤿ */
	*x = LLPH.sx[3];
	*y = LLPH.sy[3];
	return 1;
}





/* -------------------------------------------------------------------
 * ߤǥȥह
 */
int TrimL_AC(struct TrimDat a, double *x, double *y)
{
	struct RtnDat LCPH, PPH;
	double L1, L2;					/* ȥ޷()ȥȥ޷()θ */
	char str[256];


	/* ȥ޷()ȶ޷()θ */
	LCPH.cx[1] = a.TraceData[2].cx;
	LCPH.cy[1] = a.TraceData[2].cy;
	LCPH.r[1] = a.TraceData[2].r;
	LCPH.sx[1] = a.TraceData[1].sx;
	LCPH.sy[1] = a.TraceData[1].sy;
	LCPH.ex[1] = a.TraceData[1].ex;
	LCPH.ey[1] = a.TraceData[1].ey;
	lcp(&LCPH);

	/* ʤʤ */
	if (LCPH.type == 0 ) {
		strcpy(str, "Trim : error : ");
		strcat(str, _("There is not a point of intersection."));
		strcat(str, " (Line & Circle)");
		g_print("%s\n", str);
		return 0;
	}

	/* ĤΤȤ */
	else if (LCPH.type == 1 ) {
		/* ᤿ (LCPH.SX[2] , LCPH.SY[2]) */
		*x = LCPH.sx[2];
		*y = LCPH.sy[2];
		return 1;
	}

	/* ĤΤȤ */
	else if (LCPH.type == 2 ) {
		/* å (a.PicX[2] , a.PicY[2])  
		 *  1 (LCPH.sx[2] , LCPH.sy[2]) εΥ L1 롣
		 */
		PPH.sx[1] = a.PicX[2];
		PPH.sy[1] = a.PicY[2];
		PPH.ex[1] = LCPH.sx[2];
		PPH.ey[1] = LCPH.sy[2];
		pp(&PPH);
		L1 = PPH.l;
		/* å (a.PicX[2] , a.PicY[2]) 
		 *  2 (LCPH.SX[3] , LCPH.SY[3]) εΥ L2 롣
		 */
		PPH.sx[1] = a.PicX[2];
		PPH.sy[1] = a.PicY[2];
		PPH.ex[1] = LCPH.sx[3];
		PPH.ey[1] = LCPH.sy[3];
		pp(&PPH);
		L2 = PPH.l;
		/* ɤäθå˶ᤤ
		 * ᤫä(PointX,PointY)
		 */

		/*  1 ᤤ */
		if (L1 < L2) {
			/* ᤿ (LCPH.SX[2] , LCPH.SY[2]) */
			*x = LCPH.sx[2];
			*y = LCPH.sy[2];
			return 1;
		}
		/*  2 ᤤ */
		else/* if (L1 > L2)*/ {
			/* ᤿ (LCPH.SX[3] , LCPH.SY[3]) */
			*x = LCPH.sx[3];
			*y = LCPH.sy[3];
			return 1;
		}
	}
	return 0;
}





/* -------------------------------------------------------------------
 * ʱߤǥȥह
 */
int TrimL_E(struct TrimDat a, double *x, double *y)
{
	struct RtnDat LCPH, PPH;
	double L1, L2;					/* ȥ޷()ȥȥ޷()θ */
	char str[256];


	/* ȥ޷()ȶ޷(ʱ)θ */
	LCPH.sx[1] = a.TraceData[1].sx;
	LCPH.sy[1] = a.TraceData[1].sy;
	LCPH.ex[1] = a.TraceData[1].ex;
	LCPH.ey[1] = a.TraceData[1].ey;
	lep(&LCPH, a.ellipse[2], 10);

	/* ʤʤ */
	if (LCPH.type == 0 ) {
		strcpy(str, "Trim : error : ");
		strcat(str, _("There is not a point of intersection."));
		strcat(str, " (Line & Ellipse)");
		g_print("%s\n", str);
		return 0;
	}

	/* ĤΤȤ */
	else if (LCPH.type == 1 ) {
		/* ᤿ (LCPH.SX[2] , LCPH.SY[2]) */
		*x = LCPH.sx[2];
		*y = LCPH.sy[2];
		return 1;
	}

	/* ĤΤȤ */
	else if (LCPH.type == 2 ) {
		/* å (a.PicX[2] , a.PicY[2])  
		 *  1 (LCPH.sx[2] , LCPH.sy[2]) εΥ L1 롣
		 */
		PPH.sx[1] = a.PicX[2];
		PPH.sy[1] = a.PicY[2];
		PPH.ex[1] = LCPH.sx[2];
		PPH.ey[1] = LCPH.sy[2];
		pp(&PPH);
		L1 = PPH.l;
		/* å (a.PicX[2] , a.PicY[2]) 
		 *  2 (LCPH.SX[3] , LCPH.SY[3]) εΥ L2 롣
		 */
		PPH.sx[1] = a.PicX[2];
		PPH.sy[1] = a.PicY[2];
		PPH.ex[1] = LCPH.sx[3];
		PPH.ey[1] = LCPH.sy[3];
		pp(&PPH);
		L2 = PPH.l;
		/* ɤäθå˶ᤤ
		 * ᤫä(PointX,PointY)
		 */

		/*  1 ᤤ */
		if (L1 < L2) {
			/* ᤿ (LCPH.SX[2] , LCPH.SY[2]) */
			*x = LCPH.sx[2];
			*y = LCPH.sy[2];
			return 1;
		}
		/*  2 ᤤ */
		else/* if (L1 > L2)*/ {
			/* ᤿ (LCPH.SX[3] , LCPH.SY[3]) */
			*x = LCPH.sx[3];
			*y = LCPH.sy[3];
			return 1;
		}
	}
	return 0;
}





/* -------------------------------------------------------------------
 * ȥ¹
 */
int TrimL_Run(struct TrimDat *a, double x, double y)
{
	struct RtnDat PPH, LAH;
	double L;						/* ȥ޷()γ pic1 εΥ */
	double CL;						/* ȥ޷()γȥȥεΥ */
	double SenA;					/* ȥ޷()γ齪λޤǤγ */
	double ClickA;					/* ȥ޷()γȥޤǤγ */


	/* -----------------------------------------------------------
	 * ȥ¹
	 *  (x , y)
	 *  (a.TraceData[1].sx , a.TraceData[1].sy) εΥ L 롣
	 */
	PPH.sx[1] = a->TraceData[1].sx;
	PPH.sy[1] = a->TraceData[1].sy;
	PPH.ex[1] = a->PicX[1];
	PPH.ey[1] = a->PicY[1];
	pp(&PPH);
	L = PPH.l;

	/* ȸ (x , y) εΥ CL 롣 */
	PPH.sx[1] = a->TraceData[1].sx;
	PPH.sy[1] = a->TraceData[1].sy;
	PPH.ex[1] = x;
	PPH.ey[1] = y;
	pp(&PPH);
	CL = PPH.l;

	/* ȥ޷ˤγ SenA 롣 */
	LAH.sx[1] = a->TraceData[1].sx;
	LAH.sy[1] = a->TraceData[1].sy;
	LAH.ex[1] = a->TraceData[1].ex;
	LAH.ey[1] = a->TraceData[1].ey;
	la(&LAH);
	SenA = LAH.angle;

	/* ȥ޷ˤλޤǤγ ClickA 롣 */
	LAH.sx[1] = a->TraceData[1].sx;
	LAH.sy[1] = a->TraceData[1].sy;
	LAH.ex[1] = x;
	LAH.ey[1] = y;
	la(&LAH);
	ClickA = LAH.angle;

	/* γ٤ȥޤǤγ٤Ʊ */
	if (sg(SenA, compa_digits-2) == sg(ClickA, compa_digits-2)) {
		/*  */
		if (L < CL) {
			a->TraceData[1].ex = sg(x, calcu_digits);
			a->TraceData[1].ey = sg(y, calcu_digits);
		}
		/* 饨 */
		if (L > CL) {
			a->TraceData[1].sx = sg(x, calcu_digits);
			a->TraceData[1].sy = sg(y, calcu_digits);
		}
	}

	/* γ٤ȥޤǤγ٤㤦򿭤Ф */
	else { //if (sg(SenA, compa_digits) != sg(ClickA, compa_digits)) {
		a->TraceData[1].sx = x;
		a->TraceData[1].sy = y;
	}

	return 1;
}





/* -------------------------------------------------------------------
 * ȥह
 *	
 *	
 * 
 * 1 : ȥ޷                                        error
 *      ޷(Ƕǥȥ)     TrimL_Point       -1
 *      ޷                     TrimL_Line        -2
 *      ޷߸̤ޤϱ           TrimL_AC          -3
 * 2 : ȥ¹
 * -------------------------------------------------------------------
 */
int TrimL(struct TrimDat *a, double *x, double *y)
{
//	double PointX = 0, PointY = 0;	/* ȥहɸ */
	int Ret;
	char str[256];


	/* -----------------------------------------------------
	 * 1 : ȥ޷
	 */
	if (a->TraceData[1].code == 1 ) {
		/*  ޷ */
		if (a->TraceData[2].code == 0 ) {
			/* ȥ޷()ȶ޷()κǶ */
			Ret = TrimL_Point(*a, x, y);
			if (Ret == 0) {
				strcpy(str, "Trim : error : ");
				strcat(str, _("There is not a point of intersection."));
				strcat(str, " (Line & Point)");
				g_print("%s\n", str);
				return 0;
			}
		}
		/*  ޷ */
		else if (a->TraceData[2].code == 1 ) {
			/* ȥ޷()ȶ޷()θ */
			Ret = TrimL_Line(*a, x, y);
			if (Ret == 0) {
				strcpy(str, "Trim : error : ");
				strcat(str, _("There is not a point of intersection."));
				strcat(str, " (Line & Line)");
				g_print("%s\n", str);
				return 0;
			}
		}
		/*  ޷߸̤ޤϱ */
		else if (a->TraceData[2].code == 2 || a->TraceData[2].code == 4) {
			/* ȥ޷()ȶ޷()θ */
			Ret = TrimL_AC(*a, x, y);
			if (Ret == 0) {
				strcpy(str, "Trim : error : ");
				strcat(str, _("There is not a point of intersection."));
				strcat(str, " (Line & Circle)");
				g_print("%s\n", str);
				return 0;
			}
		}
		/*  ޷ʱ */
		else if (a->TraceData[2].code == 16) {
			/* ȥ޷()ȶ޷()θ */
			Ret = TrimL_E(*a, x, y);
			if (Ret == 0) {
				strcpy(str, "Trim : error : ");
				strcat(str, _("There is not a point of intersection."));
				strcat(str, " (Line & Ellipse)");
				g_print("%s\n", str);
				return 0;
			}
		}

		/* -----------------------------------------------------------
		 * ȥ¹
		 */
//		return TrimL_Run(a, PointX, PointY);
	}
	return 1;
}





/* -------------------------------------------------------------------
 * ߸̤αĹ
 *	
 * ȥȤƤʬϡΤޤޱĹȱߤˤʤʬǡ
 * ưɤ뤫ǺǤ뤱ɡȤꤢ⤷ʤǤ
 *	
 */
int TrimA_Pull(struct TrimDat *a, double x, double y)
{
	struct RtnDat PPH;
	double CSL, CEL;

	/* ȽΥå˶ᤤü򿭤Ф
	 * åޤǤεΥ
	 */
	PPH.sx[1] = a->PicX[1];
	PPH.sy[1] = a->PicY[1];
	PPH.ex[1] = a->TraceData[1].sx;
	PPH.ey[1] = a->TraceData[1].sy;
	pp(&PPH);
	CSL = PPH.l;
	/* å齪ޤǤεΥ */
	PPH.sx[1] = a->PicX[1];
	PPH.sy[1] = a->PicY[1];
	PPH.ex[1] = a->TraceData[1].ex;
	PPH.ey[1] = a->TraceData[1].ey;
	pp(&PPH);
	CEL = PPH.l;
	/* ǡˡä
	 * ǡ
	 * å˶ᤤ()
	 */
	if (CSL < CEL) {
		/* ȽλƱʤ */
		if (sg(x, compa_digits) == sg(a->TraceData[1].ex, compa_digits)
			&& sg(y, compa_digits) == sg(a->TraceData[1].ey, compa_digits))
		{
/*
			Ret = MessageBox(NULL,	(LPCSTR)"ȽλƱǤ\nߤˤޤ", 
								(LPCSTR)"ǧ" ,	
								MB_YESNO | MB_ICONQUESTION);
			if (Ret == IDYES) {
				a->TraceData[1].code = 4;
				a->TraceData[1].sx = 0;
				a->TraceData[1].sy = 0;
				a->TraceData[1].ex = 0;
				a->TraceData[1].ey = 0;
			}
			else
*/
			return 0;
		}
		else {
			a->TraceData[1].sx = sg(x, calcu_digits);
			a->TraceData[1].sy = sg(y, calcu_digits);
			return 1;
		}
	}


	/* å˶ᤤ(λ) */
	else if (CSL > CEL) {
		/* ȳƱʤߤˤ롣*/
		if (sg(a->TraceData[1].sx, compa_digits) == sg(x, compa_digits) 
			&& sg(a->TraceData[1].sy, compa_digits) == sg(y, compa_digits)) 
		{
/*
			Ret = MessageBox(NULL,	(LPCSTR)"ȳƱǤ\nߤˤޤ", 
								(LPCSTR)"ǧ" ,	
								MB_YESNO | MB_ICONQUESTION);
			if (Ret == IDYES) {
				a->TraceData[1].code = 4;
				a->TraceData[1].sx = 0;
				a->TraceData[1].sy = 0;
				a->TraceData[1].ex = 0;
				a->TraceData[1].ey = 0;
			}
			else
*/
			return 0;
		}
		else {
			a->TraceData[1].ex = sg(x, calcu_digits);
			a->TraceData[1].ey = sg(y, calcu_digits);
			return 1;
		}
	}
	return 0;
}





/* -------------------------------------------------------------------
 * ߸̤Υȥ¹
 *	
 */
int TrimA_Run(struct TrimDat *a, double x, double y)
{
	struct RtnDat LAH;
	double SA, EA, PA, KA;


	/* -----------------------------------------------------------
	 * ߸̥ȥ¹
	 */
	/* ߸̤ SA & EA  */
	SA = Arc_SE_Angle(a->TraceData[1], 0);
	EA = Arc_SE_Angle(a->TraceData[1], 1);
	/* 濴(PointX,PointY)ޤǤγ PA 롣*/
	LAH.sx[1] = a->TraceData[1].cx;
	LAH.sy[1] = a->TraceData[1].cy;
	LAH.ex[1] = x;
	LAH.ey[1] = y;
	la(&LAH);
	PA = sg(LAH.angle, calcu_digits);


	/* ߸̤Υȥ ------------------------------------
	 * 濴ޤǤγ PA
	 * 濴饯åޤǤγ KA롣
	 */
	LAH.sx[1] = a->TraceData[1].cx;
	LAH.sy[1] = a->TraceData[1].cy;
	LAH.ex[1] = a->PicX[1];
	LAH.ey[1] = a->PicY[1];
	la(&LAH);
	KA = sg(LAH.angle, calcu_digits);


	if (SA > EA)	EA = EA + 360;
	if (PA < SA)	PA = PA + 360;
	if (KA < SA)	KA = KA + 360;
	
	/* ǡˡä
	 * SelectColor = 2
	 * SelectCadDraw (A.TraceNumber[1])
	 */
	/* KA<PA */
	if (KA < PA) {
		/* ȳƱʤߤˤ롣*/
		if (sg(a->TraceData[1].sx, compa_digits) == sg(x, compa_digits) 
			&& sg(a->TraceData[1].sy, compa_digits) == sg(y, compa_digits)) 
		{
/*
			Ret = MessageBox(NULL,	(LPCSTR)"ȳƱǤ\nߤˤޤ", 
								(LPCSTR)"ǧ" ,	
								MB_YESNO | MB_ICONQUESTION);
			if (Ret == IDYES) {
				a->TraceData[1].code = 4;
				a->TraceData[1].sx = 0;
				a->TraceData[1].sy = 0;
				a->TraceData[1].ex = 0;
				a->TraceData[1].ey = 0;
			}
			else
*/
			return 0;
		}
		else {
			a->TraceData[1].ex = sg(x, calcu_digits);
			a->TraceData[1].ey = sg(y, calcu_digits);
			return 1;
		}
	}
	/* KA > PA饨 */
	if (KA > PA) {
		/* ȳƱʤߤˤ롣*/
		if (sg(a->TraceData[1].ex, compa_digits) == sg(x, compa_digits) 
			&& sg(a->TraceData[1].ey, compa_digits) == sg(y, compa_digits)) 
		{
/*
			Ret = MessageBox(NULL,	(LPCSTR)"ȽλƱǤ\nߤˤޤ", 
								(LPCSTR)"ǧ" ,	
								MB_YESNO | MB_ICONQUESTION);
			if (Ret == IDYES) {
				a->TraceData[1].code = 4;
				a->TraceData[1].sx = 0;
				a->TraceData[1].sy = 0;
				a->TraceData[1].ex = 0;
				a->TraceData[1].ey = 0;
			}
			else
*/
			return 0;
		}
		else {
			a->TraceData[1].sx = sg(x, calcu_digits);
			a->TraceData[1].sy = sg(y, calcu_digits);
			return 1;
		}
	}
	return 0;
}





/* -------------------------------------------------------------------
 * ߸̤ȥह
 *	
 *  : int	 ERR : 0   OK : 1  Ĺ : 2
 *	
 * 
 * ȥ޷߸̤ʤ
 * 		  ޷(Ƕǥȥ)
 * 		  ޷
 * 		  ޷߸̤ޤϱ
 *	
 * 
 * 		  ߸̤αĹȥθ롣
 *	
 *  SA & EA δ֤ˤʤȤϡå(pic2)˶ᤤü򿭤Ф
 * -------------------------------------------------------------------
 */
int TrimA(struct TrimDat *a, double *x, double *y)
{
	struct RtnDat LAH;
	double SA, EA, PA;
	char str[256];


	/* -----------------------------------------------------
	 * 2 : ȥ޷߸
	 */
	if (a->TraceData[1].code == 2) {
		/*  ޷ */
		if (a->TraceData[2].code == 0) {
			if (TrimC_Point(*a, x, y, 2) == 0) {
				strcpy(str, "Trim : error : ");
				strcat(str, _("There is not a point of intersection."));
				strcat(str, " (ARC & Point)");
				g_print("%s\n", str);
				return 0;
			}
		}
		/*  ޷ */
		if (a->TraceData[2].code == 1) {
			if (TrimC_Line(*a, x, y, 2) == 0) {
				strcpy(str, "Trim : error : ");
				strcat(str, _("There is not a point of intersection."));
				strcat(str, " (ARC & Line)");
				g_print("%s\n", str);
				return 0;
			}
		}
		/*  ޷߸̤ޤϱ */
		if (a->TraceData[2].code == 2 || a->TraceData[2].code == 4) {
			if (TrimC_AC(*a, x, y, 2) == 0) {
				strcpy(str, "Trim : error : ");
				strcat(str, _("There is not a point of intersection."));
				strcat(str, " (ARC & (ARC or Circle))");
				g_print("%s\n", str);
				return 0;
			}
		}
		/*  ޷ʱ */
		if (a->TraceData[2].code == 16) {
			/* ȥ޷()ȶ޷(ʱ)θ */
			if (TrimC_Ellipse(*a, x, y, 2) == 0) {
				strcpy(str, "Trim : error : ");
				strcat(str, _("There is not a point of intersection."));
				strcat(str, " (Circle & Ellipse)");
				g_print("%s\n", str);
				return 0;
			}
		}



		/* -----------------------------------------------------------
		 * ߸̥ȥ¹
		 */
		/* ߸̤ SA & EA  */
		SA = Arc_SE_Angle(a->TraceData[1], 0);
		EA = Arc_SE_Angle(a->TraceData[1], 1);
		/* 濴(PointX,PointY)ޤǤγ PA 롣*/
		LAH.sx[1] = a->TraceData[1].cx;
		LAH.sy[1] = a->TraceData[1].cy;
		LAH.ex[1] = *x;
		LAH.ey[1] = *y;
		la(&LAH);
		PA = sg(LAH.angle, calcu_digits);


		/* ߸̤αĹ --------------------------------------
		 * ߸̾ˤʤȤ
		 */
		if ( 
			((SA < EA) 
			&& (sg(PA, calcu_digits) < sg(SA, calcu_digits) 
			|| sg(PA, calcu_digits) > sg(EA, calcu_digits)))
			|| ((SA > EA) 
			&& (sg(PA, calcu_digits) <= sg(SA, calcu_digits) 
			&& sg(PA, calcu_digits) > sg(EA, calcu_digits)))
			)
		{
			return 2;
			//TrimA_Pull(a, PointX, PointY);
		}


		/* ߸̤Υȥ ------------------------------------
		 * 濴ޤǤγ PA
		 * 濴饯åޤǤγ KA롣
		 */
		return 1;
		//TrimA_Run(a, PointX, PointY, SA, EA, PA);
	}
	return 0;
}





/* -------------------------------------------------------------------
 * CAD DATA α߸̥ǡ顢SA EA 
 *	
 *  : CAD Data, int Frag = (0:SA	1:EA)
 *  : double (Deg)
 */
double Arc_SE_Angle(CAD Data, int Frag)
{
	struct RtnDat rtn;

	/* SA */
	if (Frag == 0) {
		rtn.sx[1] = Data.cx;
		rtn.sy[1] = Data.cy;
		rtn.ex[1] = Data.sx;
		rtn.ey[1] = Data.sy;
		la(&rtn);
		return (rtn.angle);
	}

	/* EA */
	else if (Frag == 1) {
		rtn.sx[1] = Data.cx;
		rtn.sy[1] = Data.cy;
		rtn.ex[1] = Data.ex;
		rtn.ey[1] = Data.ey;
		la(&rtn);
		return (rtn.angle);
	}
	return 0;
}





/* -------------------------------------------------------------------
 * ߤȥहؿΥ
 *	
 * ޷ frag 
 */
int TrimC_Point(struct TrimDat a, double *x, double *y, int frag)
{
	struct RtnDat LAH , PAPH;

	/* ߤ濴˸γ٣롣 */
	LAH.sx[1] = a.TraceData[1].cx;
	LAH.sy[1] = a.TraceData[1].cy;
	LAH.ex[1] = a.TraceData[frag].sx;
	LAH.ey[1] = a.TraceData[frag].sy;
	la(&LAH);
	/* ߤ濴٣Ⱦ¤εΥˤ */
	PAPH.sx[1] = a.TraceData[1].cx;
	PAPH.sy[1] = a.TraceData[1].cy;
	PAPH.angle = LAH.angle;
	PAPH.l = a.TraceData[1].r;
	pap(&PAPH);
	*x = PAPH.ex[1];
	*y = PAPH.ey[1];
	return 1;
}





/* -------------------------------------------------------------------
 * ߤȥहؿΥ
 *	
 * ޷ frag 
 */
int TrimC_Line(struct TrimDat a, double *x, double *y, int frag)
{
	struct RtnDat LCPH, PPH;
	double L1, L2;
	char str[256];


	/*	*/
	LCPH.cx[1] = a.TraceData[1].cx;
	LCPH.cy[1] = a.TraceData[1].cy;
	LCPH.r[1]  = a.TraceData[1].r;
	LCPH.sx[1] = a.TraceData[frag].sx;
	LCPH.sy[1] = a.TraceData[frag].sy;
	LCPH.ex[1] = a.TraceData[frag].ex;
	LCPH.ey[1] = a.TraceData[frag].ey;
	lcp(&LCPH);	 // (LCPH.SX[2],LCPH.SY[2])(LCPH.SX[3],LCPH.SY[3])

	/* ʤʤ顣 */
	if (LCPH.type == 0 ) {
		strcpy(str, "TrimC-1 : error : ");
		strcat(str, _("There is not a point of intersection."));
		g_print("%s\n", str);
		return 0;
	}

	/* 	  (LCPH.SX[2],LCPH.SY[2]) */
	else if (LCPH.type == 1 ) {
		/* (LCPH.SX[2],LCPH.SY[2]) */
		*x = LCPH.sx[2];
		*y = LCPH.sy[2];
		return 1;
	}

	/* 	  (LCPH.SX[2],LCPH.SY[2])(LCPH.SX[3],LCPH.SY[3]) */
	else if (LCPH.type == 2 ) {
		/* å(A.PicX[2],A.PicY[2])ȸ(LCPH.SX[2],LCPH.SY[2])εΥ */
		PPH.sx[1] = a.PicX[frag];
		PPH.sy[1] = a.PicY[frag];
		PPH.ex[1] = LCPH.sx[2];
		PPH.ey[1] = LCPH.sy[2];
		pp(&PPH);
		L1 = PPH.l;
		/* å(A.PicX[2],A.PicY[2])ȸ(LCPH.SX[3],LCPH.SY[3])εΥ롣 */
		PPH.sx[1] = a.PicX[frag];
		PPH.sy[1] = a.PicY[frag];
		PPH.ex[1] = LCPH.sx[3];
		PPH.ey[1] = LCPH.sy[3];
		pp(&PPH);
		L2 = PPH.l;
		/* ɤäθå˶ᤤ */
		if (L1 < L2) {
			*x = LCPH.sx[2];
			*y = LCPH.sy[2];
			return 1;
		}
		else if (L1 > L2) {
			*x = LCPH.sx[3];
			*y = LCPH.sy[3];
			return 1;
		}
		/* ᤫä(PointX,PointY) */
	}
	return 0;
}





/* -------------------------------------------------------------------
 * ߤ߸̤ޤϱߤǥȥहؿΥ
 * 
 */
int TrimC_AC(struct TrimDat a, double *x, double *y, int frag)
{
	struct RtnDat PPH, CCPH;
	double L1, L2;
	char str[256];

	/* ߤȱߤθ롣 */
	CCPH.cx[1] = a.TraceData[1].cx;
	CCPH.cy[1] = a.TraceData[1].cy;
	CCPH.r[1] = a.TraceData[1].r;
	CCPH.cx[2] = a.TraceData[frag].cx;
	CCPH.cy[2] = a.TraceData[frag].cy;
	CCPH.r[2] = a.TraceData[frag].r;
	ccp(&CCPH);	 /* (CCPH.SX[1],CCPH.SY[1])(CCPH.SX[2],CCPH.SY[2]) */

	/* ʤʤ顣 */
	if (CCPH.type == 0 ) {
		strcpy(str, "TrimC-3 : error : ");
		strcat(str, _("There is not a point of intersection."));
		g_print("%s\n", str);
		return 0;
	}

	/* ĤΤȤ */
	else if (CCPH.type == 1 ) {
		/* (CCPH.SX[1],CCPH.SY[1]) */
		*x = CCPH.sx[1];
		*y = CCPH.sy[1];
		return 1;
	}

	/* ĤΤȤ */
	else if (CCPH.type == 2 ) {
		/* å(A.PicX[2],A.PicY[2])ȸ(LCPH.SX[2],LCPH.SY[2])εΥ롣 */
		PPH.sx[1] = a.PicX[frag];
		PPH.sy[1] = a.PicY[frag];
		PPH.ex[1] = CCPH.sx[1];
		PPH.ey[1] = CCPH.sy[1];
		pp(&PPH);
		L1 = PPH.l;
		/* å(A.PicX[2],A.PicY[2])ȸ(LCPH.SX[3],LCPH.SY[3])εΥ롣 */
		PPH.sx[1] = a.PicX[frag];
		PPH.sy[1] = a.PicY[frag];
		PPH.ex[1] = CCPH.sx[2];
		PPH.ey[1] = CCPH.sy[2];
		pp(&PPH);
		L2 = PPH.l;
		/* ɤäθå˶ᤤ */
		if (L1 < L2) {
			*x = CCPH.sx[1];
			*y = CCPH.sy[1];
			return 1;
		}
		else if (L1 > L2) {
			*x = CCPH.sx[2];
			*y = CCPH.sy[2];
			return 1;
		}
		/* ᤫä(PointX,PointY) */
	}
	return 0;
}





/* -------------------------------------------------------------------
 * ߤʱߤǥȥहؿΥ
 * 
 */
int TrimC_Ellipse(struct TrimDat a, double *x, double *y, int frag)
{
	struct RtnDat PPH, rtn;
	double min_value;
	int i, min;
	ELLIPSE ellipseA;
	char str[256];


	/* ʱߤȱߤθ롣 */
	ellipseA.cx = a.TraceData[1].cx;
	ellipseA.cy = a.TraceData[1].cy;
	ellipseA.dx = a.TraceData[1].r;
	ellipseA.dy = 0;
	ellipseA.k = 1;
	ellipseA.sa = 0;
	ellipseA.ea = 360;

	ellipse_on_ellipse(&rtn, ellipseA, a.ellipse[frag]);

	/* ʤʤ顣 */
	if (rtn.type == 0 ) {
		strcpy(str, "TrimC-Ellipse() : error : ");
		strcat(str, _("There is not a point of intersection."));
		g_print("%s\n", str);
		return 0;
	}

	/*  n ĤΤȤ */
	else if (rtn.type > 0 ) {
		min = 0;
		min_value = 0;
		for (i = 1 ; i < rtn.type + 1 ; i++) {
			/* å(A.PicX[2],A.PicY[2])ȸ(LCPH.SX[2],LCPH.SY[2])εΥ롣 */
			PPH.sx[1] = a.PicX[frag];
			PPH.sy[1] = a.PicY[frag];
			PPH.ex[1] = rtn.sx[i];
			PPH.ey[1] = rtn.sy[i];
			pp(&PPH);
			if (min == 0 || min_value > PPH.l) {
				min = i;
				min_value = PPH.l;
			}
		}

		if (min == 0) {
			return 0;
		}

		else {
			*x = rtn.sx[min];
			*y = rtn.sy[min];
			//g_print("TrimC_Ellipse() : (%f,%f)\n", *x, *y);
			return 1;
		}
	}

	return 0;
}





/* -------------------------------------------------------------------
 *  : ߤȥह
 * ؿ : TrimC
 *  : struct TrimDat *
 *  : int
 *		: ERR : 0	 OK : 1
 *  : ̵
 *  : ̵
 *		: 
 * -------------------------------------------------------------------
 * 
 * 1 : ȥ޷
 *		 ޷ 2 
 *		 ޷ 3 
 *		 ޷ 2 
 *		 ޷ 3 
 *		 ޷ 2 ߸̤ޤϱ
 *		 ޷ 3 ߸̤ޤϱ
 *	
 */
int TrimC(struct TrimDat *a, double *x1, double *y1, double *x2, double *y2)
{
	char str[256];


	/*  ޷ 2  */
	if (a->TraceData[2].code == 0 ) {
		if (TrimC_Point(*a, x1, y1, 2) == 0)
			return 0;
	}
	/*  ޷ 3  */
	if (a->TraceData[3].code == 0 ) {
		if (TrimC_Point(*a, x2, y2, 3) == 0)
			return 0;
	}
	/*  ޷ 2  */
	if (a->TraceData[2].code == 1 ) {
		if (TrimC_Line(*a, x1, y1, 2) == 0)
			return 0;
	}
	/*  ޷ 3  */
	if (a->TraceData[3].code == 1 ) {
		if (TrimC_Line(*a, x2, y2, 3) == 0)
			return 0;
	}
	/*  ޷2߸ */
	if (a->TraceData[2].code == 2 || a->TraceData[2].code == 4 ) {
		if (TrimC_AC(*a, x1, y1, 2) == 0)
			return 0;
	}
	/*  ޷ 3 ߸ */
	if (a->TraceData[3].code == 2 || a->TraceData[3].code == 4 ) {
		if (TrimC_AC(*a, x2, y2, 3) == 0)
			return 0;
	}
	/*  ޷ 2 ʱ */
	if (a->TraceData[2].code == 16) {
		/* ȥ޷()ȶ޷()θ */
		if (TrimC_Ellipse(*a, x1, y1, 2) == 0) {
			strcpy(str, "Trim : error : ");
			strcat(str, _("There is not a point of intersection."));
			strcat(str, " (Circle & Ellipse)");
			g_print("%s\n", str);
			return 0;
		}
	}
	/*  ޷ 3 ʱ */
	if (a->TraceData[3].code == 16) {
		/* ȥ޷()ȶ޷()θ */
		if (TrimC_Ellipse(*a, x2, y2, 3) == 0) {
			strcpy(str, "Trim : error : ");
			strcat(str, _("There is not a point of intersection."));
			strcat(str, " (Circle & Ellipse)");
			g_print("%s\n", str);
			return 0;
		}
	}


	return 1;
}





/* -------------------------------------------------------------------
 *  : ߤȥह
 * ؿ : TrimC_Run
 *  : struct TrimDat *
 *  : int
 *		: ERR : 0	 OK : 1
 *  : ̵
 *  : ̵
 *		: 
 * -------------------------------------------------------------------
 * 
 * 1 : ȥ޷
 *		 ޷ 2 
 *		 ޷ 3 
 *		 ޷ 2 
 *		 ޷ 3 
 *		 ޷ 2 ߸̤ޤϱ
 *		 ޷ 3 ߸̤ޤϱ
 *	
 */
int TrimC_Run(struct TrimDat *a, double *x1, double *y1, double *x2, double *y2)
{
	struct RtnDat LAH;
	double K1A, K2A, CA;


	/* ---------------------------------------------------------------
	 * ߥȥ¹
	 * 
	 *  ( PointX , PointY ) ( PointX2 , PointY2 )
	 */
	/*  ( PointX , PointY ) γ K1A 롣 */
	LAH.sx[1] = a->TraceData[1].cx;
	LAH.sy[1] = a->TraceData[1].cy;
	LAH.ex[1] = *x1;
	LAH.ey[1] = *y1;
	la(&LAH);
	K1A = LAH.angle;
	/*  ( PointX2 , PointY2 ) γ K2A 롣 */
	LAH.sx[1] = a->TraceData[1].cx;
	LAH.sy[1] = a->TraceData[1].cy;
	LAH.ex[1] = *x2;
	LAH.ey[1] = *y2;
	la(&LAH);
	K2A = LAH.angle;
	/* å ( A.PicX[1] , A.PicY[1] ) γ CA 롣 */
	LAH.sx[1] = a->TraceData[1].cx;
	LAH.sy[1] = a->TraceData[1].cy;
	LAH.ex[1] = a->PicX[1];
	LAH.ey[1] = a->PicY[1];
	la(&LAH);
	CA = LAH.angle;

	/* ǡˡä */
	if (K1A < CA && CA < K2A ) {
		/* START(PointX,PointY)	  END(PointX2,PointY2) */
		a->TraceData[1].code = 2;
		a->TraceData[1].sx = *x1;
		a->TraceData[1].sy = *y1;
		a->TraceData[1].ex = *x2;
		a->TraceData[1].ey = *y2;
	}
	else if (K2A < CA && CA < K1A ) {
		/* START(PointX2,PointY2)	END(PointX,PointY) */
		a->TraceData[1].code = 2;
		a->TraceData[1].sx = *x2;
		a->TraceData[1].sy = *y2;
		a->TraceData[1].ex = *x1;
		a->TraceData[1].ey = *y1;
	}
	else if (((CA > K1A && CA > K2A) || (CA < K1A && CA < K2A)) && K2A > K1A) {
		/* START(PointX2,PointY2)	END(PointX,PointY) */
		a->TraceData[1].code = 2;
		a->TraceData[1].sx = *x2;
		a->TraceData[1].sy = *y2;
		a->TraceData[1].ex = *x1;
		a->TraceData[1].ey = *y1;
	}
	else if (((CA > K1A && CA > K2A) || (CA < K1A && CA < K2A)) && K2A < K1A) {
		/* START(PointX,PointY)	  END(PointX2,PointY2) */
		a->TraceData[1].code = 2;
		a->TraceData[1].sx = *x1;
		a->TraceData[1].sy = *y1;
		a->TraceData[1].ex = *x2;
		a->TraceData[1].ey = *y2;
	}
	return 1;
}










/* -------------------------------------------------------------------
 * ʱߤǥȥहؿΥ
 * 
 * ޷ frag 
 */
int TrimE_Point(struct TrimDat a, double *x, double *y, int frag)
{
	POINT point;
	double angle;


	/* ߤ濴˸γ٣롣 */
	point.x = a.TraceData[frag].sx;
	point.y = a.TraceData[frag].sy;
	angle = get_ellipse_angle_from_point (a.ellipse[1], point);

	point.x = 0;
	point.y = 0;
	get_ellipse_point_from_angle (a.ellipse[1], angle, &point);
	*x = point.x;
	*y = point.y;

	return 1;
}





/* -------------------------------------------------------------------
 * ʱߤȥहؿΥ
 * 
 * ޷ frag 
 */
int TrimE_Line(struct TrimDat a, double *x, double *y, int frag)
{
	struct RtnDat rtn, PPH;
	double L1, L2;
	char str[256];


	/* -------------------------------------------------------------------
	 * ʱߤθ
	 * lep
	 * RtnDat
	 *      : (sx[1],sy[1]) - (ex[1],ey[1])
	 *   ʱ : 
	 * RtnDat
	 *   type	0 , 1 , 2
	 *    1	(sx[2],sy[2])
	 *    2	(sx[3],sy[3])
	 */

	/* ȥ޷()ȶ޷()θ */
	rtn.sx[1] = a.TraceData[frag].sx;
	rtn.sy[1] = a.TraceData[frag].sy;
	rtn.ex[1] = a.TraceData[frag].ex;
	rtn.ey[1] = a.TraceData[frag].ey;
	lep(&rtn, a.ellipse[1], 10);

	/* ʤʤ顣 */
	if (rtn.type == 0 ) {
		strcpy(str, "TrimE-Line : error : ");
		strcat(str, _("There is not a point of intersection."));
		g_print("%s\n", str);
		return 0;
	}

	/* 	  (rtn.SX[2],rtn.SY[2]) */
	else if (rtn.type == 1 ) {
		/* (rtn.SX[2],rtn.SY[2]) */
		*x = rtn.sx[2];
		*y = rtn.sy[2];
//		g_print("TrimE_Line() : 1 (%f,%f)\n", rtn.sx[2], rtn.sy[2]);
		return 1;
	}

	/* 	  (rtn.SX[2],rtn.SY[2])(rtn.SX[3],rtn.SY[3]) */
	else if (rtn.type == 2 ) {
		/* å(A.PicX[2],A.PicY[2])ȸ(rtn.SX[2],rtn.SY[2])εΥ */
		PPH.sx[1] = a.PicX[frag];
		PPH.sy[1] = a.PicY[frag];
		PPH.ex[1] = rtn.sx[2];
		PPH.ey[1] = rtn.sy[2];
		pp(&PPH);
		L1 = PPH.l;
		/* å(A.PicX[2],A.PicY[2])ȸ(rtn.SX[3],rtn.SY[3])εΥ롣 */
		PPH.sx[1] = a.PicX[frag];
		PPH.sy[1] = a.PicY[frag];
		PPH.ex[1] = rtn.sx[3];
		PPH.ey[1] = rtn.sy[3];
		pp(&PPH);
		L2 = PPH.l;

//		g_print("TrimE_Line() : 1(%f,%f),%f   2(%f,%f),%f   P(%f,%f)\n", 
//				rtn.sx[2], rtn.sy[2], L1, 
//				rtn.sx[3], rtn.sy[3], L2, 
//				a.PicX[frag], a.PicY[frag]);

		/* ɤäθå˶ᤤ */
		if (L1 < L2) {
			*x = rtn.sx[2];
			*y = rtn.sy[2];
//			g_print("TrimE_Line() : Ans (%f,%f)\n", rtn.sx[2], rtn.sy[2]);
			return 1;
		}
		else if (L1 > L2) {
			*x = rtn.sx[3];
			*y = rtn.sy[3];
//			g_print("TrimE_Line() : Ans (%f,%f)\n", rtn.sx[3], rtn.sy[3]);
			return 1;
		}
		/* ᤫä(PointX,PointY) */
	}
	return 0;
}





/* -------------------------------------------------------------------
 * ʱߤ߸̤ޤϱߤǥȥहؿΥ
 * 
 */
int TrimE_AC(struct TrimDat a, double *x, double *y, int frag)
{
	struct RtnDat PPH, rtn;
	double min_value;
	int i, min;
	ELLIPSE ellipseB;
	char str[256];


	/* ʱߤȱߤθ롣 */
	ellipseB.cx = a.TraceData[frag].cx;
	ellipseB.cy = a.TraceData[frag].cy;
	ellipseB.dx = a.TraceData[frag].r;
	ellipseB.dy = 0;
	ellipseB.k = 1;
	ellipseB.sa = 0;
	ellipseB.ea = 360;

	ellipse_on_ellipse(&rtn, a.ellipse[1], ellipseB);

	/* ʤʤ顣 */
	if (rtn.type == 0 ) {
		strcpy(str, "TrimE-AC() : error : ");
		strcat(str, _("There is not a point of intersection."));
		g_print("%s\n", str);
		return 0;
	}

	/*  n ĤΤȤ */
	else if (rtn.type > 0 ) {
		min = 0;
		min_value = 0;
		for (i = 1 ; i < rtn.type + 1 ; i++) {
			/* å(A.PicX[2],A.PicY[2])ȸ(LCPH.SX[2],LCPH.SY[2])εΥ롣 */
			PPH.sx[1] = a.PicX[frag];
			PPH.sy[1] = a.PicY[frag];
			PPH.ex[1] = rtn.sx[i];
			PPH.ey[1] = rtn.sy[i];
			pp(&PPH);
			if (min == 0 || min_value > PPH.l) {
				min = i;
				min_value = PPH.l;
			}
		}

		if (min == 0) {
			return 0;
		}

		else {
			*x = rtn.sx[min];
			*y = rtn.sy[min];
			//g_print("TrimE_AC() : (%f,%f)\n", *x, *y);
			return 1;
		}
	}

	return 0;
}





/* -------------------------------------------------------------------
 * ʱߤȥहؿΥ
 * 
 * ޷ frag ʱ
 */
int TrimE_Ellipse(struct TrimDat a, double *x, double *y, int frag)
{
	struct RtnDat PPH, rtn;
	double min_value;
	int i, min;
	char str[256];


	ellipse_on_ellipse(&rtn, a.ellipse[1], a.ellipse[frag]);


	/* ʤʤ顣 */
	if (rtn.type == 0 ) {
		strcpy(str, "TrimE-Ellipse : error : ");
		strcat(str, _("There is not a point of intersection."));
		g_print("%s\n", str);
		return 0;
	}

	/*  n ĤΤȤ */
	else if (rtn.type > 0 ) {
		min = 0;
		min_value = 0;
		for (i = 1 ; i < rtn.type + 1 ; i++) {
			/* å(A.PicX[2],A.PicY[2])ȸ(LCPH.SX[2],LCPH.SY[2])εΥ롣 */
			PPH.sx[1] = a.PicX[frag];
			PPH.sy[1] = a.PicY[frag];
			PPH.ex[1] = rtn.sx[i];
			PPH.ey[1] = rtn.sy[i];
			pp(&PPH);
			if (min == 0 || min_value > PPH.l) {
				min = i;
				min_value = PPH.l;
			}
		}

		if (min == 0) {
			return 0;
		}

		else {
			*x = rtn.sx[min];
			*y = rtn.sy[min];
			//g_print("TrimE_Ellipse() : (%f,%f)\n", *x, *y);
			return 1;
		}
	}

	return 0;
}





/* -------------------------------------------------------------------
 *  : ʱߤȥह
 * ؿ : TrimE
 *  : struct TrimDat *
 *  : int
 *		: ERR : 0	 OK : 1
 *  : ̵
 *  : ̵
 *		: 
 * -------------------------------------------------------------------
 * 
 * 1 : ȥ޷
 *		 ޷ 2 
 *		 ޷ 3 
 *		 ޷ 2 
 *		 ޷ 3 
 *		 ޷ 2 ߸̤ޤϱ
 *		 ޷ 3 ߸̤ޤϱ
 *	
 */
int TrimE(struct TrimDat *a, double *x1, double *y1, double *x2, double *y2)
{
//#define TRIME
	int debug = 0;


#ifdef TRIME
	debug = 1;
#endif


	/*  ޷ 2  */
	if (a->TraceData[2].code == 0 ) {
		if (debug > 0) g_print("TrimE() : 1\n");
		if (TrimE_Point(*a, x1, y1, 2) == 0) {
			if (debug > 0) g_print("TrimE() : 1 : error\n");
			return 0;
		}
	}
	/*  ޷ 3  */
	if (a->TraceData[3].code == 0 ) {
		if (debug > 0) g_print("TrimE() : 2\n");
		if (TrimE_Point(*a, x2, y2, 3) == 0) {
			if (debug > 0) g_print("TrimE() : 2 : error\n");
			return 0;
		}
	}
	/*  ޷ 2  */
	if (a->TraceData[2].code == 1 ) {
		if (debug > 0) g_print("TrimE() : 3\n");
		if (TrimE_Line(*a, x1, y1, 2) == 0) {
			if (debug > 0) g_print("TrimE() : 3 : error\n");
			return 0;
		}
	}
	/*  ޷ 3  */
	if (a->TraceData[3].code == 1 ) {
		if (debug > 0) g_print("TrimE() : 4\n");
		if (TrimE_Line(*a, x2, y2, 3) == 0) {
			if (debug > 0) g_print("TrimE() : 4 : error\n");
			return 0;
		}
	}
	/*  ޷2߸ */
	if (a->TraceData[2].code == 2 || a->TraceData[2].code == 4 ) {
		if (debug > 0) g_print("TrimE() : 5\n");
		if (TrimE_AC(*a, x1, y1, 2) == 0) {
			if (debug > 0) g_print("TrimE() : 5 : error\n");
			return 0;
		}
	}
	/*  ޷ 3 ߸ */
	if (a->TraceData[3].code == 2 || a->TraceData[3].code == 4 ) {
		if (debug > 0) g_print("TrimE() : 6\n");
		if (TrimE_AC(*a, x2, y2, 3) == 0) {
			if (debug > 0) g_print("TrimE() : 6 : error\n");
			return 0;
		}
	}
	/*  ޷ 2 ʱ */
	if (a->TraceData[2].code == 16) {
		if (debug > 0) g_print("TrimE() : 7\n");
		if (TrimE_Ellipse(*a, x1, y1, 2) == 0) {
			if (debug > 0) g_print("TrimE() : 7 : error\n");
			return 0;
		}
	}
	/*  ޷ 3 ʱ */
	if (a->TraceData[3].code == 16) {
		if (debug > 0) g_print("TrimE() : 8\n");
		if (TrimE_Ellipse(*a, x2, y2, 3) == 0) {
			if (debug > 0) g_print("TrimE() : 8 : error\n");
			return 0;
		}
	}

	return 1;
}





/* -------------------------------------------------------------------
 *  : ߤȥह
 * ؿ : TrimC_Run
 *  : struct TrimDat *
 *  : int
 *		: ERR : 0	 OK : 1
 *  : ̵
 *  : ̵
 *		: 
 * -------------------------------------------------------------------
 * 
 * 1 : ȥ޷
 *		 ޷ 2 
 *		 ޷ 3 
 *		 ޷ 2 
 *		 ޷ 3 
 *		 ޷ 2 ߸̤ޤϱ
 *		 ޷ 3 ߸̤ޤϱ
 *	
 */
int TrimE_Run(struct TrimDat *a, double *x1, double *y1, double *x2, double *y2)
{
	double K1A, K2A, CA;
	POINT point;


	/* ---------------------------------------------------------------
	 * ߥȥ¹
	 * 
	 *  ( PointX , PointY ) ( PointX2 , PointY2 )
	 */
	/* 1 ( PointX , PointY ) γ K1A 롣 */
	point.x = *x1;
	point.y = *y1;
	K1A = get_ellipse_angle_from_point (a->ellipse[1], point);

	/* 2 ( PointX2 , PointY2 ) γ K2A 롣 */
	point.x = *x2;
	point.y = *y2;
	K2A = get_ellipse_angle_from_point (a->ellipse[1], point);

	/* å ( A.PicX[1] , A.PicY[1] ) γ CA 롣 */
	point.x = a->PicX[1];
	point.y = a->PicY[1];
	CA = get_ellipse_angle_from_point (a->ellipse[1], point);


	/* ǡˡä */
	if (K1A < CA && CA < K2A ) {
		/* START(PointX,PointY)	  END(PointX2,PointY2) */
		a->ellipse[1].sa = K1A;
		a->ellipse[1].ea = K2A;
	}
	else if (K2A < CA && CA < K1A ) {
		/* START(PointX2,PointY2)	END(PointX,PointY) */
		a->ellipse[1].sa = K2A;
		a->ellipse[1].ea = K1A;
	}
	else if (((CA > K1A && CA > K2A) || (CA < K1A && CA < K2A)) && K2A > K1A) {
		/* START(PointX2,PointY2)	END(PointX,PointY) */
		a->ellipse[1].sa = K2A;
		a->ellipse[1].ea = K1A;
	}
	else if (((CA > K1A && CA > K2A) || (CA < K1A && CA < K2A)) && K2A < K1A) {
		/* START(PointX,PointY)	  END(PointX2,PointY2) */
		a->ellipse[1].sa = K1A;
		a->ellipse[1].ea = K2A;
	}
	return 1;
}





/* -------------------------------------------------------------------
 * ߸̤αĹ
 *	
 * ȥȤƤʬϡΤޤޱĹȱߤˤʤʬǡ
 * ưɤ뤫ǺǤ뤱ɡȤꤢ⤷ʤǤ
 *	
 */
int TrimEA_Pull(struct TrimDat *a, double x, double y)
{
	struct RtnDat PPH;
	double PA, CSL, CEL;
	POINT s_point, e_point, point;


	/* ȽΥå˶ᤤü򿭤Ф
	 * åޤǤεΥ
	 */
	get_ellipse_point_from_angle (a->ellipse[1], a->ellipse[1].sa, &s_point);
	PPH.sx[1] = a->PicX[1];
	PPH.sy[1] = a->PicY[1];
	PPH.ex[1] = s_point.x;
	PPH.ey[1] = s_point.y;
	pp(&PPH);
	CSL = PPH.l;
	/* å齪ޤǤεΥ */
	get_ellipse_point_from_angle (a->ellipse[1], a->ellipse[1].ea, &e_point);
	PPH.sx[1] = a->PicX[1];
	PPH.sy[1] = a->PicY[1];
	PPH.ex[1] = e_point.x;
	PPH.ey[1] = e_point.y;
	pp(&PPH);
	CEL = PPH.l;


	/* 濴(PointX,PointY)ޤǤγ PA 롣*/
	point.x = x;
	point.y = y;
	PA = get_ellipse_angle_from_point (a->ellipse[1], point);


	/* ǡˡä */
	if (CSL < CEL) {
		/* ȽλƱʤ */
		if (sg(a->ellipse[1].ea, compa_digits) == sg(PA, compa_digits)) {
/*
			Ret = MessageBox(NULL,	(LPCSTR)"ȽλƱǤ\nߤˤޤ", 
								(LPCSTR)"ǧ" ,	
								MB_YESNO | MB_ICONQUESTION);
			if (Ret == IDYES) {
				a->TraceData[1].code = 4;
				a->TraceData[1].sx = 0;
				a->TraceData[1].sy = 0;
				a->TraceData[1].ex = 0;
				a->TraceData[1].ey = 0;
			}
			else
*/
			return 0;
		}
		else {
			a->ellipse[1].sa = PA;
			return 1;
		}
	}


	/* å˶ᤤ(λ) */
	else if (CSL > CEL) {
		/* ȳƱʤߤˤ롣*/
		if (sg(a->ellipse[1].sa, compa_digits) == sg(PA, compa_digits)) {
/*
			Ret = MessageBox(NULL,	(LPCSTR)"ȳƱǤ\nߤˤޤ", 
								(LPCSTR)"ǧ" ,	
								MB_YESNO | MB_ICONQUESTION);
			if (Ret == IDYES) {
				a->TraceData[1].code = 4;
				a->TraceData[1].sx = 0;
				a->TraceData[1].sy = 0;
				a->TraceData[1].ex = 0;
				a->TraceData[1].ey = 0;
			}
			else
*/
			return 0;
		}
		else {
			a->ellipse[1].ea = PA;
			return 1;
		}
	}
	return 0;
}





/* -------------------------------------------------------------------
 * ʱ߸̤Υȥ¹
 *	
 */
int TrimEA_Run(struct TrimDat *a, double x, double y)
{
//#define TRIMEA_RUN
	double SA, EA, PA, KA, sa, ea, pa, ka;
	POINT point;
	int debug = 0;


#ifdef TRIMEA_RUN
	debug = 1;
#endif

	/* -----------------------------------------------------------
	 * ߸̥ȥ¹
	 */
	/* ߸̤ SA & EA  */
	SA = a->ellipse[1].sa;
	EA = a->ellipse[1].ea;
	/* 濴(PointX,PointY)ޤǤγ PA 롣*/
	point.x = x;
	point.y = y;
	PA = get_ellipse_angle_from_point (a->ellipse[1], point);
	angle_check(&PA);
	if (debug > 0) g_print("TrimEA_Run() : PA = %f (%f,%f)\n", PA, x, y);

	/* ߸̤Υȥ ------------------------------------
	 * 濴ޤǤγ PA
	 * 濴饯åޤǤγ KA롣
	 */
	point.x = a->PicX[1];
	point.y = a->PicY[1];
	KA = get_ellipse_angle_from_point (a->ellipse[1], point);
	angle_check(&KA);
	if (debug > 0) g_print("TrimEA_Run() : KA = %f (%f,%f)\n", KA, a->PicX[1], a->PicY[1]);


	if (debug > 0) g_print("TrimEA_Run() : SA = %f   EA = %f   PA = %f   KA = %f\n", SA, EA, PA, KA);



	sa = SA;
	ea = EA;
	pa = PA;
	ka = KA;
	if (SA > EA) {
		ea = EA + 360;
		if (SA > PA) pa = PA + 360;
		if (SA > KA) ka = KA + 360;
	}


	/* KA < PA : 鳫 */
	if (ka < pa) {
		if (debug > 0) g_print("TrimEA_Run() : KA < PA : 鳫\n");
		/* ȳƱʤߤˤ롣*/
		if (sg(SA, compa_digits) == sg(PA, compa_digits)) {
			return 0;
		}
		else {
			if (debug > 0) g_print("TrimEA_Run() : λ\n");
			a->ellipse[1].ea = PA;
			return 1;
		}
	}

	/* KA > PA  齪λ */
	if (ka > pa) {
		if (debug > 0) g_print("TrimEA_Run() : KA > PA  齪λ\n");
		/* ȽλƱʤߤˤ롣*/
		if (sg(a->ellipse[1].ea, compa_digits) == sg(PA, compa_digits)) { 
			if (debug > 0) g_print("TrimEA_Run() : ȽλƱ\n");
			return 0;
		}
		else {
			if (debug > 0) g_print("TrimEA_Run() : \n");
			a->ellipse[1].sa = PA;
			return 1;
		}
	}


	return 0;
}





/* -------------------------------------------------------------------
 * ߸̤ȥह
 *	
 *  : int	 ERR : 0   OK : 1  Ĺ : 2
 *	
 * 
 * ȥ޷߸̤ʤ
 * 		  ޷(Ƕǥȥ)
 * 		  ޷
 * 		  ޷߸̤ޤϱ
 *	
 * 
 * 		  ߸̤αĹȥθ롣
 *	
 *  SA & EA δ֤ˤʤȤϡå(pic2)˶ᤤü򿭤Ф
 * -------------------------------------------------------------------
 */
int TrimEA(struct TrimDat *a, double *x, double *y)
{
//#define TRIMEA
	double SA, EA, PA;
	POINT point;
	int debug = 0;
	char str[256];


#ifdef TRIMEA
	debug = 1;
#endif


	/* -----------------------------------------------------
	 * 2 : ȥ޷߸
	 */
	if (a->TraceData[1].code == 16 && a->ellipse[1].code == 1) {
		/*  ޷ */
		if (a->TraceData[2].code == 0) {
			if (debug > 0) g_print("TrimEA() : 1\n");
			if (TrimE_Point(*a, x, y, 2) == 0) {
				strcpy(str, "TrimEA : error : ");
				strcat(str, _("There is not a point of intersection."));
				strcat(str, " (ELLIPSE & Point)");
				g_print("%s\n", str);
				return 0;
			}
		}
		/*  ޷ */
		else if (a->TraceData[2].code == 1) {
			if (debug > 0) g_print("TrimEA() : 2\n");
			if (TrimE_Line(*a, x, y, 2) == 0) {
				strcpy(str, "TrimEA : error : ");
				strcat(str, _("There is not a point of intersection."));
				strcat(str, " (ELLIPSE & Line)");
				g_print("%s\n", str);
				return 0;
			}
		}
		/*  ޷߸̤ޤϱ */
		else if (a->TraceData[2].code == 2 || a->TraceData[2].code == 4) {
			if (debug > 0) g_print("TrimEA() : 3\n");
			if (TrimE_AC(*a, x, y, 2) == 0) {
				strcpy(str, "TrimEA : error : ");
				strcat(str, _("There is not a point of intersection."));
				strcat(str, " (ELLIPSE & (ARC or Circle)");
				g_print("%s\n", str);
				return 0;
			}
		}
		/*  ޷ʱߤޤʱ߸ */
		else if (a->TraceData[2].code == 16) {
			if (debug > 0) g_print("TrimEA() : 4\n");
			if (TrimE_Ellipse(*a, x, y, 2) == 0) {
				strcpy(str, "TrimEA : error : ");
				strcat(str, _("There is not a point of intersection."));
				strcat(str, " (ELLIPSE & (ARC or Circle)");
				g_print("%s\n", str);
				return 0;
			}
		}


		/* -----------------------------------------------------------
		 * ߸̥ȥ¹
		 */
		/* ߸̤ SA & EA  */
		SA = a->ellipse[1].sa;
		EA = a->ellipse[1].ea;
		/* 濴(PointX,PointY)ޤǤγ PA 롣*/
		point.x = *x;
		point.y = *y;
		PA = get_ellipse_angle_from_point (a->ellipse[1], point);


		if (debug > 0) g_print("TrimEA() : SA = %f   EA = %f   PA = %f\n", SA, EA, PA);


		/* ߸̤αĹ --------------------------------------
		 * ߸̾ˤʤȤ
		 */
		if ( 
			(	(SA < EA) && (PA < SA || PA > EA)	)
			|| 
			(	(SA > EA) && (PA < SA && PA > EA)	)
			)
		{
			if (debug > 0) g_print("TrimEA() : ߸̤αĹ\n");
			return 2;
			//TrimA_Pull(a, PointX, PointY);
		}


		/* ߸̤Υȥ ------------------------------------
		 * 濴ޤǤγ PA
		 * 濴饯åޤǤγ KA롣
		 */
		if (debug > 0) g_print("TrimEA() : ߸̤Υȥ\n");
		return 1;
		//TrimA_Run(a, PointX, PointY, SA, EA, PA);
	}
	return 0;
}





/* -------------------------------------------------------------------
 *  : ߸̤ʬ䤹
 * ؿ : Split
 *  : struct TrimDat *
 *  : int  NewData = a->TraceData[3]
 *		: ERR : 0	 OK : 1
 *  : ̵
 *  : ̵
 *		: 
 * -------------------------------------------------------------------
 * 
 * 1 : ȥ޷ 
 * 		 ޷ (Ƕʬ)
 * 		 ޷ 
 * 		 ޷ ߸̤ޤϱ
 * 		 ޷ ʱ߸̤ޤʱ
 * 2 : ȥ޷ ߸
 * 		 ޷ (Ƕʬ)
 * 		 ޷ 
 * 		 ޷ ߸̤ޤϱ
 * 		 ޷ ʱ߸̤ޤʱ
 * 3 : ȥ޷ ʱ߸
 * 		 ޷ (Ƕʬ)
 * 		 ޷ 
 * 		 ޷ ߸̤ޤϱ
 * 		 ޷ ʱ߸̤ޤʱ
 * -------------------------------------------------------------------
 */
int Split(struct TrimDat *a)
{
	char str[256];
	struct RtnDat LAH;
	double PointX, PointY, SA, EA, PA;
	POINT point;


	/* -----------------------------------------------------
	 * 1 : ʬ䤹޷ 
	 */
	if (a->TraceData[1].code == 1) {
		/*  ޷  */
		if (a->TraceData[2].code == 0) {
			if (TrimL_Point(*a, &PointX, &PointY) == 0) {
				strcpy(str, "Split-10 : error : ");
				strcat(str, _("There is not a point of intersection."));
				g_print("%s\n", str);
				return 0;
			}
		}
		/*  ޷  */
		else if (a->TraceData[2].code == 1 ) {
			if (TrimL_Line(*a, &PointX, &PointY) == 0) {
				strcpy(str, "Split-11 : error : ");
				strcat(str, _("There is not a point of intersection."));
				g_print("%s\n", str);
				return 0;
			}
		}
		/*  ޷ ߸̤ޤϱ */
		else if (a->TraceData[2].code == 2 || a->TraceData[2].code == 4) {
			if (TrimL_AC(*a, &PointX, &PointY) == 0) {
				strcpy(str, "Split-12 : error : ");
				strcat(str, _("There is not a point of intersection."));
				g_print("%s\n", str);
				return 0;
			}
		}
		/*  ޷ ʱ߸̤ޤʱ */
		else if (a->TraceData[2].code == 16) {
			if (TrimL_E(*a, &PointX, &PointY) == 0) {
				strcpy(str, "Split-13 : error : ");
				strcat(str, _("There is not a point of intersection."));
				g_print("%s\n", str);
				return 0;
			}
		}


		/* -------------------------------------------------
		 * å
		 */
		if (
				sg(PointX, compa_digits) == sg(a->TraceData[1].sx, compa_digits) 
				&& 
				sg(PointY, compa_digits) == sg(a->TraceData[1].sy, compa_digits)
			) 
		{
			strcpy(str, "Split : error : ");
			strcat(str, _("The division point is the same as the start point."));
			strcat(str, " (LINE)");
			g_print("%s\n", str);
			return 0;
		}
		else if (
					sg(PointX, compa_digits) == sg(a->TraceData[1].ex, compa_digits) 
					&& 
					sg(PointY, compa_digits) == sg(a->TraceData[1].ey, compa_digits)
				) 
		{
			strcpy(str, "Split : error : ");
			strcat(str, _("The division point is the same as the end point."));
			strcat(str, " (LINE)");
			g_print("%s\n", str);
			return 0;

		}


		/* -------------------------------------------------
		 * ʬ¹
		 *  ( PointX , PointY )
		 */
		/* ʬ䤷ƤǤǡ*/
		a->TraceData[3].code = 1;
		a->TraceData[3].layer = a->TraceData[1].layer;
		a->TraceData[3].style = a->TraceData[1].style;
		a->TraceData[3].color = a->TraceData[1].color;
		a->TraceData[3].sx = sg(PointX, calcu_digits);
		a->TraceData[3].sy = sg(PointY, calcu_digits);
		a->TraceData[3].ex = a->TraceData[1].ex;
		a->TraceData[3].ey = a->TraceData[1].ey;

		/* Υǡ */
		a->TraceData[1].ex = sg(PointX, calcu_digits);
		a->TraceData[1].ey = sg(PointY, calcu_digits);
		return 1;
	}





	/* -----------------------------------------------------
	 * 2 : ʬ䤹޷߸
	 */
	else if (a->TraceData[1].code == 2) {
		/*  ޷  */
		if (a->TraceData[2].code == 0 ) {
			if (TrimC_Point(*a, &PointX, &PointY, 2) == 0) {
				strcpy(str, "Split-20 : error : ");
				strcat(str, _("There is not a point of intersection."));
				g_print("%s\n", str);
				return 0;
			}
		}
		/*  ޷  */
		else if (a->TraceData[2].code == 1 ) {
			if (TrimC_Line(*a, &PointX, &PointY, 2) == 0) {
				strcpy(str, "Split-21 : error : ");
				strcat(str, _("There is not a point of intersection."));
				g_print("%s\n", str);
				return 0;
			}
		}
		/*  ޷ ߸̤ޤϱ */
		else if (a->TraceData[2].code == 2 || a->TraceData[2].code == 4) {
			if (TrimC_AC(*a, &PointX, &PointY, 2) == 0) {
				strcpy(str, "Split-22 : error : ");
				strcat(str, _("There is not a point of intersection."));
				g_print("%s\n", str);
				return 0;
			}
		}
		/*  ޷ ʱ߸̤ޤʱ */
		else if (a->TraceData[2].code == 16) {
			if (TrimC_Ellipse(*a, &PointX, &PointY, 2) == 0) {
				strcpy(str, "Split-23 : error : ");
				strcat(str, _("There is not a point of intersection."));
				g_print("%s\n", str);
				return 0;
			}
		}


		/* -------------------------------------------------
		 * å
		 */
		if (
				sg(PointX, compa_digits) == sg(a->TraceData[1].sx, compa_digits) 
				&& 
				sg(PointY, compa_digits) == sg(a->TraceData[1].sy, compa_digits)
			)
		{
			strcpy(str, "Split : error : ");
			strcat(str, _("The division point is the same as the start point."));
			strcat(str, " (LINE)");
			g_print("%s\n", str);
			return 0;
		}

		else if (
					sg(PointX, compa_digits) == sg(a->TraceData[1].ex, compa_digits) 
					&& 
					sg(PointY, compa_digits) == sg(a->TraceData[1].ey, compa_digits)
				)
		{
			strcpy(str, "Split : error : ");
			strcat(str, _("The division point is the same as the end point."));
			strcat(str, " (LINE)");
			g_print("%s\n", str);
			return 0;
		}


		/* -------------------------------------------------
		 * ߸ʬ¹
		 *  ( PointX , PointY )
		 */
		/* ߸̤ SA & EA  */
		SA = Arc_SE_Angle(a->TraceData[1], 0);
		EA = Arc_SE_Angle(a->TraceData[1], 1);

		/* 濴ޤǤγ PA 롣 */
		LAH.sx[1] = a->TraceData[1].cx;
		LAH.sy[1] = a->TraceData[1].cy;
		LAH.ex[1] = PointX;
		LAH.ey[1] = PointY;
		la(&LAH);
		PA = sg(LAH.angle, calcu_digits);

		/* ߸̤αĹ -------------------------------------- */
		if (((SA < EA) && (PA < SA || PA > EA)) || ((SA > EA) && (PA < SA && PA > EA))) {
			return 0; /* Beep; */
		}

		/* ߸̤ʬ -------------------------------------- */
		/* (PointX,PointY) */
		/* ʬ䤷ƤǤǡ*/
		a->TraceData[3].code = 2;
		a->TraceData[3].layer = a->TraceData[1].layer;
		a->TraceData[3].style = a->TraceData[1].style;
		a->TraceData[3].color = a->TraceData[1].color;
		a->TraceData[3].cx = a->TraceData[1].cx;
		a->TraceData[3].cy = a->TraceData[1].cy;
		a->TraceData[3].r = a->TraceData[1].r;
		a->TraceData[3].sx = sg(PointX, calcu_digits);
		a->TraceData[3].sy = sg(PointY, calcu_digits);
		a->TraceData[3].ex = a->TraceData[1].ex;
		a->TraceData[3].ey = a->TraceData[1].ey;
		/* Υǡ*/
		a->TraceData[1].ex = sg(PointX, calcu_digits);
		a->TraceData[1].ey = sg(PointY, calcu_digits);
		return 1;
	}





//#ifdef TEST
	/* -----------------------------------------------------
	 * 3 : ʬ䤹޷ʱ߸
	 */
	else if (a->TraceData[1].code == 16 && a->ellipse[1].code == 1) {
		/*  ޷  */
		if (a->TraceData[2].code == 0 ) {
			if (TrimE_Point(*a, &PointX, &PointY, 2) == 0) {
				strcpy(str, "Split-30 : error : ");
				strcat(str, _("There is not a point of intersection."));
				g_print("%s\n", str);
				return 0;
			}
		}
		/*  ޷  */
		else if (a->TraceData[2].code == 1 ) {
			if (TrimE_Line(*a, &PointX, &PointY, 2) == 0) {
				strcpy(str, "Split-31 : error : ");
				strcat(str, _("There is not a point of intersection."));
				g_print("%s\n", str);
				return 0;
			}
		}
		/*  ޷ ߸̤ޤϱ */
		else if (a->TraceData[2].code == 2 || a->TraceData[2].code == 4) {
			if (TrimE_AC(*a, &PointX, &PointY, 2) == 0) {
				strcpy(str, "Split-32 : error : ");
				strcat(str, _("There is not a point of intersection."));
				g_print("%s\n", str);
				return 0;
			}
		}
		/*  ޷ ʱ߸̤ޤʱ */
		else if (a->TraceData[2].code == 16) {
			if (TrimE_Ellipse(*a, &PointX, &PointY, 2) == 0) {
				strcpy(str, "Split-33 : error : ");
				strcat(str, _("There is not a point of intersection."));
				g_print("%s\n", str);
				return 0;
			}
		}


		/* -------------------------------------------------
		 * å
		 */
		/* ʬƱ */
		get_ellipse_point_from_angle (a->ellipse[1], a->ellipse[1].sa, &point);
		if (
				(
					PointX + (1/pow(10, compa_digits)) > point.x
					&&
					PointX - (1/pow(10, compa_digits)) < point.x
				)
				&& 
				(
					PointY + (1/pow(10, compa_digits)) > point.y
					&&
					PointY - (1/pow(10, compa_digits)) < point.y
				)
			)
		{
			sprintf(str, "Split() : error : ");
			strcat(str, _("The division point is the same as the start point.") );
			strcat(str, " (ELLIPSE)");
			g_print("%s\n", str);
			return 0;
		}
		
		/* ʬƱ */
		get_ellipse_point_from_angle (a->ellipse[1], a->ellipse[1].ea, &point);
		if (
				(
					PointX + (1/pow(10, compa_digits)) > point.x
					&&
					PointX - (1/pow(10, compa_digits)) < point.x
				)
				&& 
				(
					PointY + (1/pow(10, compa_digits)) > point.y
					&&
					PointY - (1/pow(10, compa_digits)) < point.y
				)
			)
		{
			sprintf(str, "Split() : error : ");
			strcat(str, _("The division point is the same as the end point.") );
			strcat(str, " (ELLIPSE)");
			g_print("%s\n", str);
			return 0;
		}


		/* -------------------------------------------------
		 * ߸ʬ¹
		 *  ( PointX , PointY )
		 */
		/* ߸̤ SA & EA  */
		SA = a->ellipse[1].sa;
		EA = a->ellipse[1].ea;

		/* 濴ޤǤγ PA 롣 */
		point.x = PointX;
		point.y = PointY;
		PA = get_ellipse_angle_from_point (a->ellipse[1], point);

		/* ߸̤αĹ -------------------------------------- */
		if (((SA < EA) && (PA < SA || PA > EA)) || ((SA > EA) && (PA < SA && PA > EA))) {
			return 0; /* Beep; */
		}


		g_print ("split() : SA = %f   EA = %f   PA = %f\n", SA, EA, PA);


		/* ߸̤ʬ -------------------------------------- */
		/* (PointX,PointY) */
		/* ʬ䤷ƤǤǡ*/
		a->TraceData[3].code = 16;
		a->ellipse[3].code = 1;
		a->ellipse[3].layer = a->ellipse[1].layer;
		a->ellipse[3].style = a->ellipse[1].style;
		a->ellipse[3].color = a->ellipse[1].color;

		a->ellipse[3].cx = a->ellipse[1].cx;
		a->ellipse[3].cy = a->ellipse[1].cy;
		a->ellipse[3].k = a->ellipse[1].k;
		a->ellipse[3].dx = a->ellipse[1].dx;
		a->ellipse[3].dy = a->ellipse[1].dy;
		a->ellipse[3].sa = PA;
		a->ellipse[3].ea = a->ellipse[1].ea;
		/* Υǡ*/
		a->ellipse[1].ea = PA;

		return 1;
	}
//#endif



	return 0;
}





/* -------------------------------------------------------------------
 * եå
 * Fillet
 * struct TrimDat *		double R
 * int	  a->TraceData[3] : Fillet޷
 *		  ERR : 0	 OK : 1
 */
int Fillet(struct TrimDat *a, double R)
{
//#define FIRET_TEST
//char dumystr[256];


	CAD DumyCad;
	double DumyDbl1, DumyDbl2, CrossPointX = 0, CrossPointY = 0;
	double DumySX = 0, DumySY = 0, DumyEX = 0, DumyEY = 0, DumySX2 = 0, DumySY2 = 0, DumyEX2 = 0, DumyEY2 = 0;
	double FilletCX = 0, FilletCY = 0, DumyCX[3], DumyCY[3], L1, L2;
	int FilletType = 0, Int1 = 0, Int2 = 0;
	struct RtnDat DumyRTN;
	struct TrimDat DumyTrim;
	char str[256];


	/* -----------------------------------------------------
	 * ޷ǤȽ
	 * 
	 */
	if (a->TraceData[1].code == 1 ) {
		/* <> (FilletType = 1) */
		if (a->TraceData[2].code == 1 ) {
			FilletType = 1;
		}
		/* <ȱ> (FilletType = 2) */
		else if (a->TraceData[2].code == 2 || a->TraceData[2].code == 4 ) {
			FilletType = 2;
		}
	}
	else if (a->TraceData[1].code == 2 || a->TraceData[1].code == 4 ) {
		/* <ߤ> (FilletType = 2) */
		if (a->TraceData[2].code == 1 ) {
			/* ǡ1  ǡ2 줫 */
			DumyCad = a->TraceData[1];
			DumyDbl1 = a->PicX[1];
			DumyDbl2 = a->PicY[1];
			a->TraceData[1] = a->TraceData[2];
			a->PicX[1] = a->PicX[2];
			a->PicY[1] = a->PicY[2];
			a->TraceData[2] = DumyCad;
			a->PicX[2] = DumyDbl1;
			a->PicY[2] = DumyDbl2;
			FilletType = 2;
		}
		/* <ߤȱ>  (FilletType = 3)*/
		else if (a->TraceData[2].code == 2 || a->TraceData[2].code == 4 ) {
			FilletType = 3;
		}
	}



	/* -----------------------------------------------------
	 * (ȥΤ)
	 * 
	 */
	if (FilletType == 1 ) {
		DumyRTN.sx[1] = a->TraceData[1].sx;
		DumyRTN.sy[1] = a->TraceData[1].sy;
		DumyRTN.ex[1] = a->TraceData[1].ex;
		DumyRTN.ey[1] = a->TraceData[1].ey;
		DumyRTN.sx[2] = a->TraceData[2].sx;
		DumyRTN.sy[2] = a->TraceData[2].sy;
		DumyRTN.ex[2] = a->TraceData[2].ex;
		DumyRTN.ey[2] = a->TraceData[2].ey;
		llp(&DumyRTN);

		/*  */
		CrossPointX = DumyRTN.sx[3];
		CrossPointY = DumyRTN.sy[3];
	}

	else if (FilletType == 2 ) {
		DumyRTN.sx[1] = a->TraceData[1].sx;
		DumyRTN.sy[1] = a->TraceData[1].sy;
		DumyRTN.ex[1] = a->TraceData[1].ex;
		DumyRTN.ey[1] = a->TraceData[1].ey;
		DumyRTN.cx[1] = a->TraceData[2].cx;
		DumyRTN.cy[1] = a->TraceData[2].cy;
		DumyRTN.r[1] = a->TraceData[2].r;
		DumyRTN.sx[4] = a->PicX[1];
		DumyRTN.sy[4] = a->PicY[1];
		DumyRTN.ex[4] = a->PicX[2];
		DumyRTN.ey[4] = a->PicY[2];
		LCP1(&DumyRTN);

		if (DumyRTN.type == 1) {
			CrossPointX = DumyRTN.sx[2];
			CrossPointY = DumyRTN.sy[2];
		}
		else if (DumyRTN.type == 0) {
			DumyRTN.sx[1] = a->TraceData[1].sx;
			DumyRTN.sy[1] = a->TraceData[1].sy;
			DumyRTN.ex[1] = a->TraceData[1].ex;
			DumyRTN.ey[1] = a->TraceData[1].ey;
			DumyRTN.sx[2] = a->TraceData[2].cx;
			DumyRTN.sy[2] = a->TraceData[2].cy;
			plp(&DumyRTN);
			
			/*  */
			CrossPointX = DumyRTN.ex[2];
			CrossPointY = DumyRTN.ey[2];
		}
	}

	else if (FilletType == 3) {
		DumyRTN.cx[1] = a->TraceData[1].cx;
		DumyRTN.cy[1] = a->TraceData[1].cy;
		DumyRTN.r[1] = a->TraceData[1].r;
		DumyRTN.cx[2] = a->TraceData[2].cx;
		DumyRTN.cy[2] = a->TraceData[2].cy;
		DumyRTN.r[2] = a->TraceData[2].r;
		DumyRTN.sx[1] = a->PicX[1];
		DumyRTN.sy[1] = a->PicY[1];
		DumyRTN.sx[2] = a->PicX[2];
		DumyRTN.sy[2] = a->PicY[2];
		CCP1(&DumyRTN);

		if (DumyRTN.type == 1) {
			/*  */
			CrossPointX = DumyRTN.sx[1];
			CrossPointY = DumyRTN.sy[1];
		}
		else if (DumyRTN.type == 0) {
			/*	*/
			DumyRTN.sx[1] = a->TraceData[1].cx;
			DumyRTN.sy[1] = a->TraceData[1].cy;
			DumyRTN.ex[1] = a->TraceData[2].cx;
			DumyRTN.ey[1] = a->TraceData[2].cy;
			pp(&DumyRTN);
			DumyDbl1 = DumyRTN.l;
			/*	*/
			DumyRTN.sx[1] = a->TraceData[1].cx;
			DumyRTN.sy[1] = a->TraceData[1].cy;
			DumyRTN.ex[1] = a->TraceData[2].cx;
			DumyRTN.ey[1] = a->TraceData[2].cy;
			la(&DumyRTN);
			DumyDbl2 = DumyRTN.angle;
			/*	*/
			DumyDbl1 = a->TraceData[1].r + (DumyDbl1 - a->TraceData[1].r - a->TraceData[2].r) / 2;
			/*	*/
			DumyRTN.sx[1] = a->TraceData[1].cx;
			DumyRTN.sy[1] = a->TraceData[1].cy;
			DumyRTN.angle = DumyDbl2;
			DumyRTN.l = DumyDbl1;
			pap(&DumyRTN);

			/*  */
			CrossPointX = DumyRTN.ex[1];
			CrossPointY = DumyRTN.ey[1];
		}
	}



	/* -----------------------------------------------------
	 * եå濴
	 * 
	 */
	/* <> (FilletType = 1) */
	if (FilletType == 1) {
		/* 1 ФФԥå2 Ϥɤä¦ */
		/* ľοʹαˤ뤫ˤ뤫
		 * ChkPointLineSide
		 * (a->sx[1], a->sy[1]) - (a->ex[1], a->ey[1]),,(a->sx[2], a->sy[2])
		 * 	a->type = 0ERR	1	2	3
		 */
		DumyRTN.sx[1] = a->TraceData[1].sx;
		DumyRTN.sy[1] = a->TraceData[1].sy;
		DumyRTN.ex[1] = a->TraceData[1].ex;
		DumyRTN.ey[1] = a->TraceData[1].ey;
		DumyRTN.sx[2] = a->PicX[2];
		DumyRTN.sy[2] = a->PicY[2];
		ChkPointLineSide(&DumyRTN);
		Int1 = DumyRTN.type;
		
		/* 2 ФФԥå1 Ϥɤä¦ */
		DumyRTN.sx[1] = a->TraceData[2].sx;
		DumyRTN.sy[1] = a->TraceData[2].sy;
		DumyRTN.ex[1] = a->TraceData[2].ex;
		DumyRTN.ey[1] = a->TraceData[2].ey;
		DumyRTN.sx[2] = a->PicX[1];
		DumyRTN.sy[2] = a->PicY[1];
		ChkPointLineSide(&DumyRTN);
		Int2 = DumyRTN.type;

#ifdef FIRET_TEST /* --------------------------------------------------- */
		if(Int1==1)	sprintf(dumystr,"1ФФԥå2ϡ");
		else if(Int1==2)	sprintf(dumystr,"1ФФԥå2ϡ");
		else if(Int1==3)	sprintf(dumystr,"1ФФԥå2ϡ");
		else if(Int1==0)	sprintf(dumystr,"1ФФԥå2ϡerr");
		MsgBox("FIRET TEST Test", dumystr);
		if(Int2==1)	sprintf(dumystr,"2ФФԥå1ϡ");
		else if(Int2==2)	sprintf(dumystr,"2ФФԥå1ϡ");
		else if(Int2==3)	sprintf(dumystr,"2ФФԥå1ϡ");
		else if(Int2==0)	sprintf(dumystr,"2ФФԥå1ϡerr");
		MsgBox("FIRET TEST Test", dumystr);
		sprintf(dumystr,"ԥå1 (%f,%f)    ԥå2 (%f,%f)", 
						a->PicX[1], a->PicY[1], a->PicX[2], a->PicY[2]);
		MsgBox("FIRET TEST Test", dumystr);
#endif /* -------------------------------------------------------------- */


		/* 1ԥå2˥եå */
		/* ------------------------------------------------ */
		/* LO	ȽͿľΥեå */
		/* ------------------------------------------------ */
		DumyRTN.sx[1] = a->TraceData[1].sx;
		DumyRTN.sy[1] = a->TraceData[1].sy;
		DumyRTN.ex[1] = a->TraceData[1].ex;
		DumyRTN.ey[1] = a->TraceData[1].ey;
		DumyRTN.l = R;
		lo(&DumyRTN);
		/*  */
		if (Int1 == 1) {
			DumySX = DumyRTN.sx[3];
			DumySY = DumyRTN.sy[3];
			DumyEX = DumyRTN.ex[3];
			DumyEY = DumyRTN.ey[3];
		}
		/*  */
		else if (Int1 == 2) {
			DumySX = DumyRTN.sx[2];
			DumySY = DumyRTN.sy[2];
			DumyEX = DumyRTN.ex[2];
			DumyEY = DumyRTN.ey[2];
		}
		
		/* 2ԥå1˥եå */
		DumyRTN.sx[1] = a->TraceData[2].sx;
		DumyRTN.sy[1] = a->TraceData[2].sy;
		DumyRTN.ex[1] = a->TraceData[2].ex;
		DumyRTN.ey[1] = a->TraceData[2].ey;
		DumyRTN.l = R;
		lo(&DumyRTN);
		/*  */
		if (Int2 == 1) {
			DumySX2 = DumyRTN.sx[3];
			DumySY2 = DumyRTN.sy[3];
			DumyEX2 = DumyRTN.ex[3];
			DumyEY2 = DumyRTN.ey[3];
		}
		/*  */
		else if (Int2 == 2) {
			DumySX2 = DumyRTN.sx[2];
			DumySY2 = DumyRTN.sy[2];
			DumyEX2 = DumyRTN.ex[2];
			DumyEY2 = DumyRTN.ey[2];
		}


		/* 1ԥå2˥եåȤ */
		/* 2ԥå1˥եåȤθ */
		/* ------------------------------------------------ */
		/* LLP	ľθ  ƤΥեå P120 */
		/* ------------------------------------------------ */
		DumyRTN.sx[1] = DumySX;
		DumyRTN.sy[1] = DumySY;
		DumyRTN.ex[1] = DumyEX;
		DumyRTN.ey[1] = DumyEY;
		DumyRTN.sx[2] = DumySX2;
		DumyRTN.sy[2] = DumySY2;
		DumyRTN.ex[2] = DumyEX2;
		DumyRTN.ey[2] = DumyEY2;
		llp(&DumyRTN);

		if (DumyRTN.type == 0) {
			strcpy(str, "Fillet : error : ");
			strcat(str, _("There is not a point of intersection."));
			strcat(str, _(" (Two lines is Parallel)"));
			g_print("%s\n", str);
			return 0;
		}

		/* եå濴	DumyRTN.SX[3]	DumyRTN.SY[3] */
		FilletCX = DumyRTN.sx[3];
		FilletCY = DumyRTN.sy[3];
		
	}





	/* <ȱ> (FilletType = 2) */
	else if (FilletType == 2) {
		/* 1ФФԥå2Ϥɤä¦ */
		/* ľοʹαˤ뤫ˤ뤫
		 * ChkPointLineSide
		 * (a->sx[1], a->sy[1]) - (a->ex[1], a->ey[1]),,(a->sx[2], a->sy[2])
		 * 	a->type = 0ERR	1	2	3
		 */
		DumyRTN.sx[1] = a->TraceData[1].sx;
		DumyRTN.sy[1] = a->TraceData[1].sy;
		DumyRTN.ex[1] = a->TraceData[1].ex;
		DumyRTN.ey[1] = a->TraceData[1].ey;
		DumyRTN.sx[2] = a->PicX[2];
		DumyRTN.sy[2] = a->PicY[2];
		ChkPointLineSide(&DumyRTN);
		Int1 = DumyRTN.type;
		
		/* 2ФФԥå1Ϥɤä¦ */
		/* ߤˤ뤫ˤ뤫
		 * ChkPointCircleSide
		 * (a->sx[1] , a->sy[1])	(a->cx[1] , a->cy[1]) , a->r[1]
		 *	a->type = 0ERR   1   2   3
		 */
		DumyRTN.cx[1] = a->TraceData[2].cx;
		DumyRTN.cy[1] = a->TraceData[2].cy;
		DumyRTN.r[1] = a->TraceData[2].r;
		DumyRTN.sx[1] = a->PicX[1];
		DumyRTN.sy[1] = a->PicY[1];
		ChkPointCircleSide(&DumyRTN);
		Int2 = DumyRTN.type;


#ifdef FIRET_TEST /* --------------------------------------------------- */
		if(Int1==1)	sprintf(dumystr,"1ФФԥå2ϡ");
		else if(Int1==2)	sprintf(dumystr,"1ФФԥå2ϡ");
		else if(Int1==3)	sprintf(dumystr,"1ФФԥå2ϡ");
		else if(Int1==0)	sprintf(dumystr,"1ФФԥå2ϡerr");
		MsgBox("FIRET TEST Test", dumystr);
		if(Int2==1)	sprintf(dumystr,"2ФФԥå1ϡ");
		else if(Int2==2)	sprintf(dumystr,"2ФФԥå1ϡ");
		else if(Int2==3)	sprintf(dumystr,"2ФФԥå1ϡ");
		else if(Int2==0)	sprintf(dumystr,"2ФФԥå1ϡerr");
		MsgBox("FIRET TEST Test", dumystr);
		sprintf(dumystr,"ԥå1 (%f,%f)    ԥå2 (%f,%f)", 
						a->PicX[1], a->PicY[1], a->PicX[2], a->PicY[2]);
		MsgBox("FIRET TEST Test", dumystr);
#endif /* -------------------------------------------------------------- */


		DumyRTN.sx[1] = a->TraceData[1].sx;
		DumyRTN.sy[1] = a->TraceData[1].sy;
		DumyRTN.ex[1] = a->TraceData[1].ex;
		DumyRTN.ey[1] = a->TraceData[1].ey;
		DumyRTN.l = R;
		lo(&DumyRTN);
		/*  */
		if (Int1 == 1) {
			DumyRTN.sx[1] = DumyRTN.sx[3];
			DumyRTN.sy[1] = DumyRTN.sy[3];
			DumyRTN.ex[1] = DumyRTN.ex[3];
			DumyRTN.ey[1] = DumyRTN.ey[3];
		}
		/*  */
		else if (Int1 == 2) {
			DumyRTN.sx[1] = DumyRTN.sx[2];
			DumyRTN.sy[1] = DumyRTN.sy[2];
			DumyRTN.ex[1] = DumyRTN.ex[2];
			DumyRTN.ey[1] = DumyRTN.ey[2];
		}


		/*  */
		if (Int2 == 1) {
			DumyRTN.cx[1] = a->TraceData[2].cx;
			DumyRTN.cy[1] = a->TraceData[2].cy;
			DumyRTN.r[1] = a->TraceData[2].r - R;
		}
		/*  */
		else if (Int2 == 2) {
			DumyRTN.cx[1] = a->TraceData[2].cx;
			DumyRTN.cy[1] = a->TraceData[2].cy;
			DumyRTN.r[1] = a->TraceData[2].r + R;
#ifdef FIRET_TEST /* --------------------------------------------------- */
//		CircleDraw(hDrawArea, DumyRTN.cx[1], DumyRTN.cy[1], DumyRTN.r[1], 1, 0x00ffffff);
#endif // --------------------------------------------------------------
		}
		/* ľȱߤθ  ƤΥեå P126 */
		lcp(&DumyRTN);

		if (DumyRTN.type == 0) {
			strcpy(str, "Fillet : error : ");
			strcat(str, _("There is not a point of intersection."));
			strcat(str, _(" (Radius is small)"));
			g_print("%s\n", str);
			return 0;
		}

		/* 1  ( DumyRTN.SX[2] , DumyRTN.SX[2] ) */
		/* 2  ( DumyRTN.SX[3] , DumyRTN.SX[3] ) */
		DumyCX[1] = DumyRTN.sx[2];
		DumyCY[1] = DumyRTN.sy[2];
		DumyCX[2] = DumyRTN.sx[3];
		DumyCY[2] = DumyRTN.sy[3];
	}





	/* <ߤȱ> (FilletType = 3) */
	else if (FilletType == 3) {
		/* 1ФФԥå2Ϥɤä¦ */
		DumyRTN.cx[1] = a->TraceData[1].cx;
		DumyRTN.cy[1] = a->TraceData[1].cy;
		DumyRTN.r[1] = a->TraceData[1].r;
		DumyRTN.sx[1] = a->PicX[2];
		DumyRTN.sy[1] = a->PicY[2];
		ChkPointCircleSide(&DumyRTN);
		Int1 = DumyRTN.type;

		/* 2ФФԥå1Ϥɤä¦ */
		DumyRTN.cx[1] = a->TraceData[2].cx;
		DumyRTN.cy[1] = a->TraceData[2].cy;
		DumyRTN.r[1] = a->TraceData[2].r;
		DumyRTN.sx[1] = a->PicX[1];
		DumyRTN.sy[1] = a->PicY[1];
		ChkPointCircleSide(&DumyRTN);
		Int2 = DumyRTN.type;
		
		/* CCP	ߤθ */
		/*  */
		if (Int1 == 1) 	{
			DumyRTN.cx[1] = a->TraceData[1].cx;
			DumyRTN.cy[1] = a->TraceData[1].cy;
			DumyRTN.r[1] = a->TraceData[1].r - R;
		}
		/*  */
		else if (Int1 == 2) {
			DumyRTN.cx[1] = a->TraceData[1].cx;
			DumyRTN.cy[1] = a->TraceData[1].cy;
			DumyRTN.r[1] = a->TraceData[1].r + R;
		}


		/*  */
		if (Int2 == 1) {
			DumyRTN.cx[2] = a->TraceData[2].cx;
			DumyRTN.cy[2] = a->TraceData[2].cy;
			DumyRTN.r[2] = a->TraceData[2].r - R;
		}
		/*  */
		else if (Int2 == 2) {
			DumyRTN.cx[2] = a->TraceData[2].cx;
			DumyRTN.cy[2] = a->TraceData[2].cy;
			DumyRTN.r[2] = a->TraceData[2].r + R;
		}
		
		/* ߤθ */
		ccp(&DumyRTN);

		if (DumyRTN.type == 0) {
			strcpy(str, "Fillet : error : ");
			strcat(str, _("There is not a point of intersection."));
			strcat(str, _(" (Radius is small)"));
			g_print("%s\n", str);
			return 0;
		}
		
		/* 1  ( DumyRTN.SX[1] , DumyRTN.SX[1] ) */
		/* 2  ( DumyRTN.SX[2] , DumyRTN.SX[2] ) */
		DumyCX[1] = DumyRTN.sx[1];
		DumyCY[1] = DumyRTN.sy[1];
		DumyCX[2] = DumyRTN.sx[2];
		DumyCY[2] = DumyRTN.sy[2];
	}





	/* ----------------------------------------------------- */
	/* եåȱߤ濴ԥå˶ᤤȤ롣--------- */
	/* ᤤۤǤϤʤ [濴ԥåγ]	*/
	/*  [濴γ] */
	/* Ƚ̤褤ΤǤϡ */
	/*	*/
	/*	*/
	/*	*/
	if (FilletType == 2 || FilletType == 3)
	{
		/* ------------------------------------------------ */
		/* PP	֤εΥ */
		/* ------------------------------------------------ */
		/* L1 */
		DumyRTN.sx[1] = DumyCX[1];
		DumyRTN.sy[1] = DumyCY[1];
		DumyRTN.ex[1] = a->PicX[1];
		DumyRTN.ey[1] = a->PicY[1];
		pp(&DumyRTN);
		L1 = DumyRTN.l;

		DumyRTN.sx[1] = DumyCX[1];
		DumyRTN.sy[1] = DumyCY[1];
		DumyRTN.ex[1] = a->PicX[2];
		DumyRTN.ey[1] = a->PicY[2];
		pp(&DumyRTN);
		L1 = L1 + DumyRTN.l;

		/* L2 */
		DumyRTN.sx[1] = DumyCX[2];
		DumyRTN.sy[1] = DumyCY[2];
		DumyRTN.ex[1] = a->PicX[1];
		DumyRTN.ey[1] = a->PicY[1];
		pp(&DumyRTN);
		L2 = DumyRTN.l;

		DumyRTN.sx[1] = DumyCX[2];
		DumyRTN.sy[1] = DumyCY[2];
		DumyRTN.ex[1] = a->PicX[2];
		DumyRTN.ey[1] = a->PicY[2];
		pp(&DumyRTN);
		L2 = L2 + DumyRTN.l;

		if (L1 < L2) {
			FilletCX = DumyCX[1];
			FilletCY = DumyCY[1];
		}
		else if (L1 > L2) {
			FilletCX = DumyCX[2];
			FilletCY = DumyCY[2];
		}
	}
	/* ----- < եåȱߤ濴ԥå˶ᤤȤ롣> ------------------ */





	/* ----------------------------------------------------- */
	/* եåȱߤ CAD ǡˤ --------------------- */
	a->TraceData[3].code = 4;
	a->TraceData[3].layer = a->TraceData[1].layer;//NowLayer;
	a->TraceData[3].style = a->TraceData[1].style;//NowStyle;
	a->TraceData[3].color = a->TraceData[1].color;//NowColor;
	
	a->TraceData[3].cx = sg(FilletCX, calcu_digits);
	a->TraceData[3].cy = sg(FilletCY, calcu_digits);
	a->TraceData[3].r = R;


	/* ----------------------------------------------------- */
	/* եåȱߤȥह ---------------------------- */

	/* ȥΤȤΥԥå */
	/* LA	ľγ */
	DumyRTN.sx[1] = a->TraceData[3].cx;
	DumyRTN.sy[1] = a->TraceData[3].cy;
	DumyRTN.ex[1] = CrossPointX;
	DumyRTN.ey[1] = CrossPointY;
	la(&DumyRTN);
	
	/* PAP	ȳ٤ȵΥľν */
	DumyRTN.l = a->TraceData[3].r;
	pap(&DumyRTN);
	
	CrossPointX = DumyRTN.ex[1];
	CrossPointY = DumyRTN.ey[1];

	/* ----------------------------------------------------- */
	/* ȥ޷ߤʤȥ¹ ------------------------ */
	DumyTrim.TraceData[1] = a->TraceData[3];
	DumyTrim.PicX[1] = CrossPointX;
	DumyTrim.PicY[1] = CrossPointY;
	
	DumyTrim.TraceData[2] = a->TraceData[1];
	DumyTrim.PicX[2] = a->PicX[1];
	DumyTrim.PicY[2] = a->PicY[1];
	
	DumyTrim.TraceData[3] = a->TraceData[2];
	DumyTrim.PicX[3] = a->PicX[2];
	DumyTrim.PicY[3] = a->PicY[2];
	
	DumyTrim.Index = 2;

	/* < ȥ¹ > */
	TrimMain(&DumyTrim);

	a->TraceData[1] = DumyTrim.TraceData[2];
	a->PicX[1] = DumyTrim.PicX[2];
	a->PicY[1] = DumyTrim.PicY[2];
	
	a->TraceData[2] = DumyTrim.TraceData[3];
	a->PicX[2] = DumyTrim.PicX[3];
	a->PicY[2] = DumyTrim.PicY[3];
	
	a->TraceData[3] = DumyTrim.TraceData[1];
	a->PicX[3] = DumyTrim.PicX[1];
	a->PicY[3] = DumyTrim.PicY[1];
	return 1;
}





/* ====================================================================
 * ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : TrimFunc.c
 * ====================================================================
 */
